/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.projectView_old.v2.nodes.folders;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.projectView_old.id.NodeId;
import org.jetbrains.plugins.ruby.rails.projectView_old.v2.nodes.AbstractRailsPsiNodeDescriptor;
import org.jetbrains.plugins.ruby.rails.projectView_old.v2.nodes.ClassNode;
import org.jetbrains.plugins.ruby.rails.projectView_old.v2.nodes.FileNode;
import org.jetbrains.plugins.ruby.rails.projectView_old.v2.nodes.RailsNodeDescriptor;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RObjectClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.holders.utils.RContainerUtil;
import org.jetbrains.plugins.ruby.utils.RubyVirtualFileScanner;

public abstract class AbstractFolderNode
extends AbstractRailsPsiNodeDescriptor<PsiDirectory> {
    protected abstract AbstractFolderNode createFolderNode(@NotNull Module var1, @NotNull VirtualFile var2);

    protected AbstractFolderNode(@NotNull Module module, @NotNull VirtualFile directory, @Nullable String locationMark, ViewSettings viewSettings) {
        if (module == null) {
            AbstractFolderNode.$$$reportNull$$$0(0);
        }
        if (directory == null) {
            AbstractFolderNode.$$$reportNull$$$0(1);
        }
        super(module, viewSettings, AbstractFolderNode.createId(module, directory, locationMark));
    }

    @Override
    public String getTestPresentation() {
        return this.getNamePrefix() + ": " + (!this.isValid() ? "null" : this.getFolderPresentableName(Objects.requireNonNull(this.getVirtualFile())));
    }

    @Override
    @NotNull
    protected String getNamePrefix() {
        return "Folder";
    }

    @Nullable
    protected Collection<AbstractTreeNode<?>> getChildrenImpl() {
        ArrayList children = new ArrayList();
        RailsNodeDescriptor.runSafeReadActionOrCancel(() -> {
            VirtualFile directory = this.getVirtualFile();
            assert (directory != null);
            if (!directory.isValid()) {
                return;
            }
            List<VirtualFile> files = this.getChildrenForDirectory(directory);
            for (VirtualFile fileOrDir : files) {
                ProgressManager.checkCanceled();
                if (!fileOrDir.isValid() || this.skipFileOrDir(fileOrDir)) continue;
                if (fileOrDir.isDirectory()) {
                    this.processDirectory(children, fileOrDir);
                    continue;
                }
                this.processNotDirectoryFile(children, fileOrDir);
            }
        });
        if (children.isEmpty()) {
            return null;
        }
        return children;
    }

    protected boolean skipFileOrDir(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            AbstractFolderNode.$$$reportNull$$$0(2);
        }
        return false;
    }

    protected List<VirtualFile> getChildrenForDirectory(VirtualFile thisDirectory) {
        return RubyVirtualFileScanner.searchFilesUnderDirectory((Module)this.getModule(), (VirtualFile)thisDirectory, (boolean)true, (boolean)false);
    }

    @Override
    protected void updateImpl(@NotNull PresentationData data) {
        if (data == null) {
            AbstractFolderNode.$$$reportNull$$$0(3);
        }
        PsiDirectory psiDirectory = (PsiDirectory)this.extractPsiFromValue();
        assert (psiDirectory != null);
        data.setPresentableText(this.getFolderPresentableName(psiDirectory.getVirtualFile()));
        data.setIcon(this.getFolderIcon(psiDirectory));
    }

    protected Icon getFolderIcon(@NotNull PsiDirectory psiDirectory) {
        if (psiDirectory == null) {
            AbstractFolderNode.$$$reportNull$$$0(4);
        }
        return psiDirectory.getIcon(0);
    }

    @NotNull
    @NlsSafe
    protected String getFolderPresentableName(@NotNull VirtualFile dir) {
        if (dir == null) {
            AbstractFolderNode.$$$reportNull$$$0(5);
        }
        String string = dir.getPresentableName();
        if (string == null) {
            AbstractFolderNode.$$$reportNull$$$0(6);
        }
        return string;
    }

    public boolean contains(@NotNull VirtualFile file) {
        Module module;
        if (file == null) {
            AbstractFolderNode.$$$reportNull$$$0(7);
        }
        if (!this.isContainsImplApplicableTo(file, module = this.getModule())) {
            return false;
        }
        PsiDirectory psiElement = (PsiDirectory)this.extractPsiFromValue();
        if (psiElement == null || !psiElement.isValid()) {
            return false;
        }
        VirtualFile valueFile = psiElement.getVirtualFile();
        if (!VfsUtilCore.isAncestor((VirtualFile)valueFile, (VirtualFile)file, (boolean)false)) {
            return false;
        }
        VirtualFile current = file;
        while (!Comparing.equal((Object)current, (Object)valueFile)) {
            if (this.skipFileOrDir(current)) {
                return false;
            }
            current = current.getParent();
        }
        return true;
    }

    protected boolean isContainsImplApplicableTo(@NotNull VirtualFile candidateFile, @NotNull Module module) {
        if (candidateFile == null) {
            AbstractFolderNode.$$$reportNull$$$0(8);
        }
        if (module == null) {
            AbstractFolderNode.$$$reportNull$$$0(9);
        }
        return ModuleRootManager.getInstance((Module)module).getFileIndex().isInContent(candidateFile);
    }

    protected void processNotDirectoryFile(List<AbstractTreeNode<?>> nodes, VirtualFile file) {
        FileNode fileNode;
        boolean classesWereFound = this.addRClassesFromFile(nodes, file);
        if (!classesWereFound && (fileNode = this.createFileNode(file)) != null) {
            nodes.add((AbstractTreeNode<?>)fileNode);
        }
    }

    protected void processDirectory(List<AbstractTreeNode<?>> nodes, VirtualFile dir) {
        nodes.add((AbstractTreeNode<?>)this.createFolderNode(this.getModule(), dir));
    }

    protected boolean addRClassesFromFile(List<AbstractTreeNode<?>> nodes, @Nullable VirtualFile file) {
        if (!RubyVirtualFileScanner.isRubyFile((VirtualFile)file)) {
            return false;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)this.getProject()).findFile(file);
        if (psiFile instanceof RFile) {
            List allClasses = RContainerUtil.getTopLevelClasses((RContainer)((RFile)psiFile));
            boolean somethingWasFound = false;
            for (RClass rClass : allClasses) {
                ProgressManager.checkCanceled();
                if (rClass instanceof RObjectClass) continue;
                nodes.add(this.createClassNode(rClass));
                somethingWasFound = true;
            }
            return somethingWasFound;
        }
        return false;
    }

    @Nullable
    protected FileNode createFileNode(VirtualFile file) {
        NodeId nodeId = (NodeId)this.getValue();
        assert (nodeId != null);
        if (!file.isValid()) {
            return null;
        }
        Project project = this.getProject();
        if (project == null) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        if (psiFile == null || !psiFile.isValid()) {
            return null;
        }
        return new FileNode(this.getModule(), file, this.getLocationRootMark(), this.getSettings());
    }

    protected AbstractTreeNode createClassNode(RClass rClass) {
        NodeId nodeId = (NodeId)this.getValue();
        assert (nodeId != null);
        return new ClassNode(this.getModule(), rClass, this.getLocationRootMark(), this.getSettings());
    }

    public boolean shouldDrillDownOnEmptyElement() {
        return true;
    }

    public boolean canRepresent(Object element) {
        if (element instanceof VirtualFile) {
            return Comparing.equal((Object)element, (Object)this.getVirtualFile());
        }
        if (element instanceof PsiDirectory) {
            return Comparing.equal((Object)((PsiDirectory)element).getVirtualFile(), (Object)this.getVirtualFile());
        }
        return super.canRepresent(element);
    }

    private static NodeId<PsiDirectory> createId(@NotNull Module module, @NotNull VirtualFile directory, @Nullable String locationMark) {
        if (module == null) {
            AbstractFolderNode.$$$reportNull$$$0(10);
        }
        if (directory == null) {
            AbstractFolderNode.$$$reportNull$$$0(11);
        }
        PsiDirectory psiDir = (PsiDirectory)ReadAction.compute(() -> Objects.requireNonNull(PsiManager.getInstance((Project)module.getProject()).findDirectory(directory)));
        return new NodeId<PsiDirectory>(psiDir, locationMark);
    }

    @Override
    @NotNull
    public RailsNodeDescriptor.SortInfo getSortInformation() {
        RailsNodeDescriptor.SortInfo sortInfo = RailsNodeDescriptor.SortInfo.FOLDER;
        if (sortInfo == null) {
            AbstractFolderNode.$$$reportNull$$$0(12);
        }
        return sortInfo;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOrDir";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiDirectory";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/projectView_old/v2/nodes/folders/AbstractFolderNode";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidateFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/projectView_old/v2/nodes/folders/AbstractFolderNode";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFolderPresentableName";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortInformation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "skipFileOrDir";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "updateImpl";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getFolderIcon";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFolderPresentableName";
                break;
            }
            case 6: 
            case 12: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isContainsImplApplicableTo";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createId";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 12 -> new IllegalStateException(string);
        };
    }
}

