/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.projectView_old.v2.nodes;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface RailsNodeDescriptor {
    public static final int FOLDER_SORT_TYPE_ID = 2;
    public static final int CLASS_SORT_TYPE_ID = 5;
    public static final int METHOD_SORT_TYPE_ID = 10;
    public static final int FILE_SORT_TYPE_ID = 15;

    @NonNls
    @Nullable
    public Condition<AnAction> getPreselectNewActionCondition();

    @NotNull
    public SortInfo getSortInformation();

    public boolean canDelete();

    public static void runSafeReadActionOrCancel(@NotNull Runnable runnable) {
        if (runnable == null) {
            RailsNodeDescriptor.$$$reportNull$$$0(0);
        }
        try {
            if (ApplicationManager.getApplication().isDispatchThread()) {
                runnable.run();
            } else if (!ProgressIndicatorUtils.runInReadActionWithWriteActionPriority((Runnable)runnable)) {
                throw new ProcessCanceledException();
            }
        }
        catch (IndexNotReadyException e) {
            throw new ProcessCanceledException();
        }
    }

    public static <T> T runSafeReadActionOrCancel(@NotNull Computable<T> computable) {
        if (computable == null) {
            RailsNodeDescriptor.$$$reportNull$$$0(1);
        }
        Ref result = Ref.create();
        RailsNodeDescriptor.runSafeReadActionOrCancel(() -> result.set(computable.compute()));
        return (T)result.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "runnable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "computable";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/ruby/rails/projectView_old/v2/nodes/RailsNodeDescriptor";
        objectArray[2] = "runSafeReadActionOrCancel";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum SortInfo {
        PRIMARY_NODE_NODE(-1, Integer.MAX_VALUE),
        DEFAULT_NODE(0, Integer.MAX_VALUE),
        FOLDER(200, 2),
        MIGRATION_FILE(480, 15),
        FILE(500, 15),
        CLASS(0, 5),
        METHOD(0, 10),
        APPLICATION_FOLDER(10, 2),
        CONTROLLERS_FOLDER(20, 2),
        ASSETS_FOLDER(25, 2),
        MODELS_FOLDER(30, 2),
        CHANNELS_FOLDER(35, 2),
        APP_FOLDER(37, 2),
        CONFIG_FOLDER(40, 2),
        HELPERS_PARTIAL_FOLDER(50, 2),
        LAYOUTS_FOLDER(60, 2),
        SHARED_PARTIALS_FOLDER(61, 2),
        VIEWS_PARTIAL_FOLDER(70, 2),
        LIB_FOLDER(80, 2),
        PUBLIC_FOLDER(81, 2),
        TEST_UNIT_TESTS_FOLDER(90, 2),
        RSPEC_TESTS_FOLDER(100, 2),
        VENDOR_FOLDER(150, 2),
        ASSETS_IMAGES_FOLDER(60, 2),
        ASSETS_STYLESHEETS_FOLDER(80, 2),
        ASSETS_JS_FOLDER(100, 2),
        ASSETS_CUSTOM_FOLDER(120, 2),
        ASSETS_DEFAULT_FOLDER(150, 2),
        CONTROLLER(CLASS.getWeight(), 5, 3),
        HELPER(0, 6),
        PARTIALS_FOLDER(0, 7),
        ACTION(METHOD.getWeight(), 10, 8),
        VIEW(METHOD.getWeight(), 10, 9),
        MIGRATIONS_FOLDER(0, 1),
        MODEL_CLASS(CLASS.getWeight(), 5, 4),
        DB_SCHEMA(0, 10),
        DB_FIELD(0, 1),
        DB_ASSOCIATION(DB_FIELD.getWeight(), DB_FIELD.getTypeSortWeight(false), 20);

        private final int myWeight;
        private final int myTypeSortWeight_Common;
        private final int myTypeSortWeight_ByType;

        private SortInfo(int weight, int typeSortWeight_Common, int typeSortWeight_ByType) {
            this.myWeight = weight;
            this.myTypeSortWeight_Common = typeSortWeight_Common;
            this.myTypeSortWeight_ByType = typeSortWeight_ByType;
        }

        private SortInfo(int weight, int typeSortWeight) {
            this(weight, typeSortWeight, typeSortWeight);
        }

        private SortInfo(int weight) {
            this(weight, 0);
        }

        public int getWeight() {
            return this.myWeight;
        }

        public int getTypeSortWeight(boolean sortByType) {
            return sortByType ? this.myTypeSortWeight_ByType : this.myTypeSortWeight_Common;
        }
    }
}

