/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.projectView_old.v2.nodes;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.AbstractModuleNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.platform.ModuleAttachProcessor;
import com.intellij.util.containers.ContainerUtil;
import icons.RubyIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.rails.codeInsight.sprockets.SprocketAssetsLoadPathManager;
import org.jetbrains.plugins.ruby.rails.facet.RailsFacetUtil;
import org.jetbrains.plugins.ruby.rails.facet.configuration.RailsPaths;
import org.jetbrains.plugins.ruby.rails.facet.configuration.StandardRailsPaths;
import org.jetbrains.plugins.ruby.rails.model.RailsApp;
import org.jetbrains.plugins.ruby.rails.projectView_old.v2.nodes.AbstractRailsPsiNodeDescriptor;
import org.jetbrains.plugins.ruby.rails.projectView_old.v2.nodes.FileNode;
import org.jetbrains.plugins.ruby.rails.projectView_old.v2.nodes.FileWithDoubleNameNode;
import org.jetbrains.plugins.ruby.rails.projectView_old.v2.nodes.ModuleExternalLibrariesNode;
import org.jetbrains.plugins.ruby.rails.projectView_old.v2.nodes.RailsNodeDescriptor;
import org.jetbrains.plugins.ruby.rails.projectView_old.v2.nodes.folders.AbstractFolderNode;
import org.jetbrains.plugins.ruby.rails.projectView_old.v2.nodes.folders.AppFolderNode;
import org.jetbrains.plugins.ruby.rails.projectView_old.v2.nodes.folders.ApplicationFolderNode;
import org.jetbrains.plugins.ruby.rails.projectView_old.v2.nodes.folders.AssetsTopLevelFolderNode;
import org.jetbrains.plugins.ruby.rails.projectView_old.v2.nodes.folders.ChannelsFolderNode;
import org.jetbrains.plugins.ruby.rails.projectView_old.v2.nodes.folders.ConfigFolderNode;
import org.jetbrains.plugins.ruby.rails.projectView_old.v2.nodes.folders.ControllersFolderNode;
import org.jetbrains.plugins.ruby.rails.projectView_old.v2.nodes.folders.LayoutsFolder;
import org.jetbrains.plugins.ruby.rails.projectView_old.v2.nodes.folders.LibFolderNode;
import org.jetbrains.plugins.ruby.rails.projectView_old.v2.nodes.folders.LogFolderNode;
import org.jetbrains.plugins.ruby.rails.projectView_old.v2.nodes.folders.MailersFolderNode;
import org.jetbrains.plugins.ruby.rails.projectView_old.v2.nodes.folders.MigrationsFolder;
import org.jetbrains.plugins.ruby.rails.projectView_old.v2.nodes.folders.MinorFolderNode;
import org.jetbrains.plugins.ruby.rails.projectView_old.v2.nodes.folders.ModelsFolderNode;
import org.jetbrains.plugins.ruby.rails.projectView_old.v2.nodes.folders.PublicFolderNode;
import org.jetbrains.plugins.ruby.rails.projectView_old.v2.nodes.folders.RSpecFolderNode;
import org.jetbrains.plugins.ruby.rails.projectView_old.v2.nodes.folders.SharedPartialsFolderNode;
import org.jetbrains.plugins.ruby.rails.projectView_old.v2.nodes.folders.TestUnitTestsFolderNode;
import org.jetbrains.plugins.ruby.rails.projectView_old.v2.nodes.folders.UnclassifiedDBFolderNode;
import org.jetbrains.plugins.ruby.rails.projectView_old.v2.nodes.folders.UnclassifiedHelpersFolderNode;
import org.jetbrains.plugins.ruby.rails.projectView_old.v2.nodes.folders.UnclassifiedViewsFolderNode;
import org.jetbrains.plugins.ruby.rails.projectView_old.v2.nodes.folders.VendorFolderNode;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.utils.RubyVirtualFileScanner;

public class RailsModuleNode
extends AbstractModuleNode
implements RailsNodeDescriptor {
    private static final Logger LOG = Logger.getInstance(RailsModuleNode.class);
    public static final Key<Boolean> RAILS_VIEW_TEST_MODE_HIDE_LIBRARIES = Key.create((String)"RAILS_VIEW_TEST_MODE_HIDE_LIBRARIES");
    public static final Set<String> CUSTOMIZED_HOME_SUBFOLDERS_NAMES = Set.of("app", "config", "db", "lib", "log", "public", "vendor", "test", "spec");
    public static final Set<String> IGNORED_HOME_SUBFOLDERS_NAMES = Set.of(".idea");
    public static final Set<String> CUSTOMIZED_APP_SUBFOLDERS_NAMES = Collections.singleton("lib");
    private final boolean myIsRubyModuleType;
    @NotNull
    private final RailsNodeDescriptor.SortInfo mySortInfo;
    private Set<VirtualFile> myDirectoriesToMimic;

    public RailsModuleNode(@NotNull Module module, ViewSettings viewSettings) {
        if (module == null) {
            RailsModuleNode.$$$reportNull$$$0(0);
        }
        super(module.getProject(), module, viewSettings);
        this.myDirectoriesToMimic = new HashSet<VirtualFile>();
        this.myIsRubyModuleType = RModuleUtil.getInstance().isRubyModule(module);
        this.mySortInfo = ModuleAttachProcessor.getPrimaryModule((Project)module.getProject()) == module ? RailsNodeDescriptor.SortInfo.PRIMARY_NODE_NODE : RailsNodeDescriptor.SortInfo.DEFAULT_NODE;
    }

    @NotNull
    public Collection<? extends AbstractTreeNode<?>> getChildren() {
        ArrayList nodesList = new ArrayList();
        RailsNodeDescriptor.runSafeReadActionOrCancel(() -> {
            VirtualFile root;
            VirtualFile appAssetsDir;
            VirtualFile migrationsRoot;
            Module module = (Module)this.getValue();
            assert (module != null);
            if (module.isDisposed()) {
                return;
            }
            StandardRailsPaths staticPaths = RailsFacetUtil.getRailsAppStaticPaths((Module)module);
            assert (staticPaths != null) : "Rails path is null for " + String.valueOf(module);
            VirtualFileManager fileManager = VirtualFileManager.getInstance();
            ViewSettings viewSettings = this.getSettings();
            VirtualFile homeDir = RailsFacetUtil.getRailsAppHomeDir((Module)module);
            if (homeDir == null) {
                return;
            }
            ModuleFileIndex fileIndex = ModuleRootManager.getInstance((Module)module).getFileIndex();
            if (!homeDir.isValid()) {
                return;
            }
            RailsApp railsApp = RailsApp.fromModule((Module)module);
            if (railsApp == null) {
                return;
            }
            SprocketAssetsLoadPathManager manager = SprocketAssetsLoadPathManager.getInstance((RailsApp)railsApp);
            Set assetsRoots = manager.getAssetsRoots();
            List files = RubyVirtualFileScanner.searchFilesUnderDirectory((Module)module, (VirtualFile)homeDir, (boolean)true, (boolean)false);
            for (VirtualFile fileOrDir : files) {
                if (!fileOrDir.isValid() || assetsRoots.contains(fileOrDir)) continue;
                AbstractTreeNode folderNode = RailsModuleNode.createNodeForDirUnderApplicationHome(fileOrDir, fileIndex, module, viewSettings, staticPaths);
                if (folderNode != null) {
                    nodesList.add(folderNode);
                    continue;
                }
                if (!"app".equals(fileOrDir.getName()) || !fileOrDir.isDirectory()) continue;
                RailsModuleNode.processAppFolderContent(fileOrDir, assetsRoots, module, nodesList, viewSettings);
            }
            if (!RailsModuleNode.hasModelsFolder(nodesList) && (migrationsRoot = RailsPaths.findDefaultFile((Module)module, (String)"db/migrate")) != null) {
                nodesList.add(new MigrationsFolder(module, viewSettings));
            }
            if ((appAssetsDir = RailsPaths.findDefaultFile((Module)module, (String)"app/assets")) != null) {
                nodesList.add(new AssetsTopLevelFolderNode(module, appAssetsDir, viewSettings));
            }
            if ((root = RailsPaths.findDefaultFile((Module)module, (String)"app/controllers")) != null) {
                nodesList.add(new ApplicationFolderNode(module, viewSettings));
            }
            if ((root = RailsPaths.findDefaultFile((Module)module, (String)"app/views", (String[])new String[]{"shared"})) != null) {
                nodesList.add(new SharedPartialsFolderNode(module, viewSettings));
            }
            if ((root = RailsPaths.findDefaultFile((Module)module, (String)"app/views", (String[])new String[]{"layouts"})) != null) {
                nodesList.add(new LayoutsFolder(module, viewSettings));
            }
            if (!RailsModuleNode.hideLibraryContentsInTests(module)) {
                Project project = this.getProject();
                assert (project != null);
                ModuleExternalLibrariesNode libraryGroupNode = new ModuleExternalLibrariesNode(project, module, viewSettings);
                nodesList.add(libraryGroupNode);
            }
        });
        HashSet directoriesToMimic = ContainerUtil.newHashSet((Object[])ModuleRootManager.getInstance((Module)Objects.requireNonNull((Module)this.getValue())).getContentRoots());
        nodesList.forEach(it -> {
            VirtualFile dirToMimic;
            VirtualFile virtualFile;
            if ((it instanceof AbstractFolderNode || it instanceof FileNode) && (virtualFile = ((AbstractRailsPsiNodeDescriptor)it).getVirtualFile()) != null && (dirToMimic = virtualFile.getParent()) != null && dirToMimic.isValid() && dirToMimic.isDirectory()) {
                directoriesToMimic.add(dirToMimic);
            }
        });
        this.myDirectoriesToMimic = directoriesToMimic;
        ArrayList arrayList = nodesList;
        if (arrayList == null) {
            RailsModuleNode.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    private static boolean hideLibraryContentsInTests(Module module) {
        assert (module != null) : "we do not expect null module  here";
        Boolean data = (Boolean)module.getUserData(RAILS_VIEW_TEST_MODE_HIDE_LIBRARIES);
        return data != null && data != false;
    }

    private static boolean hasModelsFolder(List<AbstractTreeNode<?>> nodesList) {
        for (AbstractTreeNode<?> abstractTreeNode : nodesList) {
            if (!(abstractTreeNode instanceof ModelsFolderNode)) continue;
            return true;
        }
        return false;
    }

    private static void processAppFolderContent(VirtualFile appDir, Set<VirtualFile> assetsRoots, Module module, List<AbstractTreeNode<?>> nodesList, ViewSettings viewSettings) {
        String appDirUrl = appDir.getUrl();
        List files = RubyVirtualFileScanner.searchFilesUnderDirectory((Module)module, (VirtualFile)appDir, (boolean)true, (boolean)false);
        for (VirtualFile fileOrDir : files) {
            if (!fileOrDir.isValid() || fileOrDir.getName().equals("assets") || assetsRoots.contains(fileOrDir)) continue;
            AbstractRailsPsiNodeDescriptor folderNode = null;
            if (fileOrDir.isDirectory()) {
                String dirName = fileOrDir.getName();
                if ("controllers".equals(dirName)) {
                    folderNode = ControllersFolderNode.create(module, viewSettings);
                } else if ("models".equals(dirName)) {
                    folderNode = ModelsFolderNode.create(module, viewSettings);
                } else if ("helpers".equals(dirName)) {
                    folderNode = UnclassifiedHelpersFolderNode.create(module, viewSettings);
                } else if ("views".equals(dirName)) {
                    folderNode = UnclassifiedViewsFolderNode.create(module, viewSettings);
                } else if ("channels".equals(dirName)) {
                    folderNode = new ChannelsFolderNode(module, viewSettings);
                } else if ("mailers".equals(dirName)) {
                    folderNode = new MailersFolderNode(module, viewSettings);
                } else if (!CUSTOMIZED_APP_SUBFOLDERS_NAMES.contains(dirName)) {
                    folderNode = new AppFolderNode(module, fileOrDir, viewSettings);
                }
            } else {
                folderNode = new FileWithDoubleNameNode(module, fileOrDir, appDirUrl, viewSettings);
            }
            if (folderNode == null) continue;
            nodesList.add((AbstractTreeNode<?>)folderNode);
        }
    }

    @Nullable
    private static AbstractTreeNode createNodeForDirUnderApplicationHome(VirtualFile fileOrDir, ModuleFileIndex moduleFileIndex, Module module, ViewSettings viewSettings, StandardRailsPaths railsPaths) {
        if (fileOrDir.isDirectory()) {
            String dirName = fileOrDir.getName();
            if (IGNORED_HOME_SUBFOLDERS_NAMES.contains(dirName)) {
                return null;
            }
            if (!CUSTOMIZED_HOME_SUBFOLDERS_NAMES.contains(dirName)) {
                return new MinorFolderNode(module, fileOrDir, moduleFileIndex.isInTestSourceContent(fileOrDir), viewSettings);
            }
            return switch (dirName) {
                case "spec" -> new RSpecFolderNode(module, viewSettings);
                case "test" -> new TestUnitTestsFolderNode(module, viewSettings);
                case "app" -> null;
                case "config" -> new ConfigFolderNode(module, viewSettings);
                case "db" -> new UnclassifiedDBFolderNode(module, viewSettings);
                case "lib" -> new LibFolderNode(module, viewSettings);
                case "public" -> new PublicFolderNode(module, viewSettings);
                case "log" -> new LogFolderNode(module, viewSettings);
                case "vendor" -> new VendorFolderNode(module, viewSettings);
                default -> {
                    LOG.error("Unexpected folder in Rails view: " + fileOrDir.getPath());
                    yield null;
                }
            };
        }
        return new FileNode(module, fileOrDir, railsPaths.getRailsApplicationHomeURL(), viewSettings);
    }

    public void update(@NotNull PresentationData presentation) {
        if (presentation == null) {
            RailsModuleNode.$$$reportNull$$$0(2);
        }
        super.update(presentation);
        Module module = (Module)this.getValue();
        if (module == null || module.isDisposed()) {
            this.setValue(null);
            return;
        }
        Icon closedIcon = this.myIsRubyModuleType ? RubyIcons.Rails.ProjectView.RailsModuleFolder : RubyIcons.Rails.ProjectView.JrailsModuleFolder;
        presentation.setIcon(closedIcon);
    }

    @Override
    @NonNls
    @Nullable
    public Condition<AnAction> getPreselectNewActionCondition() {
        return null;
    }

    @Override
    @NotNull
    public RailsNodeDescriptor.SortInfo getSortInformation() {
        RailsNodeDescriptor.SortInfo sortInfo = this.mySortInfo;
        if (sortInfo == null) {
            RailsModuleNode.$$$reportNull$$$0(3);
        }
        return sortInfo;
    }

    @Override
    public boolean canDelete() {
        return true;
    }

    public int getWeight() {
        return this.getSortInformation().getWeight();
    }

    public int getTypeSortWeight(boolean sortByType) {
        return this.getSortInformation().getTypeSortWeight(sortByType);
    }

    public boolean canRepresent(Object element) {
        if (element instanceof VirtualFile) {
            return this.myDirectoriesToMimic.contains(element);
        }
        return super.canRepresent(element);
    }

    public boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            RailsModuleNode.$$$reportNull$$$0(4);
        }
        if (super.contains(file)) {
            return true;
        }
        if (!RailsModuleNode.hideLibraryContentsInTests((Module)this.getValue())) {
            Collection<AbstractTreeNode<?>> treeNodes = this.getChildren();
            for (AbstractTreeNode<?> treeNode : treeNodes) {
                if (!(treeNode instanceof ModuleExternalLibrariesNode)) continue;
                return ((ModuleExternalLibrariesNode)treeNode).contains(file);
            }
        }
        return false;
    }

    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        RailsModuleNode node = (RailsModuleNode)o;
        return node.mySortInfo == this.mySortInfo && node.myIsRubyModuleType == this.myIsRubyModuleType;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.mySortInfo.hashCode();
        result = 31 * result + (this.myIsRubyModuleType ? 1 : 0);
        return result;
    }

    public static String getUnclassifiedTitle() {
        return RBundle.message((String)"rails.project.module.view.nodes.unclassified.mark");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/projectView_old/v2/nodes/RailsModuleNode";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/projectView_old/v2/nodes/RailsModuleNode";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortInformation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3 -> new IllegalStateException(string);
        };
    }
}

