/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.projectView_old.v2.nodes;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.ObjectUtils;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.projectView_old.id.NodeId;
import org.jetbrains.plugins.ruby.rails.projectView_old.v2.nodes.AbstractRailsPsiNodeDescriptor;
import org.jetbrains.plugins.ruby.rails.projectView_old.v2.nodes.RailsNodeDescriptor;

public class FileNode
extends AbstractRailsPsiNodeDescriptor<PsiFile>
implements RailsNodeDescriptor {
    private static final Logger LOG = Logger.getInstance(FileNode.class);

    public FileNode(@NotNull Module module, @NotNull VirtualFile file, @Nullable String locationMark, ViewSettings viewSettings) {
        if (module == null) {
            FileNode.$$$reportNull$$$0(0);
        }
        if (file == null) {
            FileNode.$$$reportNull$$$0(1);
        }
        super(module, viewSettings, FileNode.createNodeIdForFileNode(module, file, locationMark));
    }

    @Override
    public String getTestPresentation() {
        if (!this.isValid()) {
            return "File: null";
        }
        return "File: " + this.getFilePresentableName((PsiFile)this.extractNotNullPsiFromValue());
    }

    protected Collection<AbstractTreeNode<?>> getChildrenImpl() {
        return null;
    }

    private static NodeId<PsiFile> createNodeIdForFileNode(@NotNull Module module, @NotNull VirtualFile file, @Nullable String locationMark) {
        PsiFile psiFile;
        if (module == null) {
            FileNode.$$$reportNull$$$0(2);
        }
        if (file == null) {
            FileNode.$$$reportNull$$$0(3);
        }
        LOG.assertTrue((psiFile = PsiManager.getInstance((Project)module.getProject()).findFile(file)) != null, (Object)("Virtual file: " + file.getPath()));
        return new NodeId<PsiFile>(psiFile, locationMark);
    }

    @Override
    @NotNull
    public RailsNodeDescriptor.SortInfo getSortInformation() {
        RailsNodeDescriptor.SortInfo sortInfo = RailsNodeDescriptor.SortInfo.FILE;
        if (sortInfo == null) {
            FileNode.$$$reportNull$$$0(4);
        }
        return sortInfo;
    }

    public Comparable getTypeSortKey() {
        return (Comparable)ObjectUtils.doIfNotNull((Object)this.getVirtualFile(), it -> new PsiFileNode.ExtensionSortKey(FileNode.computeExtensionForSortKey(it)));
    }

    @NotNull
    private static String computeExtensionForSortKey(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            FileNode.$$$reportNull$$$0(5);
        }
        String realExtension = virtualFile.getExtension();
        FileType fileType = virtualFile.getFileType();
        String string = !(fileType instanceof PlainTextFileType) || StringUtil.isEmpty((String)realExtension) ? fileType.getDefaultExtension() : realExtension;
        if (string == null) {
            FileNode.$$$reportNull$$$0(6);
        }
        return string;
    }

    public boolean canRepresent(Object element) {
        if (element instanceof VirtualFile) {
            return Comparing.equal((Object)element, (Object)this.getVirtualFile());
        }
        return super.canRepresent(element);
    }

    @Override
    protected void updateImpl(@NotNull PresentationData data) {
        if (data == null) {
            FileNode.$$$reportNull$$$0(7);
        }
        PsiFile value = (PsiFile)this.extractPsiFromValue();
        assert (value != null);
        @NlsSafe String presentableName = this.getFilePresentableName(value);
        data.setPresentableText(presentableName);
        data.setIcon(value.getIcon(2));
    }

    protected String getFilePresentableName(@NotNull PsiFile file) {
        if (file == null) {
            FileNode.$$$reportNull$$$0(8);
        }
        return file.getName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/projectView_old/v2/nodes/FileNode";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/projectView_old/v2/nodes/FileNode";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortInformation";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "computeExtensionForSortKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createNodeIdForFileNode";
                break;
            }
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "computeExtensionForSortKey";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "updateImpl";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getFilePresentableName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 6 -> new IllegalStateException(string);
        };
    }
}

