/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.projectView_old.v2.nodes;

import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.DropTargetNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CustomizedDataContext;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringActionHandlerFactory;
import com.intellij.refactoring.move.MoveHandler;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.facet.configuration.RailsPaths;
import org.jetbrains.plugins.ruby.rails.model.RailsAction;
import org.jetbrains.plugins.ruby.rails.model.RailsController;
import org.jetbrains.plugins.ruby.rails.model.RailsHelper;
import org.jetbrains.plugins.ruby.rails.model.RailsLayout;
import org.jetbrains.plugins.ruby.rails.model.RailsView;
import org.jetbrains.plugins.ruby.rails.nameConventions.ControllersConventions;
import org.jetbrains.plugins.ruby.rails.projectView_old.v2.PreselectTemplateCondition;
import org.jetbrains.plugins.ruby.rails.projectView_old.v2.nodes.ClassNode;
import org.jetbrains.plugins.ruby.rails.projectView_old.v2.nodes.ControllerActionNode;
import org.jetbrains.plugins.ruby.rails.projectView_old.v2.nodes.FileNode;
import org.jetbrains.plugins.ruby.rails.projectView_old.v2.nodes.HelperNode;
import org.jetbrains.plugins.ruby.rails.projectView_old.v2.nodes.MethodNode;
import org.jetbrains.plugins.ruby.rails.projectView_old.v2.nodes.RailsNodeDescriptor;
import org.jetbrains.plugins.ruby.rails.projectView_old.v2.nodes.ViewNode;
import org.jetbrains.plugins.ruby.rails.projectView_old.v2.nodes.folders.ControllerPartialsFolder;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.utils.RubyVirtualFileScanner;

public final class ControllerClassNode
extends ClassNode
implements DropTargetNode {
    private final RailsController myController;
    @NotNull
    private Set<VirtualFile> myDirectoriesToMimic;

    public ControllerClassNode(@NotNull Module module, @NotNull RailsController controller, ViewSettings viewSettings) {
        if (module == null) {
            ControllerClassNode.$$$reportNull$$$0(0);
        }
        if (controller == null) {
            ControllerClassNode.$$$reportNull$$$0(1);
        }
        super(module, controller.getRClass(), "CONTROLLER_IN_CONTROLLERS_SUBTREE", viewSettings);
        this.myDirectoriesToMimic = new HashSet<VirtualFile>();
        this.myController = controller;
    }

    public boolean canDrop(TreeNode @NotNull [] sourceNodes) {
        PsiFileSystemItem[] sourceElements;
        if (sourceNodes == null) {
            ControllerClassNode.$$$reportNull$$$0(2);
        }
        if (!this.isValid()) {
            return false;
        }
        Project project = this.getProject();
        PsiDirectory viewsFolder = this.getViewsFolder(project);
        if (viewsFolder != null && (sourceElements = ControllerClassNode.extractPsiItems(sourceNodes, project)).length > 0) {
            return MoveHandler.canMove((PsiElement[])sourceElements, (PsiElement)viewsFolder);
        }
        return false;
    }

    @Nullable
    private PsiDirectory getViewsFolder(@NotNull Project project) {
        if (project == null) {
            ControllerClassNode.$$$reportNull$$$0(3);
        }
        VirtualFile virtualFile = this.getVirtualFile();
        assert (virtualFile != null);
        RailsController controller = RailsController.fromFile((Module)this.getModule(), (VirtualFile)virtualFile);
        assert (controller != null);
        return ControllerClassNode.getViewsFolder(controller, project);
    }

    public void drop(TreeNode @NotNull [] sourceNodes, @NotNull DataContext dataContext) {
        PsiFileSystemItem[] sourceElements;
        if (dataContext == null) {
            ControllerClassNode.$$$reportNull$$$0(4);
        }
        if (sourceNodes == null) {
            ControllerClassNode.$$$reportNull$$$0(5);
        }
        if (!this.isValid()) {
            return;
        }
        Project project = this.getProject();
        PsiDirectory viewsFolder = this.getViewsFolder(project);
        if (viewsFolder != null && (sourceElements = ControllerClassNode.extractPsiItems(sourceNodes, project)).length != 0) {
            this.doDrop(viewsFolder, sourceElements, dataContext, false);
        }
    }

    public void dropExternalFiles(PsiFileSystemItem @Nullable [] sourceFileArray, DataContext dataContext) {
        if (sourceFileArray == null) {
            return;
        }
        if (!this.isValid()) {
            return;
        }
        Project project = this.getProject();
        PsiDirectory viewsFolder = this.getViewsFolder(project);
        if (viewsFolder != null) {
            this.doDrop(viewsFolder, sourceFileArray, dataContext, true);
        }
    }

    private void doDrop(PsiDirectory viewsFolder, PsiFileSystemItem[] sourceElements, DataContext dataContext, boolean externalDrop) {
        RefactoringActionHandler moveHandler = RefactoringActionHandlerFactory.getInstance().createMoveHandler();
        moveHandler.invoke(this.myProject, (PsiElement[])sourceElements, CustomizedDataContext.withSnapshot((DataContext)(externalDrop ? DataContext.EMPTY_CONTEXT : dataContext), sink -> sink.set(LangDataKeys.TARGET_PSI_ELEMENT, (Object)viewsFolder)));
    }

    private static PsiFileSystemItem[] extractPsiItems(TreeNode[] sourceNodes, Project project) {
        ArrayList<PsiDirectory> files = new ArrayList<PsiDirectory>();
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        for (TreeNode sourceNode : sourceNodes) {
            Object item;
            VirtualFile virtualFile;
            Object userObject;
            if (!(sourceNode instanceof DefaultMutableTreeNode) || !((userObject = ((DefaultMutableTreeNode)sourceNode).getUserObject()) instanceof FileNode) || (virtualFile = ((FileNode)userObject).getVirtualFile()) == null || (item = virtualFile.isDirectory() ? psiManager.findDirectory(virtualFile) : psiManager.findFile(virtualFile)) == null) continue;
            files.add((PsiDirectory)item);
        }
        return files.toArray(new PsiFileSystemItem[0]);
    }

    @Nullable
    public static PsiDirectory getViewsFolder(@NotNull RailsController controller, @NotNull Project project) {
        VirtualFile viewsFolder;
        if (controller == null) {
            ControllerClassNode.$$$reportNull$$$0(6);
        }
        if (project == null) {
            ControllerClassNode.$$$reportNull$$$0(7);
        }
        if ((viewsFolder = (VirtualFile)ContainerUtil.getFirstItem((List)controller.getViewsFolders())) != null) {
            return PsiManager.getInstance((Project)project).findDirectory(viewsFolder);
        }
        return null;
    }

    @Override
    protected void buildChildren(@NotNull List<? super AbstractTreeNode<?>> children, @NotNull List<? super TextRange> nestedEntitiesRanges) {
        RailsHelper helper;
        if (children == null) {
            ControllerClassNode.$$$reportNull$$$0(8);
        }
        if (nestedEntitiesRanges == null) {
            ControllerClassNode.$$$reportNull$$$0(9);
        }
        RClass rClass = (RClass)this.extractPsiFromValue();
        assert (rClass != null);
        HashSet<VirtualFile> directoriesToMimic = new HashSet<VirtualFile>();
        RailsController controller = RailsController.fromClass((RClass)rClass);
        assert (controller != null) : rClass.getName();
        Module module = this.getModule();
        ViewSettings settings = this.getSettings();
        VirtualFile viewsFolder = (VirtualFile)ContainerUtil.getFirstItem((List)controller.getViewsFolders());
        if (viewsFolder != null) {
            directoriesToMimic.add(viewsFolder);
            ControllerPartialsFolder partials = new ControllerPartialsFolder(module, viewsFolder, settings);
            if (!controller.isApplicationController() || !partials.getChildren().isEmpty()) {
                children.add((AbstractTreeNode<?>)partials);
            }
        }
        if ((helper = controller.getHelper()) != null) {
            VirtualFile helperContainer = helper.getFile().getParent();
            if (helperContainer != null && helperContainer.isValid()) {
                directoriesToMimic.add(helperContainer);
            }
            children.add((AbstractTreeNode<?>)new HelperNode(module, helper.getRModule(), settings));
        }
        super.buildChildren(children, nestedEntitiesRanges);
        if (viewsFolder != null) {
            directoriesToMimic.add(viewsFolder);
            List files = RubyVirtualFileScanner.searchFilesUnderDirectory((Module)module, (VirtualFile)viewsFolder, (boolean)false, (boolean)false);
            for (VirtualFile file : files) {
                RailsView view = RailsView.fromFile((VirtualFile)file, (Module)module);
                if (view != null && (view.isPartial() || view.getAction() != null)) continue;
                children.add((AbstractTreeNode<?>)(view != null ? new ViewNode(module, view.getFile(), settings) : new FileNode(module, file, "CONTROLLERS_SUBTREE", settings)));
            }
        }
        this.myDirectoriesToMimic = directoriesToMimic;
    }

    @Override
    public boolean canRepresent(Object element) {
        return super.canRepresent(element) || element instanceof VirtualFile && this.myDirectoriesToMimic.contains(element);
    }

    @Override
    @Nullable
    protected MethodNode createNodeForMethod(Module module, RMethod method, String parentLocationRootMark) {
        if (RailsAction.fromMethod((RMethod)method) != null) {
            return new ControllerActionNode(this.getModule(), method, this.getSettings());
        }
        return null;
    }

    @Override
    @NotNull
    protected String getNamePrefix() {
        return "Controller";
    }

    public boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            ControllerClassNode.$$$reportNull$$$0(10);
        }
        VirtualFile virtualFile = this.getVirtualFile();
        assert (virtualFile != null);
        RailsController controller = RailsController.fromFile((Module)this.getModule(), (VirtualFile)virtualFile);
        return ControllerClassNode.isFileBelongsToController(file, controller);
    }

    public static boolean isFileBelongsToController(VirtualFile file, RailsController controller) {
        if (controller == null) {
            return false;
        }
        if (Comparing.equal((Object)file, (Object)controller.getFile())) {
            return true;
        }
        RailsHelper helper = controller.getHelper();
        if (helper != null && Comparing.equal((Object)file, (Object)helper.getFile())) {
            return true;
        }
        if (Comparing.equal((Object)file, (Object)ControllerClassNode.findDirectoryForHelper(controller))) {
            return true;
        }
        VirtualFile viewsFolder = (VirtualFile)ContainerUtil.getFirstItem((List)controller.getViewsFolders());
        if (viewsFolder != null && VfsUtilCore.isAncestor((VirtualFile)viewsFolder, (VirtualFile)file, (boolean)false)) {
            return true;
        }
        List layouts = controller.getAllLayouts();
        for (RailsLayout layout : layouts) {
            if (!Comparing.equal((Object)file, (Object)layout.getFile())) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void updateImpl(@NotNull PresentationData data) {
        if (data == null) {
            ControllerClassNode.$$$reportNull$$$0(11);
        }
        super.updateImpl(data);
        data.setIcon(AllIcons.Nodes.Controller);
    }

    @Override
    @NotNull
    public RailsNodeDescriptor.SortInfo getSortInformation() {
        RailsNodeDescriptor.SortInfo sortInfo = RailsNodeDescriptor.SortInfo.CONTROLLER;
        if (sortInfo == null) {
            ControllerClassNode.$$$reportNull$$$0(12);
        }
        return sortInfo;
    }

    @Override
    public boolean validate() {
        if (!super.validate()) {
            return false;
        }
        RClass rClass = (RClass)this.extractPsiFromValue();
        assert (rClass != null);
        if (RailsController.fromClass((RClass)rClass) == null) {
            this.setValue(null);
        }
        return this.getValue() != null;
    }

    @Override
    public Condition<AnAction> getPreselectNewActionCondition() {
        return new PreselectTemplateCondition("Erb File");
    }

    @Override
    public PsiDirectory[] getAssociatedDirectories() {
        PsiDirectory[] psiDirectoryArray;
        if (!this.isValid()) {
            return null;
        }
        PsiDirectory viewsFolder = this.getViewsFolder(this.getProject());
        if (viewsFolder != null) {
            PsiDirectory[] psiDirectoryArray2 = new PsiDirectory[1];
            psiDirectoryArray = psiDirectoryArray2;
            psiDirectoryArray2[0] = viewsFolder;
        } else {
            psiDirectoryArray = null;
        }
        return psiDirectoryArray;
    }

    @Override
    public String getNodeTypeName() {
        return "controller";
    }

    public RailsController getController() {
        return this.myController;
    }

    @Nullable
    private static VirtualFile findDirectoryForHelper(@NotNull RailsController controller) {
        String relativePath;
        if (controller == null) {
            ControllerClassNode.$$$reportNull$$$0(13);
        }
        if ((relativePath = ControllersConventions.getRelativePathOfControllerFolder((String)controller.getFile().getParent().getUrl(), (Module)controller.getModule())) == null) {
            return null;
        }
        Module module = controller.getModule();
        VirtualFile helpersRoot = RailsPaths.findDefaultFile((Module)module, (String)"app/helpers");
        if (helpersRoot == null) {
            return null;
        }
        return relativePath.isEmpty() ? helpersRoot : helpersRoot.findFileByRelativePath(relativePath);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 6: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controller";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceNodes";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nestedEntitiesRanges";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/projectView_old/v2/nodes/ControllerClassNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/projectView_old/v2/nodes/ControllerClassNode";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortInformation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "canDrop";
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getViewsFolder";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "drop";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "buildChildren";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "updateImpl";
                break;
            }
            case 12: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findDirectoryForHelper";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 12 -> new IllegalStateException(string);
        };
    }
}

