/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.projectView_old.v2;

import com.intellij.ide.SelectInContext;
import com.intellij.ide.impl.ProjectViewSelectInTarget;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.rails.projectView_old.v2.RailsProjectViewPane;

public class RailsProjectViewSelectInTarget
extends ProjectViewSelectInTarget
implements DumbAware {
    private final RailsProjectViewPane myRailsProjectViewPane;

    protected RailsProjectViewSelectInTarget(Project project, RailsProjectViewPane railsProjectViewPane) {
        super(project);
        this.myRailsProjectViewPane = railsProjectViewPane;
    }

    public String toString() {
        return RBundle.message((String)"select.in.rails");
    }

    public String getMinorViewId() {
        return "RailsProjectView";
    }

    public float getWeight() {
        return this.myRailsProjectViewPane.getWeight();
    }

    public boolean isSubIdSelectable(String subId, SelectInContext context) {
        return true;
    }

    protected boolean canSelect(PsiFileSystemItem psiFileSystemItem) {
        return super.canSelect(psiFileSystemItem);
    }

    public void select(PsiElement element, boolean requestFocus) {
        PsiElement toSelect = RailsProjectViewSelectInTarget.getElementToSelect(element);
        if (toSelect == null) {
            return;
        }
        PsiElement originalElement = toSelect.getOriginalElement();
        VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)originalElement);
        this.select(originalElement, virtualFile, requestFocus);
    }

    @Nullable
    private static PsiElement getElementToSelect(PsiElement element) {
        PsiFile baseRootFile = RailsProjectViewSelectInTarget.getFileForBaseLanguage(element);
        if (baseRootFile == null) {
            return null;
        }
        FileViewProvider viewProvider = baseRootFile.getViewProvider();
        PsiElement elementAtBaseLang = viewProvider.findElementAt(element.getTextOffset(), viewProvider.getBaseLanguage());
        return elementAtBaseLang != null ? elementAtBaseLang : baseRootFile;
    }

    @Nullable
    private static PsiFile getFileForBaseLanguage(PsiElement element) {
        PsiFile containingFile = element.getContainingFile();
        if (containingFile == null) {
            return null;
        }
        FileViewProvider viewProvider = containingFile.getViewProvider();
        return viewProvider.getPsi(viewProvider.getBaseLanguage());
    }
}

