/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.projectView_old.v2;

import com.intellij.facet.ProjectWideFacetAdapter;
import com.intellij.facet.ProjectWideFacetListener;
import com.intellij.facet.ProjectWideFacetListenersRegistry;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.SelectInTarget;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.ide.projectView.impl.AbstractProjectViewPaneWithAsyncSupport;
import com.intellij.ide.projectView.impl.ProjectAbstractTreeStructureBase;
import com.intellij.ide.projectView.impl.ProjectViewTree;
import com.intellij.ide.projectView.impl.nodes.AbstractModuleNode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.registry.RegistryValueListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.tree.TreeUtil;
import icons.RubyIcons;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.rails.RailsUtil;
import org.jetbrains.plugins.ruby.rails.codeInsight.sprockets.assetsPaths.AssetsRegistrationWatcher;
import org.jetbrains.plugins.ruby.rails.database.MigrationParser;
import org.jetbrains.plugins.ruby.rails.facet.RailsFacetUtil;
import org.jetbrains.plugins.ruby.rails.facet.versions.RailsFacet;
import org.jetbrains.plugins.ruby.rails.facet.versions.RailsFacetType;
import org.jetbrains.plugins.ruby.rails.projectView_old.id.NodeId;
import org.jetbrains.plugins.ruby.rails.projectView_old.v2.RailsProjectViewSelectInTarget;
import org.jetbrains.plugins.ruby.rails.projectView_old.v2.RailsProjectViewTreeStructure;
import org.jetbrains.plugins.ruby.rails.projectView_old.v2.nodes.AbstractRailsPsiNodeDescriptor;
import org.jetbrains.plugins.ruby.rails.projectView_old.v2.nodes.ClassNode;
import org.jetbrains.plugins.ruby.rails.projectView_old.v2.nodes.ControllerClassNode;
import org.jetbrains.plugins.ruby.rails.projectView_old.v2.nodes.RailsNodeDescriptor;
import org.jetbrains.plugins.ruby.rails.projectView_old.v2.nodes.folders.ModelsFolderNode;
import org.jetbrains.plugins.ruby.rails.projectView_old.v2.providers.DestroyRailsElementProvider;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.utils.RubyPluginUtil;

public final class RailsProjectViewPane
extends AbstractProjectViewPaneWithAsyncSupport
implements MigrationParser.MigrationListener {
    private static final Logger LOG = Logger.getInstance(RailsProjectViewPane.class);
    public static final DataKey<RailsProjectViewPane> RAILS_VIEW = DataKey.create((String)"railsView");
    @NonNls
    public static final String ID = "RailsProjectView";
    static final String ENABLED_KEY = "ruby.rails.projectView.enabled";
    private boolean myIsShown;

    @VisibleForTesting
    public RailsProjectViewPane(@NotNull Project project) {
        if (project == null) {
            RailsProjectViewPane.$$$reportNull$$$0(0);
        }
        super(project);
        Registry.get((String)ENABLED_KEY).addListener(new RegistryValueListener(){

            public void afterValueChanged(@NotNull RegistryValue value) {
                if (value == null) {
                    1.$$$reportNull$$$0(0);
                }
                RailsProjectViewPane.this.onFacetsChanged();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/plugins/ruby/rails/projectView_old/v2/RailsProjectViewPane$1", "afterValueChanged"));
            }
        }, RubyPluginUtil.getUnloadAwareDisposable((Project)project));
        ProjectWideFacetListenersRegistry.getInstance((Project)project).registerListener(RailsFacetType.getInstance().getId(), (ProjectWideFacetListener)new ProjectWideFacetAdapter<RailsFacet>(){

            public void firstFacetAdded() {
                LOG.info("first facet added");
                RailsProjectViewPane.this.onFacetsChanged();
            }

            public void allFacetsRemoved() {
                LOG.info("all facets removed");
                RailsProjectViewPane.this.onFacetsChanged();
            }
        }, (Disposable)this);
        MessageBusConnection connection = project.getMessageBus().connect((Disposable)this);
        connection.subscribe(MigrationParser.MIGRATIONS_CHANGED_TOPIC, (Object)this);
        connection.subscribe(AssetsRegistrationWatcher.ASSETS_CHANGED_TOPIC, this::moduleUpdated);
        connection.subscribe(ModuleListener.TOPIC, (Object)new ModuleListener(){

            public void modulesAdded(@NotNull Project project, @NotNull List<? extends Module> modules) {
                if (project == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (modules == null) {
                    3.$$$reportNull$$$0(1);
                }
                for (Module module : modules) {
                    RailsProjectViewPane.this.moduleUpdated(module);
                }
            }

            public void moduleRemoved(@NotNull Project project, @NotNull Module module) {
                if (project == null) {
                    3.$$$reportNull$$$0(2);
                }
                if (module == null) {
                    3.$$$reportNull$$$0(3);
                }
                RailsProjectViewPane.this.moduleUpdated(module);
            }

            public void modulesRenamed(@NotNull Project project, @NotNull List<? extends Module> modules, @NotNull Function<? super Module, String> oldNameProvider) {
                if (project == null) {
                    3.$$$reportNull$$$0(4);
                }
                if (modules == null) {
                    3.$$$reportNull$$$0(5);
                }
                if (oldNameProvider == null) {
                    3.$$$reportNull$$$0(6);
                }
                modules.forEach(module -> RailsProjectViewPane.this.moduleUpdated((Module)module));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 1: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "modules";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "module";
                        break;
                    }
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "oldNameProvider";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/projectView_old/v2/RailsProjectViewPane$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "modulesAdded";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "moduleRemoved";
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[2] = "modulesRenamed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public boolean isInitiallyVisible() {
        this.myIsShown = RailsProjectViewPane.isEnabled() && RailsUtil.getAllModulesWithRailsSupport((Project)this.myProject).length > 0;
        return this.myIsShown;
    }

    @NotNull
    public String getTitle() {
        String string = RBundle.message((String)"rails.project.module.view.presentable");
        if (string == null) {
            RailsProjectViewPane.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = RubyIcons.Rails.Rails;
        if (icon == null) {
            RailsProjectViewPane.$$$reportNull$$$0(2);
        }
        return icon;
    }

    @NotNull
    public String getId() {
        return ID;
    }

    public int getWeight() {
        return 5;
    }

    private void onFacetsChanged() {
        boolean shouldShow;
        boolean bl = shouldShow = RailsProjectViewPane.isEnabled() && RailsUtil.getAllModulesWithRailsSupport((Project)this.myProject).length > 0;
        if (shouldShow && !this.myIsShown) {
            this.addMe();
        }
        if (!shouldShow && this.myIsShown) {
            this.removeMe();
        }
    }

    private void addMe() {
        ProjectView projectView = ProjectView.getInstance((Project)this.myProject);
        projectView.addProjectPane((AbstractProjectViewPane)this);
        this.myIsShown = true;
    }

    private void removeMe() {
        ProjectView projectView = ProjectView.getInstance((Project)this.myProject);
        projectView.removeProjectPane((AbstractProjectViewPane)this);
        this.myIsShown = false;
    }

    @NotNull
    public SelectInTarget createSelectInTarget() {
        return new RailsProjectViewSelectInTarget(this.myProject, this);
    }

    @NotNull
    protected ProjectAbstractTreeStructureBase createStructure() {
        return new RailsProjectViewTreeStructure(this.myProject, this.getId());
    }

    @NotNull
    protected ProjectViewTree createTree(@NotNull DefaultTreeModel treeModel) {
        if (treeModel == null) {
            RailsProjectViewPane.$$$reportNull$$$0(3);
        }
        return new ProjectViewTree(treeModel){

            public String toString() {
                return RailsProjectViewPane.this.getTitle() + " " + super.toString();
            }
        };
    }

    @NotNull
    public List<PsiElement> getElementsFromNode(@Nullable Object node) {
        Object psiElement;
        Object o = this.getValueFromNode(node);
        if (o instanceof NodeId && (psiElement = ((NodeId)o).getPsiElement()) != null && psiElement.isValid()) {
            List<PsiElement> list = Collections.singletonList(psiElement);
            if (list == null) {
                RailsProjectViewPane.$$$reportNull$$$0(4);
            }
            return list;
        }
        List list = super.getElementsFromNode(node);
        if (list == null) {
            RailsProjectViewPane.$$$reportNull$$$0(5);
        }
        return list;
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        if (sink == null) {
            RailsProjectViewPane.$$$reportNull$$$0(6);
        }
        super.uiDataSnapshot(sink);
        sink.set(RAILS_VIEW, (Object)this);
        for (TreePath path : (TreePath[])ObjectUtils.notNull((Object)this.getSelectionPaths(), (Object)new TreePath[0])) {
            Condition<AnAction> condition;
            RailsNodeDescriptor node = (RailsNodeDescriptor)TreeUtil.getLastUserObject(RailsNodeDescriptor.class, (TreePath)path);
            Condition<AnAction> condition2 = condition = node == null ? null : node.getPreselectNewActionCondition();
            if (condition == null) continue;
            sink.set(LangDataKeys.PRESELECT_NEW_ACTION_CONDITION, condition);
            break;
        }
    }

    protected void uiDataSnapshotForSelection(@NotNull DataSink sink, @Nullable Object @NotNull [] selectedUserObjects, @Nullable @Nullable Object @Nullable [] singleSelectedPathUserObjects) {
        if (sink == null) {
            RailsProjectViewPane.$$$reportNull$$$0(7);
        }
        if (selectedUserObjects == null) {
            RailsProjectViewPane.$$$reportNull$$$0(8);
        }
        super.uiDataSnapshotForSelection(sink, selectedUserObjects, singleSelectedPathUserObjects);
        sink.lazy(PlatformDataKeys.DELETE_ELEMENT_PROVIDER, () -> {
            for (Object node : selectedUserObjects) {
                if (node instanceof ClassNode) {
                    ClassNode classNode = (ClassNode)node;
                    Module module = classNode.getModule();
                    String scriptExecutablePath = RailsUtil.getRailsScriptExecutablePath((Module)module, (String)"rails");
                    String nodeTypeName = classNode.getNodeTypeName();
                    if (nodeTypeName != null) {
                        String name = node instanceof ControllerClassNode ? ((ControllerClassNode)node).getController().getQualifiedName() : classNode.getName();
                        return new DestroyRailsElementProvider(module, scriptExecutablePath, nodeTypeName, name);
                    }
                }
                if (!(node instanceof RailsNodeDescriptor) || ((RailsNodeDescriptor)node).canDelete()) continue;
                return DisabledDeleteProvider.INSTANCE;
            }
            return null;
        });
    }

    public PsiDirectory @NotNull [] getSelectedDirectories() {
        PsiDirectory[] associatedDirectories;
        AbstractRailsPsiNodeDescriptor nodeDescriptor;
        List selectedNodes = this.getSelectedNodes(AbstractRailsPsiNodeDescriptor.class);
        if (selectedNodes.size() == 1 && (nodeDescriptor = (AbstractRailsPsiNodeDescriptor)selectedNodes.get(0)) != null && (associatedDirectories = nodeDescriptor.getAssociatedDirectories()) != null) {
            if (associatedDirectories == null) {
                RailsProjectViewPane.$$$reportNull$$$0(9);
            }
            return associatedDirectories;
        }
        PsiDirectory[] psiDirectoryArray = super.getSelectedDirectories();
        if (psiDirectoryArray == null) {
            RailsProjectViewPane.$$$reportNull$$$0(10);
        }
        return psiDirectoryArray;
    }

    protected PsiDirectory @NotNull [] getSelectedDirectoriesInAmbiguousCase(Object userObject) {
        Module module;
        if (userObject instanceof AbstractModuleNode && RailsFacetUtil.hasRailsSupport((Module)(module = (Module)((AbstractModuleNode)userObject).getValue()))) {
            PsiDirectory homePsiDir;
            VirtualFile homeDir = RailsFacetUtil.getRailsAppHomeDir((Module)module);
            PsiDirectory psiDirectory = homePsiDir = homeDir != null ? PsiManager.getInstance((Project)this.myProject).findDirectory(homeDir) : null;
            if (homePsiDir != null) {
                PsiDirectory[] psiDirectoryArray = new PsiDirectory[]{homePsiDir};
                if (psiDirectoryArray == null) {
                    RailsProjectViewPane.$$$reportNull$$$0(11);
                }
                return psiDirectoryArray;
            }
        }
        PsiDirectory[] psiDirectoryArray = super.getSelectedDirectoriesInAmbiguousCase(userObject);
        if (psiDirectoryArray == null) {
            RailsProjectViewPane.$$$reportNull$$$0(12);
        }
        return psiDirectoryArray;
    }

    public void migrationsChanged(Module module) {
        LOG.info("migrations changed (" + String.valueOf(module) + ")");
        ModelsFolderNode modelsFolderNode = ModelsFolderNode.create(module, ViewSettings.DEFAULT);
        if (modelsFolderNode != null) {
            this.updateFrom(modelsFolderNode, true, true);
        }
    }

    private void moduleUpdated(@Nullable Module module) {
        if (!RModuleUtil.getInstance().isRubyModule(module)) {
            return;
        }
        LOG.info("module updated (" + String.valueOf(module) + ")");
        this.updateFromRoot(true);
    }

    private static boolean isEnabled() {
        return ApplicationManager.getApplication().isUnitTestMode() || Registry.is((String)ENABLED_KEY, (boolean)false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 4, 5, 9, 10, 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/projectView_old/v2/RailsProjectViewPane";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeModel";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedUserObjects";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/projectView_old/v2/RailsProjectViewPane";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitle";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsFromNode";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedDirectories";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedDirectoriesInAmbiguousCase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createTree";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "uiDataSnapshot";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "uiDataSnapshotForSelection";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 4, 5, 9, 10, 11, 12 -> new IllegalStateException(string);
        };
    }

    private static class DisabledDeleteProvider
    implements DeleteProvider {
        public static final DisabledDeleteProvider INSTANCE = new DisabledDeleteProvider();

        private DisabledDeleteProvider() {
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                DisabledDeleteProvider.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void deleteElement(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                DisabledDeleteProvider.$$$reportNull$$$0(1);
            }
        }

        public boolean canDeleteElement(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                DisabledDeleteProvider.$$$reportNull$$$0(2);
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/rails/projectView_old/v2/RailsProjectViewPane$DisabledDeleteProvider";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/rails/projectView_old/v2/RailsProjectViewPane$DisabledDeleteProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "deleteElement";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "canDeleteElement";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }
}

