/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.undo;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramFileEditor;
import com.intellij.diagram.state.DiagramFullSnapshot;
import com.intellij.diagram.state.DiagramSnapshot;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.UnexpectedUndoException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UmlUndoableAction
extends BasicUndoableAction {
    @Nullable
    private DiagramBuilder myBuilder;
    @Nullable
    private DiagramSnapshot myOldState;
    @Nullable
    private DiagramSnapshot myNewState;

    public UmlUndoableAction(@NotNull DiagramBuilder builder, @NotNull DiagramSnapshot oldState, PsiFile @NotNull [] files) {
        if (builder == null) {
            UmlUndoableAction.$$$reportNull$$$0(0);
        }
        if (oldState == null) {
            UmlUndoableAction.$$$reportNull$$$0(1);
        }
        if (files == null) {
            UmlUndoableAction.$$$reportNull$$$0(2);
        }
        super(UmlUndoableAction.getAffectedDocuments(builder, files));
        this.myBuilder = builder;
        this.myOldState = oldState;
        this.myNewState = DiagramFullSnapshot.Factory.getInstance().makeSnapshot(builder);
        Disposer.register((Disposable)builder, () -> {
            this.myBuilder = null;
            this.myOldState = null;
            this.myNewState = null;
        });
    }

    public void undo() throws UnexpectedUndoException {
        PsiDocumentManager.getInstance((Project)this.getBuilder().getProject()).commitAllDocuments();
        this.getOldState().restoreAsync(this.getBuilder());
    }

    public void redo() throws UnexpectedUndoException {
        PsiDocumentManager.getInstance((Project)this.getBuilder().getProject()).commitAllDocuments();
        this.getNewState().restoreAsync(this.getBuilder());
    }

    @NotNull
    private DiagramBuilder getBuilder() {
        DiagramBuilder diagramBuilder = Objects.requireNonNull(this.myBuilder);
        if (diagramBuilder == null) {
            UmlUndoableAction.$$$reportNull$$$0(3);
        }
        return diagramBuilder;
    }

    @NotNull
    private DiagramFileEditor getEditor() {
        DiagramFileEditor diagramFileEditor = Objects.requireNonNull(this.getBuilder().getEditor());
        if (diagramFileEditor == null) {
            UmlUndoableAction.$$$reportNull$$$0(4);
        }
        return diagramFileEditor;
    }

    @NotNull
    private DiagramSnapshot getOldState() {
        DiagramSnapshot diagramSnapshot = Objects.requireNonNull(this.myOldState);
        if (diagramSnapshot == null) {
            UmlUndoableAction.$$$reportNull$$$0(5);
        }
        return diagramSnapshot;
    }

    @NotNull
    private DiagramSnapshot getNewState() {
        DiagramSnapshot diagramSnapshot = Objects.requireNonNull(this.myNewState);
        if (diagramSnapshot == null) {
            UmlUndoableAction.$$$reportNull$$$0(6);
        }
        return diagramSnapshot;
    }

    public static DocumentReference @NotNull [] getAffectedDocuments(@NotNull DiagramBuilder builder, PsiFile ... files) {
        if (builder == null) {
            UmlUndoableAction.$$$reportNull$$$0(7);
        }
        if (files == null) {
            UmlUndoableAction.$$$reportNull$$$0(8);
        }
        ArrayList<DocumentReference> refs = new ArrayList<DocumentReference>();
        Optional.ofNullable(builder.getEditor()).stream().flatMap(it -> it.getDocumentReferences().stream()).forEach(refs::add);
        DocumentReference umlVirtualFileRef = builder.getDocumentReference();
        if (umlVirtualFileRef != null) {
            refs.add(umlVirtualFileRef);
        }
        for (PsiFile file : files) {
            VirtualFile vf;
            if (!file.isValid() || (vf = file.getVirtualFile()) == null || !vf.isValid()) continue;
            refs.add(DocumentReferenceManager.getInstance().create(vf));
        }
        DocumentReference[] documentReferenceArray = refs.toArray(DocumentReference.EMPTY_ARRAY);
        if (documentReferenceArray == null) {
            UmlUndoableAction.$$$reportNull$$$0(9);
        }
        return documentReferenceArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldState";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uml/undo/UmlUndoableAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uml/undo/UmlUndoableAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuilder";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getOldState";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewState";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAffectedDocuments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getAffectedDocuments";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6, 9 -> new IllegalStateException(string);
        };
    }
}

