/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.sdk;

import com.intellij.openapi.util.NlsSafe;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public enum LanguageLevel {
    RUBY18(18, "1.8"),
    RUBY19(19, "1.9"),
    RUBY20(20, "2.0"),
    RUBY21(21, "2.1"),
    RUBY22(22, "2.2"),
    RUBY23(23, "2.3"),
    RUBY24(24, "2.4"),
    RUBY25(25, "2.5"),
    RUBY26(26, "2.6"),
    RUBY27(27, "2.7"),
    RUBY30(30, "3.0"),
    RUBY31(31, "3.1"),
    RUBY32(32, "3.2"),
    RUBY33(33, "3.3"),
    RUBY34(34, "3.4");

    @TestOnly
    public static final List<LanguageLevel> SUPPORTED;
    private final int myCode;
    @NlsSafe
    private final String myShortName;

    private LanguageLevel(int code, String shortName) {
        if (shortName == null) {
            LanguageLevel.$$$reportNull$$$0(0);
        }
        this.myCode = code;
        this.myShortName = shortName;
    }

    public int getCode() {
        return this.myCode;
    }

    @NotNull
    @NlsSafe
    public String getShortName() {
        String string = this.myShortName;
        if (string == null) {
            LanguageLevel.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isGreaterThan(@Nullable LanguageLevel other) {
        return other == null || this.myCode > other.myCode;
    }

    public boolean isLessThan(@Nullable LanguageLevel other) {
        return other != null && this.myCode < other.myCode;
    }

    @NotNull
    public String toString() {
        String string = "ruby" + this.myCode;
        if (string == null) {
            LanguageLevel.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public static LanguageLevel fromString(@Nullable String languageLevelString) {
        for (LanguageLevel level : LanguageLevel.values()) {
            if (!level.toString().equals(languageLevelString)) continue;
            LanguageLevel languageLevel = level;
            if (languageLevel == null) {
                LanguageLevel.$$$reportNull$$$0(3);
            }
            return languageLevel;
        }
        return LanguageLevel.latest();
    }

    @NotNull
    public static LanguageLevel latest() {
        LanguageLevel languageLevel = RUBY34;
        if (languageLevel == null) {
            LanguageLevel.$$$reportNull$$$0(4);
        }
        return languageLevel;
    }

    static {
        SUPPORTED = List.of(RUBY23, RUBY24, RUBY25, RUBY26, RUBY27, RUBY30, RUBY31, RUBY32, RUBY33, RUBY34);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/sdk/LanguageLevel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/sdk/LanguageLevel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "fromString";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "latest";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4 -> new IllegalStateException(string);
        };
    }
}

