/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.remote.impl;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.text.Strings;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteSdkException;
import com.intellij.remote.RemoteSdkProperties;
import com.intellij.ssh.RSyncUtil;
import com.intellij.ssh.SftpChannelPermissionDeniedException;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.PathUtil;
import com.jetbrains.plugins.remotesdk.CredentialsDeployable;
import com.jetbrains.plugins.remotesdk.RemoteTransfer;
import com.jetbrains.plugins.webDeployment.DeploymentPathUtils;
import com.jetbrains.plugins.webDeployment.ExecutionContext;
import com.jetbrains.plugins.webDeployment.PublishUtils;
import com.jetbrains.plugins.webDeployment.TransferOperation;
import com.jetbrains.plugins.webDeployment.TransferTask;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.DeploymentPathMapping;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.connections.RemoteConnection;
import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.remote.RubyRemoteSdkAdditionalData;
import org.jetbrains.plugins.ruby.remote.impl.RubySshTransferConfig;
import org.jetbrains.plugins.ruby.ruby.RubyUtil;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkAdditionalData;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkSystemAccessor;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkTransfer;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;

public final class RubySshRemoteTransfer
extends RemoteTransfer
implements RubySdkTransfer {
    private static final Logger LOG = Logger.getInstance(RubySshRemoteTransfer.class);
    private static final Function<String, String> APPEND_RB_FOLDER = input -> Strings.isEmpty((String)input) ? null : input + "/rb";
    private static final Function<PathMappingSettings.PathMapping, DeploymentPathMapping> PATH_MAPPING_TO_DEPLOYMENT_MAPPING = pathMapping -> {
        assert (pathMapping != null);
        DeploymentPathMapping mapping = new DeploymentPathMapping();
        mapping.setDeployPath(pathMapping.getRemoteRoot());
        mapping.setLocalPath(pathMapping.getLocalRoot());
        return mapping;
    };
    private final RubyRemoteSdkAdditionalData myData;
    private final RemoteCredentials myCredentials;
    private final RubySdkSystemAccessor myAccessor;

    public RubySshRemoteTransfer(@Nullable Project project, @NotNull Sdk sdk) throws ExecutionException, InterruptedException {
        if (sdk == null) {
            RubySshRemoteTransfer.$$$reportNull$$$0(0);
        }
        this(project, sdk, RubyRemoteSdkAdditionalData.notNullFrom((Sdk)sdk).getRemoteCredentials(project, true));
    }

    private RubySshRemoteTransfer(@Nullable Project project, @NotNull Sdk sdk, @NotNull RemoteCredentials remoteCredentials) {
        if (sdk == null) {
            RubySshRemoteTransfer.$$$reportNull$$$0(1);
        }
        if (remoteCredentials == null) {
            RubySshRemoteTransfer.$$$reportNull$$$0(2);
        }
        super(project, null, (RemoteTransfer.HelpersTransferConfig)new RubySshTransferConfig(sdk, remoteCredentials));
        this.myData = RubyRemoteSdkAdditionalData.notNullFrom((Sdk)sdk);
        this.myCredentials = remoteCredentials;
        this.myAccessor = RubySdkSystemAccessor.from((RubySdkAdditionalData)this.myData);
        LOG.assertTrue(project == null || !project.isDefault(), (Object)"Must not use a default project for remote transfer");
    }

    private static String getRemoteHelpersPath(String helpersPath) {
        return (String)APPEND_RB_FOLDER.apply((Object)helpersPath);
    }

    @NotNull
    public static Collection<String> getHelpersPaths() {
        Collection collection = Collections2.transform((Collection)RubyUtil.getScriptBasePaths(), APPEND_RB_FOLDER);
        if (collection == null) {
            RubySshRemoteTransfer.$$$reportNull$$$0(3);
        }
        return collection;
    }

    @NotNull
    public static PathMappingSettings getHelpersMappings(@NotNull RemoteSdkProperties data) {
        if (data == null) {
            RubySshRemoteTransfer.$$$reportNull$$$0(4);
        }
        String remotePath = RubySshRemoteTransfer.getRemoteHelpersPath(data.getHelpersPath());
        PathMappingSettings mappingSettings = new PathMappingSettings();
        for (String localPath : RubySshRemoteTransfer.getHelpersPaths()) {
            mappingSettings.addMapping(localPath, remotePath);
        }
        PathMappingSettings pathMappingSettings = mappingSettings;
        if (pathMappingSettings == null) {
            RubySshRemoteTransfer.$$$reportNull$$$0(5);
        }
        return pathMappingSettings;
    }

    public void uploadHelpers() {
        LOG.info("Uploading helpers");
        if (RSyncUtil.canUseRSync()) {
            this.uploadHelpersWithRSync();
        } else {
            this.uploadHelpers(true, RubySshRemoteTransfer.getHelpersPaths(), RubySshRemoteTransfer.getRemoteHelpersPath(this.getHelpersTransferConfig().getHelpersPath()), RBundle.message((String)"upload.helpers"));
        }
        LOG.info("Helpers uploaded");
    }

    private void uploadHelpersWithRSync() {
        this.createTask(this.getProject(), RBundle.message((String)"upload.helpers"), true, indicator -> {
            String remoteHelpersPath = RubySshRemoteTransfer.getRemoteHelpersPath(this.getHelpersTransferConfig().getHelpersPath());
            try {
                for (String localHelperPath : RubySshRemoteTransfer.getHelpersPaths()) {
                    RSyncUtil.uploadWithRSync((String)localHelperPath, (String)remoteHelpersPath, (RemoteCredentials)this.myCredentials, (ProgressIndicator)indicator);
                }
            }
            catch (ExecutionException e) {
                LOG.warn("Error uploading helpers: " + e.getMessage());
            }
        }).queue();
    }

    public void updateLocalGemsCopy(@NotNull Sdk sdk, @NotNull List<PathMappingSettings.PathMapping> pathMappings, @NotNull ProgressIndicator indicator) throws RemoteSdkException {
        if (sdk == null) {
            RubySshRemoteTransfer.$$$reportNull$$$0(6);
        }
        if (pathMappings == null) {
            RubySshRemoteTransfer.$$$reportNull$$$0(7);
        }
        if (indicator == null) {
            RubySshRemoteTransfer.$$$reportNull$$$0(8);
        }
        LOG.info("Updating gems' local copy");
        if (RSyncUtil.canUseRSync()) {
            LOG.info("Downloading gems via rsync");
            try {
                RSyncUtil.download(pathMappings, (List)RubySdkTransfer.getSyncExcludeGlobs(), (RemoteCredentials)this.myCredentials, (ProgressIndicator)indicator);
            }
            catch (ExecutionException e) {
                throw new RemoteSdkException(RBundle.message((String)"dialog.message.can.t.copy.gems"), (Throwable)e);
            }
        }
        LOG.info("Downloading gems via TransferOperation");
        CredentialsDeployable deployable = new CredentialsDeployable(this.myCredentials);
        deployable.setId("Download Dir" + String.valueOf(deployable));
        try {
            RemoteTransfer.RemoteSdkExecutionContext context = this.createCopyGemContext(indicator, (Deployable)deployable, indicator.getText(), pathMappings);
            RubySshRemoteTransfer.copyLocations(sdk, context, RubySshRemoteTransfer.convertMappingsToLocation(pathMappings));
        }
        catch (FileSystemException e) {
            LOG.warn((Throwable)e);
            PublishUtils.showLoginDialogAfterAuthFail((Throwable)e, (Deployable)deployable);
        }
    }

    @NotNull
    public RubySdkSystemAccessor getSystemAccessor() {
        RubySdkSystemAccessor rubySdkSystemAccessor = this.myAccessor;
        if (rubySdkSystemAccessor == null) {
            RubySshRemoteTransfer.$$$reportNull$$$0(9);
        }
        return rubySdkSystemAccessor;
    }

    public void moveFileToLocalPath(@NotNull String sourcePath, @NotNull String newParentDir, boolean replaceExisting, @NotNull ProgressIndicator progressIndicator) throws FileSystemException {
        if (sourcePath == null) {
            RubySshRemoteTransfer.$$$reportNull$$$0(10);
        }
        if (newParentDir == null) {
            RubySshRemoteTransfer.$$$reportNull$$$0(11);
        }
        if (progressIndicator == null) {
            RubySshRemoteTransfer.$$$reportNull$$$0(12);
        }
        LOG.debug("Transferring file '" + sourcePath + "' to new parent dir '" + newParentDir + "', replace: " + replaceExisting);
        RemoteTransfer.RemoteSdkExecutionContext context = this.createCopyGemContext(progressIndicator, (Deployable)new CredentialsDeployable(this.myCredentials), RBundle.message((String)"file.system.moving.file", (Object[])new Object[]{Paths.get(sourcePath, new String[0]).getFileName().toString()}), RubySshRemoteTransfer.getHelpersMappings((RemoteSdkProperties)this.myData).getPathMappings());
        context.setServerSideModification(true);
        FileObject sourceFile = context.findRemoteFile(new WebServerConfig.RemotePath(sourcePath), true);
        FileObject targetFile = DeploymentPathUtils.getLocalFile((String)Paths.get(newParentDir, PathUtil.getFileName((String)sourcePath)).toString());
        TransferOperation.RemoteMoveOrCopy operation = new TransferOperation.RemoteMoveOrCopy(sourceFile, targetFile, false, replaceExisting, true);
        operation.execute((ExecutionContext)context);
        LOG.debug("File + '" + String.valueOf(sourceFile.getName()) + "' is transferred successfully.");
    }

    private static List<String> convertMappingsToLocation(List<PathMappingSettings.PathMapping> pathMappings) {
        ArrayList<String> locations = new ArrayList<String>();
        for (PathMappingSettings.PathMapping pathMapping : pathMappings) {
            locations.add(new File(pathMapping.getLocalRoot()).getAbsolutePath());
        }
        return locations;
    }

    private RemoteTransfer.RemoteSdkExecutionContext createCopyGemContext(ProgressIndicator indicator, Deployable deployable, String message, List<PathMappingSettings.PathMapping> pathMappings) throws FileSystemException {
        RemoteConnection connection = this.openConnection(message, deployable, indicator);
        RemoteTransfer.RemoteSdkExecutionContext context = this.getRemoteSdkExecutionContext(indicator, connection, deployable);
        context.setServerSideModification(false);
        context.setPromptForOverwrite(true);
        PublishConfig publishConfig = context.getConfig();
        publishConfig.setCreateEmptyDirectories(true);
        publishConfig.setOverwriteAll(false);
        publishConfig.setPromptOnLocalOverwrite(false);
        publishConfig.setDeleteMissingItems(true);
        publishConfig.setConfirmBeforeDeletion(false);
        publishConfig.setConfirmBeforeUploading(false);
        publishConfig.setPathMappings(deployable.getId(), Lists.transform(pathMappings, PATH_MAPPING_TO_DEPLOYMENT_MAPPING));
        publishConfig.setExcludeMask(publishConfig.getExcludeMask().replace(".git;", "").replace(";.git", ""));
        return context;
    }

    protected RemoteTransfer.RemoteSdkExecutionContext getRemoteSdkExecutionContext(@NotNull ProgressIndicator indicator, @Nullable RemoteConnection connection, @NotNull Deployable deployable) {
        if (indicator == null) {
            RubySshRemoteTransfer.$$$reportNull$$$0(13);
        }
        if (deployable == null) {
            RubySshRemoteTransfer.$$$reportNull$$$0(14);
        }
        RemoteTransfer.RemoteSdkExecutionContext context = super.getRemoteSdkExecutionContext(indicator, connection, deployable);
        String deployableId = deployable.getId();
        if (deployableId != null && deployableId.startsWith("UploadHelpers")) {
            context.getConfig().setExcludeMask("");
        }
        return context;
    }

    protected String @NotNull [] getAdditionalExcludePatterns() {
        String[] stringArray = ArrayUtil.toStringArray((Collection)RubySdkTransfer.getSyncExcludeGlobs());
        if (stringArray == null) {
            RubySshRemoteTransfer.$$$reportNull$$$0(15);
        }
        return stringArray;
    }

    private static synchronized void copyLocations(@NotNull Sdk sdk, @NotNull RemoteTransfer.RemoteSdkExecutionContext context, @NotNull List<String> locations) throws FileSystemException {
        if (sdk == null) {
            RubySshRemoteTransfer.$$$reportNull$$$0(16);
        }
        if (locations == null) {
            RubySshRemoteTransfer.$$$reportNull$$$0(17);
        }
        if (context == null) {
            RubySshRemoteTransfer.$$$reportNull$$$0(18);
        }
        RubySdkUtil.checkIfRubySdkDisposed((Sdk)sdk);
        TransferTask.ListBased.ResultWithErrors resultWithErrors = RubySshRemoteTransfer.scanFiles((ExecutionContext)context, locations);
        for (TransferOperation operation : Lists.newArrayList((Iterable)resultWithErrors.operations)) {
            RubySdkUtil.checkIfRubySdkDisposed((Sdk)sdk);
            context.getProgressIndicator().checkCanceled();
            context.getProgressIndicator().setText(operation.getProgressText((ExecutionContext)context));
            try {
                operation.execute((ExecutionContext)context);
            }
            catch (FileSystemException e) {
                if (RubySshRemoteTransfer.isPermissionDenied(e)) {
                    LOG.warn("Permission denied", (Throwable)e);
                    continue;
                }
                throw e;
            }
        }
    }

    private static boolean isPermissionDenied(FileSystemException e) {
        return ExceptionUtil.causedBy((Throwable)e, SftpChannelPermissionDeniedException.class);
    }

    private static TransferTask.ListBased.ResultWithErrors scanFiles(ExecutionContext context, Collection<String> roots) throws FileSystemException {
        ArrayList result = new ArrayList();
        DeploymentPathUtils.ErrorsAndExclusions errors = new DeploymentPathUtils.ErrorsAndExclusions();
        for (String root : roots) {
            errors.addAll(DeploymentPathUtils.processIncoming((FileObject)DeploymentPathUtils.getLocalFile((String)root), (ExecutionContext)context, result));
        }
        return new TransferTask.ListBased.ResultWithErrors(result, errors);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5, 9, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteCredentials";
                break;
            }
            case 3: 
            case 5: 
            case 9: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/remote/impl/RubySshRemoteTransfer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathMappings";
                break;
            }
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourcePath";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newParentDir";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deployable";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locations";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/remote/impl/RubySshRemoteTransfer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getHelpersPaths";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getHelpersMappings";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemAccessor";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalExcludePatterns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 5: 
            case 9: 
            case 15: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getHelpersMappings";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "updateLocalGemsCopy";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "moveFileToLocalPath";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getRemoteSdkExecutionContext";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "copyLocations";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5, 9, 15 -> new IllegalStateException(string);
        };
    }
}

