/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.remote.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.remote.RemoteFile;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.gem.RubyGemsEnvironment;
import org.jetbrains.plugins.ruby.remote.RubyRemoteInterpreterManager;
import org.jetbrains.plugins.ruby.remote.RubyRemoteSdkAdditionalData;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkConfigurationException;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkConfigurator;
import org.jetbrains.plugins.ruby.ruby.sdk.implementation.RubyImplementationHandler;
import org.jetbrains.plugins.ruby.utils.VirtualFileUtil;

public abstract class RubyRemoteSdkConfigurator
extends RubySdkConfigurator<RubyRemoteSdkAdditionalData> {
    private static final Logger LOG = Logger.getInstance(RubyRemoteSdkConfigurator.class);
    public static final String[] GEM_MAPPING_SUBDIRS = new String[]{"bin", "gems", "specifications", "bundler"};

    public void initSdk(@NotNull Sdk sdk) throws RubySdkConfigurationException {
        if (sdk == null) {
            RubyRemoteSdkConfigurator.$$$reportNull$$$0(0);
        }
        LOG.info("initializing " + String.valueOf(sdk));
        super.initSdk(sdk);
        RubyRemoteSdkConfigurator.initPathMappings(sdk);
        RubyRemoteSdkConfigurator.synchronizeFilesBetweenLocalAndRemoteHost(sdk);
    }

    public static void initPathMappings(@NotNull Sdk sdk) {
        if (sdk == null) {
            RubyRemoteSdkConfigurator.$$$reportNull$$$0(1);
        }
        RubyRemoteSdkAdditionalData.modifyRemote((Sdk)sdk, remoteSdkData -> {
            String localGemsRootPath = RubyRemoteSdkAdditionalData.getLocalGemsRootPath((Sdk)sdk);
            LinkedHashSet remoteRootPaths = ContainerUtil.newLinkedHashSet((Object[])new String[]{FileUtil.toSystemIndependentName((String)new File(RubyImplementationHandler.notNullFrom((Sdk)sdk).getDefaultGemBoxPath()).getParent())});
            remoteRootPaths.addAll(RubyGemsEnvironment.getGemPaths((Sdk)sdk));
            PathMappingSettings mappingSettings = RubyRemoteSdkConfigurator.createMappingSettings(localGemsRootPath, remoteRootPaths);
            remoteSdkData.setPathMappings(mappingSettings);
            remoteSdkData.setGemsRootUrls(RubyRemoteSdkConfigurator.createGemsRootList(localGemsRootPath, remoteRootPaths));
            RubyRemoteSdkConfigurator.mapGemsBinDirectory(sdk, remoteSdkData, localGemsRootPath);
            remoteSdkData.addLoadPathMappings(sdk);
        });
    }

    private static void synchronizeFilesBetweenLocalAndRemoteHost(@NotNull Sdk sdk) {
        if (sdk == null) {
            RubyRemoteSdkConfigurator.$$$reportNull$$$0(2);
        }
        RubyRemoteInterpreterManager.getInstance().updateHelpers(sdk);
        RubyRemoteInterpreterManager.getInstance().updateGemsCopy(sdk, null, !ApplicationManager.getApplication().isUnitTestMode());
    }

    private static PathMappingSettings createMappingSettings(String localGemsRootPath, Set<String> remoteGemsRoots) {
        PathMappingSettings result = new PathMappingSettings();
        for (String remoteRootPath : remoteGemsRoots) {
            String localRootPath = RubyRemoteSdkConfigurator.getLocalGemPath(localGemsRootPath, remoteRootPath);
            RubyRemoteSdkConfigurator.addMapping(result, remoteRootPath, localRootPath, GEM_MAPPING_SUBDIRS);
        }
        return result;
    }

    private static List<String> createGemsRootList(String localGemsRootPath, Set<String> remoteRootPaths) {
        ArrayList<String> result = new ArrayList<String>();
        for (String remoteRootPath : remoteRootPaths) {
            String localRootPath = RubyRemoteSdkConfigurator.getLocalGemPath(localGemsRootPath, remoteRootPath);
            result.add(VirtualFileUtil.constructLocalUrl((String)(localRootPath + "/gems")));
            result.add(VirtualFileUtil.constructLocalUrl((String)(localRootPath + "/bundler/gems")));
        }
        return result;
    }

    private static void mapGemsBinDirectory(@NotNull Sdk sdk, @NotNull RubyRemoteSdkAdditionalData modifiableRemoteSdkData, @NotNull String localGemsRootPath) {
        String gemsBinDirectory;
        if (sdk == null) {
            RubyRemoteSdkConfigurator.$$$reportNull$$$0(3);
        }
        if (modifiableRemoteSdkData == null) {
            RubyRemoteSdkConfigurator.$$$reportNull$$$0(4);
        }
        if (localGemsRootPath == null) {
            RubyRemoteSdkConfigurator.$$$reportNull$$$0(5);
        }
        if ((gemsBinDirectory = RubyGemsEnvironment.getExecutableDirectory((Sdk)sdk)) == null) {
            throw new RuntimeException("Could not find gems binaries directory");
        }
        String localGemsBinPath = RubyRemoteSdkConfigurator.getLocalGemPath(localGemsRootPath, gemsBinDirectory);
        LOG.info("localGemsBinPath=" + localGemsBinPath + ", remoteGemsBinPath=" + gemsBinDirectory);
        modifiableRemoteSdkData.setGemsBinDirectory(localGemsBinPath);
        modifiableRemoteSdkData.addPathMapping(localGemsBinPath, gemsBinDirectory);
        try {
            VfsUtil.createDirectories((String)localGemsBinPath);
        }
        catch (IOException e) {
            String errorMessage = "Unable to create a local gems bin path: " + localGemsBinPath;
            LOG.error(errorMessage, (Throwable)e);
            throw new RuntimeException(errorMessage, e);
        }
    }

    @NotNull
    private static String getLocalGemPath(@NotNull String rootPath, @NotNull String remotePath) {
        if (rootPath == null) {
            RubyRemoteSdkConfigurator.$$$reportNull$$$0(6);
        }
        if (remotePath == null) {
            RubyRemoteSdkConfigurator.$$$reportNull$$$0(7);
        }
        String string = new File(rootPath, remotePath).toString();
        if (string == null) {
            RubyRemoteSdkConfigurator.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static void addMapping(@NotNull PathMappingSettings mappingSettings, @NotNull String remoteRootPath, @NotNull String localRootPath, String ... subDirs) {
        if (mappingSettings == null) {
            RubyRemoteSdkConfigurator.$$$reportNull$$$0(9);
        }
        if (remoteRootPath == null) {
            RubyRemoteSdkConfigurator.$$$reportNull$$$0(10);
        }
        if (localRootPath == null) {
            RubyRemoteSdkConfigurator.$$$reportNull$$$0(11);
        }
        if (subDirs == null) {
            RubyRemoteSdkConfigurator.$$$reportNull$$$0(12);
        }
        for (String subDir : subDirs) {
            String localPath = new File(localRootPath, subDir).getAbsolutePath();
            String remotePath = RemoteFile.createRemoteFile((String)remoteRootPath, (String)subDir).getPath();
            LOG.info("localPath=" + localPath + ", remotePath=" + remotePath);
            mappingSettings.addMapping(localPath, remotePath);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifiableRemoteSdkData";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localGemsRootPath";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootPath";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remotePath";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/remote/impl/RubyRemoteSdkConfigurator";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mappingSettings";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteRootPath";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localRootPath";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subDirs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/remote/impl/RubyRemoteSdkConfigurator";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalGemPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "initSdk";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "initPathMappings";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "synchronizeFilesBetweenLocalAndRemoteHost";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "mapGemsBinDirectory";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getLocalGemPath";
                break;
            }
            case 8: {
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addMapping";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8 -> new IllegalStateException(string);
        };
    }
}

