/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.remote.impl;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.remote.PathMappingProvider;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteMappingsManager;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remote.RemoteSdkProperties;
import com.intellij.ssh.ConnectionBuilder;
import com.intellij.ssh.DialogSshSudoPasswordStringProvider;
import com.intellij.ssh.PasswordStringProvider;
import com.intellij.ssh.RemoteCredentialsUtil;
import com.intellij.ssh.SshException;
import com.intellij.ssh.process.SshExecProcess;
import com.intellij.util.PathMappingSettings;
import com.jetbrains.plugins.remotesdk.RemoteSdkSessionUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.remote.RubyRemoteSdkAdditionalData;
import org.jetbrains.plugins.ruby.remote.impl.RubyConsoleRemoteProcessHandler;
import org.jetbrains.plugins.ruby.remote.impl.RubyRemoteProcessHandler;
import org.jetbrains.plugins.ruby.remote.impl.RubySshRemoteTransfer;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.run.ProjectAwareRubyRunner;
import org.jetbrains.plugins.ruby.ruby.run.RubyAbstractRunner;
import org.jetbrains.plugins.ruby.ruby.run.RubyCommandLine;
import org.jetbrains.plugins.ruby.ruby.run.context.RubyRunnerExecutionContext;

public class RubyRemoteRunner
extends RubyAbstractRunner
implements ProjectAwareRubyRunner {
    public static final String RUBY_PREFIX = "ruby";
    private static final Logger LOG = Logger.getInstance(RubyRemoteRunner.class);
    private static final String FIND_AVAILABLE_PORTS_SCRIPT = "require 'socket'; puts (1..%d).map{|i| TCPServer.open('127.0.0.1', 0)}.map{|server| port = server.addr[1]; server.close; port}";
    @NotNull
    protected final RubyRemoteSdkAdditionalData myData;
    @Nullable
    protected Project myProject;
    private volatile RemoteCredentials myCredentials;

    protected RubyRemoteRunner(@NotNull RubyRemoteSdkAdditionalData data, @Nullable Module module) {
        if (data == null) {
            RubyRemoteRunner.$$$reportNull$$$0(0);
        }
        super(module, data.getSdkSystemAccessor());
        this.myData = data;
        this.myProject = RModuleUtil.getInstance().getProject(module);
    }

    @NotNull
    private SshExecProcess doCreateProcess(@NotNull RubyCommandLine commandLine) throws InterruptedException, ExecutionException {
        if (commandLine == null) {
            RubyRemoteRunner.$$$reportNull$$$0(1);
        }
        ConnectionBuilder connectionBuilder = RemoteCredentialsUtil.connectionBuilder((RemoteCredentials)this.getCredentials(), (Project)this.myProject);
        RemoteSdkSessionUtil.checkConnection((ConnectionBuilder)connectionBuilder, (Project)this.myProject);
        SshExecProcess sshExecProcess = RemoteCredentialsUtil.processBuilder((ConnectionBuilder)connectionBuilder, (GeneralCommandLine)commandLine).withSudo((PasswordStringProvider)(commandLine.isAskForSudo() ? new DialogSshSudoPasswordStringProvider(this.myCredentials) : null)).withAllocatePty(commandLine.isAllocatePty()).start(60);
        if (sshExecProcess == null) {
            RubyRemoteRunner.$$$reportNull$$$0(2);
        }
        return sshExecProcess;
    }

    @NotNull
    public RubyCommandLine createCommandLine(@NotNull RubyRunnerExecutionContext context) {
        if (context == null) {
            RubyRemoteRunner.$$$reportNull$$$0(3);
        }
        RubyCommandLine rubyCommandLine = super.createCommandLine((RubyRunnerExecutionContext)this.patchCommands(context).withPathMappings(this.addDefaultMappings(context.getPathMappings())));
        if (rubyCommandLine == null) {
            RubyRemoteRunner.$$$reportNull$$$0(4);
        }
        return rubyCommandLine;
    }

    @NotNull
    public Map<String, String> getParentEnv() {
        Map<String, String> map = Collections.emptyMap();
        if (map == null) {
            RubyRemoteRunner.$$$reportNull$$$0(5);
        }
        return map;
    }

    @NotNull
    protected RubyRunnerExecutionContext patchCommands(@NotNull RubyRunnerExecutionContext context) {
        if (context == null) {
            RubyRemoteRunner.$$$reportNull$$$0(6);
        }
        RubyRunnerExecutionContext rubyRunnerExecutionContext = context;
        if (rubyRunnerExecutionContext == null) {
            RubyRemoteRunner.$$$reportNull$$$0(7);
        }
        return rubyRunnerExecutionContext;
    }

    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    public void setProject(@Nullable Project project) {
        this.myProject = project;
    }

    @NotNull
    public String toSystemDependentName(@NotNull String path, @NotNull PathMappingSettings pathMappings) {
        if (path == null) {
            RubyRemoteRunner.$$$reportNull$$$0(8);
        }
        if (pathMappings == null) {
            RubyRemoteRunner.$$$reportNull$$$0(9);
        }
        String string = pathMappings.convertToRemote(path);
        if (string == null) {
            RubyRemoteRunner.$$$reportNull$$$0(10);
        }
        return string;
    }

    protected int @NotNull [] findAvailableRemotePorts(int @NotNull [] localPorts) throws ExecutionException {
        ProcessOutput output;
        if (localPorts == null) {
            RubyRemoteRunner.$$$reportNull$$$0(11);
        }
        if ((output = (ProcessOutput)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> this.executeInSameThread(RubyRunnerExecutionContext.create((String[])new String[]{this.myData.getInterpreterPath(), "-e", String.format(FIND_AVAILABLE_PORTS_SCRIPT, localPorts.length)})), RBundle.message((String)"remote.find.available.ports.title"), false, this.myProject)).getExitCode() != 0) {
            throw new RuntimeException("unable to find available remote ports: " + output.getStderr());
        }
        ArrayList<Integer> remotePorts = new ArrayList<Integer>();
        for (String line : output.getStdoutLines()) {
            remotePorts.add(Integer.parseInt(line.trim()));
        }
        LOG.assertTrue(remotePorts.size() == localPorts.length, (Object)("Unexpected output: " + output.getStdout()));
        int[] ports = new int[remotePorts.size()];
        for (int i = 0; i < remotePorts.size(); ++i) {
            ports[i] = (Integer)remotePorts.get(i);
        }
        if (ports == null) {
            RubyRemoteRunner.$$$reportNull$$$0(12);
        }
        return ports;
    }

    @NotNull
    protected ProcessHandler createProcessHandlerInner(@NotNull RubyCommandLine commandLine, @Nullable String runnerId) throws ExecutionException {
        if (commandLine == null) {
            RubyRemoteRunner.$$$reportNull$$$0(13);
        }
        try {
            return new RubyRemoteProcessHandler(this.doCreateProcess(commandLine), commandLine.getCommandLineString());
        }
        catch (SshException | InterruptedException e) {
            throw new ExecutionException(e);
        }
    }

    @NotNull
    protected ProcessHandler createConsoleProcessHandlerInner(@NotNull RubyCommandLine commandLine) throws ExecutionException {
        if (commandLine == null) {
            RubyRemoteRunner.$$$reportNull$$$0(14);
        }
        try {
            return new RubyConsoleRemoteProcessHandler(this.doCreateProcess(commandLine), commandLine.getCommandLineString());
        }
        catch (InterruptedException e) {
            throw new ExecutionException((Throwable)e);
        }
    }

    @NotNull
    public PathMappingSettings addDefaultMappings(@Nullable PathMappingSettings pathMappings) {
        PathMappingSettings newMappingSettings = RubyRemoteRunner.addDefaultRemoteMappings(pathMappings, this.myProject, this.myData);
        newMappingSettings.addAll(RubySshRemoteTransfer.getHelpersMappings((RemoteSdkProperties)this.myData));
        newMappingSettings.addAll(this.myData.getPathMappings());
        PathMappingSettings pathMappingSettings = newMappingSettings;
        if (pathMappingSettings == null) {
            RubyRemoteRunner.$$$reportNull$$$0(15);
        }
        return pathMappingSettings;
    }

    @NotNull
    public RubyRemoteSdkAdditionalData getSdkAdditionalData() {
        RubyRemoteSdkAdditionalData rubyRemoteSdkAdditionalData = this.myData;
        if (rubyRemoteSdkAdditionalData == null) {
            RubyRemoteRunner.$$$reportNull$$$0(16);
        }
        return rubyRemoteSdkAdditionalData;
    }

    public static PathMappingSettings addDefaultRemoteMappings(@Nullable PathMappingSettings pathMappings, @Nullable Project project, @NotNull RubyRemoteSdkAdditionalData rubyRemoteSdkAdditionalData) {
        if (rubyRemoteSdkAdditionalData == null) {
            RubyRemoteRunner.$$$reportNull$$$0(17);
        }
        PathMappingSettings newMappingSettings = RubyRemoteRunner.cloneMappings(pathMappings);
        if (project != null && !project.isDisposed()) {
            RemoteMappingsManager.Mappings userDefinedMappings = RemoteMappingsManager.getInstance((Project)project).getForServer(RUBY_PREFIX, rubyRemoteSdkAdditionalData.getSdkId());
            if (userDefinedMappings != null) {
                newMappingSettings.addAll(userDefinedMappings.getSettings());
            }
            PathMappingProvider.getSuitableMappingProviders((RemoteSdkAdditionalData)rubyRemoteSdkAdditionalData).stream().map(p -> p.getPathMappingSettings(project, (RemoteSdkAdditionalData)rubyRemoteSdkAdditionalData)).flatMap(p -> p.getPathMappings().stream()).filter(pm -> !newMappingSettings.canReplaceLocal(pm.getLocalRoot())).forEach(pm -> newMappingSettings.add(pm));
        }
        return newMappingSettings;
    }

    @NotNull
    private RemoteCredentials getCredentials() throws InterruptedException, ExecutionException {
        if (this.myCredentials == null) {
            this.myCredentials = this.myData.getRemoteCredentials(this.myProject, false);
        }
        RemoteCredentials remoteCredentials = this.myCredentials;
        if (remoteCredentials == null) {
            RubyRemoteRunner.$$$reportNull$$$0(18);
        }
        return remoteCredentials;
    }

    @NotNull
    public static RubyRemoteRunner getRunner(@NotNull RubyRemoteSdkAdditionalData data, @Nullable Module module) {
        if (data == null) {
            RubyRemoteRunner.$$$reportNull$$$0(19);
        }
        return new RubyRemoteRunner(data, module);
    }

    @NotNull
    private static PathMappingSettings cloneMappings(@Nullable PathMappingSettings mappingSettings) {
        PathMappingSettings newMappingSettings = new PathMappingSettings();
        if (mappingSettings != null) {
            for (PathMappingSettings.PathMapping mapping : mappingSettings.getPathMappings()) {
                newMappingSettings.add(mapping);
            }
        }
        PathMappingSettings pathMappingSettings = newMappingSettings;
        if (pathMappingSettings == null) {
            RubyRemoteRunner.$$$reportNull$$$0(20);
        }
        return pathMappingSettings;
    }

    @NotNull
    protected String getLinuxShellCommand() {
        return "bash";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 5, 7, 10, 12, 15, 16, 18, 20 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 1: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 12: 
            case 15: 
            case 16: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/remote/impl/RubyRemoteRunner";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathMappings";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localPorts";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rubyRemoteSdkAdditionalData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/remote/impl/RubyRemoteRunner";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "doCreateProcess";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommandLine";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentEnv";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "patchCommands";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "toSystemDependentName";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "findAvailableRemotePorts";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "addDefaultMappings";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkAdditionalData";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getCredentials";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "cloneMappings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "doCreateProcess";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 12: 
            case 15: 
            case 16: 
            case 18: 
            case 20: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createCommandLine";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "patchCommands";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "toSystemDependentName";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findAvailableRemotePorts";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createProcessHandlerInner";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createConsoleProcessHandlerInner";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addDefaultRemoteMappings";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getRunner";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 5, 7, 10, 12, 15, 16, 18, 20 -> new IllegalStateException(string);
        };
    }
}

