/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.remote.impl;

import com.google.common.collect.Lists;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.remote.CredentialsType;
import com.intellij.remote.RemoteConnectionCredentialsWrapper;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remote.RemoteSdkProperties;
import com.intellij.remote.ext.CredentialsManager;
import com.intellij.ssh.config.unified.SshConfigManager;
import com.intellij.util.Alarm;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.jetbrains.plugins.remotesdk.RemoteCredentialsProducer;
import com.jetbrains.plugins.remotesdk.RemoteSdkUtil;
import com.jetbrains.plugins.remotesdk.SshCredentialsUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.util.BundlerUtil;
import org.jetbrains.plugins.ruby.gem.workspace.sync.RubySdkGemLibraryManager;
import org.jetbrains.plugins.ruby.remote.RubyRemoteInterpreterManager;
import org.jetbrains.plugins.ruby.remote.RubyRemoteSdkAdditionalData;
import org.jetbrains.plugins.ruby.remote.RubyRemoteSdkTransferListener;
import org.jetbrains.plugins.ruby.remote.impl.RemoteRubySdkSystemAccessor;
import org.jetbrains.plugins.ruby.remote.impl.RubyCreateRemoteInterpreterDialog;
import org.jetbrains.plugins.ruby.remote.impl.RubyRemoteSdkConfigurator;
import org.jetbrains.plugins.ruby.ruby.run.RubyAbstractRunner;
import org.jetbrains.plugins.ruby.ruby.run.RubyRunner;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkAdditionalData;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkConfigurator;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkSystemAccessor;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkTransfer;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkType;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;
import org.jetbrains.plugins.ruby.utils.RubyPluginUtil;

public final class RubyRemoteInterpreterManagerImpl
extends RubyRemoteInterpreterManager
implements Disposable {
    private static final Logger LOG = Logger.getInstance(RubyRemoteInterpreterManagerImpl.class);
    private static final List<String> BINARIES_TO_FETCH = List.of("bundle", "bundler", "erb", "gem", "jgem", "irb", "racc", "rake", "rbs", "rdbg", "rdoc", "ri", "ruby", "jruby", "typeprof");
    private final MergingUpdateQueue myTaskQueue;
    private final Semaphore myUpdateSemaphore = new Semaphore();

    private RubyRemoteInterpreterManagerImpl() {
        this.myTaskQueue = new MergingUpdateQueue("Updating remote sdk", 500, true, null, RubyPluginUtil.getUnloadAwareDisposable(), null, Alarm.ThreadToUse.POOLED_THREAD);
        MessageBusConnection messageBusConnection = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this);
        messageBusConnection.subscribe(SshConfigManager.SSH_CONFIGS, (Object)new SshConfigManager.Listener(){

            public void sshConfigsChanged() {
                ProjectJdkTable projectJdkTable = ProjectJdkTable.getInstance();
                SshConfigManager manager = SshConfigManager.getInstance(null);
                for (Sdk sdk : projectJdkTable.getAllJdks()) {
                    if (!(sdk.getSdkType() instanceof RubySdkType)) continue;
                    RemoteSdkUtil.updateSshConfigData((SdkAdditionalData)sdk.getSdkAdditionalData(), (SshConfigManager)manager);
                }
            }
        });
        messageBusConnection.subscribe(ProjectJdkTable.JDK_TABLE_TOPIC, (Object)new ProjectJdkTable.Listener(){

            public void jdkRemoved(@NotNull Sdk sdk) {
                if (sdk == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (RubyRemoteInterpreterManager.isRemoteSdk((Sdk)sdk)) {
                    RubyRemoteInterpreterManagerImpl.this.beforeRemoteSdkRemoved(sdk);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "org/jetbrains/plugins/ruby/remote/impl/RubyRemoteInterpreterManagerImpl$2", "jdkRemoved"));
            }
        });
        CredentialsType.EP_NAME.addExtensionPointListener(new ExtensionPointListener<CredentialsType<?>>(){

            public void extensionAdded(@NotNull CredentialsType<?> extension, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    3.$$$reportNull$$$0(1);
                }
                CredentialsManager.recogniseCredentialType(3.getStream(), extension);
            }

            public void extensionRemoved(@NotNull CredentialsType<?> extension, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    3.$$$reportNull$$$0(2);
                }
                if (pluginDescriptor == null) {
                    3.$$$reportNull$$$0(3);
                }
                CredentialsManager.forgetCredentialType(3.getStream(), extension);
            }

            private static Stream<SdkAdditionalData> getStream() {
                return Arrays.stream(ProjectJdkTable.getInstance().getAllJdks()).map(sdk -> sdk.getSdkType() instanceof RubySdkType ? sdk.getSdkAdditionalData() : null);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "extension";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/plugins/ruby/remote/impl/RubyRemoteInterpreterManagerImpl$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionAdded";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)this);
    }

    public Sdk addRemoteSdk(@Nullable Project project, @NotNull Collection<Sdk> existingSdks, SdkType @NotNull [] sdkTypes) {
        RubyCreateRemoteInterpreterDialog dialog;
        if (existingSdks == null) {
            RubyRemoteInterpreterManagerImpl.$$$reportNull$$$0(0);
        }
        if (sdkTypes == null) {
            RubyRemoteInterpreterManagerImpl.$$$reportNull$$$0(1);
        }
        return (dialog = new RubyCreateRemoteInterpreterDialog(project, existingSdks, sdkTypes)).showAndGet() ? dialog.getSdk() : null;
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isRemoteSdk(@Nullable String interpreterPath) {
        return RemoteSdkProperties.isRemoteSdk((String)interpreterPath);
    }

    public boolean producesSshSdkCredentials(@NotNull Sdk sdk) {
        RubySdkAdditionalData data;
        if (sdk == null) {
            RubyRemoteInterpreterManagerImpl.$$$reportNull$$$0(2);
        }
        if ((data = RubySdkAdditionalData.notNullFrom((Sdk)sdk)) instanceof RubyRemoteSdkAdditionalData) {
            return SshCredentialsUtil.producesSshSdkCredentials((RemoteSdkAdditionalData)((RubyRemoteSdkAdditionalData)data));
        }
        return false;
    }

    public void dispose() {
    }

    private static void prepareSdkRoots(@NotNull RubyRemoteSdkAdditionalData data) {
        if (data == null) {
            RubyRemoteInterpreterManagerImpl.$$$reportNull$$$0(3);
        }
        ApplicationManager.getApplication().invokeLater(() -> ApplicationManager.getApplication().runWriteAction(() -> {
            PathMappingSettings mappingSettings = data.getPathMappings();
            for (PathMappingSettings.PathMapping pm : mappingSettings.getPathMappings()) {
                try {
                    VfsUtil.createDirectories((String)pm.getLocalRoot());
                }
                catch (IOException iOException) {}
            }
        }));
    }

    public void updateGemsCopy(final @NotNull Sdk sdk, final @Nullable Module module, boolean asynchronous) {
        if (sdk == null) {
            RubyRemoteInterpreterManagerImpl.$$$reportNull$$$0(4);
        }
        if (!RubyRemoteInterpreterManagerImpl.isRemoteSdk((Sdk)sdk)) {
            return;
        }
        RubySdkAdditionalData data = RubySdkAdditionalData.notNullFrom((Sdk)sdk);
        assert (data instanceof RubyRemoteSdkAdditionalData);
        final RubyRemoteSdkAdditionalData remoteData = (RubyRemoteSdkAdditionalData)data;
        RubyRemoteInterpreterManagerImpl.prepareSdkRoots(remoteData);
        final String progressTitle = RBundle.message((String)"downloading.gems.title");
        if (!asynchronous || ApplicationManager.getApplication().isUnitTestMode()) {
            ProgressIndicator indicator = Objects.requireNonNullElseGet(ProgressManager.getInstance().getProgressIndicator(), ProgressIndicatorBase::new);
            indicator.setText(progressTitle);
            ProgressManager.getInstance().executeProcessUnderProgress(() -> {
                this.myUpdateSemaphore.down();
                try {
                    this.doUpdateGemsCopy(sdk, remoteData, module, indicator);
                }
                finally {
                    this.myUpdateSemaphore.up();
                }
            }, indicator);
            return;
        }
        this.myTaskQueue.queue(new Update(sdk){

            public void run() {
                RubyRemoteInterpreterManagerImpl.this.myUpdateSemaphore.down();
                Ref indicatorRef = new Ref();
                ApplicationManager.getApplication().invokeAndWait(() -> indicatorRef.set((Object)new BackgroundableProcessIndicator(null, progressTitle, PerformInBackgroundOption.ALWAYS_BACKGROUND, null, null, true)), ModalityState.any());
                ProgressManager.getInstance().runProcess(() -> {
                    try {
                        RubyRemoteInterpreterManagerImpl.this.doUpdateGemsCopy(sdk, remoteData, module, (ProgressIndicator)indicatorRef.get());
                    }
                    finally {
                        RubyRemoteInterpreterManagerImpl.this.myUpdateSemaphore.up();
                    }
                }, (ProgressIndicator)indicatorRef.get());
            }
        });
    }

    public void updateHelpers(@NotNull Sdk sdk) {
        if (sdk == null) {
            RubyRemoteInterpreterManagerImpl.$$$reportNull$$$0(5);
        }
        if (!RubyRemoteInterpreterManagerImpl.isRemoteSdk((Sdk)sdk)) {
            return;
        }
        try {
            LOG.info("Uploading helpers for " + String.valueOf(sdk) + " at " + String.valueOf(Thread.currentThread()));
            this.getRemoteTransfer(null, sdk).uploadHelpers();
            LOG.info("Helpers uploaded for " + String.valueOf(sdk) + " at " + String.valueOf(Thread.currentThread()));
        }
        catch (InterruptedException e) {
            LOG.error((Throwable)e);
        }
        catch (ExecutionException e) {
            LOG.warn((Throwable)e);
        }
    }

    @NotNull
    public RemoteCredentials getRemoteCredentials(@NotNull RemoteConnectionCredentialsWrapper wrapper, @Nullable Project project, boolean allowSynchronousInteraction) throws InterruptedException, ExecutionException {
        if (wrapper == null) {
            RubyRemoteInterpreterManagerImpl.$$$reportNull$$$0(6);
        }
        RemoteCredentials remoteCredentials = new RemoteCredentialsProducer(wrapper).getRemoteCredentials(project, allowSynchronousInteraction);
        if (remoteCredentials == null) {
            RubyRemoteInterpreterManagerImpl.$$$reportNull$$$0(7);
        }
        return remoteCredentials;
    }

    public void produceRemoteCredentials(@NotNull RemoteConnectionCredentialsWrapper wrapper, @Nullable Project project, boolean allowSynchronousInteraction, @NotNull Consumer<RemoteCredentials> consumer) {
        if (wrapper == null) {
            RubyRemoteInterpreterManagerImpl.$$$reportNull$$$0(8);
        }
        if (consumer == null) {
            RubyRemoteInterpreterManagerImpl.$$$reportNull$$$0(9);
        }
        new RemoteCredentialsProducer(wrapper).produceRemoteCredentials(project, allowSynchronousInteraction, consumer);
    }

    @NotNull
    public RubyRunner getRunner(@NotNull RubyRemoteSdkAdditionalData data, @Nullable Module module) {
        if (data == null) {
            RubyRemoteInterpreterManagerImpl.$$$reportNull$$$0(10);
        }
        RubyAbstractRunner rubyAbstractRunner = RubySdkConfigurator.from((RubySdkAdditionalData)data).buildRunner((RubySdkAdditionalData)data, module);
        if (rubyAbstractRunner == null) {
            RubyRemoteInterpreterManagerImpl.$$$reportNull$$$0(11);
        }
        return rubyAbstractRunner;
    }

    @NotNull
    public RubySdkTransfer getRemoteTransfer(@Nullable Project project, @NotNull Sdk sdk) throws ExecutionException, InterruptedException {
        if (sdk == null) {
            RubyRemoteInterpreterManagerImpl.$$$reportNull$$$0(12);
        }
        RubySdkConfigurator configurator = RubySdkConfigurator.from((Sdk)sdk);
        assert (configurator instanceof RubyRemoteSdkConfigurator) : "Got " + String.valueOf(configurator) + " instead of remote configurator ";
        RubySdkTransfer rubySdkTransfer = configurator.buildSdkTransfer(project, sdk);
        if (rubySdkTransfer == null) {
            RubyRemoteInterpreterManagerImpl.$$$reportNull$$$0(13);
        }
        return rubySdkTransfer;
    }

    @NotNull
    public RubySdkSystemAccessor getRubySdkSystemAccessor(@NotNull RubyRemoteSdkAdditionalData data) {
        if (data == null) {
            RubyRemoteInterpreterManagerImpl.$$$reportNull$$$0(14);
        }
        return new RemoteRubySdkSystemAccessor(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUpdateGemsCopy(@NotNull Sdk sdk, @NotNull RubyRemoteSdkAdditionalData remoteData, @Nullable Module module, @NotNull ProgressIndicator indicator) {
        if (sdk == null) {
            RubyRemoteInterpreterManagerImpl.$$$reportNull$$$0(15);
        }
        if (remoteData == null) {
            RubyRemoteInterpreterManagerImpl.$$$reportNull$$$0(16);
        }
        if (indicator == null) {
            RubyRemoteInterpreterManagerImpl.$$$reportNull$$$0(17);
        }
        LOG.info("Updating gems for " + String.valueOf(sdk));
        ((RubyRemoteSdkTransferListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(RUBY_REMOTE_SDK_TRANSFER_LISTENER_TOPIC)).downloadStarted(sdk);
        sdk.putUserData(RUBY_REMOTE_SDK_TRANSFER_STATE_KEY, (Object)true);
        try {
            List<PathMappingSettings.PathMapping> mappingsToCopy = RubyRemoteInterpreterManagerImpl.getMappingsToCopy(sdk, remoteData, module);
            this.getRemoteTransfer(null, sdk).updateLocalGemsCopy(sdk, mappingsToCopy, indicator);
            LOG.info("Gems for " + String.valueOf(sdk) + " updated");
            RubyRemoteInterpreterManagerImpl.refreshLocalCacheFileSystem(sdk, indicator, mappingsToCopy);
        }
        catch (InterruptedException mappingsToCopy) {
        }
        catch (ProcessCanceledException e) {
            LOG.warn("Gems copying has been canceled");
        }
        catch (ExecutionException e) {
            LOG.error("Can't copy gems:" + e.getMessage(), (Throwable)e);
        }
        finally {
            sdk.putUserData(RUBY_REMOTE_SDK_TRANSFER_STATE_KEY, (Object)false);
            ((RubyRemoteSdkTransferListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(RUBY_REMOTE_SDK_TRANSFER_LISTENER_TOPIC)).downloadComplete(sdk);
        }
    }

    private static void refreshLocalCacheFileSystem(@NotNull Sdk sdk, @NotNull ProgressIndicator indicator, @NotNull List<PathMappingSettings.PathMapping> mappingsToCopy) {
        if (sdk == null) {
            RubyRemoteInterpreterManagerImpl.$$$reportNull$$$0(18);
        }
        if (indicator == null) {
            RubyRemoteInterpreterManagerImpl.$$$reportNull$$$0(19);
        }
        if (mappingsToCopy == null) {
            RubyRemoteInterpreterManagerImpl.$$$reportNull$$$0(20);
        }
        HashSet<File> filesToRefresh = new HashSet<File>();
        for (PathMappingSettings.PathMapping pathMapping : mappingsToCopy) {
            String localRoot;
            if (pathMapping == null || StringUtil.isEmpty((String)(localRoot = pathMapping.getLocalRoot()))) continue;
            filesToRefresh.add(new File(localRoot));
        }
        LOG.info("Starting roots refresh for " + String.valueOf(sdk) + " (" + filesToRefresh.size() + " roots)");
        Application application = ApplicationManager.getApplication();
        LocalFileSystem.getInstance().refreshIoFiles(filesToRefresh, !application.isUnitTestMode(), true, () -> {
            LOG.info("Roots refreshed for " + String.valueOf(sdk) + " (" + filesToRefresh.size() + " roots); Refreshing gems;");
            RubySdkGemLibraryManager.getInstance().refreshRoots(sdk, !application.isUnitTestMode());
            RubySdkGemLibraryManager.getInstance().refresh(!application.isUnitTestMode());
        });
    }

    private static List<PathMappingSettings.PathMapping> getMappingsToCopy(@NotNull Sdk sdk, @NotNull RubyRemoteSdkAdditionalData remoteData, @Nullable Module module) {
        String remoteLockFilePath;
        String lockFilePath;
        if (sdk == null) {
            RubyRemoteInterpreterManagerImpl.$$$reportNull$$$0(21);
        }
        if (remoteData == null) {
            RubyRemoteInterpreterManagerImpl.$$$reportNull$$$0(22);
        }
        ArrayList mappings = Lists.newArrayList((Iterable)remoteData.getPathMappings().getPathMappings());
        String remoteInterpreterDir = remoteData.getInterpreterDir();
        String sdkCacheRoot = RubyRemoteSdkAdditionalData.getLocalGemsRootPath((Sdk)sdk);
        for (String binaryToFetch : BINARIES_TO_FETCH) {
            String remoteBinaryPath = FileUtil.toSystemIndependentName((String)FileUtil.join((String[])new String[]{remoteInterpreterDir, binaryToFetch}));
            String localBinaryPath = FileUtil.toSystemDependentName((String)(sdkCacheRoot + remoteBinaryPath));
            mappings.add(new PathMappingSettings.PathMapping(localBinaryPath, remoteBinaryPath));
        }
        if (module != null && (lockFilePath = BundlerUtil.getLockFilePath((Module)module)) != null && !lockFilePath.equals(remoteLockFilePath = RubySdkUtil.convertToRemote((Sdk)sdk, (Module)module, (String)lockFilePath))) {
            mappings.add(new PathMappingSettings.PathMapping(lockFilePath, remoteLockFilePath));
        }
        return mappings;
    }

    @TestOnly
    public boolean areGemsSynchronized() {
        return this.myTaskQueue.isEmpty() && this.myUpdateSemaphore.isUp();
    }

    public void fullyLoadCredentials(@NotNull RubyRemoteSdkAdditionalData data) {
        if (data == null) {
            RubyRemoteInterpreterManagerImpl.$$$reportNull$$$0(23);
        }
        RemoteSdkUtil.fullyLoadCredentials((SdkAdditionalData)data, null);
    }

    private void beforeRemoteSdkRemoved(@NotNull Sdk sdk) {
        if (sdk == null) {
            RubyRemoteInterpreterManagerImpl.$$$reportNull$$$0(24);
        }
        if (!RubyRemoteInterpreterManagerImpl.isRemoteSdk((Sdk)sdk)) {
            LOG.debug("Nothing to do before removal of non-remote sdk: ", new Object[]{sdk});
            return;
        }
        try {
            this.getRemoteTransfer(null, sdk).beforeRemoteSdkRemoved(sdk);
        }
        catch (InterruptedException e) {
            LOG.warn("Before removal steps for sdk were interrupted: " + String.valueOf(sdk));
        }
        catch (ExecutionException e) {
            LOG.error("Failed to execute before removal steps for sdk: " + String.valueOf(sdk), (Throwable)e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 11, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingSdks";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkTypes";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 12: 
            case 15: 
            case 18: 
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 3: 
            case 10: 
            case 14: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrapper";
                break;
            }
            case 7: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/remote/impl/RubyRemoteInterpreterManagerImpl";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 16: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteData";
                break;
            }
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mappingsToCopy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/remote/impl/RubyRemoteInterpreterManagerImpl";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemoteCredentials";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunner";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemoteTransfer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addRemoteSdk";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "producesSshSdkCredentials";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "prepareSdkRoots";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "updateGemsCopy";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "updateHelpers";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getRemoteCredentials";
                break;
            }
            case 7: 
            case 11: 
            case 13: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "produceRemoteCredentials";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getRunner";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getRemoteTransfer";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getRubySdkSystemAccessor";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "doUpdateGemsCopy";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "refreshLocalCacheFileSystem";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getMappingsToCopy";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "fullyLoadCredentials";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "beforeRemoteSdkRemoved";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 11, 13 -> new IllegalStateException(string);
        };
    }
}

