/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.util;

import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public final class RbsNamingConventionUtils {
    private static final String UNICODE_RANGE = "\\x7f-\\xff\\x{001C0}-\\x{10FFFF}";
    private static final String IDENT_PART_ANY_CASE = "[_A-Za-z0-9\\x7f-\\xff\\x{001C0}-\\x{10FFFF}]";
    private static final String CONST_REGEXP = "[A-Z\\p{Lu}][_A-Za-z0-9\\x7f-\\xff\\x{001C0}-\\x{10FFFF}]*";
    private static final String TYPE_ALIAS_REGEXP = "[a-z][_A-Za-z0-9\\x7f-\\xff\\x{001C0}-\\x{10FFFF}]*";
    private static final String SYMBOL_REGEXP = ":((@@?|\\$)?\\w+[?!]?|[|&/%~`^]|<=>|===?|=~|<<?|>>?|[<>]=?|[+-]@?|\\*\\*?|\\[]=?|![=~]?)";
    private static final Pattern INTERFACE_NAME_PATTERN = Pattern.compile("(::)?([A-Z\\p{Lu}][_A-Za-z0-9\\x7f-\\xff\\x{001C0}-\\x{10FFFF}]*::)*(_[A-Z\\p{Lu}][_A-Za-z0-9\\x7f-\\xff\\x{001C0}-\\x{10FFFF}]*)");
    private static final Pattern CLASS_NAME_PATTERN;
    private static final Pattern CONSTANT_NAME_PATTERN;
    private static final Pattern MODULE_NAME_PATTERN;
    private static final Pattern SYMBOL_PATTERN;
    private static final Pattern TYPE_ALIAS_NAME_PATTERN;
    private static final Pattern TYPE_VARIABLE_NAME_PATTERN;

    private RbsNamingConventionUtils() {
    }

    public static boolean isValidInterfaceName(@NotNull String name) {
        if (name == null) {
            RbsNamingConventionUtils.$$$reportNull$$$0(0);
        }
        return INTERFACE_NAME_PATTERN.matcher(name).matches();
    }

    public static boolean isValidClassName(@NotNull String name) {
        if (name == null) {
            RbsNamingConventionUtils.$$$reportNull$$$0(1);
        }
        return CLASS_NAME_PATTERN.matcher(name).matches();
    }

    public static boolean isValidConstantName(@NotNull String name) {
        if (name == null) {
            RbsNamingConventionUtils.$$$reportNull$$$0(2);
        }
        return CONSTANT_NAME_PATTERN.matcher(name).matches();
    }

    public static boolean isValidModuleName(@NotNull String name) {
        if (name == null) {
            RbsNamingConventionUtils.$$$reportNull$$$0(3);
        }
        return MODULE_NAME_PATTERN.matcher(name).matches();
    }

    public static boolean isValidSymbolName(@NotNull String name) {
        if (name == null) {
            RbsNamingConventionUtils.$$$reportNull$$$0(4);
        }
        return SYMBOL_PATTERN.matcher(name).matches();
    }

    public static boolean isValidTypeAliasName(@NotNull String name) {
        if (name == null) {
            RbsNamingConventionUtils.$$$reportNull$$$0(5);
        }
        return TYPE_ALIAS_NAME_PATTERN.matcher(name).matches();
    }

    public static boolean isValidTypeVariableName(@NotNull String name) {
        if (name == null) {
            RbsNamingConventionUtils.$$$reportNull$$$0(6);
        }
        return TYPE_VARIABLE_NAME_PATTERN.matcher(name).matches();
    }

    static {
        CONSTANT_NAME_PATTERN = CLASS_NAME_PATTERN = Pattern.compile("(::)?([A-Z\\p{Lu}][_A-Za-z0-9\\x7f-\\xff\\x{001C0}-\\x{10FFFF}]*::)*([A-Z\\p{Lu}][_A-Za-z0-9\\x7f-\\xff\\x{001C0}-\\x{10FFFF}]*)");
        MODULE_NAME_PATTERN = CLASS_NAME_PATTERN;
        SYMBOL_PATTERN = Pattern.compile(SYMBOL_REGEXP);
        TYPE_ALIAS_NAME_PATTERN = Pattern.compile("(::)?([A-Z\\p{Lu}][_A-Za-z0-9\\x7f-\\xff\\x{001C0}-\\x{10FFFF}]*::)*([a-z][_A-Za-z0-9\\x7f-\\xff\\x{001C0}-\\x{10FFFF}]*)");
        TYPE_VARIABLE_NAME_PATTERN = Pattern.compile(CONST_REGEXP);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "name";
        objectArray2[1] = "com/intellij/lang/ruby/rbs/util/RbsNamingConventionUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isValidInterfaceName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isValidClassName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isValidConstantName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isValidModuleName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isValidSymbolName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isValidTypeAliasName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isValidTypeVariableName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

