/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.util;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RObjectClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.AnonymousDefiningCallType;

public final class Fqn
implements Comparable<Fqn> {
    public static final Fqn INVALID = new Fqn();
    private static final Cache<Object, @NotNull Fqn> FLYWEIGHT = Caffeine.newBuilder().maximumSize(10000L).expireAfterAccess(10L, TimeUnit.MINUTES).build();
    private final List<@NlsSafe String> myComponents;

    private Fqn() {
        this.myComponents = Collections.emptyList();
    }

    private Fqn(@NotNull @NlsSafe String component) {
        if (component == null) {
            Fqn.$$$reportNull$$$0(0);
        }
        this.myComponents = List.of(component);
    }

    private Fqn(@NotNull List<@NlsSafe String> components) {
        if (components == null) {
            Fqn.$$$reportNull$$$0(1);
        }
        this.myComponents = List.copyOf(components);
    }

    @NotNull
    public Fqn absolute() {
        if (this == INVALID) {
            Fqn fqn = INVALID;
            if (fqn == null) {
                Fqn.$$$reportNull$$$0(2);
            }
            return fqn;
        }
        if (this.myComponents.size() == 1 && this.myComponents.get(0).startsWith("::")) {
            Fqn fqn = this;
            if (fqn == null) {
                Fqn.$$$reportNull$$$0(3);
            }
            return fqn;
        }
        String component = "::" + this.join(true);
        Fqn fqn = (Fqn)FLYWEIGHT.get((Object)component, __ -> new Fqn(component));
        if (fqn == null) {
            Fqn.$$$reportNull$$$0(4);
        }
        return fqn;
    }

    @Override
    public int compareTo(@NotNull Fqn other) {
        if (other == null) {
            Fqn.$$$reportNull$$$0(5);
        }
        List<String> components = this.split().myComponents;
        List<String> otherComponents = other.split().myComponents;
        int size = Math.min(components.size(), otherComponents.size());
        for (int i = 0; i < size; ++i) {
            int result = components.get(i).compareTo(otherComponents.get(i));
            if (result == 0) continue;
            return result;
        }
        return components.size() - otherComponents.size();
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.myComponents.equals(((Fqn)obj).myComponents);
    }

    public @NotNull List<@NlsSafe String> getComponents() {
        List<String> list = this.myComponents;
        if (list == null) {
            Fqn.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NlsSafe
    @NotNull
    public String getName() {
        String string = this.getName(false);
        if (string == null) {
            Fqn.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NlsSafe
    @NotNull
    public String getName(boolean normalize) {
        if (this == INVALID) {
            throw new UnsupportedOperationException();
        }
        String component = (String)ContainerUtil.getLastItem(this.myComponents);
        String string = normalize ? StringUtil.trimStart((String)component, (String)"::") : component;
        if (string == null) {
            Fqn.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public Fqn getParent() {
        if (this.myComponents.size() <= 1) {
            Fqn fqn = INVALID;
            if (fqn == null) {
                Fqn.$$$reportNull$$$0(9);
            }
            return fqn;
        }
        List<@NlsSafe String> components = this.myComponents.subList(0, this.myComponents.size() - 1);
        Fqn fqn = (Fqn)FLYWEIGHT.get(components, __ -> new Fqn(components));
        if (fqn == null) {
            Fqn.$$$reportNull$$$0(10);
        }
        return fqn;
    }

    public int hashCode() {
        return this.myComponents.hashCode();
    }

    public boolean isAbsolute() {
        return ContainerUtil.indexOf(this.myComponents, it -> it.startsWith("::")) >= 0;
    }

    public boolean isEquivalentTo(@NotNull Fqn other) {
        if (other == null) {
            Fqn.$$$reportNull$$$0(11);
        }
        return this == other || this.join(true).equals(other.join(true));
    }

    public boolean isEquivalentTo(@NotNull String other) {
        if (other == null) {
            Fqn.$$$reportNull$$$0(12);
        }
        return this.join(true).equals(StringUtil.trimStart((String)other, (String)"::"));
    }

    @NlsSafe
    @NotNull
    public String join() {
        String string = this.join(false);
        if (string == null) {
            Fqn.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NlsSafe
    @NotNull
    public String join(boolean normalize) {
        String joined;
        if (this.myComponents.size() == 1) {
            joined = this.myComponents.get(0);
        } else {
            int topLevelIndex = ContainerUtil.lastIndexOf(this.myComponents, component -> component.startsWith("::"));
            List<String> relevantComponents = topLevelIndex != -1 ? this.myComponents.subList(topLevelIndex, this.myComponents.size()) : this.myComponents;
            joined = String.join((CharSequence)"::", relevantComponents);
        }
        String string = normalize ? StringUtil.trimStart((String)joined, (String)"::") : joined;
        if (string == null) {
            Fqn.$$$reportNull$$$0(14);
        }
        return string;
    }

    @NotNull
    public Fqn normalize() {
        if (this == INVALID) {
            Fqn fqn = this;
            if (fqn == null) {
                Fqn.$$$reportNull$$$0(15);
            }
            return fqn;
        }
        if (this.myComponents.size() == 1 && !this.myComponents.get(0).startsWith("::")) {
            Fqn fqn = this;
            if (fqn == null) {
                Fqn.$$$reportNull$$$0(16);
            }
            return fqn;
        }
        String component = this.join(true);
        Fqn fqn = (Fqn)FLYWEIGHT.get((Object)component, __ -> new Fqn(component));
        if (fqn == null) {
            Fqn.$$$reportNull$$$0(17);
        }
        return fqn;
    }

    @NotNull
    public Fqn relativize(@NotNull Fqn nesting) {
        if (nesting == null) {
            Fqn.$$$reportNull$$$0(18);
        }
        if (nesting == INVALID) {
            Fqn fqn = this;
            if (fqn == null) {
                Fqn.$$$reportNull$$$0(19);
            }
            return fqn;
        }
        for (int i = 1; i < this.myComponents.size(); ++i) {
            if (!new Fqn(this.myComponents.subList(0, i)).isEquivalentTo(nesting)) continue;
            List<@NlsSafe String> components = this.myComponents.subList(i, this.myComponents.size());
            Fqn fqn = (Fqn)FLYWEIGHT.get(components, __ -> new Fqn(components));
            if (fqn == null) {
                Fqn.$$$reportNull$$$0(20);
            }
            return fqn;
        }
        Fqn fqn = this.relativize(nesting.getParent());
        if (fqn == null) {
            Fqn.$$$reportNull$$$0(21);
        }
        return fqn;
    }

    @NotNull
    public Fqn split() {
        if (this == INVALID) {
            Fqn fqn = INVALID;
            if (fqn == null) {
                Fqn.$$$reportNull$$$0(22);
            }
            return fqn;
        }
        if (this.myComponents.size() == 1 && !this.myComponents.get(0).contains("::")) {
            Fqn fqn = this;
            if (fqn == null) {
                Fqn.$$$reportNull$$$0(23);
            }
            return fqn;
        }
        ArrayList components = new ArrayList(this.myComponents.size());
        for (String component : this.myComponents) {
            if (component.startsWith("::")) {
                components.clear();
            }
            components.addAll(StringUtil.split((String)component, (String)"::"));
        }
        Fqn fqn = (Fqn)FLYWEIGHT.get(components, __ -> new Fqn(components));
        if (fqn == null) {
            Fqn.$$$reportNull$$$0(24);
        }
        return fqn;
    }

    @NotNull
    public String toString() {
        String string = this.join();
        if (string == null) {
            Fqn.$$$reportNull$$$0(25);
        }
        return string;
    }

    @NotNull
    public static Fqn concat(@NotNull Fqn first, @Nullable String second, String ... rest) {
        if (first == null) {
            Fqn.$$$reportNull$$$0(26);
        }
        if (first == INVALID || second == null || rest == null || ArrayUtil.contains(null, (String[])rest)) {
            Fqn fqn = INVALID;
            if (fqn == null) {
                Fqn.$$$reportNull$$$0(27);
            }
            return fqn;
        }
        ArrayList<String> components = new ArrayList<String>(first.myComponents.size() + 1 + rest.length);
        components.addAll(first.myComponents);
        components.add(second);
        components.addAll(List.of(rest));
        Fqn fqn = (Fqn)FLYWEIGHT.get(components, __ -> new Fqn(components));
        if (fqn == null) {
            Fqn.$$$reportNull$$$0(28);
        }
        return fqn;
    }

    @NotNull
    public static Fqn concat(@NotNull Fqn first, @NotNull Fqn second, Fqn ... rest) {
        if (first == null) {
            Fqn.$$$reportNull$$$0(29);
        }
        if (second == null) {
            Fqn.$$$reportNull$$$0(30);
        }
        if (rest == null) {
            Fqn.$$$reportNull$$$0(31);
        }
        return Fqn.concat(ContainerUtil.prepend(List.of(rest), (Object[])new Fqn[]{first, second}));
    }

    @NotNull
    public static Fqn concat(@NotNull List<Fqn> fqns) {
        if (fqns == null) {
            Fqn.$$$reportNull$$$0(32);
        }
        if (fqns.isEmpty() || fqns.contains(INVALID)) {
            Fqn fqn = INVALID;
            if (fqn == null) {
                Fqn.$$$reportNull$$$0(33);
            }
            return fqn;
        }
        Fqn fqn = (Fqn)FLYWEIGHT.get(List.copyOf(fqns), __ -> new Fqn(ContainerUtil.flatMap((Iterable)fqns, fqn -> fqn.myComponents)));
        if (fqn == null) {
            Fqn.$$$reportNull$$$0(34);
        }
        return fqn;
    }

    @NotNull
    public static Fqn deserialize(@NotNull DataInput input) throws IOException {
        int size;
        if (input == null) {
            Fqn.$$$reportNull$$$0(35);
        }
        if ((size = input.readInt()) == 0) {
            Fqn fqn = INVALID;
            if (fqn == null) {
                Fqn.$$$reportNull$$$0(36);
            }
            return fqn;
        }
        ArrayList<@NlsSafe String> components = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            components.add(input.readUTF());
        }
        Fqn fqn = (Fqn)FLYWEIGHT.get(components, __ -> new Fqn(components));
        if (fqn == null) {
            Fqn.$$$reportNull$$$0(37);
        }
        return fqn;
    }

    @NotNull
    public static Fqn deserialize(@NotNull StubInputStream input) throws IOException {
        int size;
        if (input == null) {
            Fqn.$$$reportNull$$$0(38);
        }
        if ((size = input.readVarInt()) == 0) {
            Fqn fqn = INVALID;
            if (fqn == null) {
                Fqn.$$$reportNull$$$0(39);
            }
            return fqn;
        }
        ArrayList<@NlsSafe String> components = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            components.add(input.readNameString());
        }
        Fqn fqn = (Fqn)FLYWEIGHT.get(components, __ -> new Fqn(components));
        if (fqn == null) {
            Fqn.$$$reportNull$$$0(40);
        }
        return fqn;
    }

    @NotNull
    public static Fqn of(@NlsSafe @Nullable String first, String ... rest) {
        if (first == null || rest == null || ArrayUtil.contains(null, (String[])rest)) {
            Fqn fqn = INVALID;
            if (fqn == null) {
                Fqn.$$$reportNull$$$0(41);
            }
            return fqn;
        }
        if (first.isEmpty() || ArrayUtil.contains((String)"", (String[])rest)) {
            Fqn fqn = INVALID;
            if (fqn == null) {
                Fqn.$$$reportNull$$$0(42);
            }
            return fqn;
        }
        if (rest.length == 0) {
            Fqn fqn = (Fqn)FLYWEIGHT.get((Object)first, __ -> new Fqn(first));
            if (fqn == null) {
                Fqn.$$$reportNull$$$0(43);
            }
            return fqn;
        }
        List<@NlsSafe String> components = List.of((String[])ArrayUtil.prepend((Object)first, (Object[])rest));
        Fqn fqn = (Fqn)FLYWEIGHT.get(components, __ -> new Fqn(components));
        if (fqn == null) {
            Fqn.$$$reportNull$$$0(44);
        }
        return fqn;
    }

    @NotNull
    public static Fqn of(@NotNull List<@NlsSafe String> components) {
        if (components == null) {
            Fqn.$$$reportNull$$$0(45);
        }
        if (components.isEmpty()) {
            Fqn fqn = INVALID;
            if (fqn == null) {
                Fqn.$$$reportNull$$$0(46);
            }
            return fqn;
        }
        Fqn fqn = (Fqn)FLYWEIGHT.get(List.copyOf(components), __ -> new Fqn(components));
        if (fqn == null) {
            Fqn.$$$reportNull$$$0(47);
        }
        return fqn;
    }

    @NotNull
    public static Fqn of(@NotNull FQN other) {
        if (other == null) {
            Fqn.$$$reportNull$$$0(48);
        }
        return Fqn.of(other, null);
    }

    @NotNull
    public static Fqn of(@NotNull FQN other, @Nullable PsiElement invocationPoint) {
        if (other == null) {
            Fqn.$$$reportNull$$$0(49);
        }
        if (invocationPoint instanceof PsiFile) {
            Fqn fqn = INVALID;
            if (fqn == null) {
                Fqn.$$$reportNull$$$0(50);
            }
            return fqn;
        }
        Fqn fqn = (Fqn)FLYWEIGHT.get((Object)other, __ -> {
            FQN normalized = other.normalize();
            if (AnonymousDefiningCallType.isAnonymousFQN((FQN)normalized)) {
                return INVALID;
            }
            String component = RObjectClass.makeNonSingletonClassFqn((FQN)normalized).getFullPath();
            return !component.isBlank() ? new Fqn(component) : INVALID;
        });
        if (fqn == null) {
            Fqn.$$$reportNull$$$0(51);
        }
        return fqn;
    }

    public static void serialize(@NotNull Fqn fqn, @NotNull DataOutput output) throws IOException {
        if (fqn == null) {
            Fqn.$$$reportNull$$$0(52);
        }
        if (output == null) {
            Fqn.$$$reportNull$$$0(53);
        }
        output.writeInt(fqn.myComponents.size());
        for (String component : fqn.myComponents) {
            output.writeUTF(component);
        }
    }

    public static void serialize(@NotNull Fqn fqn, @NotNull StubOutputStream output) throws IOException {
        if (fqn == null) {
            Fqn.$$$reportNull$$$0(54);
        }
        if (output == null) {
            Fqn.$$$reportNull$$$0(55);
        }
        output.writeVarInt(fqn.myComponents.size());
        for (String component : fqn.myComponents) {
            output.writeName(component);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 6, 7, 8, 9, 10, 13, 14, 15, 16, 17, 19, 20, 21, 22, 23, 24, 25, 27, 28, 33, 34, 36, 37, 39, 40, 41, 42, 43, 44, 46, 47, 50, 51 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 1: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 46: 
            case 47: 
            case 50: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ruby/rbs/util/Fqn";
                break;
            }
            case 5: 
            case 11: 
            case 12: 
            case 48: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nesting";
                break;
            }
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rest";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqns";
                break;
            }
            case 35: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
            case 52: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 53: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ruby/rbs/util/Fqn";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "absolute";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponents";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getParent";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "join";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "normalize";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "relativize";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "split";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 27: 
            case 28: 
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "concat";
                break;
            }
            case 36: 
            case 37: 
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "deserialize";
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 46: 
            case 47: 
            case 50: 
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "of";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 46: 
            case 47: 
            case 50: 
            case 51: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalentTo";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "relativize";
                break;
            }
            case 26: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "concat";
                break;
            }
            case 35: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 45: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "of";
                break;
            }
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 6, 7, 8, 9, 10, 13, 14, 15, 16, 17, 19, 20, 21, 22, 23, 24, 25, 27, 28, 33, 34, 36, 37, 39, 40, 41, 42, 43, 44, 46, 47, 50, 51 -> new IllegalStateException(string);
        };
    }
}

