/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.tools.collection.workspace.fileIndex;

import com.intellij.lang.ruby.rbs.tools.collection.workspace.storage.RbsCollectionLibraryEntity;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.ruby.rbs.frontback.RbsBundle;
import com.intellij.ruby.rbs.frontback.RbsIcons;
import com.intellij.util.TextWithIcon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.model.navigation.FileLocationProvider;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/lang/ruby/rbs/tools/collection/workspace/fileIndex/RbsCollectionLibraryFileLocationProvider;", "Lorg/jetbrains/plugins/ruby/model/navigation/FileLocationProvider;", "<init>", "()V", "getFileLocation", "Lcom/intellij/util/TextWithIcon;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.ruby.rbs.backend"})
final class RbsCollectionLibraryFileLocationProvider
implements FileLocationProvider {
    @Nullable
    public TextWithIcon getFileLocation(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string = file.getUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
        String fileUrl = string;
        for (RbsCollectionLibraryEntity entity : WorkspaceModel.Companion.getInstance(project).getCurrentSnapshot().entities(RbsCollectionLibraryEntity.class)) {
            if (!VfsUtilCore.isEqualOrAncestor((String)entity.getRoot().getUrl(), (String)fileUrl)) continue;
            String text = null;
            if (RModuleUtil.getInstance().getAllModulesWithRubySupport(project).length > 1) {
                Object[] objectArray = new Object[]{entity.getModuleId().getName()};
                String string2 = RbsBundle.message((String)"rbs.collection.name.with.module", (Object[])objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                text = string2;
            } else {
                String string3 = RbsBundle.message((String)"rbs.collection.name", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
                text = string3;
            }
            return new TextWithIcon(text, RbsIcons.RBS_COLLECTION_LIBRARY_ICON);
        }
        return null;
    }
}

