/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.tools.collection;

import com.intellij.lang.ruby.rbs.tools.collection.RbsCollectionConfigService;
import com.intellij.lang.ruby.rbs.tools.collection.RbsCollectionSearchScope;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiCacheKey;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
public final class RbsCollectionSearchScopeService {
    private static final PsiCacheKey<GlobalSearchScope, PsiFile> SEARCH_SCOPE_KEY = PsiCacheKey.create((String)RbsCollectionSearchScopeService.class.getName(), file -> {
        Project project = file.getProject();
        return RbsCollectionSearchScope.fromConfig(project, file, RbsCollectionConfigService.getInstance(project).getConfig((PsiFile)file));
    });

    @Nullable
    public GlobalSearchScope getSearchScope(@NotNull Project project) {
        if (project == null) {
            RbsCollectionSearchScopeService.$$$reportNull$$$0(0);
        }
        return (GlobalSearchScope)ObjectUtils.doIfNotNull((Object)ProjectUtil.guessProjectDir((Project)project), it -> this.getSearchScope(project, (VirtualFile)it));
    }

    @Nullable
    public GlobalSearchScope getSearchScope(@NotNull Project project, @NotNull VirtualFile file) {
        VirtualFile contentRoot;
        if (project == null) {
            RbsCollectionSearchScopeService.$$$reportNull$$$0(1);
        }
        if (file == null) {
            RbsCollectionSearchScopeService.$$$reportNull$$$0(2);
        }
        if ((contentRoot = ProjectFileIndex.getInstance((Project)project).getContentRootForFile(file)) == null) {
            return null;
        }
        PsiFile lockfile = (PsiFile)ObjectUtils.doIfNotNull((Object)contentRoot.findChild("rbs_collection.lock.yaml"), arg_0 -> ((PsiManager)PsiManager.getInstance((Project)project)).findFile(arg_0));
        if (lockfile == null) {
            return null;
        }
        return (GlobalSearchScope)ObjectUtils.nullizeByCondition((Object)((GlobalSearchScope)SEARCH_SCOPE_KEY.getValue((PsiElement)lockfile)), it -> !it.contains(file));
    }

    @Nullable
    public GlobalSearchScope getSearchScope(@NotNull PsiElement element) {
        if (element == null) {
            RbsCollectionSearchScopeService.$$$reportNull$$$0(3);
        }
        Project project = element.getProject();
        VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)element);
        return file != null ? this.getSearchScope(project, file) : null;
    }

    @NotNull
    public static RbsCollectionSearchScopeService getInstance() {
        RbsCollectionSearchScopeService rbsCollectionSearchScopeService = (RbsCollectionSearchScopeService)ApplicationManager.getApplication().getService(RbsCollectionSearchScopeService.class);
        if (rbsCollectionSearchScopeService == null) {
            RbsCollectionSearchScopeService.$$$reportNull$$$0(4);
        }
        return rbsCollectionSearchScopeService;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ruby/rbs/tools/collection/RbsCollectionSearchScopeService";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ruby/rbs/tools/collection/RbsCollectionSearchScopeService";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSearchScope";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

