/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.settings;

import com.intellij.lang.ruby.rbs.settings.RbsLanguageSettings;
import com.intellij.lang.ruby.rbs.tools.collection.RbsCollectionSupport;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.observable.properties.AtomicBooleanProperty;
import com.intellij.openapi.observable.properties.ObservableProperty;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.platform.backend.workspace.WorkspaceModelChangeListener;
import com.intellij.platform.backend.workspace.WorkspaceModelTopics;
import com.intellij.platform.workspace.jps.entities.ModuleEntity;
import com.intellij.platform.workspace.storage.VersionedStorageChange;
import com.intellij.ruby.rbs.frontback.RbsBundle;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u000fH\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0014H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u000fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/lang/ruby/rbs/settings/RbsLanguageConfigurable;", "Lcom/intellij/openapi/options/SearchableConfigurable;", "Lcom/intellij/openapi/options/Configurable$NoScroll;", "Lcom/intellij/openapi/Disposable$Default;", "project", "Lcom/intellij/openapi/project/Project;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "isCollectionManagementAvailable", "Lcom/intellij/openapi/observable/properties/AtomicBooleanProperty;", "checkbox", "Lcom/intellij/ui/components/JBCheckBox;", "apply", "", "createComponent", "Ljavax/swing/JComponent;", "disposeUIResources", "getDisplayName", "", "getId", "isModified", "", "reset", "intellij.ruby.rbs.backend"})
public final class RbsLanguageConfigurable
implements SearchableConfigurable,
Configurable.NoScroll,
Disposable.Default {
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope cs;
    @NotNull
    private final AtomicBooleanProperty isCollectionManagementAvailable;
    private JBCheckBox checkbox;

    public RbsLanguageConfigurable(@NotNull Project project, @NotNull CoroutineScope cs) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        this.project = project;
        this.cs = cs;
        this.isCollectionManagementAvailable = new AtomicBooleanProperty(true);
    }

    public void apply() {
        RbsLanguageSettings rbsLanguageSettings = RbsLanguageSettings.getInstance(this.project);
        JBCheckBox jBCheckBox = this.checkbox;
        if (jBCheckBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"checkbox");
            jBCheckBox = null;
        }
        rbsLanguageSettings.setCollectionManagementEnabled(jBCheckBox.isSelected());
    }

    @NotNull
    public JComponent createComponent() {
        return (JComponent)BuilderKt.panel(arg_0 -> RbsLanguageConfigurable.createComponent$lambda$3(this, arg_0));
    }

    public void disposeUIResources() {
        Disposer.dispose((Disposable)((Disposable)this));
    }

    @NotNull
    public String getDisplayName() {
        String string = RbsBundle.message((String)"rbs.language.configurable.name", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public String getId() {
        return "preferences.language.rbs";
    }

    public boolean isModified() {
        if (!this.isCollectionManagementAvailable.get().booleanValue()) {
            return false;
        }
        JBCheckBox jBCheckBox = this.checkbox;
        if (jBCheckBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"checkbox");
            jBCheckBox = null;
        }
        return jBCheckBox.isSelected() != RbsLanguageSettings.getInstance(this.project).isCollectionManagementEnabled();
    }

    public void reset() {
        JBCheckBox jBCheckBox = this.checkbox;
        if (jBCheckBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"checkbox");
            jBCheckBox = null;
        }
        jBCheckBox.setSelected(this.isCollectionManagementAvailable.get() != false && RbsLanguageSettings.getInstance(this.project).isCollectionManagementEnabled());
    }

    private static final Unit createComponent$lambda$3$lambda$1(RbsLanguageConfigurable this$0, Row $this$row) {
        Cell cell;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.enabledIf((ObservableProperty)this$0.isCollectionManagementAvailable);
        String string = RbsBundle.message((String)"rbs.language.configurable.collection.enable", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Cell it = cell = $this$row.checkBox(string);
        boolean bl = false;
        this$0.checkbox = (JBCheckBox)it.getComponent();
        JBCheckBox jBCheckBox = this$0.checkbox;
        if (jBCheckBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"checkbox");
            jBCheckBox = null;
        }
        jBCheckBox.setSelected(this$0.isCollectionManagementAvailable.get() != false && RbsLanguageSettings.getInstance(this$0.project).isCollectionManagementEnabled());
        String string2 = RbsBundle.message((String)"rbs.language.configurable.collection.description", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        Row.rowComment$default((Row)$this$row, (String)string2, (int)0, null, (int)6, null);
        return Unit.INSTANCE;
    }

    private static final Unit createComponent$lambda$3$lambda$2(RbsLanguageConfigurable this$0, boolean value) {
        JBCheckBox jBCheckBox = this$0.checkbox;
        if (jBCheckBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"checkbox");
            jBCheckBox = null;
        }
        jBCheckBox.setSelected(value && RbsLanguageSettings.getInstance(this$0.project).isCollectionManagementEnabled());
        return Unit.INSTANCE;
    }

    private static final Unit createComponent$lambda$3(RbsLanguageConfigurable this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        this$0.project.getMessageBus().connect((Disposable)this$0).subscribe(WorkspaceModelTopics.CHANGED, (Object)new WorkspaceModelChangeListener(this$0){
            final /* synthetic */ RbsLanguageConfigurable this$0;
            {
                this.this$0 = $receiver;
            }

            public void changed(VersionedStorageChange event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (!event.getChanges(ModuleEntity.class).isEmpty()) {
                    RbsLanguageConfigurable.access$isCollectionManagementAvailable$p(this.this$0).set(RbsCollectionSupport.isRbsCollectionManagementAvailable(RbsLanguageConfigurable.access$getProject$p(this.this$0)));
                }
            }
        });
        Panel.row$default((Panel)$this$panel, null, arg_0 -> RbsLanguageConfigurable.createComponent$lambda$3$lambda$1(this$0, arg_0), (int)1, null);
        this$0.isCollectionManagementAvailable.afterChange(arg_0 -> RbsLanguageConfigurable.createComponent$lambda$3$lambda$2(this$0, arg_0));
        BuildersKt.launch$default((CoroutineScope)this$0.cs, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this$0, null){
            int label;
            final /* synthetic */ RbsLanguageConfigurable this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        RbsLanguageConfigurable.access$isCollectionManagementAvailable$p(this.this$0).set(RbsCollectionSupport.isRbsCollectionManagementAvailable(RbsLanguageConfigurable.access$getProject$p(this.this$0)));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ AtomicBooleanProperty access$isCollectionManagementAvailable$p(RbsLanguageConfigurable $this) {
        return $this.isCollectionManagementAvailable;
    }

    public static final /* synthetic */ Project access$getProject$p(RbsLanguageConfigurable $this) {
        return $this.project;
    }
}

