/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.ruby.types;

import com.intellij.lang.ruby.rbs.model.api.RbsContainerSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsClassSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsModuleSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsSingletonSymbol;
import com.intellij.lang.ruby.rbs.model.psi.RbsSearchScope;
import com.intellij.lang.ruby.rbs.psi.data.RbsMethodTypeSignature;
import com.intellij.lang.ruby.rbs.psi.data.RbsProcTypeSignature;
import com.intellij.lang.ruby.rbs.psi.data.RbsQualifiedNameTypeSignature;
import com.intellij.lang.ruby.rbs.psi.data.RbsTypeSignature;
import com.intellij.lang.ruby.rbs.psi.data.RbsTypeSignatureResolver;
import com.intellij.lang.ruby.rbs.ruby.codeInsight.types.RbsRubyInterfaceType;
import com.intellij.lang.ruby.rbs.ruby.model.impl.RbsRubyClassSymbol;
import com.intellij.lang.ruby.rbs.ruby.model.impl.RbsRubyModuleSymbol;
import com.intellij.lang.ruby.rbs.ruby.model.impl.RbsRubySingletonSymbol;
import com.intellij.lang.ruby.rbs.ruby.types.RbsRubyCallArgument;
import com.intellij.lang.ruby.rbs.ruby.types.RbsRubyTypeConverter;
import com.intellij.lang.ruby.rbs.util.Fqn;
import com.intellij.lang.ruby.rbs.util.RbsFqns;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.IncomingType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.SymbolicExecutionContext;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.SymbolicTypeInferenceProvider;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.TypeInferenceComponent;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.instance.TypeInferenceInstance;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.symbolicExpression.SymbolicCall;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.SingletonClassSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.TopLevelSymbolImpl;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.Access;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.ContextImpl;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeUtilCore;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeWithNilability;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.impl.REmptyType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.impl.RModuleType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.ArgumentInfo;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RSingletonMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RBinaryExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.fields.RInstanceVariable;

public final class RbsRubyTypeUtil {
    @Nullable
    public static RbsTypeSignature extractArrayTypeVariableTypeSignature(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull RbsTypeSignature signature) {
        RbsTypeSignature resolvedSignature;
        if (project == null) {
            RbsRubyTypeUtil.$$$reportNull$$$0(0);
        }
        if (searchScope == null) {
            RbsRubyTypeUtil.$$$reportNull$$$0(1);
        }
        if (signature == null) {
            RbsRubyTypeUtil.$$$reportNull$$$0(2);
        }
        if (!((resolvedSignature = signature.apply(new RbsTypeSignatureResolver(project, searchScope))) instanceof RbsQualifiedNameTypeSignature)) {
            return null;
        }
        RbsQualifiedNameTypeSignature qualifiedNameTypeSignature = (RbsQualifiedNameTypeSignature)resolvedSignature;
        if (!qualifiedNameTypeSignature.getFqn().isEquivalentTo(RbsFqns.ARRAY_FQN)) {
            return null;
        }
        return (RbsTypeSignature)ContainerUtil.getFirstItem(qualifiedNameTypeSignature.getTypeArgumentSignatures());
    }

    @Nullable
    public static RbsTypeSignature extractHashTypeVariableTypeSignature(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull RbsTypeSignature signature) {
        RbsTypeSignature resolvedSignature;
        if (project == null) {
            RbsRubyTypeUtil.$$$reportNull$$$0(3);
        }
        if (searchScope == null) {
            RbsRubyTypeUtil.$$$reportNull$$$0(4);
        }
        if (signature == null) {
            RbsRubyTypeUtil.$$$reportNull$$$0(5);
        }
        if (!((resolvedSignature = signature.apply(new RbsTypeSignatureResolver(project, searchScope))) instanceof RbsQualifiedNameTypeSignature)) {
            return null;
        }
        RbsQualifiedNameTypeSignature qualifiedNameTypeSignature = (RbsQualifiedNameTypeSignature)resolvedSignature;
        if (!qualifiedNameTypeSignature.getFqn().isEquivalentTo(RbsFqns.HASH_FQN)) {
            return null;
        }
        return (RbsTypeSignature)ContainerUtil.getOrElse(qualifiedNameTypeSignature.getTypeArgumentSignatures(), (int)1, null);
    }

    @Nullable
    public static RbsContainerSymbol findContainerSymbolForRubyElement(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull PsiElement element) {
        Symbol context;
        if (project == null) {
            RbsRubyTypeUtil.$$$reportNull$$$0(6);
        }
        if (searchScope == null) {
            RbsRubyTypeUtil.$$$reportNull$$$0(7);
        }
        if (element == null) {
            RbsRubyTypeUtil.$$$reportNull$$$0(8);
        }
        if ((context = SymbolUtil.getScopeContextWithCaching((PsiElement)element)) == null) {
            return null;
        }
        boolean createAsSingleton = element instanceof RSingletonMethod || element instanceof RInstanceVariable && ContextImpl.getContext((PsiElement)element).getAccess() == Access.CLASS;
        return RbsRubyTypeUtil.findContainerSymbolForRubySymbol(project, searchScope, context, createAsSingleton, true);
    }

    @Nullable
    public static RbsContainerSymbol findContainerSymbolForRubySymbol(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull Symbol symbol, boolean createAsSingleton, boolean createFallbackIfMissing) {
        if (project == null) {
            RbsRubyTypeUtil.$$$reportNull$$$0(9);
        }
        if (searchScope == null) {
            RbsRubyTypeUtil.$$$reportNull$$$0(10);
        }
        if (symbol == null) {
            RbsRubyTypeUtil.$$$reportNull$$$0(11);
        }
        Fqn fqn = Fqn.of(symbol.getFQNWithNesting());
        Type type = symbol.getType();
        RbsContainerSymbol container = null;
        if (SymbolUtil.getClassTypes().contains(type) || symbol instanceof TopLevelSymbolImpl) {
            container = RbsClassSymbol.find(project, searchScope, fqn).orElse(null);
        } else if (SymbolUtil.getModuleTypes().contains(type)) {
            container = RbsModuleSymbol.find(project, searchScope, fqn).orElse(null);
        }
        if (container != null) {
            return symbol instanceof SingletonClassSymbol || createAsSingleton ? new RbsSingletonSymbol(container) : container;
        }
        if (!createFallbackIfMissing) {
            return null;
        }
        if (symbol instanceof SingletonClassSymbol) {
            return RbsRubySingletonSymbol.create(project, searchScope, symbol);
        }
        if (SymbolUtil.getClassTypes().contains(type)) {
            return RbsRubyClassSymbol.create(project, searchScope, symbol);
        }
        if (SymbolUtil.getModuleTypes().contains(type)) {
            return RbsRubyModuleSymbol.create(project, searchScope, symbol);
        }
        return null;
    }

    @Nullable
    public static RbsContainerSymbol findContainerSymbolForRubyType(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull RType type) {
        if (project == null) {
            RbsRubyTypeUtil.$$$reportNull$$$0(12);
        }
        if (searchScope == null) {
            RbsRubyTypeUtil.$$$reportNull$$$0(13);
        }
        if (type == null) {
            RbsRubyTypeUtil.$$$reportNull$$$0(14);
        }
        if (type instanceof RbsRubyInterfaceType) {
            return ((RbsRubyInterfaceType)type).getSymbol();
        }
        Symbol symbol = RTypeUtilCore.getBirthTypeSymbol((RType)type);
        if (symbol == null) {
            return null;
        }
        boolean createAsSingleton = type instanceof RModuleType;
        return RbsRubyTypeUtil.findContainerSymbolForRubySymbol(project, searchScope, symbol, createAsSingleton, true);
    }

    @Nullable
    public static RbsTypeSignature findMatchingParameterTypeSignature(@NotNull RbsProcTypeSignature signature, @NotNull List<? extends PsiElement> arguments, @NotNull PsiElement argument) {
        if (signature == null) {
            RbsRubyTypeUtil.$$$reportNull$$$0(15);
        }
        if (arguments == null) {
            RbsRubyTypeUtil.$$$reportNull$$$0(16);
        }
        if (argument == null) {
            RbsRubyTypeUtil.$$$reportNull$$$0(17);
        }
        return RbsRubyTypeUtil.findMatchingParameterTypeSignature(signature, RbsRubyCallArgument.fromPsiElement(argument, false), arguments.indexOf(argument));
    }

    @Nullable
    public static RbsTypeSignature findMatchingParameterTypeSignature(@NotNull RbsProcTypeSignature signature, @NotNull List<SymbolicCall.SymbolicArgumentInfo> argumentInfos, @NotNull SymbolicCall.SymbolicArgumentInfo argumentInfo) {
        if (signature == null) {
            RbsRubyTypeUtil.$$$reportNull$$$0(18);
        }
        if (argumentInfos == null) {
            RbsRubyTypeUtil.$$$reportNull$$$0(19);
        }
        if (argumentInfo == null) {
            RbsRubyTypeUtil.$$$reportNull$$$0(20);
        }
        return RbsRubyTypeUtil.findMatchingParameterTypeSignature(signature, RbsRubyCallArgument.fromSymbolicArgumentInfo(argumentInfo), argumentInfos.indexOf(argumentInfo));
    }

    @Nullable
    public static RbsTypeSignature findMatchingParameterTypeSignature(@NotNull RbsProcTypeSignature signature, @NotNull List<ArgumentInfo> parameters, @NotNull ArgumentInfo parameter) {
        ArgumentInfo.Type parameterType;
        if (signature == null) {
            RbsRubyTypeUtil.$$$reportNull$$$0(21);
        }
        if (parameters == null) {
            RbsRubyTypeUtil.$$$reportNull$$$0(22);
        }
        if (parameter == null) {
            RbsRubyTypeUtil.$$$reportNull$$$0(23);
        }
        if ((parameterType = parameter.getType()).isBlock()) {
            return signature.getBlockTypeSignature();
        }
        int index = ContainerUtil.indexOf((List)ContainerUtil.filter(parameters, info -> info.getType().isPositional()), it -> it.getName().equals(parameter.getName()) && it.getType().equals((Object)parameter.getType()));
        RbsProcTypeSignature.Parameter matchingParameter = RbsRubyTypeUtil.findMatchingParameter(signature, parameter, index);
        if (matchingParameter == null) {
            return null;
        }
        RbsTypeSignature typeSignature = matchingParameter.getTypeSignature();
        if (parameterType == ArgumentInfo.Type.ARRAY || parameterType == ArgumentInfo.Type.HASH) {
            return switch (matchingParameter.getParameterType()) {
                case RbsProcTypeSignature.ParameterType.POSITIONAL_REST -> new RbsQualifiedNameTypeSignature(RbsFqns.ARRAY_FQN, List.of(typeSignature));
                case RbsProcTypeSignature.ParameterType.KEYWORD_REST -> new RbsQualifiedNameTypeSignature(RbsFqns.HASH_FQN, List.of(new RbsQualifiedNameTypeSignature(RbsFqns.SYMBOL_FQN), typeSignature));
                default -> typeSignature;
            };
        }
        return typeSignature;
    }

    public static boolean isMatchingProcTypeSignature(@NotNull RBinaryExpression expression, @NotNull PsiElement argument, @NotNull RbsProcTypeSignature procTypeSignature) {
        if (expression == null) {
            RbsRubyTypeUtil.$$$reportNull$$$0(24);
        }
        if (argument == null) {
            RbsRubyTypeUtil.$$$reportNull$$$0(25);
        }
        if (procTypeSignature == null) {
            RbsRubyTypeUtil.$$$reportNull$$$0(26);
        }
        if (procTypeSignature.hasUntypedParameters()) {
            return true;
        }
        Project project = expression.getProject();
        GlobalSearchScope searchScope = expression.getResolveScope().intersectWith(RbsSearchScope.collectionScope((PsiElement)expression));
        REmptyType contextType = REmptyType.INSTANCE;
        List<RbsRubyCallArgument> arguments = Stream.ofNullable(expression.getRightOperand()).map(operand -> RbsRubyCallArgument.fromPsiElement((PsiElement)operand, operand.getTextOffset() < argument.getTextOffset())).collect(Collectors.toList());
        return RbsRubyTypeUtil.isMatchingProcTypeSignature(project, (SearchScope)searchScope, (RType)contextType, arguments, false, procTypeSignature, null);
    }

    public static boolean isMatchingProcTypeSignature(@NotNull RPossibleCall call, @NotNull RbsProcTypeSignature procTypeSignature) {
        if (call == null) {
            RbsRubyTypeUtil.$$$reportNull$$$0(27);
        }
        if (procTypeSignature == null) {
            RbsRubyTypeUtil.$$$reportNull$$$0(28);
        }
        if (procTypeSignature.hasUntypedParameters()) {
            return true;
        }
        Project project = call.getProject();
        GlobalSearchScope searchScope = call.getResolveScope().intersectWith(RbsSearchScope.collectionScope((PsiElement)call));
        REmptyType contextType = REmptyType.INSTANCE;
        List arguments = ContainerUtil.map((Collection)RubyPsiUtil.getCallArgumentsIncludingIndexes((RPossibleCall)call), it -> RbsRubyCallArgument.fromPsiElement((PsiElement)it, true));
        boolean isBlockGiven = call instanceof RBlockCall || RubyPsiUtil.isBlockGivenToPsiElement((PsiElement)call);
        return RbsRubyTypeUtil.isMatchingProcTypeSignature(project, (SearchScope)searchScope, (RType)contextType, arguments, isBlockGiven, procTypeSignature, null);
    }

    public static boolean isPartialMatchingProcTypeSignature(@NotNull RPossibleCall call, @NotNull PsiElement argument, @NotNull RbsProcTypeSignature procTypeSignature) {
        if (call == null) {
            RbsRubyTypeUtil.$$$reportNull$$$0(29);
        }
        if (argument == null) {
            RbsRubyTypeUtil.$$$reportNull$$$0(30);
        }
        if (procTypeSignature == null) {
            RbsRubyTypeUtil.$$$reportNull$$$0(31);
        }
        if (procTypeSignature.hasUntypedParameters()) {
            return true;
        }
        Project project = call.getProject();
        GlobalSearchScope searchScope = call.getResolveScope().intersectWith(RbsSearchScope.collectionScope((PsiElement)call));
        REmptyType contextType = REmptyType.INSTANCE;
        List arguments = ContainerUtil.mapNotNull((Collection)RubyPsiUtil.getCallArgumentsIncludingIndexes((RPossibleCall)call), it -> {
            if (argument.getTextOffset() < it.getTextOffset()) {
                return null;
            }
            return RbsRubyCallArgument.fromPsiElement((PsiElement)it, true);
        });
        boolean isBlockGiven = call instanceof RBlockCall || RubyPsiUtil.isBlockGivenToPsiElement((PsiElement)call);
        return RbsRubyTypeUtil.isPartialMatchingProcTypeSignature(project, (SearchScope)searchScope, (RType)contextType, arguments, isBlockGiven, procTypeSignature);
    }

    @NotNull
    public static <T extends RbsProcTypeSignature> Collector<T, ?, Stream<T>> matchingSignatures(@NotNull RBinaryExpression expression, @NotNull PsiElement argument) {
        if (expression == null) {
            RbsRubyTypeUtil.$$$reportNull$$$0(32);
        }
        if (argument == null) {
            RbsRubyTypeUtil.$$$reportNull$$$0(33);
        }
        Collector collector = Collectors.collectingAndThen(Collectors.toList(), signatures -> {
            if (signatures.size() == 1) {
                return signatures.stream();
            }
            return signatures.stream().filter(signature -> RbsRubyTypeUtil.isMatchingProcTypeSignature(expression, argument, signature));
        });
        if (collector == null) {
            RbsRubyTypeUtil.$$$reportNull$$$0(34);
        }
        return collector;
    }

    @NotNull
    public static <T extends RbsProcTypeSignature> Collector<T, ?, Stream<T>> matchingSignatures(@NotNull RPossibleCall call) {
        if (call == null) {
            RbsRubyTypeUtil.$$$reportNull$$$0(35);
        }
        Collector collector = Collectors.collectingAndThen(Collectors.toList(), signatures -> {
            if (signatures.size() == 1) {
                return signatures.stream();
            }
            return signatures.stream().filter(signature -> RbsRubyTypeUtil.isMatchingProcTypeSignature(call, signature));
        });
        if (collector == null) {
            RbsRubyTypeUtil.$$$reportNull$$$0(36);
        }
        return collector;
    }

    @NotNull
    public static <T extends RbsProcTypeSignature> Collector<T, ?, Stream<T>> matchingSignatures(@NotNull RPossibleCall possibleCall, @NotNull PsiElement argument) {
        if (possibleCall == null) {
            RbsRubyTypeUtil.$$$reportNull$$$0(37);
        }
        if (argument == null) {
            RbsRubyTypeUtil.$$$reportNull$$$0(38);
        }
        Collector collector = Collectors.collectingAndThen(Collectors.toList(), signatures -> {
            if (signatures.size() == 1) {
                return signatures.stream();
            }
            return signatures.stream().filter(signature -> RbsRubyTypeUtil.isMatchingProcTypeSignature(possibleCall, argument, signature));
        });
        if (collector == null) {
            RbsRubyTypeUtil.$$$reportNull$$$0(39);
        }
        return collector;
    }

    @NotNull
    public static <T extends RbsProcTypeSignature> Collector<T, ?, Stream<T>> matchingSignatures(@NotNull Project project, @NotNull SymbolicExecutionContext context, @NotNull SymbolicCall symbolicCall, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull TypeInferenceInstance.CallContext callContext, @Nullable PsiElement invocationPoint) {
        if (project == null) {
            RbsRubyTypeUtil.$$$reportNull$$$0(40);
        }
        if (context == null) {
            RbsRubyTypeUtil.$$$reportNull$$$0(41);
        }
        if (symbolicCall == null) {
            RbsRubyTypeUtil.$$$reportNull$$$0(42);
        }
        if (callContext == null) {
            RbsRubyTypeUtil.$$$reportNull$$$0(43);
        }
        Collector collector = Collectors.collectingAndThen(Collectors.toList(), signatures -> {
            if (signatures.size() == 1) {
                return signatures.stream();
            }
            return signatures.stream().filter(signature -> RbsRubyTypeUtil.isMatchingProcTypeSignature(project, context, symbolicCall, callContext, signature, invocationPoint));
        });
        if (collector == null) {
            RbsRubyTypeUtil.$$$reportNull$$$0(44);
        }
        return collector;
    }

    @Nullable
    private static RbsProcTypeSignature.Parameter findMatchingParameter(@NotNull RbsProcTypeSignature signature, @NotNull RbsRubyCallArgument argument, int index) {
        if (signature == null) {
            RbsRubyTypeUtil.$$$reportNull$$$0(45);
        }
        if (argument == null) {
            RbsRubyTypeUtil.$$$reportNull$$$0(46);
        }
        return switch (argument.getIncomingType()) {
            case IncomingType.NONE -> Optional.ofNullable(signature.findParameter(RbsProcTypeSignature.ParameterType.POSITIONAL_TYPES, index)).orElseGet(() -> signature.findParameter(RbsProcTypeSignature.ParameterType.POSITIONAL_REST));
            case IncomingType.ASSOC -> Optional.ofNullable(signature.findParameter(RbsProcTypeSignature.ParameterType.KEYWORD_TYPES, StringUtil.notNullize((String)argument.getKeyName()))).orElseGet(() -> signature.findParameter(RbsProcTypeSignature.ParameterType.KEYWORD_REST));
            default -> null;
        };
    }

    @Nullable
    private static RbsProcTypeSignature.Parameter findMatchingParameter(@NotNull RbsProcTypeSignature signature, @NotNull ArgumentInfo parameter, int index) {
        if (signature == null) {
            RbsRubyTypeUtil.$$$reportNull$$$0(47);
        }
        if (parameter == null) {
            RbsRubyTypeUtil.$$$reportNull$$$0(48);
        }
        return switch (parameter.getType()) {
            case ArgumentInfo.Type.SIMPLE, ArgumentInfo.Type.PREDEFINED -> Optional.ofNullable(signature.findParameter(RbsProcTypeSignature.ParameterType.POSITIONAL_TYPES, index)).orElseGet(() -> !(signature instanceof RbsMethodTypeSignature) ? signature.findParameter(RbsProcTypeSignature.ParameterType.POSITIONAL_REST) : null);
            case ArgumentInfo.Type.ARRAY -> signature.findParameter(RbsProcTypeSignature.ParameterType.POSITIONAL_REST);
            case ArgumentInfo.Type.KEYREQ, ArgumentInfo.Type.NAMED -> signature.findParameter(RbsProcTypeSignature.ParameterType.KEYWORD_TYPES, parameter.getName());
            case ArgumentInfo.Type.HASH -> signature.findParameter(RbsProcTypeSignature.ParameterType.KEYWORD_REST);
            default -> null;
        };
    }

    @Nullable
    private static RbsTypeSignature findMatchingParameterTypeSignature(@NotNull RbsProcTypeSignature signature, @NotNull RbsRubyCallArgument argument, int index) {
        RbsProcTypeSignature.Parameter matchingParameter;
        if (signature == null) {
            RbsRubyTypeUtil.$$$reportNull$$$0(49);
        }
        if (argument == null) {
            RbsRubyTypeUtil.$$$reportNull$$$0(50);
        }
        if ((matchingParameter = RbsRubyTypeUtil.findMatchingParameter(signature, argument, index)) == null) {
            return null;
        }
        RbsTypeSignature typeSignature = matchingParameter.getTypeSignature();
        if (matchingParameter.isKeyword() || matchingParameter.isKeywordRest()) {
            return new RbsQualifiedNameTypeSignature(RbsFqns.HASH_FQN, List.of(new RbsQualifiedNameTypeSignature(RbsFqns.SYMBOL_FQN), typeSignature));
        }
        return typeSignature;
    }

    private static boolean isMatchingProcTypeSignature(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull RType contextType, @NotNull List<RbsRubyCallArgument> arguments, boolean isBlockGiven, @NotNull RbsProcTypeSignature procTypeSignature, @Nullable PsiElement invocationPoint) {
        if (project == null) {
            RbsRubyTypeUtil.$$$reportNull$$$0(51);
        }
        if (searchScope == null) {
            RbsRubyTypeUtil.$$$reportNull$$$0(52);
        }
        if (contextType == null) {
            RbsRubyTypeUtil.$$$reportNull$$$0(53);
        }
        if (arguments == null) {
            RbsRubyTypeUtil.$$$reportNull$$$0(54);
        }
        if (procTypeSignature == null) {
            RbsRubyTypeUtil.$$$reportNull$$$0(55);
        }
        if (procTypeSignature.hasUntypedParameters()) {
            return true;
        }
        List<RbsProcTypeSignature.Parameter> parameters = procTypeSignature.getParameters();
        RbsProcTypeSignature blockTypeSignature = procTypeSignature.getBlockTypeSignature();
        LinkedList positionalParameters = parameters.stream().filter(RbsProcTypeSignature.Parameter::isPositional).collect(Collectors.toCollection(LinkedList::new));
        Map keywordParameters = parameters.stream().filter(RbsProcTypeSignature.Parameter::isKeyword).collect(Collectors.toMap(RbsProcTypeSignature.Parameter::getKeywordName, Function.identity()));
        RbsProcTypeSignature.Parameter positionalRestParameter = (RbsProcTypeSignature.Parameter)ContainerUtil.find(parameters, RbsProcTypeSignature.Parameter::isPositionalRest);
        RbsProcTypeSignature.Parameter keywordRestParameter = (RbsProcTypeSignature.Parameter)ContainerUtil.find(parameters, RbsProcTypeSignature.Parameter::isKeywordRest);
        if (blockTypeSignature != null && !procTypeSignature.isBlockOptional() && !isBlockGiven) {
            return false;
        }
        if (blockTypeSignature == null && isBlockGiven) {
            return false;
        }
        for (RbsRubyCallArgument argument : arguments) {
            switch (argument.getIncomingType()) {
                case NONE: {
                    RType parameterType;
                    RbsProcTypeSignature.Parameter parameter = (RbsProcTypeSignature.Parameter)ObjectUtils.coalesce((Object)((RbsProcTypeSignature.Parameter)positionalParameters.poll()), (Object)positionalRestParameter);
                    if (parameter == null) {
                        return false;
                    }
                    RType argumentType = argument.getType();
                    if (RTypeUtil.isSubtype((RType)argumentType, (RType)(parameterType = (RType)ObjectUtils.doIfNotNull((Object)RbsRubyTypeConverter.convert(project, searchScope, contextType, parameter.getTypeSignature(), invocationPoint), RTypeWithNilability::getType))) != ThreeState.NO) break;
                    return false;
                }
                case ASSOC: {
                    RType parameterType;
                    RbsProcTypeSignature.Parameter parameter = (RbsProcTypeSignature.Parameter)ObjectUtils.coalesce((Object)((RbsProcTypeSignature.Parameter)keywordParameters.remove(argument.getKeyName())), (Object)keywordRestParameter);
                    if (parameter == null) {
                        return false;
                    }
                    RType argumentType = argument.getType();
                    if (RTypeUtil.isSubtype((RType)argumentType, (RType)(parameterType = (RType)ObjectUtils.doIfNotNull((Object)RbsRubyTypeConverter.convert(project, searchScope, contextType, parameter.getTypeSignature(), invocationPoint), RTypeWithNilability::getType))) != ThreeState.NO) break;
                    return false;
                }
                case ARRAY_TO_ARG: 
                case HASH_TO_ARG: 
                case FORWARDING: {
                    return true;
                }
                case BLOCK: {
                    if (blockTypeSignature != null) break;
                    return false;
                }
            }
        }
        return !ContainerUtil.exists((Iterable)positionalParameters, RbsProcTypeSignature.Parameter::isRequired) && !ContainerUtil.exists(keywordParameters.values(), RbsProcTypeSignature.Parameter::isRequired);
    }

    private static boolean isMatchingProcTypeSignature(@NotNull RPossibleCall call, @NotNull PsiElement argument, @NotNull RbsProcTypeSignature procTypeSignature) {
        if (call == null) {
            RbsRubyTypeUtil.$$$reportNull$$$0(56);
        }
        if (argument == null) {
            RbsRubyTypeUtil.$$$reportNull$$$0(57);
        }
        if (procTypeSignature == null) {
            RbsRubyTypeUtil.$$$reportNull$$$0(58);
        }
        if (procTypeSignature.hasUntypedParameters()) {
            return true;
        }
        Project project = call.getProject();
        GlobalSearchScope searchScope = call.getResolveScope().intersectWith(RbsSearchScope.collectionScope((PsiElement)call));
        REmptyType contextType = REmptyType.INSTANCE;
        List arguments = ContainerUtil.map((Collection)RubyPsiUtil.getCallArgumentsIncludingIndexes((RPossibleCall)call), it -> RbsRubyCallArgument.fromPsiElement((PsiElement)it, it.getTextOffset() < argument.getTextOffset()));
        boolean isBlockGiven = call instanceof RBlockCall || RubyPsiUtil.isBlockGivenToPsiElement((PsiElement)call);
        return RbsRubyTypeUtil.isMatchingProcTypeSignature(project, (SearchScope)searchScope, (RType)contextType, arguments, isBlockGiven, procTypeSignature, null);
    }

    private static boolean isMatchingProcTypeSignature(@NotNull Project project, @NotNull SymbolicExecutionContext context, @NotNull SymbolicCall symbolicCall, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull TypeInferenceInstance.CallContext callContext, @NotNull RbsProcTypeSignature procTypeSignature, @Nullable PsiElement invocationPoint) {
        if (project == null) {
            RbsRubyTypeUtil.$$$reportNull$$$0(59);
        }
        if (context == null) {
            RbsRubyTypeUtil.$$$reportNull$$$0(60);
        }
        if (symbolicCall == null) {
            RbsRubyTypeUtil.$$$reportNull$$$0(61);
        }
        if (procTypeSignature == null) {
            RbsRubyTypeUtil.$$$reportNull$$$0(62);
        }
        if (callContext == null) {
            RbsRubyTypeUtil.$$$reportNull$$$0(63);
        }
        if (procTypeSignature.hasUntypedParameters()) {
            return true;
        }
        RPsiElement element = callContext.getElement();
        GlobalSearchScope searchScope = element.getResolveScope().intersectWith(RbsSearchScope.collectionScope((PsiElement)element));
        RType contextType = SymbolicTypeInferenceProvider.getReceiverType((SymbolicCall)symbolicCall, (TypeInferenceComponent)((TypeInferenceComponent)context.getComponent(TypeInferenceComponent.class)), (TypeInferenceInstance.CallContext)callContext);
        List arguments = ContainerUtil.map((Collection)symbolicCall.getArguments(), argumentInfo -> RbsRubyCallArgument.fromSymbolicArgumentInfo(context, argumentInfo));
        boolean isBlockGiven = symbolicCall.isBlockGiven();
        return RbsRubyTypeUtil.isMatchingProcTypeSignature(project, (SearchScope)searchScope, contextType, arguments, isBlockGiven, procTypeSignature, invocationPoint);
    }

    private static boolean isPartialMatchingProcTypeSignature(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull RType contextType, @NotNull List<RbsRubyCallArgument> arguments, boolean isBlockGiven, @NotNull RbsProcTypeSignature procTypeSignature) {
        if (project == null) {
            RbsRubyTypeUtil.$$$reportNull$$$0(64);
        }
        if (searchScope == null) {
            RbsRubyTypeUtil.$$$reportNull$$$0(65);
        }
        if (contextType == null) {
            RbsRubyTypeUtil.$$$reportNull$$$0(66);
        }
        if (arguments == null) {
            RbsRubyTypeUtil.$$$reportNull$$$0(67);
        }
        if (procTypeSignature == null) {
            RbsRubyTypeUtil.$$$reportNull$$$0(68);
        }
        if (procTypeSignature.hasUntypedParameters()) {
            return true;
        }
        List<RbsProcTypeSignature.Parameter> parameters = procTypeSignature.getParameters();
        RbsProcTypeSignature blockTypeSignature = procTypeSignature.getBlockTypeSignature();
        LinkedList positionalParameters = parameters.stream().filter(RbsProcTypeSignature.Parameter::isPositional).collect(Collectors.toCollection(LinkedList::new));
        Map keywordParameters = parameters.stream().filter(RbsProcTypeSignature.Parameter::isKeyword).collect(Collectors.toMap(RbsProcTypeSignature.Parameter::getKeywordName, Function.identity()));
        RbsProcTypeSignature.Parameter positionalRestParameter = (RbsProcTypeSignature.Parameter)ContainerUtil.find(parameters, RbsProcTypeSignature.Parameter::isPositionalRest);
        RbsProcTypeSignature.Parameter keywordRestParameter = (RbsProcTypeSignature.Parameter)ContainerUtil.find(parameters, RbsProcTypeSignature.Parameter::isKeywordRest);
        if (blockTypeSignature == null && isBlockGiven) {
            return false;
        }
        for (RbsRubyCallArgument argument : arguments) {
            switch (argument.getIncomingType()) {
                case NONE: {
                    RType parameterType;
                    RbsProcTypeSignature.Parameter parameter = (RbsProcTypeSignature.Parameter)ObjectUtils.coalesce((Object)((RbsProcTypeSignature.Parameter)positionalParameters.poll()), (Object)positionalRestParameter);
                    if (parameter == null) {
                        return false;
                    }
                    RType argumentType = argument.getType();
                    if (RTypeUtil.isSubtype((RType)argumentType, (RType)(parameterType = (RType)ObjectUtils.doIfNotNull((Object)RbsRubyTypeConverter.convert(project, searchScope, contextType, parameter.getTypeSignature(), null), RTypeWithNilability::getType))) != ThreeState.NO) break;
                    return false;
                }
                case ASSOC: {
                    RType parameterType;
                    RbsProcTypeSignature.Parameter parameter = (RbsProcTypeSignature.Parameter)ObjectUtils.coalesce((Object)((RbsProcTypeSignature.Parameter)keywordParameters.remove(argument.getKeyName())), (Object)keywordRestParameter);
                    if (parameter == null) {
                        return false;
                    }
                    RType argumentType = argument.getType();
                    if (RTypeUtil.isSubtype((RType)argumentType, (RType)(parameterType = (RType)ObjectUtils.doIfNotNull((Object)RbsRubyTypeConverter.convert(project, searchScope, contextType, parameter.getTypeSignature(), null), RTypeWithNilability::getType))) != ThreeState.NO) break;
                    return false;
                }
                case ARRAY_TO_ARG: 
                case HASH_TO_ARG: 
                case FORWARDING: {
                    return true;
                }
                case BLOCK: {
                    if (blockTypeSignature != null) break;
                    return false;
                }
            }
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 34, 36, 39, 44 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: 
            case 13: 
            case 52: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 2: 
            case 5: 
            case 15: 
            case 18: 
            case 21: 
            case 45: 
            case 47: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 16: 
            case 54: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 17: 
            case 25: 
            case 30: 
            case 33: 
            case 38: 
            case 46: 
            case 50: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentInfos";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentInfo";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 23: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 24: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 26: 
            case 28: 
            case 31: 
            case 55: 
            case 58: 
            case 62: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "procTypeSignature";
                break;
            }
            case 27: 
            case 29: 
            case 35: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 34: 
            case 36: 
            case 39: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ruby/rbs/ruby/types/RbsRubyTypeUtil";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "possibleCall";
                break;
            }
            case 41: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 42: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbolicCall";
                break;
            }
            case 43: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callContext";
                break;
            }
            case 53: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ruby/rbs/ruby/types/RbsRubyTypeUtil";
                break;
            }
            case 34: 
            case 36: 
            case 39: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "matchingSignatures";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "extractArrayTypeVariableTypeSignature";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "extractHashTypeVariableTypeSignature";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findContainerSymbolForRubyElement";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findContainerSymbolForRubySymbol";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findContainerSymbolForRubyType";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "findMatchingParameterTypeSignature";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "isMatchingProcTypeSignature";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "isPartialMatchingProcTypeSignature";
                break;
            }
            case 32: 
            case 33: 
            case 35: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "matchingSignatures";
                break;
            }
            case 34: 
            case 36: 
            case 39: 
            case 44: {
                break;
            }
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "findMatchingParameter";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 34, 36, 39, 44 -> new IllegalStateException(string);
        };
    }
}

