/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.ruby.types;

import com.intellij.lang.ruby.rbs.psi.data.RbsProcTypeSignature;
import com.intellij.lang.ruby.rbs.psi.data.RbsTypeSignature;
import com.intellij.lang.ruby.rbs.ruby.types.RbsRubyTypeSignaturePresentationVisitor;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RType;

public final class RbsRubyTypeSignaturePresenter {
    private RbsRubyTypeSignaturePresenter() {
    }

    @NlsSafe
    @NotNull
    public static String getPresentableText(@NotNull RbsTypeSignature signature) {
        if (signature == null) {
            RbsRubyTypeSignaturePresenter.$$$reportNull$$$0(0);
        }
        return RbsRubyTypeSignaturePresenter.getPresentableText(Collections.emptyList(), Collections.emptyList(), signature);
    }

    @NlsSafe
    @NotNull
    public static String getPresentableText(@NotNull List<RType> containerTypeVariableTypes, @NotNull List<RType> localTypeVariableTypes, @NotNull RbsTypeSignature signature) {
        if (containerTypeVariableTypes == null) {
            RbsRubyTypeSignaturePresenter.$$$reportNull$$$0(1);
        }
        if (localTypeVariableTypes == null) {
            RbsRubyTypeSignaturePresenter.$$$reportNull$$$0(2);
        }
        if (signature == null) {
            RbsRubyTypeSignaturePresenter.$$$reportNull$$$0(3);
        }
        RbsRubyTypeSignaturePresentationVisitor visitor = new RbsRubyTypeSignaturePresentationVisitor(containerTypeVariableTypes, localTypeVariableTypes);
        signature.accept(visitor);
        String string = Objects.requireNonNull(visitor.getResult());
        if (string == null) {
            RbsRubyTypeSignaturePresenter.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NlsSafe
    @NotNull
    public static String getPresentableText(@NotNull List<RType> containerTypeVariableTypes, @NotNull List<RType> localTypeVariableTypes, @NotNull RbsProcTypeSignature.Parameter parameter) {
        if (containerTypeVariableTypes == null) {
            RbsRubyTypeSignaturePresenter.$$$reportNull$$$0(5);
        }
        if (localTypeVariableTypes == null) {
            RbsRubyTypeSignaturePresenter.$$$reportNull$$$0(6);
        }
        if (parameter == null) {
            RbsRubyTypeSignaturePresenter.$$$reportNull$$$0(7);
        }
        String name = parameter.getName();
        String type = RbsRubyTypeSignaturePresenter.getPresentableText(containerTypeVariableTypes, localTypeVariableTypes, parameter.getTypeSignature());
        return RbsRubyTypeSignaturePresenter.getParameterPresentableText(parameter.getParameterType(), name, type);
    }

    @NlsSafe
    @NotNull
    static String getParameterPresentableText(@NotNull RbsProcTypeSignature.ParameterType parameterType, @Nullable String name, @NotNull String type) {
        if (parameterType == null) {
            RbsRubyTypeSignaturePresenter.$$$reportNull$$$0(8);
        }
        if (type == null) {
            RbsRubyTypeSignaturePresenter.$$$reportNull$$$0(9);
        }
        String string = switch (parameterType) {
            default -> throw new IncompatibleClassChangeError();
            case RbsProcTypeSignature.ParameterType.POSITIONAL_REQUIRED -> String.format("%s %s", type, StringUtil.notNullize((String)name)).trim();
            case RbsProcTypeSignature.ParameterType.POSITIONAL_OPTIONAL -> String.format("?%s %s", type, StringUtil.notNullize((String)name)).trim();
            case RbsProcTypeSignature.ParameterType.POSITIONAL_REST -> String.format("*%s %s", type, StringUtil.notNullize((String)name)).trim();
            case RbsProcTypeSignature.ParameterType.KEYWORD_REQUIRED -> String.format("%s: %s", Objects.requireNonNull(name), type).trim();
            case RbsProcTypeSignature.ParameterType.KEYWORD_OPTIONAL -> String.format("?%s: %s", Objects.requireNonNull(name), type).trim();
            case RbsProcTypeSignature.ParameterType.KEYWORD_REST -> String.format("**%s %s", type, StringUtil.notNullize((String)name)).trim();
        };
        if (string == null) {
            RbsRubyTypeSignaturePresenter.$$$reportNull$$$0(10);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containerTypeVariableTypes";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localTypeVariableTypes";
                break;
            }
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ruby/rbs/ruby/types/RbsRubyTypeSignaturePresenter";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterType";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ruby/rbs/ruby/types/RbsRubyTypeSignaturePresenter";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableText";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterPresentableText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableText";
                break;
            }
            case 4: 
            case 10: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getParameterPresentableText";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 10 -> new IllegalStateException(string);
        };
    }
}

