/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.ruby.types;

import com.intellij.lang.ruby.rbs.model.api.RbsTypeVariableSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsClassSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsContainerTypeVariableSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsModuleSymbol;
import com.intellij.lang.ruby.rbs.psi.RbsVariance;
import com.intellij.lang.ruby.rbs.psi.data.RbsProcTypeSignature;
import com.intellij.lang.ruby.rbs.psi.data.RbsTypeSignature;
import com.intellij.lang.ruby.rbs.psi.data.RbsTypeSignatureResolver;
import com.intellij.lang.ruby.rbs.psi.index.RbsMethodNamePropertiesIndex;
import com.intellij.lang.ruby.rbs.ruby.types.RbsRubyTypeConverter;
import com.intellij.lang.ruby.rbs.ruby.types.RbsRubyTypeSignatureUtil;
import com.intellij.lang.ruby.rbs.ruby.types.RbsRubyTypeVariableExtractor;
import com.intellij.lang.ruby.rbs.util.Fqn;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeWithNilability;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RubyTypeProvider;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RubyVariance;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.impl.REmptyType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.impl.RSymbolTypeImpl;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;

public final class RbsRubyTypeProvider
implements RubyTypeProvider {
    @Nullable
    public RType createTypeBySymbol(@NotNull Symbol symbol, @NotNull List<RType> typeArguments) {
        if (symbol == null) {
            RbsRubyTypeProvider.$$$reportNull$$$0(0);
        }
        if (typeArguments == null) {
            RbsRubyTypeProvider.$$$reportNull$$$0(1);
        }
        Project project = symbol.getProject();
        GlobalSearchScope searchScope = GlobalSearchScope.allScope((Project)project);
        Fqn fqn = Fqn.of(symbol.getFQNWithNesting());
        MultiMap<Integer, RbsContainerTypeVariableSymbol> typeVariables = SymbolUtil.getClassTypes().contains(symbol.getType()) ? new RbsClassSymbol(fqn).getTypeVariableSymbols(project, (SearchScope)searchScope) : (SymbolUtil.getModuleTypes().contains(symbol.getType()) ? new RbsModuleSymbol(fqn).getTypeVariableSymbols(project, (SearchScope)searchScope) : MultiMap.empty());
        if (typeVariables.isEmpty()) {
            return null;
        }
        ArrayList<Pair> zippedArguments = new ArrayList<Pair>();
        int max = typeVariables.keySet().stream().max(Comparator.naturalOrder()).map(it -> it + 1).orElseThrow();
        for (int i = 0; i < max; ++i) {
            RbsContainerTypeVariableSymbol typeVariable = (RbsContainerTypeVariableSymbol)ContainerUtil.getFirstItem((Collection)typeVariables.get((Object)i));
            RubyVariance variance = RbsRubyTypeProvider.getVariance(typeVariable);
            if (i < typeArguments.size() || typeVariable.getDefaultType() == null) {
                RType type = (RType)ContainerUtil.getOrElse(typeArguments, (int)i, (Object)REmptyType.INSTANCE);
                zippedArguments.add(new Pair((Object)variance, (Object)type));
                continue;
            }
            RbsTypeSignature defaultTypeSignature = typeVariable.getDefaultType().apply(new RbsTypeSignatureResolver(project, (SearchScope)searchScope));
            List containerTypeVariableTypes = ContainerUtil.map(zippedArguments, it -> new RTypeWithNilability((RType)it.getSecond()));
            RTypeWithNilability typeWithNilability = RbsRubyTypeConverter.convert(project, (SearchScope)searchScope, null, containerTypeVariableTypes, Collections.emptyList(), defaultTypeSignature, null);
            zippedArguments.add(new Pair((Object)variance, (Object)((RTypeWithNilability)ObjectUtils.coalesce((Object)typeWithNilability, (Object)RTypeWithNilability.EMPTY)).getType()));
        }
        return new RSymbolTypeImpl(symbol, zippedArguments);
    }

    @Nullable
    public RType getBlockSelfType(@NotNull RBlockCall call) {
        GlobalSearchScope searchScope;
        Project project;
        Set<RbsMethodNamePropertiesIndex.Property> properties;
        if (call == null) {
            RbsRubyTypeProvider.$$$reportNull$$$0(2);
        }
        if (!(properties = RbsMethodNamePropertiesIndex.getMethodProperties(project = call.getProject(), (SearchScope)(searchScope = call.getResolveScope()), (String)ObjectUtils.coalesce((Object)RubyPsiUtil.getCallCommand((PsiElement)call), (Object)""))).contains((Object)RbsMethodNamePropertiesIndex.Property.HAS_BLOCK_TYPE_SIGNATURE_WITH_SELF_TYPE)) {
            return null;
        }
        return RbsRubyTypeSignatureUtil.findBlockCallTypeSignature(project, (SearchScope)searchScope, call).map((arg_0, arg_1) -> RbsRubyTypeProvider.lambda$getBlockSelfType$2(call, project, (SearchScope)searchScope, arg_0, arg_1)).map(RTypeWithNilability::getType).orElse(null);
    }

    @NotNull
    private static RubyVariance getVariance(@Nullable RbsTypeVariableSymbol typeVariable) {
        if (typeVariable == null) {
            RubyVariance rubyVariance = RubyVariance.INVARIANT;
            if (rubyVariance == null) {
                RbsRubyTypeProvider.$$$reportNull$$$0(3);
            }
            return rubyVariance;
        }
        RubyVariance rubyVariance = switch (typeVariable.getVariance()) {
            default -> throw new IncompatibleClassChangeError();
            case RbsVariance.INVARIANT -> RubyVariance.INVARIANT;
            case RbsVariance.COVARIANT -> RubyVariance.COVARIANT;
            case RbsVariance.CONTRAVARIANT -> RubyVariance.CONTRAVARIANT;
        };
        if (rubyVariance == null) {
            RbsRubyTypeProvider.$$$reportNull$$$0(4);
        }
        return rubyVariance;
    }

    private static /* synthetic */ RTypeWithNilability lambda$getBlockSelfType$2(RBlockCall call, Project project, SearchScope searchScope, RbsRubyTypeSignatureUtil.CallContext context, RbsProcTypeSignature signature) {
        RbsTypeSignature selfTypeSignature = signature.getSelfTypeSignature();
        if (selfTypeSignature == null) {
            return null;
        }
        RType contextType = RTypeUtil.getTypeForReceiver((RPossibleCall)call);
        List<RTypeWithNilability> containerTypeVariableTypes = RbsRubyTypeVariableExtractor.getTypeArguments(new RTypeWithNilability(contextType));
        List<RTypeWithNilability> methodTypeVariableTypes = RbsRubyTypeVariableExtractor.extractMethodTypeVariableTypes((RPossibleCall)call, context.getMatchingTypeSignature());
        return RbsRubyTypeConverter.convert(project, searchScope, contextType, containerTypeVariableTypes, methodTypeVariableTypes, selfTypeSignature, (PsiElement)call);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeArguments";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ruby/rbs/ruby/types/RbsRubyTypeProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ruby/rbs/ruby/types/RbsRubyTypeProvider";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createTypeBySymbol";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getBlockSelfType";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4 -> new IllegalStateException(string);
        };
    }
}

