/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.ruby.navigation;

import com.intellij.lang.ruby.rbs.model.api.RbsContainerSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsClassSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsClassVariableSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsConstantSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsGlobalVariableSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsInstanceVariableSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsInterfaceSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsMethodSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsModuleSymbol;
import com.intellij.lang.ruby.rbs.model.psi.RbsSearchScope;
import com.intellij.lang.ruby.rbs.ruby.model.impl.RbsRubyContainerSymbol;
import com.intellij.lang.ruby.rbs.ruby.types.RbsRubyTypeUtil;
import com.intellij.lang.ruby.rbs.util.Fqn;
import com.intellij.model.Symbol;
import com.intellij.model.psi.PsiSymbolService;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.ruby.rbs.frontback.RbsFileType;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RAliasStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RSingletonMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modules.RModule;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RConstant;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.fields.RClassVariable;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.fields.RInstanceVariable;
import org.jetbrains.plugins.ruby.ruby.lang.psi.visitors.RubyElementVisitor;
import org.jetbrains.plugins.ruby.ruby.model.impl.RubyGlobalVariableSymbol;
import org.jetbrains.plugins.ruby.ruby.navigation.RubyTypeSignatureProvider;
import org.jetbrains.plugins.ruby.util.StreamUtil;

public final class RbsRubyTypeSignatureProvider
implements RubyTypeSignatureProvider,
DumbAware {
    @NotNull
    public List<? extends Symbol> getTypeSignatures(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull Symbol declaration) {
        if (project == null) {
            RbsRubyTypeSignatureProvider.$$$reportNull$$$0(0);
        }
        if (searchScope == null) {
            RbsRubyTypeSignatureProvider.$$$reportNull$$$0(1);
        }
        if (declaration == null) {
            RbsRubyTypeSignatureProvider.$$$reportNull$$$0(2);
        }
        MyVisitor visitor = new MyVisitor(project, searchScope.intersectWith((SearchScope)RbsSearchScope.collectionScope(project)));
        if (declaration instanceof RubyGlobalVariableSymbol) {
            RubyGlobalVariableSymbol symbol = (RubyGlobalVariableSymbol)declaration;
            List<RbsGlobalVariableSymbol> list = RbsGlobalVariableSymbol.find(project, searchScope, symbol.getName()).stream().toList();
            if (list == null) {
                RbsRubyTypeSignatureProvider.$$$reportNull$$$0(3);
            }
            return list;
        }
        PsiElement element = PsiSymbolService.getInstance().extractElementFromSymbol(declaration);
        if (element != null) {
            element.accept((PsiElementVisitor)visitor);
        }
        List<Symbol> list = List.copyOf(visitor.mySymbols);
        if (list == null) {
            RbsRubyTypeSignatureProvider.$$$reportNull$$$0(4);
        }
        return list;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file) {
        if (project == null) {
            RbsRubyTypeSignatureProvider.$$$reportNull$$$0(5);
        }
        if (file == null) {
            RbsRubyTypeSignatureProvider.$$$reportNull$$$0(6);
        }
        return FileTypeIndex.containsFileOfType((FileType)RbsFileType.INSTANCE, (GlobalSearchScope)GlobalSearchScope.allScope((Project)project));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ruby/rbs/ruby/navigation/RbsRubyTypeSignatureProvider";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ruby/rbs/ruby/navigation/RbsRubyTypeSignatureProvider";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSignatures";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getTypeSignatures";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4 -> new IllegalStateException(string);
        };
    }

    private static final class MyVisitor
    extends RubyElementVisitor {
        private final Project myProject;
        private final SearchScope mySearchScope;
        private final Set<Symbol> mySymbols;

        private MyVisitor(@NotNull Project project, @NotNull SearchScope searchScope) {
            if (project == null) {
                MyVisitor.$$$reportNull$$$0(0);
            }
            if (searchScope == null) {
                MyVisitor.$$$reportNull$$$0(1);
            }
            this.mySymbols = new LinkedHashSet<Symbol>();
            this.myProject = project;
            this.mySearchScope = searchScope;
        }

        public void visitRAliasStatement(@NotNull RAliasStatement statement) {
            RbsContainerSymbol container;
            if (statement == null) {
                MyVisitor.$$$reportNull$$$0(2);
            }
            if ((container = this.findContainerSymbol((PsiElement)statement)) == null) {
                return;
            }
            container.children(this.myProject, this.mySearchScope).mapMulti(StreamUtil.select(RbsMethodSymbol.class, (Class[])new Class[0])).filter(symbol -> symbol.getName().equals(statement.getNewName())).findFirst().ifPresent(this.mySymbols::add);
        }

        public void visitRClass(@NotNull RClass clazz) {
            if (clazz == null) {
                MyVisitor.$$$reportNull$$$0(3);
            }
            RbsClassSymbol.find(this.myProject, this.mySearchScope, Fqn.of(clazz.getFQNWithNesting())).ifPresent(this.mySymbols::add);
        }

        public void visitRClassVariable(@NotNull RClassVariable classVariable) {
            RbsContainerSymbol container;
            if (classVariable == null) {
                MyVisitor.$$$reportNull$$$0(4);
            }
            if ((container = this.findContainerSymbol((PsiElement)classVariable)) == null) {
                return;
            }
            container.children(this.myProject, this.mySearchScope).mapMulti(StreamUtil.select(RbsClassVariableSymbol.class, (Class[])new Class[0])).filter(symbol -> symbol.getName().equals(classVariable.getName())).findFirst().ifPresent(this.mySymbols::add);
        }

        public void visitRConstant(@NotNull RConstant constant) {
            if (constant == null) {
                MyVisitor.$$$reportNull$$$0(5);
            }
            RbsConstantSymbol.find(this.myProject, this.mySearchScope, Fqn.of(constant.getFQNWithNesting())).ifPresent(this.mySymbols::add);
        }

        public void visitRInstanceVariable(@NotNull RInstanceVariable instanceVariable) {
            RbsContainerSymbol container;
            if (instanceVariable == null) {
                MyVisitor.$$$reportNull$$$0(6);
            }
            if ((container = this.findContainerSymbol((PsiElement)instanceVariable)) == null) {
                return;
            }
            container.children(this.myProject, this.mySearchScope).mapMulti(StreamUtil.select(RbsInstanceVariableSymbol.class, (Class[])new Class[0])).filter(symbol -> symbol.getName().equals(instanceVariable.getName())).findFirst().ifPresent(this.mySymbols::add);
        }

        public void visitRMethod(@NotNull RMethod method) {
            RbsContainerSymbol container;
            if (method == null) {
                MyVisitor.$$$reportNull$$$0(7);
            }
            if ((container = this.findContainerSymbol((PsiElement)method)) == null) {
                return;
            }
            container.allAncestors(this.myProject, this.mySearchScope).dropWhile(ancestor -> !ancestor.equals(container)).filter(ancestor -> ancestor.equals(container) || ancestor instanceof RbsInterfaceSymbol).flatMap(ancestor -> ancestor.children(this.myProject, this.mySearchScope)).mapMulti(StreamUtil.select(RbsMethodSymbol.class, (Class[])new Class[0])).filter(symbol -> symbol.getName().equals(method.getName())).findFirst().ifPresent(this.mySymbols::add);
        }

        public void visitRModule(@NotNull RModule module) {
            if (module == null) {
                MyVisitor.$$$reportNull$$$0(8);
            }
            RbsModuleSymbol.find(this.myProject, this.mySearchScope, Fqn.of(module.getFQNWithNesting())).ifPresent(this.mySymbols::add);
        }

        public void visitRSingletonMethod(@NotNull RSingletonMethod singletonMethod) {
            RbsContainerSymbol container;
            if (singletonMethod == null) {
                MyVisitor.$$$reportNull$$$0(9);
            }
            if ((container = this.findContainerSymbol((PsiElement)singletonMethod)) == null) {
                return;
            }
            container.allAncestors(this.myProject, this.mySearchScope).dropWhile(ancestor -> !ancestor.equals(container)).filter(ancestor -> ancestor.equals(container) || ancestor instanceof RbsInterfaceSymbol).flatMap(ancestor -> ancestor.children(this.myProject, this.mySearchScope)).mapMulti(StreamUtil.select(RbsMethodSymbol.class, (Class[])new Class[0])).filter(symbol -> symbol.getName().equals(singletonMethod.getName())).findFirst().ifPresent(this.mySymbols::add);
        }

        @Nullable
        private RbsContainerSymbol findContainerSymbol(@NotNull PsiElement element) {
            RbsContainerSymbol container;
            if (element == null) {
                MyVisitor.$$$reportNull$$$0(10);
            }
            return !((container = RbsRubyTypeUtil.findContainerSymbolForRubyElement(this.myProject, this.mySearchScope, element)) instanceof RbsRubyContainerSymbol) ? container : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "searchScope";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "clazz";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "classVariable";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "constant";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "instanceVariable";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "singletonMethod";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/ruby/rbs/ruby/navigation/RbsRubyTypeSignatureProvider$MyVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRAliasStatement";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRClass";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRClassVariable";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRConstant";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRInstanceVariable";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRMethod";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRModule";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRSingletonMethod";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findContainerSymbol";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

