/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.ruby.model.impl;

import com.intellij.lang.ruby.rbs.model.api.RbsContainerSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsClassSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsContainerTypeVariableSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsInterfaceSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsModuleSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsSingletonSymbol;
import com.intellij.lang.ruby.rbs.psi.data.RbsTypeSignature;
import com.intellij.lang.ruby.rbs.ruby.model.cache.RbsRubySymbolsCache;
import com.intellij.lang.ruby.rbs.util.Fqn;
import com.intellij.model.Pointer;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.containers.MultiMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.model.navigation.NavigatableSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.util.ResolveAncestor;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.util.SymbolHierarchy;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.SingletonClassSymbol;

public abstract class RbsRubyContainerSymbol
implements RbsContainerSymbol {
    protected final Fqn myFqn;
    protected final List<Ancestor> myAncestors;

    RbsRubyContainerSymbol(@NotNull Fqn fqn, @NotNull List<Ancestor> ancestors) {
        if (fqn == null) {
            RbsRubyContainerSymbol.$$$reportNull$$$0(0);
        }
        if (ancestors == null) {
            RbsRubyContainerSymbol.$$$reportNull$$$0(1);
        }
        this.myFqn = fqn;
        this.myAncestors = List.copyOf(ancestors);
    }

    @Override
    @NotNull
    public Stream<? extends RbsContainerSymbol> allAncestors(@NotNull Project project, @NotNull SearchScope searchScope) {
        if (project == null) {
            RbsRubyContainerSymbol.$$$reportNull$$$0(2);
        }
        if (searchScope == null) {
            RbsRubyContainerSymbol.$$$reportNull$$$0(3);
        }
        Stream<RbsContainerSymbol> stream = ((List)RbsRubySymbolsCache.getInstance(project, searchScope).getAllAncestors().get((Object)this, __ -> this.getAllAncestorsWithSelfTypes(project, searchScope))).stream().peek(__ -> ProgressManager.checkCanceled());
        if (stream == null) {
            RbsRubyContainerSymbol.$$$reportNull$$$0(4);
        }
        return stream;
    }

    @Override
    @NotNull
    public Stream<? extends RbsContainerSymbol> ancestors(@NotNull Project project, @NotNull SearchScope searchScope) {
        if (project == null) {
            RbsRubyContainerSymbol.$$$reportNull$$$0(5);
        }
        if (searchScope == null) {
            RbsRubyContainerSymbol.$$$reportNull$$$0(6);
        }
        Stream<? extends RbsContainerSymbol> stream = this.allAncestors(project, searchScope);
        if (stream == null) {
            RbsRubyContainerSymbol.$$$reportNull$$$0(7);
        }
        return stream;
    }

    @Override
    @NotNull
    public Stream<? extends com.intellij.model.Symbol> children(@NotNull Project project, @NotNull SearchScope searchScope) {
        if (project == null) {
            RbsRubyContainerSymbol.$$$reportNull$$$0(8);
        }
        if (searchScope == null) {
            RbsRubyContainerSymbol.$$$reportNull$$$0(9);
        }
        Stream stream = Stream.empty();
        if (stream == null) {
            RbsRubyContainerSymbol.$$$reportNull$$$0(10);
        }
        return stream;
    }

    @NotNull
    public abstract Pointer<? extends RbsRubyContainerSymbol> createPointer();

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RbsRubyContainerSymbol other = (RbsRubyContainerSymbol)obj;
        return this.myFqn.equals(other.myFqn) && this.myAncestors.equals(other.myAncestors);
    }

    @Override
    @NotNull
    public Fqn getFqn() {
        Fqn fqn = this.myFqn;
        if (fqn == null) {
            RbsRubyContainerSymbol.$$$reportNull$$$0(11);
        }
        return fqn;
    }

    @Override
    @NotNull
    public Map<RbsContainerSymbol, Function<RbsTypeSignature, RbsTypeSignature>> getTypeVariableBinding(@NotNull Project project, @NotNull SearchScope searchScope) {
        if (project == null) {
            RbsRubyContainerSymbol.$$$reportNull$$$0(12);
        }
        if (searchScope == null) {
            RbsRubyContainerSymbol.$$$reportNull$$$0(13);
        }
        Map map = FactoryMap.create(__ -> Function.identity());
        if (map == null) {
            RbsRubyContainerSymbol.$$$reportNull$$$0(14);
        }
        return map;
    }

    @Override
    @NotNull
    public MultiMap<Integer, RbsContainerTypeVariableSymbol> getTypeVariableSymbols(@NotNull Project project, @NotNull SearchScope searchScope) {
        if (project == null) {
            RbsRubyContainerSymbol.$$$reportNull$$$0(15);
        }
        if (searchScope == null) {
            RbsRubyContainerSymbol.$$$reportNull$$$0(16);
        }
        MultiMap multiMap = MultiMap.empty();
        if (multiMap == null) {
            RbsRubyContainerSymbol.$$$reportNull$$$0(17);
        }
        return multiMap;
    }

    @NotNull
    private List<? extends RbsContainerSymbol> getAllAncestorsWithSelfTypes(@NotNull Project project, @NotNull SearchScope searchScope) {
        if (project == null) {
            RbsRubyContainerSymbol.$$$reportNull$$$0(18);
        }
        if (searchScope == null) {
            RbsRubyContainerSymbol.$$$reportNull$$$0(19);
        }
        LinkedHashSet<RbsRubyContainerSymbol> ancestors = new LinkedHashSet<RbsRubyContainerSymbol>();
        for (Ancestor ancestor : this.myAncestors) {
            ProgressManager.checkCanceled();
            RbsContainerSymbol container = ancestor.fqn.isEquivalentTo(this.myFqn) ? this : ancestor.getContainerSymbol();
            if (container == null) continue;
            if (container instanceof RbsModuleSymbol) {
                RbsModuleSymbol module = (RbsModuleSymbol)container;
                ancestors.addAll(ContainerUtil.filterIsInstance(module.getSelfTypeSymbols(project, searchScope), RbsInterfaceSymbol.class));
            }
            ancestors.add((RbsRubyContainerSymbol)container);
        }
        List list = List.copyOf(ancestors);
        if (list == null) {
            RbsRubyContainerSymbol.$$$reportNull$$$0(20);
        }
        return list;
    }

    @NotNull
    static List<Ancestor> getAncestors(@NotNull Symbol symbol) {
        if (symbol == null) {
            RbsRubyContainerSymbol.$$$reportNull$$$0(21);
        }
        LinkedHashSet<Ancestor> ancestors = new LinkedHashSet<Ancestor>();
        Iterator it = new LinkedList(SymbolHierarchy.getAncestorsCaching((Symbol)symbol, null)).descendingIterator();
        while (it.hasNext()) {
            Symbol ancestor = ((ResolveAncestor)it.next()).getSymbol();
            Fqn fqn = Fqn.of(ancestor.getFQNWithNesting());
            if (fqn == Fqn.INVALID) continue;
            ancestors.add(new Ancestor(fqn, ancestor.getType(), ancestor instanceof SingletonClassSymbol));
        }
        List<Ancestor> list = List.copyOf(ancestors);
        if (list == null) {
            RbsRubyContainerSymbol.$$$reportNull$$$0(22);
        }
        return list;
    }

    public int hashCode() {
        return 31 * this.myFqn.hashCode() + this.myAncestors.hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 7, 10, 11, 14, 17, 20, 22 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ancestors";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 12: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 13: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 11: 
            case 14: 
            case 17: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ruby/rbs/ruby/model/impl/RbsRubyContainerSymbol";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ruby/rbs/ruby/model/impl/RbsRubyContainerSymbol";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "allAncestors";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "ancestors";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "children";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getFqn";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeVariableBinding";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeVariableSymbols";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllAncestorsWithSelfTypes";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getAncestors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "allAncestors";
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 11: 
            case 14: 
            case 17: 
            case 20: 
            case 22: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "ancestors";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "children";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getTypeVariableBinding";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getTypeVariableSymbols";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getAllAncestorsWithSelfTypes";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getAncestors";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 7, 10, 11, 14, 17, 20, 22 -> new IllegalStateException(string);
        };
    }

    protected record Ancestor(@NotNull Fqn fqn, @NotNull Type type, boolean isSingleton) {
        @NotNull
        private final Fqn fqn;
        @NotNull
        private final Type type;

        protected Ancestor(@NotNull Fqn fqn, @NotNull Type type, boolean isSingleton) {
            if (fqn == null) {
                Ancestor.$$$reportNull$$$0(0);
            }
            if (type == null) {
                Ancestor.$$$reportNull$$$0(1);
            }
        }

        @Nullable
        private RbsContainerSymbol getContainerSymbol() {
            NavigatableSymbol container;
            if (SymbolUtil.getClassTypes().contains(this.type)) {
                container = new RbsClassSymbol(this.fqn);
            } else if (SymbolUtil.getModuleTypes().contains(this.type)) {
                container = new RbsModuleSymbol(this.fqn);
            } else {
                return null;
            }
            return this.isSingleton ? new RbsSingletonSymbol((RbsContainerSymbol)container) : container;
        }

        @NotNull
        public Fqn fqn() {
            Fqn fqn = this.fqn;
            if (fqn == null) {
                Ancestor.$$$reportNull$$$0(2);
            }
            return fqn;
        }

        @NotNull
        public Type type() {
            Type type = this.type;
            if (type == null) {
                Ancestor.$$$reportNull$$$0(3);
            }
            return type;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fqn";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/ruby/rbs/ruby/model/impl/RbsRubyContainerSymbol$Ancestor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/ruby/rbs/ruby/model/impl/RbsRubyContainerSymbol$Ancestor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fqn";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "type";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

