/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.ruby.model.impl;

import com.intellij.lang.ruby.rbs.ruby.model.cache.RbsRubySymbolsCache;
import com.intellij.lang.ruby.rbs.ruby.model.impl.RbsRubyContainerSymbol;
import com.intellij.lang.ruby.rbs.util.Fqn;
import com.intellij.model.Pointer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.SearchScope;
import com.intellij.ruby.rbs.frontback.RbsBundle;
import com.intellij.ruby.rbs.frontback.RbsIcons;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.util.List;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.model.presentation.SymbolPresentation;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;

public final class RbsRubyClassSymbol
extends RbsRubyContainerSymbol {
    private RbsRubyClassSymbol(@NotNull Fqn fqn, @NotNull List<RbsRubyContainerSymbol.Ancestor> ancestors) {
        if (fqn == null) {
            RbsRubyClassSymbol.$$$reportNull$$$0(0);
        }
        if (ancestors == null) {
            RbsRubyClassSymbol.$$$reportNull$$$0(1);
        }
        super(fqn, ancestors);
    }

    @NotNull
    public Pointer<RbsRubyClassSymbol> createPointer() {
        Pointer pointer = Pointer.hardPointer((Object)this);
        if (pointer == null) {
            RbsRubyClassSymbol.$$$reportNull$$$0(2);
        }
        return pointer;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NotNull
    public SymbolPresentation getPresentation() {
        String name = this.getName();
        @Nls Supplier shortDescriptionSupplier = RbsBundle.messagePointer((String)"rbs.ruby.model.class.shortDescription", (Object[])new Object[]{name});
        Fqn fqn = this.myFqn.split();
        if (fqn.getParent() == Fqn.INVALID) {
            return new SymbolPresentation(RbsIcons.RBS_CLASS_ICON, name, shortDescriptionSupplier);
        }
        @Nls Supplier longDescriptionSupplier = RbsBundle.messagePointer((String)"rbs.ruby.model.class.longDescription", (Object[])new Object[]{name, fqn.getParent().join()});
        return new SymbolPresentation(RbsIcons.RBS_CLASS_ICON, name, shortDescriptionSupplier, longDescriptionSupplier);
    }

    @NotNull
    public String toString() {
        String string = "RbsRubyClassSymbol{myFqn=%s}".formatted(this.myFqn);
        if (string == null) {
            RbsRubyClassSymbol.$$$reportNull$$$0(3);
        }
        return string;
    }

    @RequiresReadLock
    @RequiresBackgroundThread(generateAssertion=false)
    @Nullable
    public static RbsRubyClassSymbol create(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull Symbol symbol) {
        if (project == null) {
            RbsRubyClassSymbol.$$$reportNull$$$0(4);
        }
        if (searchScope == null) {
            RbsRubyClassSymbol.$$$reportNull$$$0(5);
        }
        if (symbol == null) {
            RbsRubyClassSymbol.$$$reportNull$$$0(6);
        }
        ThreadingAssertions.softAssertReadAccess();
        Fqn fqn = Fqn.of(symbol.getFQNWithNesting());
        if (fqn == Fqn.INVALID) {
            return null;
        }
        return (RbsRubyClassSymbol)RbsRubySymbolsCache.getInstance(project, searchScope).getRubyClassSymbols().get((Object)fqn, __ -> new RbsRubyClassSymbol(fqn, RbsRubyClassSymbol.getAncestors(symbol)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ancestors";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ruby/rbs/ruby/model/impl/RbsRubyClassSymbol";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ruby/rbs/ruby/model/impl/RbsRubyClassSymbol";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createPointer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

