/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.ruby.lang.parameterInfo;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.lang.ASTNode;
import com.intellij.lang.parameterInfo.CreateParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoHandler;
import com.intellij.lang.parameterInfo.ParameterInfoUIContext;
import com.intellij.lang.parameterInfo.ParameterInfoUtils;
import com.intellij.lang.parameterInfo.UpdateParameterInfoContext;
import com.intellij.lang.ruby.rbs.model.api.RbsContainerSymbol;
import com.intellij.lang.ruby.rbs.model.hierarchy.RbsContainerSymbolUtil;
import com.intellij.lang.ruby.rbs.model.impl.RbsMethodSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsSingletonSymbol;
import com.intellij.lang.ruby.rbs.model.psi.RbsSearchScope;
import com.intellij.lang.ruby.rbs.psi.RbsDeclarationType;
import com.intellij.lang.ruby.rbs.psi.data.RbsMethodTypeSignature;
import com.intellij.lang.ruby.rbs.psi.data.RbsProcTypeSignature;
import com.intellij.lang.ruby.rbs.psi.data.RbsTypeSignature;
import com.intellij.lang.ruby.rbs.psi.data.RbsTypeSignatureBinding;
import com.intellij.lang.ruby.rbs.psi.data.RbsTypeSignatureResolver;
import com.intellij.lang.ruby.rbs.ruby.inspections.RbsRubyInspectionUtil;
import com.intellij.lang.ruby.rbs.ruby.types.RbsRubyTypeSignaturePresenter;
import com.intellij.lang.ruby.rbs.ruby.types.RbsRubyTypeUtil;
import com.intellij.lang.ruby.rbs.ruby.types.RbsRubyTypeVariableExtractor;
import com.intellij.model.Symbol;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ruby.rbs.frontback.RbsBundle;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.plugins.ruby.ruby.codeInsight.ArgMapping;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramInfo.RubyParameterInfoHandler;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeUtil;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.assoc.RAssoc;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RAssignmentExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RListOfExpressions;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.REmptyListOfExpressionsImpl;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.methodCall.RCallNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.util.StreamUtil;

@ApiStatus.Internal
public final class RbsRubyParameterInfoHandler
implements ParameterInfoHandler<RPossibleCall, MyMethodData> {
    @Nullable
    public RPossibleCall findElementForParameterInfo(@NotNull CreateParameterInfoContext context) {
        RPossibleCall call;
        if (context == null) {
            RbsRubyParameterInfoHandler.$$$reportNull$$$0(0);
        }
        if ((call = (RPossibleCall)ObjectUtils.doIfNotNull((Object)context.getFile(), file -> RubyParameterInfoHandler.findParameterOwner((PsiFile)file, (int)context.getOffset()))) == null) {
            return null;
        }
        GlobalSearchScope searchScope = call.getResolveScope().intersectWith(RbsSearchScope.collectionScope((PsiElement)call));
        List<MyMethodData> data = RbsRubyParameterInfoHandler.createMethodData(context.getProject(), (SearchScope)searchScope, call);
        context.setItemsToShow((Object[])data.toArray(new MyMethodData[0]));
        return !data.isEmpty() ? call : null;
    }

    @Nullable
    public RPossibleCall findElementForUpdatingParameterInfo(@NotNull UpdateParameterInfoContext context) {
        RPossibleCall candidate;
        if (context == null) {
            RbsRubyParameterInfoHandler.$$$reportNull$$$0(1);
        }
        if ((candidate = (RPossibleCall)ObjectUtils.doIfNotNull((Object)context.getFile(), file -> RubyParameterInfoHandler.findParameterOwner((PsiFile)file, (int)context.getOffset()))) == null) {
            return null;
        }
        RPossibleCall owner = (RPossibleCall)context.getParameterOwner();
        if (owner instanceof RCall && !(candidate instanceof RCall) && PsiTreeUtil.isAncestor((PsiElement)((RCall)owner).getCallArguments(), (PsiElement)candidate, (boolean)true)) {
            return owner;
        }
        if (!owner.isValid()) {
            String originalCommand;
            RCall parent = RCallNavigator.getByFirstRArgument((PsiElement)candidate);
            if (RubyPsiUtil.isCallWithCommand((PsiElement)parent, (String[])new String[]{originalCommand = ((MyMethodData)context.getObjectsToView()[0]).getCommand()})) {
                context.setParameterOwner((PsiElement)parent);
                return parent;
            }
            if (RubyPsiUtil.isCallWithCommand((PsiElement)candidate, (String[])new String[]{originalCommand})) {
                context.setParameterOwner((PsiElement)candidate);
            }
        }
        return candidate;
    }

    public boolean isWhitespaceSensitive() {
        return true;
    }

    public void showParameterInfo(@NotNull RPossibleCall call, @NotNull CreateParameterInfoContext context) {
        if (call == null) {
            RbsRubyParameterInfoHandler.$$$reportNull$$$0(2);
        }
        if (context == null) {
            RbsRubyParameterInfoHandler.$$$reportNull$$$0(3);
        }
        context.showHint((PsiElement)call, context.getOffset(), (ParameterInfoHandler)this);
    }

    public void updateParameterInfo(@NotNull RPossibleCall call, @NotNull UpdateParameterInfoContext context) {
        if (call == null) {
            RbsRubyParameterInfoHandler.$$$reportNull$$$0(4);
        }
        if (context == null) {
            RbsRubyParameterInfoHandler.$$$reportNull$$$0(5);
        }
        int index = RbsRubyParameterInfoHandler.getCurrentParameterIndex(call, context);
        context.setCurrentParameter(index);
        if (index < 0) {
            context.setHighlightedParameter(null);
        }
        MyMethodData[] data = (MyMethodData[])context.getObjectsToView();
        List arguments = index >= 0 ? ContainerUtil.getFirstItems((List)call.getArguments(), (int)index) : Collections.emptyList();
        for (int i = data.length - 1; i >= 0; --i) {
            RbsMethodTypeSignature methodTypeSignature = data[i].myMethodTypeSignature;
            Object nextParameter = RbsRubyParameterInfoHandler.findNextParameter((RbsProcTypeSignature)methodTypeSignature, arguments);
            boolean enabled = methodTypeSignature.hasUntypedParameters() || nextParameter != null || call.getArguments().isEmpty() && methodTypeSignature.getParameters().isEmpty();
            context.setUIComponentEnabled(i, enabled);
            if (!enabled || index < 0 && !RbsRubyTypeUtil.isMatchingProcTypeSignature(call, methodTypeSignature)) continue;
            context.setHighlightedParameter((Object)data[i]);
        }
    }

    public void updateUI(@NotNull MyMethodData data, @NotNull ParameterInfoUIContext context) {
        if (data == null) {
            RbsRubyParameterInfoHandler.$$$reportNull$$$0(6);
        }
        if (context == null) {
            RbsRubyParameterInfoHandler.$$$reportNull$$$0(7);
        }
        this.updateAndGetUi(data, context);
    }

    @VisibleForTesting
    @NotNull
    public String updateAndGetUi(@NotNull MyMethodData data, @NotNull ParameterInfoUIContext context) {
        if (data == null) {
            RbsRubyParameterInfoHandler.$$$reportNull$$$0(8);
        }
        if (context == null) {
            RbsRubyParameterInfoHandler.$$$reportNull$$$0(9);
        }
        RbsMethodTypeSignature methodTypeSignature = data.myMethodTypeSignature;
        List<RType> containerTypeVariableTypes = data.myContainerTypeVariableTypes;
        if (methodTypeSignature.hasUntypedParameters()) {
            String message = RbsBundle.message((String)"rbs.parameter.info.untyped.parameters", (Object[])new Object[0]);
            String string = context.setupUIComponentPresentation(message, -1, -1, !context.isUIComponentEnabled(), false, false, context.getDefaultParameterColor());
            if (string == null) {
                RbsRubyParameterInfoHandler.$$$reportNull$$$0(10);
            }
            return string;
        }
        if (methodTypeSignature.getParameters().isEmpty() && methodTypeSignature.getBlockTypeSignature() == null) {
            String message = CodeInsightBundle.message((String)"parameter.info.no.parameters", (Object[])new Object[0]);
            String string = context.setupUIComponentPresentation(message, -1, -1, !context.isUIComponentEnabled(), false, false, context.getDefaultParameterColor());
            if (string == null) {
                RbsRubyParameterInfoHandler.$$$reportNull$$$0(11);
            }
            return string;
        }
        StringBuilder sb = new StringBuilder();
        Object currentParameter = RbsRubyParameterInfoHandler.findNextParameter(methodTypeSignature, context);
        int startOffset = -1;
        int endOffset = -1;
        for (RbsProcTypeSignature.Parameter parameter : methodTypeSignature.getParameters()) {
            if (!sb.isEmpty()) {
                sb.append(", ");
            }
            String parameterPresentation = RbsRubyTypeSignaturePresenter.getPresentableText(containerTypeVariableTypes, Collections.emptyList(), parameter);
            if (parameter == currentParameter) {
                startOffset = sb.length();
                endOffset = sb.append(parameterPresentation).length();
                continue;
            }
            sb.append(parameterPresentation);
        }
        RbsProcTypeSignature blockTypeSignature = methodTypeSignature.getBlockTypeSignature();
        if (blockTypeSignature != null) {
            if (!sb.isEmpty()) {
                sb.append(", ");
            }
            String prefix = methodTypeSignature.isBlockOptional() ? "?&" : "&";
            String blockPresentation = RbsRubyTypeSignaturePresenter.getPresentableText(containerTypeVariableTypes, Collections.emptyList(), blockTypeSignature);
            if (blockTypeSignature == currentParameter) {
                startOffset = sb.length();
                endOffset = sb.append(prefix).append(blockPresentation).length();
            } else {
                sb.append(prefix).append(blockPresentation);
            }
        }
        String string = context.setupUIComponentPresentation(sb.toString(), startOffset, endOffset, !context.isUIComponentEnabled(), false, false, context.getDefaultParameterColor());
        if (string == null) {
            RbsRubyParameterInfoHandler.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    private static List<MyMethodData> createMethodData(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull RPossibleCall call) {
        if (project == null) {
            RbsRubyParameterInfoHandler.$$$reportNull$$$0(13);
        }
        if (searchScope == null) {
            RbsRubyParameterInfoHandler.$$$reportNull$$$0(14);
        }
        if (call == null) {
            RbsRubyParameterInfoHandler.$$$reportNull$$$0(15);
        }
        List<MyMethodData> list = RTypeUtil.flattenUnionAndIntersectionType((RType)RTypeUtil.getTypeForReceiver((RPossibleCall)call)).stream().flatMap(contextType -> {
            Function<RbsTypeSignature, RbsTypeSignature> binding;
            List<Object> containerTypeVariableTypes;
            String command;
            Stream<? extends Symbol> children;
            RbsContainerSymbol containerSymbol = RbsRubyTypeUtil.findContainerSymbolForRubyType(project, searchScope, contextType);
            if (containerSymbol == null) {
                return null;
            }
            if (!RubyPsiUtil.isSuperCall((RPossibleCall)call)) {
                children = containerSymbol.allChildren(project, searchScope);
                command = RubyPsiUtil.getCallCommand((PsiElement)call);
            } else {
                children = containerSymbol.superChildren(project, searchScope);
                command = (String)ObjectUtils.doIfNotNull((Object)RubyPsiUtil.getContainingRMethod((PsiElement)call), PsiNamedElement::getName);
            }
            if (command == null) {
                return null;
            }
            RbsMethodSymbol methodSymbol = children.mapMulti(StreamUtil.select(RbsMethodSymbol.class, (Class[])new Class[0])).filter(child -> child.getName().equals(command)).mapMulti(RbsContainerSymbolUtil.inlineInitialize(project, searchScope, containerSymbol)).findFirst().orElse(null);
            if (methodSymbol == null) {
                return null;
            }
            if (RbsRubyInspectionUtil.isIgnoredCallContext(containerSymbol, methodSymbol, call)) {
                return null;
            }
            if (containerSymbol instanceof RbsSingletonSymbol && RbsRubyParameterInfoHandler.isInitializeMethod(methodSymbol)) {
                containerTypeVariableTypes = Collections.emptyList();
                binding = ((RbsSingletonSymbol)containerSymbol).getOriginalSymbol().getTypeVariableBinding(project, searchScope).getOrDefault(methodSymbol.getContainerSymbol(), RbsTypeSignatureBinding.UNTYPED);
            } else {
                containerTypeVariableTypes = RbsRubyTypeVariableExtractor.getTypeArguments(contextType);
                binding = containerSymbol.getTypeVariableBinding(project, searchScope).getOrDefault(methodSymbol.getContainerSymbol(), RbsTypeSignatureBinding.UNTYPED);
            }
            return methodSymbol.getMethodTypeSignatures(project, searchScope).stream().map(signature -> ((RbsMethodTypeSignature)signature.apply((Function)binding)).apply((Function)new RbsTypeSignatureResolver(project, searchScope))).map(signature -> new MyMethodData((List<RType>)containerTypeVariableTypes, command, (RbsMethodTypeSignature)signature));
        }).distinct().toList();
        if (list == null) {
            RbsRubyParameterInfoHandler.$$$reportNull$$$0(16);
        }
        return list;
    }

    @Nullable
    private static Object findNextParameter(@NotNull RbsProcTypeSignature signature, @NotNull List<RPsiElement> arguments) {
        if (signature == null) {
            RbsRubyParameterInfoHandler.$$$reportNull$$$0(17);
        }
        if (arguments == null) {
            RbsRubyParameterInfoHandler.$$$reportNull$$$0(18);
        }
        List<RbsProcTypeSignature.Parameter> parameters = signature.getParameters();
        LinkedList positionalParameters = parameters.stream().filter(RbsProcTypeSignature.Parameter::isPositional).collect(Collectors.toCollection(LinkedList::new));
        Map keywordParameters = parameters.stream().filter(RbsProcTypeSignature.Parameter::isKeyword).collect(Collectors.toMap(RbsProcTypeSignature.Parameter::getKeywordName, Function.identity(), (first, __) -> first, LinkedHashMap::new));
        RbsProcTypeSignature.Parameter positionalRestParameter = (RbsProcTypeSignature.Parameter)ContainerUtil.find(parameters, RbsProcTypeSignature.Parameter::isPositionalRest);
        RbsProcTypeSignature.Parameter keywordRestParameter = (RbsProcTypeSignature.Parameter)ContainerUtil.find(parameters, RbsProcTypeSignature.Parameter::isKeywordRest);
        boolean keywordArgumentSeen = false;
        for (RPsiElement argument : arguments) {
            switch (ArgMapping.getIncomingType((PsiElement)argument)) {
                case NONE: {
                    if (ObjectUtils.coalesce((Object)((RbsProcTypeSignature.Parameter)positionalParameters.poll()), (Object)positionalRestParameter) != null) break;
                    return null;
                }
                case ASSOC: {
                    String keyText = (String)ObjectUtils.doIfCast((Object)argument, RAssoc.class, RAssoc::getKeyText);
                    if (ObjectUtils.coalesce((Object)((RbsProcTypeSignature.Parameter)keywordParameters.remove(keyText)), (Object)keywordRestParameter) == null) {
                        return null;
                    }
                    keywordArgumentSeen = true;
                    break;
                }
                case ARRAY_TO_ARG: {
                    positionalParameters.clear();
                    break;
                }
                case HASH_TO_ARG: {
                    keywordParameters.clear();
                    keywordArgumentSeen = true;
                    break;
                }
                case FORWARDING: {
                    return null;
                }
            }
        }
        RbsProcTypeSignature.Parameter positionalParameter = (RbsProcTypeSignature.Parameter)ObjectUtils.coalesce((Object)((RbsProcTypeSignature.Parameter)positionalParameters.poll()), (Object)positionalRestParameter);
        if (!keywordArgumentSeen && positionalParameter != null) {
            return positionalParameter;
        }
        RbsProcTypeSignature.Parameter keywordParameter = (RbsProcTypeSignature.Parameter)ObjectUtils.coalesce((Object)((RbsProcTypeSignature.Parameter)ContainerUtil.getFirstItem(keywordParameters.values())), (Object)keywordRestParameter);
        if (keywordParameter != null) {
            return keywordParameter;
        }
        return signature.getBlockTypeSignature();
    }

    @Nullable
    private static Object findNextParameter(@NotNull RbsMethodTypeSignature methodTypeSignature, @NotNull ParameterInfoUIContext context) {
        int index;
        if (methodTypeSignature == null) {
            RbsRubyParameterInfoHandler.$$$reportNull$$$0(19);
        }
        if (context == null) {
            RbsRubyParameterInfoHandler.$$$reportNull$$$0(20);
        }
        if ((index = context.getCurrentParameterIndex()) < 0) {
            return null;
        }
        return RbsRubyParameterInfoHandler.findNextParameter((RbsProcTypeSignature)methodTypeSignature, ContainerUtil.getFirstItems((List)((RPossibleCall)context.getParameterOwner()).getArguments(), (int)index));
    }

    private static int getCurrentParameterIndex(@NotNull RPossibleCall possibleCall, @NotNull UpdateParameterInfoContext context) {
        if (possibleCall == null) {
            RbsRubyParameterInfoHandler.$$$reportNull$$$0(21);
        }
        if (context == null) {
            RbsRubyParameterInfoHandler.$$$reportNull$$$0(22);
        }
        int caretOffset = context.getOffset();
        if (possibleCall instanceof RCall) {
            RCall call = (RCall)possibleCall;
            RListOfExpressions arguments = call.getCallArguments();
            PsiElement command = call.getPsiCommand();
            if (command.getTextRange().getEndOffset() + 1 <= caretOffset) {
                if (arguments instanceof REmptyListOfExpressionsImpl) {
                    return 0;
                }
                return ParameterInfoUtils.getCurrentParameterIndex((ASTNode)arguments.getNode(), (int)Math.max(arguments.getTextOffset(), caretOffset), (IElementType)RubyTokenTypes.tCOMMA);
            }
            return ParameterInfoUtils.getCurrentParameterIndex((ASTNode)arguments.getNode(), (int)caretOffset, (IElementType)RubyTokenTypes.tCOMMA);
        }
        if (possibleCall instanceof RAssignmentExpression) {
            RAssignmentExpression assignment = (RAssignmentExpression)possibleCall;
            PsiElement operation = assignment.getOperation();
            return operation != null && operation.getTextRange().getEndOffset() <= caretOffset ? 0 : -1;
        }
        return possibleCall.getTextRange().getEndOffset() < caretOffset ? 0 : -1;
    }

    private static boolean isInitializeMethod(@NotNull RbsMethodSymbol method) {
        if (method == null) {
            RbsRubyParameterInfoHandler.$$$reportNull$$$0(23);
        }
        return method.getDeclarationType() == RbsDeclarationType.INSTANCE_DECLARATION && "initialize".equals(method.getName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 11, 12, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 4: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ruby/rbs/ruby/lang/parameterInfo/RbsRubyParameterInfoHandler";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodTypeSignature";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "possibleCall";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ruby/rbs/ruby/lang/parameterInfo/RbsRubyParameterInfoHandler";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "updateAndGetUi";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createMethodData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findElementForParameterInfo";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findElementForUpdatingParameterInfo";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "showParameterInfo";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "updateParameterInfo";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "updateUI";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "updateAndGetUi";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 16: {
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createMethodData";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findNextParameter";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentParameterIndex";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isInitializeMethod";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 11, 12, 16 -> new IllegalStateException(string);
        };
    }

    public static class MyMethodData {
        private final List<RType> myContainerTypeVariableTypes;
        private final String myCommand;
        private final RbsMethodTypeSignature myMethodTypeSignature;

        private MyMethodData(@NotNull List<RType> containerTypeVariableTypes, @NotNull String command, @NotNull RbsMethodTypeSignature methodTypeSignature) {
            if (containerTypeVariableTypes == null) {
                MyMethodData.$$$reportNull$$$0(0);
            }
            if (command == null) {
                MyMethodData.$$$reportNull$$$0(1);
            }
            if (methodTypeSignature == null) {
                MyMethodData.$$$reportNull$$$0(2);
            }
            this.myContainerTypeVariableTypes = containerTypeVariableTypes;
            this.myCommand = command;
            this.myMethodTypeSignature = methodTypeSignature;
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || !this.getClass().equals(obj.getClass())) {
                return false;
            }
            MyMethodData other = (MyMethodData)obj;
            return this.myContainerTypeVariableTypes.equals(other.myContainerTypeVariableTypes) && this.myCommand.equals(other.myCommand) && this.myMethodTypeSignature.getTypeParameters().equals(other.myMethodTypeSignature.getTypeParameters()) && this.myMethodTypeSignature.getParameters().equals(other.myMethodTypeSignature.getParameters()) && this.myMethodTypeSignature.hasUntypedParameters() == other.myMethodTypeSignature.hasUntypedParameters() && Objects.equals(this.myMethodTypeSignature.getSelfTypeSignature(), other.myMethodTypeSignature.getSelfTypeSignature()) && this.myMethodTypeSignature.isBlockOptional() == other.myMethodTypeSignature.isBlockOptional() && Objects.equals(this.myMethodTypeSignature.getBlockTypeSignature(), other.myMethodTypeSignature.getBlockTypeSignature());
        }

        @NotNull
        public String getCommand() {
            String string = this.myCommand;
            if (string == null) {
                MyMethodData.$$$reportNull$$$0(3);
            }
            return string;
        }

        public int hashCode() {
            return Objects.hash(this.myContainerTypeVariableTypes, this.myCommand, this.myMethodTypeSignature.getTypeParameters(), this.myMethodTypeSignature.getParameters(), this.myMethodTypeSignature.hasUntypedParameters(), this.myMethodTypeSignature.getSelfTypeSignature(), this.myMethodTypeSignature.isBlockOptional(), this.myMethodTypeSignature.getBlockTypeSignature());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "containerTypeVariableTypes";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "command";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "methodTypeSignature";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/ruby/rbs/ruby/lang/parameterInfo/RbsRubyParameterInfoHandler$MyMethodData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/ruby/rbs/ruby/lang/parameterInfo/RbsRubyParameterInfoHandler$MyMethodData";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCommand";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }
}

