/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.ruby.inspections.dataFlow;

import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.ide.actions.CreateFileFromTemplateAction;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.ide.fileTemplates.actions.CreateFromTemplateActionBase;
import com.intellij.lang.ruby.rbs.actions.RbsCreateClassFileAction;
import com.intellij.lang.ruby.rbs.model.api.RbsContainerSymbol;
import com.intellij.lang.ruby.rbs.model.psi.RbsPsiSymbolDeclaration;
import com.intellij.lang.ruby.rbs.model.psi.RbsPsiSymbolDeclarationSearcher;
import com.intellij.lang.ruby.rbs.model.psi.RbsSearchScope;
import com.intellij.lang.ruby.rbs.psi.RbsAliasMember;
import com.intellij.lang.ruby.rbs.psi.RbsAttributeMember;
import com.intellij.lang.ruby.rbs.psi.RbsClassDecl;
import com.intellij.lang.ruby.rbs.psi.RbsConstDecl;
import com.intellij.lang.ruby.rbs.psi.RbsDeclarationMembers;
import com.intellij.lang.ruby.rbs.psi.RbsDeclarationMembersOwner;
import com.intellij.lang.ruby.rbs.psi.RbsDeclarationType;
import com.intellij.lang.ruby.rbs.psi.RbsGlobalDecl;
import com.intellij.lang.ruby.rbs.psi.RbsMethodMember;
import com.intellij.lang.ruby.rbs.psi.RbsModuleDecl;
import com.intellij.lang.ruby.rbs.psi.RbsPsiFile;
import com.intellij.lang.ruby.rbs.psi.RbsStatementElement;
import com.intellij.lang.ruby.rbs.psi.RbsVarTypeMember;
import com.intellij.lang.ruby.rbs.psi.util.RbsPsiEditUtil;
import com.intellij.lang.ruby.rbs.psi.util.RbsPsiElementFactory;
import com.intellij.lang.ruby.rbs.psi.util.RbsPsiUtil;
import com.intellij.lang.ruby.rbs.ruby.codeInsight.intentions.rbs.RbsRubyEditTypeSignatureIntention;
import com.intellij.lang.ruby.rbs.util.Fqn;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiEditorUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ruby.rbs.frontback.RbsBundle;
import com.intellij.ruby.rbs.frontback.RbsFileType;
import com.intellij.ruby.rbs.frontback.RbsIcons;
import com.intellij.ruby.rbs.frontback.psi.RbsAttributeType;
import com.intellij.ruby.rbs.frontback.psi.RbsVisibility;
import com.intellij.ui.list.TargetPopup;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresWriteLock;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.model.navigation.TargetPresentationUtil;
import org.jetbrains.plugins.ruby.model.psi.PsiSymbolDeclarationService;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.RElementWithFQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.TypeSet;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.Access;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.ContextImpl;
import org.jetbrains.plugins.ruby.ruby.interpret.RubyInterpretUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RAliasStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RObjectClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RClassObject;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RSingletonMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.Visibility;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.controlStructures.VisibilityUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RConstant;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RGlobalVariable;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RPseudoConstant;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.fields.RClassVariable;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.fields.RInstanceVariable;
import org.jetbrains.plugins.ruby.ruby.lang.psi.visitors.RubySystemCallVisitor;
import org.jetbrains.plugins.ruby.ruby.templates.CreateFileFromTemplateInDirectoryDialog;
import org.jetbrains.plugins.ruby.utils.NamingConventions;

final class RbsAddTypeSignatureQuickFix
implements LocalQuickFix,
DumbAware {
    RbsAddTypeSignatureQuickFix() {
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            RbsAddTypeSignatureQuickFix.$$$reportNull$$$0(0);
        }
        if (descriptor == null) {
            RbsAddTypeSignatureQuickFix.$$$reportNull$$$0(1);
        }
        PsiElement element = descriptor.getPsiElement();
        GlobalSearchScope searchScope = GlobalSearchScope.projectScope((Project)project).intersectWith(RbsSearchScope.collectionScope(element));
        Editor editor = PsiEditorUtil.findEditor((PsiElement)element);
        if (editor == null) {
            return;
        }
        element.accept((PsiElementVisitor)new MyVisitor(project, (SearchScope)searchScope, editor, descriptor.getTextRangeInElement()));
    }

    public boolean availableInBatchMode() {
        return false;
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            RbsAddTypeSignatureQuickFix.$$$reportNull$$$0(2);
        }
        if (descriptor == null) {
            RbsAddTypeSignatureQuickFix.$$$reportNull$$$0(3);
        }
        PsiElement element = descriptor.getPsiElement();
        GlobalSearchScope searchScope = GlobalSearchScope.projectScope((Project)project).intersectWith(RbsSearchScope.collectionScope(element));
        MyPreviewVisitor visitor = new MyPreviewVisitor(project, (SearchScope)searchScope, descriptor.getTextRangeInElement());
        element.accept((PsiElementVisitor)visitor);
        MyPreviewInfo result = visitor.getPreviewInfo();
        if (result == null) {
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            if (intentionPreviewInfo == null) {
                RbsAddTypeSignatureQuickFix.$$$reportNull$$$0(4);
            }
            return intentionPreviewInfo;
        }
        return new IntentionPreviewInfo.CustomDiff((FileType)RbsFileType.INSTANCE, result.filename, "", result.text);
    }

    @NotNull
    public String getFamilyName() {
        String string = RbsBundle.message((String)"rbs.inspection.missing.type.signature.add.family.name", (Object[])new Object[0]);
        if (string == null) {
            RbsAddTypeSignatureQuickFix.$$$reportNull$$$0(5);
        }
        return string;
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ruby/rbs/ruby/inspections/dataFlow/RbsAddTypeSignatureQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ruby/rbs/ruby/inspections/dataFlow/RbsAddTypeSignatureQuickFix";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "generatePreview";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "generatePreview";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5 -> new IllegalStateException(string);
        };
    }

    private static final class MyVisitor
    extends RubySystemCallVisitor {
        private final Project myProject;
        private final SearchScope mySearchScope;
        private final Editor myEditor;
        private final TextRange myRangeInElement;

        private MyVisitor(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull Editor editor, @Nullable TextRange rangeInElement) {
            if (project == null) {
                MyVisitor.$$$reportNull$$$0(0);
            }
            if (searchScope == null) {
                MyVisitor.$$$reportNull$$$0(1);
            }
            if (editor == null) {
                MyVisitor.$$$reportNull$$$0(2);
            }
            this.myProject = project;
            this.mySearchScope = searchScope;
            this.myEditor = editor;
            this.myRangeInElement = (TextRange)ObjectUtils.coalesce((Object)rangeInElement, (Object)TextRange.EMPTY_RANGE);
        }

        public void visitRAliasStatement(@NotNull RAliasStatement aliasStatement) {
            RElementWithFQN context;
            Fqn fqn;
            if (aliasStatement == null) {
                MyVisitor.$$$reportNull$$$0(3);
            }
            if ((fqn = Fqn.of((context = SymbolUtil.getContextContainer((PsiElement)aliasStatement)).getFQNWithNesting(), (PsiElement)context).split()) == Fqn.INVALID) {
                return;
            }
            RbsDeclarationType declarationType = context instanceof RObjectClass ? RbsDeclarationType.SINGLETON_DECLARATION : RbsDeclarationType.INSTANCE_DECLARATION;
            String name = aliasStatement.getNewName();
            String targetName = aliasStatement.getOldName();
            if (name == null || targetName == null) {
                return;
            }
            if (aliasStatement.isMethodAlias()) {
                this.findOrCreateContainer(fqn, (PsiElement)aliasStatement, container -> {
                    RbsPsiSymbolDeclaration<?> statement = this.insertStatement((PsiElement)container, (RbsStatementElement)RbsPsiElementFactory.createAliasMember(this.myProject, declarationType, name, targetName));
                    if (statement != null) {
                        RbsRubyEditTypeSignatureIntention.openAndEditTypeSignature(this.myProject, statement, (PsiElement)aliasStatement);
                    }
                });
            } else {
                this.createFile("global_variables.rbs", (PsiElement)aliasStatement, file -> {
                    RbsPsiSymbolDeclaration<?> statement = this.insertStatement((PsiElement)file, RbsPsiElementFactory.createGlobalVariableDeclaration(this.myProject, StringUtil.trimStart((String)name, (String)"$")));
                    if (statement != null) {
                        RbsRubyEditTypeSignatureIntention.openAndEditTypeSignature(this.myProject, statement, (PsiElement)aliasStatement);
                    }
                });
            }
        }

        public void visitAttrAccessorCall(@NotNull RCall call) {
            RElementWithFQN context;
            Fqn fqn;
            if (call == null) {
                MyVisitor.$$$reportNull$$$0(4);
            }
            if ((fqn = Fqn.of((context = SymbolUtil.getContextContainer((PsiElement)call)).getFQNWithNesting(), (PsiElement)context).split()) == Fqn.INVALID) {
                return;
            }
            RbsVisibility visibility = RbsVisibility.valueOf((Visibility)((Visibility)ObjectUtils.coalesce((Object)VisibilityUtil.getCurrentPointVisibility((PsiElement)call), (Object)Visibility.PUBLIC)));
            RbsDeclarationType declarationType = context instanceof RObjectClass ? RbsDeclarationType.SINGLETON_DECLARATION : RbsDeclarationType.INSTANCE_DECLARATION;
            PsiElement argument = (PsiElement)ContainerUtil.find((Iterable)call.getArguments(), it -> it.getTextRange().shiftLeft(call.getTextOffset()).intersects(this.myRangeInElement));
            if (argument == null) {
                return;
            }
            String name = RubyInterpretUtil.evaluateStringOrSymbolElement((PsiElement)argument);
            if (name == null) {
                return;
            }
            this.findOrCreateContainer(fqn, (PsiElement)call, container -> {
                RbsPsiSymbolDeclaration<?> statement = this.insertStatement((PsiElement)container, (RbsStatementElement)RbsPsiElementFactory.createAttributeMember(this.myProject, visibility, RbsAttributeType.ATTRIBUTE_ACCESSOR, declarationType, name));
                if (statement != null) {
                    RbsRubyEditTypeSignatureIntention.openAndEditTypeSignature(this.myProject, statement, (PsiElement)call);
                }
            });
        }

        public void visitAttrReaderCall(@NotNull RCall call) {
            RElementWithFQN context;
            Fqn fqn;
            if (call == null) {
                MyVisitor.$$$reportNull$$$0(5);
            }
            if ((fqn = Fqn.of((context = SymbolUtil.getContextContainer((PsiElement)call)).getFQNWithNesting(), (PsiElement)context).split()) == Fqn.INVALID) {
                return;
            }
            RbsVisibility visibility = RbsVisibility.valueOf((Visibility)((Visibility)ObjectUtils.coalesce((Object)VisibilityUtil.getCurrentPointVisibility((PsiElement)call), (Object)Visibility.PUBLIC)));
            RbsDeclarationType declarationType = context instanceof RObjectClass ? RbsDeclarationType.SINGLETON_DECLARATION : RbsDeclarationType.INSTANCE_DECLARATION;
            PsiElement argument = (PsiElement)ContainerUtil.find((Iterable)call.getArguments(), it -> it.getTextRange().shiftLeft(call.getTextOffset()).intersects(this.myRangeInElement));
            if (argument == null) {
                return;
            }
            String name = RubyInterpretUtil.evaluateStringOrSymbolElement((PsiElement)argument);
            if (name == null) {
                return;
            }
            this.findOrCreateContainer(fqn, (PsiElement)call, container -> {
                RbsPsiSymbolDeclaration<?> statement = this.insertStatement((PsiElement)container, (RbsStatementElement)RbsPsiElementFactory.createAttributeMember(this.myProject, visibility, RbsAttributeType.ATTRIBUTE_READER, declarationType, name));
                if (statement != null) {
                    RbsRubyEditTypeSignatureIntention.openAndEditTypeSignature(this.myProject, statement, (PsiElement)call);
                }
            });
        }

        public void visitAttrWriterCall(@NotNull RCall call) {
            RElementWithFQN context;
            Fqn fqn;
            if (call == null) {
                MyVisitor.$$$reportNull$$$0(6);
            }
            if ((fqn = Fqn.of((context = SymbolUtil.getContextContainer((PsiElement)call)).getFQNWithNesting(), (PsiElement)context).split()) == Fqn.INVALID) {
                return;
            }
            RbsVisibility visibility = RbsVisibility.valueOf((Visibility)((Visibility)ObjectUtils.coalesce((Object)VisibilityUtil.getCurrentPointVisibility((PsiElement)call), (Object)Visibility.PUBLIC)));
            RbsDeclarationType declarationType = context instanceof RObjectClass ? RbsDeclarationType.SINGLETON_DECLARATION : RbsDeclarationType.INSTANCE_DECLARATION;
            PsiElement argument = (PsiElement)ContainerUtil.find((Iterable)call.getArguments(), it -> it.getTextRange().shiftLeft(call.getTextOffset()).intersects(this.myRangeInElement));
            if (argument == null) {
                return;
            }
            String name = RubyInterpretUtil.evaluateStringOrSymbolElement((PsiElement)argument);
            if (name == null) {
                return;
            }
            this.findOrCreateContainer(fqn, (PsiElement)call, container -> {
                RbsPsiSymbolDeclaration<?> statement = this.insertStatement((PsiElement)container, (RbsStatementElement)RbsPsiElementFactory.createAttributeMember(this.myProject, visibility, RbsAttributeType.ATTRIBUTE_WRITER, declarationType, name));
                if (statement != null) {
                    RbsRubyEditTypeSignatureIntention.openAndEditTypeSignature(this.myProject, statement, (PsiElement)call);
                }
            });
        }

        public void visitRClassVariable(@NotNull RClassVariable classVariable) {
            RElementWithFQN context;
            Fqn fqn;
            if (classVariable == null) {
                MyVisitor.$$$reportNull$$$0(7);
            }
            if ((fqn = Fqn.of((context = SymbolUtil.getContextContainer((PsiElement)classVariable)).getFQNWithNesting(), (PsiElement)context).split()) == Fqn.INVALID) {
                return;
            }
            String name = classVariable.getName();
            if (name == null) {
                return;
            }
            this.findOrCreateContainer(fqn, (PsiElement)classVariable, container -> {
                RbsPsiSymbolDeclaration<?> statement = this.insertStatement((PsiElement)container, (RbsStatementElement)RbsPsiElementFactory.createClassVariableMember(this.myProject, name));
                if (statement != null) {
                    RbsRubyEditTypeSignatureIntention.openAndEditTypeSignature(this.myProject, statement, (PsiElement)classVariable);
                }
            });
        }

        public void visitRConstant(@NotNull RConstant constant) {
            if (constant == null) {
                MyVisitor.$$$reportNull$$$0(8);
            }
            Fqn fqn = Fqn.of(constant.getFQNWithNesting()).split();
            Fqn parentFqn = fqn.getParent();
            String name = fqn.getName();
            if (parentFqn != Fqn.INVALID) {
                this.findOrCreateContainer(parentFqn, (PsiElement)constant, container -> {
                    RbsPsiSymbolDeclaration<?> statement = this.insertStatement((PsiElement)container, (RbsStatementElement)RbsPsiElementFactory.createConstantDeclaration(this.myProject, name));
                    if (statement != null) {
                        RbsRubyEditTypeSignatureIntention.openAndEditTypeSignature(this.myProject, statement, (PsiElement)constant);
                    }
                });
            } else {
                String filename = "%s.rbs".formatted(NamingConventions.toUnderscoreCase((String)name));
                this.createFile(filename, (PsiElement)constant, file -> {
                    RbsPsiSymbolDeclaration<?> statement = this.insertStatement((PsiElement)file, RbsPsiElementFactory.createConstantDeclaration(this.myProject, name));
                    if (statement != null) {
                        RbsRubyEditTypeSignatureIntention.openAndEditTypeSignature(this.myProject, statement, (PsiElement)constant);
                    }
                });
            }
        }

        public void visitRGlobalVariable(@NotNull RGlobalVariable globalVariable) {
            if (globalVariable == null) {
                MyVisitor.$$$reportNull$$$0(9);
            }
            String name = globalVariable.getName();
            this.createFile("global_variables.rbs", (PsiElement)globalVariable, file -> {
                RbsPsiSymbolDeclaration<?> statement = this.insertStatement((PsiElement)file, RbsPsiElementFactory.createGlobalVariableDeclaration(this.myProject, name));
                if (statement != null) {
                    RbsRubyEditTypeSignatureIntention.openAndEditTypeSignature(this.myProject, statement, (PsiElement)globalVariable);
                }
            });
        }

        public void visitRInstanceVariable(@NotNull RInstanceVariable instanceVariable) {
            RElementWithFQN context;
            Fqn fqn;
            if (instanceVariable == null) {
                MyVisitor.$$$reportNull$$$0(10);
            }
            if ((fqn = Fqn.of((context = SymbolUtil.getContextContainer((PsiElement)instanceVariable)).getFQNWithNesting(), (PsiElement)context).split()) == Fqn.INVALID) {
                return;
            }
            RbsDeclarationType declarationType = context instanceof RObjectClass || ContextImpl.getContext((PsiElement)instanceVariable).getAccess() == Access.CLASS ? RbsDeclarationType.SINGLETON_DECLARATION : RbsDeclarationType.INSTANCE_DECLARATION;
            String name = instanceVariable.getName();
            if (name == null) {
                return;
            }
            this.findOrCreateContainer(fqn, (PsiElement)instanceVariable, container -> {
                RbsPsiSymbolDeclaration<?> statement = this.insertStatement((PsiElement)container, (RbsStatementElement)RbsPsiElementFactory.createInstanceVariableMember(this.myProject, declarationType, name));
                if (statement != null) {
                    RbsRubyEditTypeSignatureIntention.openAndEditTypeSignature(this.myProject, statement, (PsiElement)instanceVariable);
                }
            });
        }

        public void visitRMethod(@NotNull RMethod method) {
            RElementWithFQN context;
            Fqn fqn;
            if (method == null) {
                MyVisitor.$$$reportNull$$$0(11);
            }
            if ((fqn = Fqn.of((context = SymbolUtil.getContextContainer((PsiElement)method.getParent())).getFQNWithNesting(), (PsiElement)context).split()) == Fqn.INVALID) {
                return;
            }
            RbsVisibility visibility = RbsVisibility.valueOf((Visibility)method.getVisibility());
            RbsDeclarationType declarationType = context instanceof RObjectClass ? RbsDeclarationType.SINGLETON_DECLARATION : RbsDeclarationType.INSTANCE_DECLARATION;
            String name = method.getName();
            this.findOrCreateContainer(fqn, (PsiElement)method, container -> {
                RbsPsiSymbolDeclaration<?> statement = this.insertStatement((PsiElement)container, (RbsStatementElement)RbsPsiElementFactory.createMethodMember(this.myProject, visibility, declarationType, name));
                if (statement != null) {
                    RbsRubyEditTypeSignatureIntention.openAndEditTypeSignature(this.myProject, statement, (PsiElement)method);
                }
            });
        }

        public void visitRSingletonMethod(@NotNull RSingletonMethod method) {
            RElementWithFQN context;
            Fqn fqn;
            if (method == null) {
                MyVisitor.$$$reportNull$$$0(12);
            }
            if ((fqn = Fqn.of((context = SymbolUtil.getContextContainer((PsiElement)method.getParent())).getFQNWithNesting(), (PsiElement)context).split()) == Fqn.INVALID) {
                return;
            }
            RbsVisibility visibility = RbsVisibility.valueOf((Visibility)method.getVisibility());
            if (!(ObjectUtils.doIfNotNull((Object)method.getClassObject(), RClassObject::getExpression) instanceof RPseudoConstant)) {
                return;
            }
            String name = method.getName();
            this.findOrCreateContainer(fqn, (PsiElement)method, container -> {
                RbsPsiSymbolDeclaration<?> statement = this.insertStatement((PsiElement)container, (RbsStatementElement)RbsPsiElementFactory.createMethodMember(this.myProject, visibility, RbsDeclarationType.SINGLETON_DECLARATION, name));
                if (statement != null) {
                    RbsRubyEditTypeSignatureIntention.openAndEditTypeSignature(this.myProject, statement, (PsiElement)method);
                }
            });
        }

        @NotNull
        private CreateFileFromTemplateInDirectoryDialog.Builder createBuilder(@NotNull String name, @NotNull String directory, @NotNull PsiElement invocationPoint) {
            if (name == null) {
                MyVisitor.$$$reportNull$$$0(13);
            }
            if (directory == null) {
                MyVisitor.$$$reportNull$$$0(14);
            }
            if (invocationPoint == null) {
                MyVisitor.$$$reportNull$$$0(15);
            }
            VirtualFile root = Objects.requireNonNull((VirtualFile)ObjectUtils.coalesce((Object)((VirtualFile)ObjectUtils.doIfNotNull((Object)PsiUtilCore.getVirtualFile((PsiElement)invocationPoint), arg_0 -> ((ProjectFileIndex)ProjectFileIndex.getInstance((Project)this.myProject)).getContentRootForFile(arg_0))), (Object)ProjectUtil.guessProjectDir((Project)this.myProject)));
            CreateFileFromTemplateInDirectoryDialog.Builder builder = CreateFileFromTemplateInDirectoryDialog.builder((Project)this.myProject).setRoot(root).setTitle(RbsBundle.message((String)"rbs.inspection.missing.type.signature.add.create.file.title", (Object[])new Object[0])).setKind(RbsBundle.message((String)"rbs.actions.create.class.file.dialog.file", (Object[])new Object[0]), RbsIcons.RBS_FILE_ICON, "RBS File").setValidator(RbsCreateClassFileAction.RBS_FILE_VALIDATOR).setDefaultDirectory(directory).setDefaultName(name);
            if (builder == null) {
                MyVisitor.$$$reportNull$$$0(16);
            }
            return builder;
        }

        private void createClass(@NotNull Fqn fqn, @NotNull PsiElement invocationPoint, @NotNull Consumer<? super RbsClassDecl> callback) {
            if (fqn == null) {
                MyVisitor.$$$reportNull$$$0(17);
            }
            if (invocationPoint == null) {
                MyVisitor.$$$reportNull$$$0(18);
            }
            if (callback == null) {
                MyVisitor.$$$reportNull$$$0(19);
            }
            String name = fqn.getName();
            String filename = "%s.rbs".formatted(NamingConventions.toUnderscoreCase((String)name));
            String directory = "sig/%s".formatted(NamingConventions.toUnderscoreCase((String)fqn.getParent().join()));
            this.createBuilder(filename, directory, invocationPoint).show((CreateFileFromTemplateInDirectoryDialog.FileCreator)new MyFileCreator(this.myProject, "RBS Class", fqn), file -> {
                String command = RbsBundle.message((String)"rbs.inspection.missing.type.signature.add.command.name", (Object[])new Object[0]);
                WriteCommandAction.runWriteCommandAction((Project)this.myProject, (String)command, null, () -> {
                    PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
                    RbsPsiUtil.findChildrenOfTypeMatching((PsiElement)file, RbsClassDecl.class, it -> it.getFqn().equals(fqn)).stream().findFirst().ifPresent(callback);
                }, (PsiFile[])new PsiFile[0]);
            });
        }

        private void createFile(@NotNull String filename, @NotNull PsiElement invocationPoint, @NotNull Consumer<? super RbsPsiFile> callback) {
            if (filename == null) {
                MyVisitor.$$$reportNull$$$0(20);
            }
            if (invocationPoint == null) {
                MyVisitor.$$$reportNull$$$0(21);
            }
            if (callback == null) {
                MyVisitor.$$$reportNull$$$0(22);
            }
            this.createBuilder(filename, "sig", invocationPoint).show((CreateFileFromTemplateInDirectoryDialog.FileCreator)new MyFileCreator(this.myProject), file -> {
                String command = RbsBundle.message((String)"rbs.inspection.missing.type.signature.add.command.name", (Object[])new Object[0]);
                WriteCommandAction.runWriteCommandAction((Project)this.myProject, (String)command, null, () -> {
                    PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
                    callback.accept((RbsPsiFile)((Object)file));
                }, (PsiFile[])new PsiFile[0]);
            });
        }

        private void createContainer(@NotNull Fqn fqn, @NotNull PsiElement invocationPoint, @NotNull Consumer<? super RbsDeclarationMembersOwner> callback) {
            if (fqn == null) {
                MyVisitor.$$$reportNull$$$0(23);
            }
            if (invocationPoint == null) {
                MyVisitor.$$$reportNull$$$0(24);
            }
            if (callback == null) {
                MyVisitor.$$$reportNull$$$0(25);
            }
            if (SymbolUtil.findConstantByFQN((Project)this.myProject, (TypeSet)SymbolUtil.getClassTypes(), (FQN)FQN.of((String)fqn.join()), null) != null) {
                this.createClass(fqn, invocationPoint, callback);
            } else {
                this.createModule(fqn, invocationPoint, callback);
            }
        }

        private void createModule(@NotNull Fqn fqn, @NotNull PsiElement invocationPoint, @NotNull Consumer<? super RbsModuleDecl> callback) {
            if (fqn == null) {
                MyVisitor.$$$reportNull$$$0(26);
            }
            if (invocationPoint == null) {
                MyVisitor.$$$reportNull$$$0(27);
            }
            if (callback == null) {
                MyVisitor.$$$reportNull$$$0(28);
            }
            String name = fqn.getName();
            String filename = "%s.rbs".formatted(NamingConventions.toUnderscoreCase((String)name));
            String directory = "sig/%s".formatted(NamingConventions.toUnderscoreCase((String)fqn.getParent().join()));
            this.createBuilder(filename, directory, invocationPoint).show((CreateFileFromTemplateInDirectoryDialog.FileCreator)new MyFileCreator(this.myProject, "RBS Module", fqn), file -> {
                String command = RbsBundle.message((String)"rbs.inspection.missing.type.signature.add.command.name", (Object[])new Object[0]);
                WriteCommandAction.runWriteCommandAction((Project)this.myProject, (String)command, null, () -> {
                    PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
                    RbsPsiUtil.findChildrenOfTypeMatching((PsiElement)file, RbsModuleDecl.class, it -> it.getFqn().equals(fqn)).stream().findFirst().ifPresent(callback);
                }, (PsiFile[])new PsiFile[0]);
            });
        }

        private void findContainer(@NotNull RbsContainerSymbol container, @NotNull Consumer<? super RbsDeclarationMembersOwner> callback) {
            if (container == null) {
                MyVisitor.$$$reportNull$$$0(29);
            }
            if (callback == null) {
                MyVisitor.$$$reportNull$$$0(30);
            }
            List<RbsPsiSymbolDeclaration<?>> declarations = RbsPsiSymbolDeclarationSearcher.getDeclarations(this.myProject, this.mySearchScope, container);
            switch (declarations.size()) {
                case 0: {
                    break;
                }
                case 1: {
                    RbsPsiSymbolDeclaration declaration2 = (RbsPsiSymbolDeclaration)ContainerUtil.getOnlyItem(declarations);
                    PsiElement psiElement = declaration2.getDeclaringElement();
                    if (!(psiElement instanceof RbsDeclarationMembersOwner)) break;
                    RbsDeclarationMembersOwner membersOwner = (RbsDeclarationMembersOwner)psiElement;
                    String command = RbsBundle.message((String)"rbs.inspection.missing.type.signature.add.command.name", (Object[])new Object[0]);
                    WriteCommandAction.runWriteCommandAction((Project)this.myProject, (String)command, null, () -> callback.accept(membersOwner), (PsiFile[])new PsiFile[0]);
                    break;
                }
                default: {
                    String title = RbsBundle.message((String)"rbs.inspection.missing.type.signature.add.disambiguate.title", (Object[])new Object[0]);
                    TargetPopup.createTargetPopup((String)title, declarations, TargetPresentationUtil::createTargetPresentation, declaration -> {
                        PsiElement patt34542$temp = declaration.getDeclaringElement();
                        if (patt34542$temp instanceof RbsDeclarationMembersOwner) {
                            RbsDeclarationMembersOwner membersOwner = (RbsDeclarationMembersOwner)patt34542$temp;
                            String command = RbsBundle.message((String)"rbs.inspection.missing.type.signature.add.command.name", (Object[])new Object[0]);
                            WriteCommandAction.runWriteCommandAction((Project)this.myProject, (String)command, null, () -> callback.accept(membersOwner), (PsiFile[])new PsiFile[0]);
                        }
                    }).showInBestPositionFor(this.myEditor);
                }
            }
        }

        private void findOrCreateContainer(@NotNull Fqn fqn, @NotNull PsiElement invocationPoint, @NotNull Consumer<? super RbsDeclarationMembersOwner> callback) {
            RbsContainerSymbol containerSymbol;
            if (fqn == null) {
                MyVisitor.$$$reportNull$$$0(31);
            }
            if (invocationPoint == null) {
                MyVisitor.$$$reportNull$$$0(32);
            }
            if (callback == null) {
                MyVisitor.$$$reportNull$$$0(33);
            }
            if ((containerSymbol = (RbsContainerSymbol)RbsContainerSymbol.find(this.myProject, this.mySearchScope, fqn).findAny().orElse(null)) != null) {
                this.findContainer(containerSymbol, callback);
            } else {
                this.createContainer(fqn, invocationPoint, callback);
            }
        }

        @RequiresWriteLock
        @Nullable
        private <T extends RbsStatementElement> RbsPsiSymbolDeclaration<?> insertStatement(@NotNull PsiElement parent, @NotNull T statement) {
            RbsStatementElement dereferenced;
            RbsDeclarationMembersOwner membersOwner;
            RbsDeclarationMembers members;
            if (parent == null) {
                MyVisitor.$$$reportNull$$$0(34);
            }
            if (statement == null) {
                MyVisitor.$$$reportNull$$$0(35);
            }
            ThreadingAssertions.assertWriteAccess();
            Object newElement = parent instanceof RbsDeclarationMembersOwner ? ((members = (membersOwner = (RbsDeclarationMembersOwner)parent).getDeclarationMembers()) != null ? RbsPsiEditUtil.insertStatement(members, statement) : null) : RbsPsiEditUtil.insertStatement(parent, statement);
            if (newElement == null) {
                return null;
            }
            SmartPsiElementPointer pointer = SmartPointerManager.createPointer(newElement);
            PsiDocumentManager manager = PsiDocumentManager.getInstance((Project)this.myProject);
            Document document = manager.getDocument(parent.getContainingFile());
            if (document != null) {
                manager.doPostponedOperationsAndUnblockDocument(document);
            }
            if ((dereferenced = (RbsStatementElement)pointer.dereference()) == null) {
                return null;
            }
            return (RbsPsiSymbolDeclaration)ContainerUtil.getOnlyItem((Collection)PsiSymbolDeclarationService.getInstance().getDeclarations((PsiElement)dereferenced, RbsPsiSymbolDeclaration.class));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 16 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "searchScope";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aliasStatement";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "call";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "classVariable";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "constant";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "globalVariable";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "instanceVariable";
                    break;
                }
                case 11: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "directory";
                    break;
                }
                case 15: 
                case 18: 
                case 21: 
                case 24: 
                case 27: 
                case 32: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "invocationPoint";
                    break;
                }
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/ruby/rbs/ruby/inspections/dataFlow/RbsAddTypeSignatureQuickFix$MyVisitor";
                    break;
                }
                case 17: 
                case 23: 
                case 26: 
                case 31: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fqn";
                    break;
                }
                case 19: 
                case 22: 
                case 25: 
                case 28: 
                case 30: 
                case 33: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callback";
                    break;
                }
                case 20: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filename";
                    break;
                }
                case 29: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "container";
                    break;
                }
                case 34: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 35: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/ruby/rbs/ruby/inspections/dataFlow/RbsAddTypeSignatureQuickFix$MyVisitor";
                    break;
                }
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createBuilder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "visitRAliasStatement";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "visitAttrAccessorCall";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "visitAttrReaderCall";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "visitAttrWriterCall";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "visitRClassVariable";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "visitRConstant";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "visitRGlobalVariable";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "visitRInstanceVariable";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "visitRMethod";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "visitRSingletonMethod";
                    break;
                }
                case 13: 
                case 14: 
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "createBuilder";
                    break;
                }
                case 16: {
                    break;
                }
                case 17: 
                case 18: 
                case 19: {
                    objectArray = objectArray;
                    objectArray[2] = "createClass";
                    break;
                }
                case 20: 
                case 21: 
                case 22: {
                    objectArray = objectArray;
                    objectArray[2] = "createFile";
                    break;
                }
                case 23: 
                case 24: 
                case 25: {
                    objectArray = objectArray;
                    objectArray[2] = "createContainer";
                    break;
                }
                case 26: 
                case 27: 
                case 28: {
                    objectArray = objectArray;
                    objectArray[2] = "createModule";
                    break;
                }
                case 29: 
                case 30: {
                    objectArray = objectArray;
                    objectArray[2] = "findContainer";
                    break;
                }
                case 31: 
                case 32: 
                case 33: {
                    objectArray = objectArray;
                    objectArray[2] = "findOrCreateContainer";
                    break;
                }
                case 34: 
                case 35: {
                    objectArray = objectArray;
                    objectArray[2] = "insertStatement";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 16 -> new IllegalStateException(string);
            };
        }
    }

    private static final class MyPreviewVisitor
    extends RubySystemCallVisitor {
        private final Project myProject;
        private final SearchScope mySearchScope;
        private final TextRange myRangeInElement;
        @Nullable
        private MyPreviewInfo myPreviewInfo;

        private MyPreviewVisitor(@NotNull Project project, @NotNull SearchScope searchScope, @Nullable TextRange rangeInElement) {
            if (project == null) {
                MyPreviewVisitor.$$$reportNull$$$0(0);
            }
            if (searchScope == null) {
                MyPreviewVisitor.$$$reportNull$$$0(1);
            }
            this.myProject = project;
            this.mySearchScope = searchScope;
            this.myRangeInElement = (TextRange)ObjectUtils.coalesce((Object)rangeInElement, (Object)TextRange.EMPTY_RANGE);
        }

        @Nullable
        public MyPreviewInfo getPreviewInfo() {
            return this.myPreviewInfo;
        }

        public void visitRAliasStatement(@NotNull RAliasStatement aliasStatement) {
            RElementWithFQN context;
            Fqn fqn;
            if (aliasStatement == null) {
                MyPreviewVisitor.$$$reportNull$$$0(2);
            }
            if ((fqn = Fqn.of((context = SymbolUtil.getContextContainer((PsiElement)aliasStatement)).getFQNWithNesting(), (PsiElement)context).split()) == Fqn.INVALID) {
                return;
            }
            RbsDeclarationType declarationType = context instanceof RObjectClass ? RbsDeclarationType.SINGLETON_DECLARATION : RbsDeclarationType.INSTANCE_DECLARATION;
            String name = aliasStatement.getNewName();
            String targetName = aliasStatement.getOldName();
            if (name == null || targetName == null) {
                return;
            }
            if (aliasStatement.isMethodAlias()) {
                String filename = this.findContainerFilename(fqn);
                RbsAliasMember declaration = RbsPsiElementFactory.createAliasMember(this.myProject, declarationType, name, targetName);
                this.myPreviewInfo = new MyPreviewInfo(filename, declaration.getText());
            } else {
                String filename = "sig/global_variables.rbs";
                RbsGlobalDecl declaration = RbsPsiElementFactory.createGlobalVariableDeclaration(this.myProject, StringUtil.trimStart((String)name, (String)"$"));
                this.myPreviewInfo = new MyPreviewInfo("sig/global_variables.rbs", declaration.getText());
            }
        }

        public void visitAttrAccessorCall(@NotNull RCall call) {
            RElementWithFQN context;
            Fqn fqn;
            if (call == null) {
                MyPreviewVisitor.$$$reportNull$$$0(3);
            }
            if ((fqn = Fqn.of((context = SymbolUtil.getContextContainer((PsiElement)call)).getFQNWithNesting(), (PsiElement)context).split()) == Fqn.INVALID) {
                return;
            }
            RbsVisibility visibility = RbsVisibility.valueOf((Visibility)((Visibility)ObjectUtils.coalesce((Object)VisibilityUtil.getCurrentPointVisibility((PsiElement)call), (Object)Visibility.PUBLIC)));
            RbsDeclarationType declarationType = context instanceof RObjectClass ? RbsDeclarationType.SINGLETON_DECLARATION : RbsDeclarationType.INSTANCE_DECLARATION;
            PsiElement argument = (PsiElement)ContainerUtil.find((Iterable)call.getArguments(), it -> it.getTextRange().shiftLeft(call.getTextOffset()).intersects(this.myRangeInElement));
            if (argument == null) {
                return;
            }
            String name = RubyInterpretUtil.evaluateStringOrSymbolElement((PsiElement)argument);
            if (name == null) {
                return;
            }
            String filename = this.findContainerFilename(fqn);
            RbsAttributeMember declaration = RbsPsiElementFactory.createAttributeMember(this.myProject, visibility, RbsAttributeType.ATTRIBUTE_ACCESSOR, declarationType, name);
            this.myPreviewInfo = new MyPreviewInfo(filename, declaration.getText());
        }

        public void visitAttrReaderCall(@NotNull RCall call) {
            RElementWithFQN context;
            Fqn fqn;
            if (call == null) {
                MyPreviewVisitor.$$$reportNull$$$0(4);
            }
            if ((fqn = Fqn.of((context = SymbolUtil.getContextContainer((PsiElement)call)).getFQNWithNesting(), (PsiElement)context).split()) == Fqn.INVALID) {
                return;
            }
            RbsVisibility visibility = RbsVisibility.valueOf((Visibility)((Visibility)ObjectUtils.coalesce((Object)VisibilityUtil.getCurrentPointVisibility((PsiElement)call), (Object)Visibility.PUBLIC)));
            RbsDeclarationType declarationType = context instanceof RObjectClass ? RbsDeclarationType.SINGLETON_DECLARATION : RbsDeclarationType.INSTANCE_DECLARATION;
            PsiElement argument = (PsiElement)ContainerUtil.find((Iterable)call.getArguments(), it -> it.getTextRange().shiftLeft(call.getTextOffset()).intersects(this.myRangeInElement));
            if (argument == null) {
                return;
            }
            String name = RubyInterpretUtil.evaluateStringOrSymbolElement((PsiElement)argument);
            if (name == null) {
                return;
            }
            String filename = this.findContainerFilename(fqn);
            RbsAttributeMember declaration = RbsPsiElementFactory.createAttributeMember(this.myProject, visibility, RbsAttributeType.ATTRIBUTE_READER, declarationType, name);
            this.myPreviewInfo = new MyPreviewInfo(filename, declaration.getText());
        }

        public void visitAttrWriterCall(@NotNull RCall call) {
            RElementWithFQN context;
            Fqn fqn;
            if (call == null) {
                MyPreviewVisitor.$$$reportNull$$$0(5);
            }
            if ((fqn = Fqn.of((context = SymbolUtil.getContextContainer((PsiElement)call)).getFQNWithNesting(), (PsiElement)context).split()) == Fqn.INVALID) {
                return;
            }
            RbsVisibility visibility = RbsVisibility.valueOf((Visibility)((Visibility)ObjectUtils.coalesce((Object)VisibilityUtil.getCurrentPointVisibility((PsiElement)call), (Object)Visibility.PUBLIC)));
            RbsDeclarationType declarationType = context instanceof RObjectClass ? RbsDeclarationType.SINGLETON_DECLARATION : RbsDeclarationType.INSTANCE_DECLARATION;
            PsiElement argument = (PsiElement)ContainerUtil.find((Iterable)call.getArguments(), it -> it.getTextRange().shiftLeft(call.getTextOffset()).intersects(this.myRangeInElement));
            if (argument == null) {
                return;
            }
            String name = RubyInterpretUtil.evaluateStringOrSymbolElement((PsiElement)argument);
            if (name == null) {
                return;
            }
            String filename = this.findContainerFilename(fqn);
            RbsAttributeMember declaration = RbsPsiElementFactory.createAttributeMember(this.myProject, visibility, RbsAttributeType.ATTRIBUTE_WRITER, declarationType, name);
            this.myPreviewInfo = new MyPreviewInfo(filename, declaration.getText());
        }

        public void visitRClassVariable(@NotNull RClassVariable classVariable) {
            RElementWithFQN context;
            Fqn fqn;
            if (classVariable == null) {
                MyPreviewVisitor.$$$reportNull$$$0(6);
            }
            if ((fqn = Fqn.of((context = SymbolUtil.getContextContainer((PsiElement)classVariable)).getFQNWithNesting(), (PsiElement)context).split()) == Fqn.INVALID) {
                return;
            }
            String name = classVariable.getName();
            if (name == null) {
                return;
            }
            String filename = this.findContainerFilename(fqn);
            RbsVarTypeMember declaration = RbsPsiElementFactory.createClassVariableMember(this.myProject, name);
            this.myPreviewInfo = new MyPreviewInfo(filename, declaration.getText());
        }

        public void visitRConstant(@NotNull RConstant constant) {
            if (constant == null) {
                MyPreviewVisitor.$$$reportNull$$$0(7);
            }
            Fqn fqn = Fqn.of(constant.getFQNWithNesting()).split();
            Fqn parentFqn = fqn.getParent();
            String name = fqn.getName();
            String filename = parentFqn != Fqn.INVALID ? this.findContainerFilename(parentFqn) : "sig/%s.rbs".formatted(NamingConventions.toUnderscoreCase((String)name));
            RbsConstDecl declaration = RbsPsiElementFactory.createConstantDeclaration(this.myProject, name);
            this.myPreviewInfo = new MyPreviewInfo(filename, declaration.getText());
        }

        public void visitRGlobalVariable(@NotNull RGlobalVariable globalVariable) {
            if (globalVariable == null) {
                MyPreviewVisitor.$$$reportNull$$$0(8);
            }
            String name = globalVariable.getName();
            String filename = "sig/global_variables.rbs";
            RbsGlobalDecl declaration = RbsPsiElementFactory.createGlobalVariableDeclaration(this.myProject, name);
            this.myPreviewInfo = new MyPreviewInfo("sig/global_variables.rbs", declaration.getText());
        }

        public void visitRInstanceVariable(@NotNull RInstanceVariable instanceVariable) {
            RElementWithFQN context;
            Fqn fqn;
            if (instanceVariable == null) {
                MyPreviewVisitor.$$$reportNull$$$0(9);
            }
            if ((fqn = Fqn.of((context = SymbolUtil.getContextContainer((PsiElement)instanceVariable)).getFQNWithNesting(), (PsiElement)context).split()) == Fqn.INVALID) {
                return;
            }
            RbsDeclarationType declarationType = context instanceof RObjectClass || ContextImpl.getContext((PsiElement)instanceVariable).getAccess() == Access.CLASS ? RbsDeclarationType.SINGLETON_DECLARATION : RbsDeclarationType.INSTANCE_DECLARATION;
            String name = instanceVariable.getName();
            if (name == null) {
                return;
            }
            String filename = this.findContainerFilename(fqn);
            RbsVarTypeMember declaration = RbsPsiElementFactory.createInstanceVariableMember(this.myProject, declarationType, name);
            this.myPreviewInfo = new MyPreviewInfo(filename, declaration.getText());
        }

        public void visitRMethod(@NotNull RMethod method) {
            RElementWithFQN context;
            Fqn fqn;
            if (method == null) {
                MyPreviewVisitor.$$$reportNull$$$0(10);
            }
            if ((fqn = Fqn.of((context = SymbolUtil.getContextContainer((PsiElement)method.getParent())).getFQNWithNesting(), (PsiElement)context).split()) == Fqn.INVALID) {
                return;
            }
            RbsVisibility visibility = RbsVisibility.valueOf((Visibility)method.getVisibility());
            RbsDeclarationType declarationType = context instanceof RObjectClass ? RbsDeclarationType.SINGLETON_DECLARATION : RbsDeclarationType.INSTANCE_DECLARATION;
            String name = method.getName();
            String filename = this.findContainerFilename(fqn);
            RbsMethodMember declaration = RbsPsiElementFactory.createMethodMember(this.myProject, visibility, declarationType, name);
            this.myPreviewInfo = new MyPreviewInfo(filename, declaration.getText());
        }

        public void visitRSingletonMethod(@NotNull RSingletonMethod method) {
            RElementWithFQN context;
            Fqn fqn;
            if (method == null) {
                MyPreviewVisitor.$$$reportNull$$$0(11);
            }
            if ((fqn = Fqn.of((context = SymbolUtil.getContextContainer((PsiElement)method.getParent())).getFQNWithNesting(), (PsiElement)context).split()) == Fqn.INVALID) {
                return;
            }
            RbsVisibility visibility = RbsVisibility.valueOf((Visibility)method.getVisibility());
            if (!(ObjectUtils.doIfNotNull((Object)method.getClassObject(), RClassObject::getExpression) instanceof RPseudoConstant)) {
                return;
            }
            String name = method.getName();
            String filename = this.findContainerFilename(fqn);
            RbsMethodMember declaration = RbsPsiElementFactory.createMethodMember(this.myProject, visibility, RbsDeclarationType.SINGLETON_DECLARATION, name);
            this.myPreviewInfo = new MyPreviewInfo(filename, declaration.getText());
        }

        @NotNull
        private String findContainerFilename(@NotNull Fqn fqn) {
            if (fqn == null) {
                MyPreviewVisitor.$$$reportNull$$$0(12);
            }
            String string = RbsContainerSymbol.find(this.myProject, this.mySearchScope, fqn).mapMulti((container, consumer) -> RbsPsiSymbolDeclarationSearcher.processDeclarations(this.myProject, this.mySearchScope, container, declaration -> {
                VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)declaration.getDeclaringElement());
                if (file == null) {
                    return false;
                }
                String filename = TargetPresentationUtil.getRelativePath((Project)this.myProject, (VirtualFile)file);
                if (filename != null) {
                    consumer.accept(filename);
                }
                return false;
            })).findFirst().orElse("sig/%s.rbs".formatted(NamingConventions.toUnderscoreCase((String)fqn.join())));
            if (string == null) {
                MyPreviewVisitor.$$$reportNull$$$0(13);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 13 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "searchScope";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aliasStatement";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "call";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "classVariable";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "constant";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "globalVariable";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "instanceVariable";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fqn";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/ruby/rbs/ruby/inspections/dataFlow/RbsAddTypeSignatureQuickFix$MyPreviewVisitor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/ruby/rbs/ruby/inspections/dataFlow/RbsAddTypeSignatureQuickFix$MyPreviewVisitor";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findContainerFilename";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "visitRAliasStatement";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "visitAttrAccessorCall";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "visitAttrReaderCall";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "visitAttrWriterCall";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "visitRClassVariable";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "visitRConstant";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "visitRGlobalVariable";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "visitRInstanceVariable";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "visitRMethod";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "visitRSingletonMethod";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "findContainerFilename";
                    break;
                }
                case 13: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 13 -> new IllegalStateException(string);
            };
        }
    }

    private record MyPreviewInfo(@Nullable String filename, @NotNull String text) {
        @NotNull
        private final String text;

        private MyPreviewInfo(@Nullable String filename, @NotNull String text) {
            if (text == null) {
                MyPreviewInfo.$$$reportNull$$$0(0);
            }
        }

        @NotNull
        public String text() {
            String string = this.text;
            if (string == null) {
                MyPreviewInfo.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/ruby/rbs/ruby/inspections/dataFlow/RbsAddTypeSignatureQuickFix$MyPreviewInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/ruby/rbs/ruby/inspections/dataFlow/RbsAddTypeSignatureQuickFix$MyPreviewInfo";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "text";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static final class MyFileCreator
    implements CreateFileFromTemplateInDirectoryDialog.FileCreator<RbsPsiFile> {
        private final Project myProject;
        private final String myTemplateName;
        private final Fqn myFqn;

        private MyFileCreator(@NotNull Project project) {
            if (project == null) {
                MyFileCreator.$$$reportNull$$$0(0);
            }
            this(project, "RBS File", Fqn.INVALID);
        }

        private MyFileCreator(@NotNull Project project, @NotNull String templateName, @NotNull Fqn fqn) {
            if (project == null) {
                MyFileCreator.$$$reportNull$$$0(1);
            }
            if (templateName == null) {
                MyFileCreator.$$$reportNull$$$0(2);
            }
            if (fqn == null) {
                MyFileCreator.$$$reportNull$$$0(3);
            }
            this.myProject = project;
            this.myTemplateName = templateName;
            this.myFqn = fqn;
        }

        @Nullable
        public RbsPsiFile createFile(@NotNull PsiDirectory directory, @NotNull String name) throws Exception {
            if (directory == null) {
                MyFileCreator.$$$reportNull$$$0(4);
            }
            if (name == null) {
                MyFileCreator.$$$reportNull$$$0(5);
            }
            FileTemplate template = FileTemplateManager.getInstance((Project)this.myProject).getInternalTemplate(this.myTemplateName);
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                template.setReformatCode(false);
            }
            if (this.myTemplateName.equals("RBS File")) {
                return (RbsPsiFile)CreateFileFromTemplateAction.createFileFromTemplate((String)name, (FileTemplate)template, (PsiDirectory)directory, null, (boolean)true);
            }
            Properties properties = FileTemplateManager.getInstance((Project)this.myProject).getDefaultProperties();
            properties.setProperty("NAME", this.myFqn.join());
            RbsPsiFile file = (RbsPsiFile)FileTemplateUtil.createFromTemplate((FileTemplate)template, (String)name, (Properties)properties, (PsiDirectory)directory).getContainingFile();
            if (template.isLiveTemplateEnabled()) {
                CreateFromTemplateActionBase.startLiveTemplate((PsiFile)file);
            }
            return file;
        }

        @NotNull
        public String getActionName(@NotNull String name) {
            if (name == null) {
                MyFileCreator.$$$reportNull$$$0(6);
            }
            String string = RbsBundle.message((String)"rbs.inspection.missing.type.signature.add.create.file.name", (Object[])new Object[]{name});
            if (string == null) {
                MyFileCreator.$$$reportNull$$$0(7);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "templateName";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fqn";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "directory";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/ruby/rbs/ruby/inspections/dataFlow/RbsAddTypeSignatureQuickFix$MyFileCreator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/ruby/rbs/ruby/inspections/dataFlow/RbsAddTypeSignatureQuickFix$MyFileCreator";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "createFile";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getActionName";
                    break;
                }
                case 7: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 7 -> new IllegalStateException(string);
            };
        }
    }
}

