/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.psi.util;

import com.intellij.lang.ruby.rbs.psi.RbsAliasMember;
import com.intellij.lang.ruby.rbs.psi.RbsClassNameElement;
import com.intellij.lang.ruby.rbs.psi.RbsClassStatementElement;
import com.intellij.lang.ruby.rbs.psi.RbsContainerDeclarationElement;
import com.intellij.lang.ruby.rbs.psi.RbsDeclarationMembersOwner;
import com.intellij.lang.ruby.rbs.psi.RbsGenericsBound;
import com.intellij.lang.ruby.rbs.psi.RbsInterfaceDeclarationElement;
import com.intellij.lang.ruby.rbs.psi.RbsMethodMember;
import com.intellij.lang.ruby.rbs.psi.RbsModuleTypeParams;
import com.intellij.lang.ruby.rbs.psi.RbsPsiFile;
import com.intellij.lang.ruby.rbs.psi.RbsQualifiedNameElement;
import com.intellij.lang.ruby.rbs.psi.RbsSimpleType;
import com.intellij.lang.ruby.rbs.psi.RbsUseClause;
import com.intellij.lang.ruby.rbs.psi.RbsUseClauseType;
import com.intellij.lang.ruby.rbs.psi.RbsUseNamespace;
import com.intellij.lang.ruby.rbs.psi.RbsUseNamespaceElement;
import com.intellij.lang.ruby.rbs.psi.RbsVisibilityModifier;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ruby.rbs.frontback.psi.RbsVisibility;
import com.intellij.ruby.rbs.frontback.psi.tree.RbsElementTypesGenerated;
import com.intellij.ruby.rbs.frontback.psi.tree.RbsTokenSets;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RbsPsiUtil {
    private RbsPsiUtil() {
    }

    @Contract(value="null -> false")
    public static boolean canBeFirstElementOfContainerDeclaration(@Nullable PsiElement element) {
        return RbsPsiUtil.isFirstNonWhiteSpaceElementOnLine(element) && !RbsPsiUtil.isInsideInterfaceDeclaration(element);
    }

    @Contract(value="null -> false")
    public static boolean canBeFirstElementOfTopLevelDeclaration(@Nullable PsiElement element) {
        return RbsPsiUtil.isFirstNonWhiteSpaceElementOnLine(element) && !RbsPsiUtil.isInsideContainerDeclaration(element);
    }

    @Contract(value="null -> false")
    public static boolean isFirstNonWhiteSpaceElementOnLine(@Nullable PsiElement element) {
        if (element == null) {
            return false;
        }
        while ((element = PsiTreeUtil.prevLeaf((PsiElement)element, (boolean)true)) != null) {
            if (!(element instanceof PsiWhiteSpace)) {
                return false;
            }
            if (!element.textContains('\n')) continue;
            return true;
        }
        return true;
    }

    @Contract(value="null -> false")
    public static boolean isInsideContainerDeclaration(@Nullable PsiElement element) {
        return PsiTreeUtil.getParentOfType((PsiElement)element, RbsContainerDeclarationElement.class) != null;
    }

    @Contract(value="null -> false")
    public static boolean isInsideInterfaceDeclaration(@Nullable PsiElement element) {
        return PsiTreeUtil.getParentOfType((PsiElement)element, RbsInterfaceDeclarationElement.class) != null;
    }

    @NotNull
    public static <T extends PsiElement> List<T> findChildrenOfTypeMatching(@NotNull PsiElement element, @NotNull Class<T> clazz, @NotNull Predicate<? super T> predicate) {
        if (element == null) {
            RbsPsiUtil.$$$reportNull$$$0(0);
        }
        if (clazz == null) {
            RbsPsiUtil.$$$reportNull$$$0(1);
        }
        if (predicate == null) {
            RbsPsiUtil.$$$reportNull$$$0(2);
        }
        List<? super T> list = PsiTreeUtil.findChildrenOfAnyType((PsiElement)element, (Class[])new Class[]{clazz}).stream().filter(predicate).toList();
        if (list == null) {
            RbsPsiUtil.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Contract(value="null -> null")
    @Nullable
    public static RbsDeclarationMembersOwner getDirectParentClassOrModuleDeclaration(@Nullable PsiElement element) {
        return (RbsDeclarationMembersOwner)ObjectUtils.tryCast((Object)PsiTreeUtil.getParentOfType((PsiElement)element, RbsContainerDeclarationElement.class), RbsDeclarationMembersOwner.class);
    }

    @NotNull
    public static RbsVisibility getDeclarationVisibility(@NotNull RbsClassStatementElement declaration) {
        PsiElement previousSibling;
        RbsVisibilityModifier modifier;
        if (declaration == null) {
            RbsPsiUtil.$$$reportNull$$$0(4);
        }
        if ((modifier = (RbsVisibilityModifier)PsiTreeUtil.getChildOfType((PsiElement)declaration, RbsVisibilityModifier.class)) != null) {
            RbsVisibility rbsVisibility = PsiUtilCore.getElementType((PsiElement)modifier.getFirstChild()) == RbsElementTypesGenerated.RBS_KPUBLIC_INLINE ? RbsVisibility.PUBLIC_VISIBILITY : RbsVisibility.PRIVATE_VISIBILITY;
            if (rbsVisibility == null) {
                RbsPsiUtil.$$$reportNull$$$0(5);
            }
            return rbsVisibility;
        }
        for (previousSibling = declaration.getPrevSibling(); previousSibling != null && !RbsTokenSets.RBS_VISIBILITY_MEMBERS.contains(PsiUtilCore.getElementType((PsiElement)previousSibling)); previousSibling = previousSibling.getPrevSibling()) {
        }
        RbsVisibility rbsVisibility = PsiUtilCore.getElementType((PsiElement)previousSibling) == RbsElementTypesGenerated.RBS_PRIVATE_MEMBER ? RbsVisibility.PRIVATE_VISIBILITY : RbsVisibility.PUBLIC_VISIBILITY;
        if (rbsVisibility == null) {
            RbsPsiUtil.$$$reportNull$$$0(6);
        }
        return rbsVisibility;
    }

    @NotNull
    public static List<RbsUseClauseType> getUseClauseTypes(@NotNull PsiElement element) {
        PsiFile psiFile;
        if (element == null) {
            RbsPsiUtil.$$$reportNull$$$0(7);
        }
        if (!((psiFile = element.getContainingFile()) instanceof RbsPsiFile)) {
            List<RbsUseClauseType> list = Collections.emptyList();
            if (list == null) {
                RbsPsiUtil.$$$reportNull$$$0(8);
            }
            return list;
        }
        RbsPsiFile file = (RbsPsiFile)psiFile;
        List list = ContainerUtil.mapNotNull(file.getUseClauses(), RbsUseClause::getClauseType);
        if (list == null) {
            RbsPsiUtil.$$$reportNull$$$0(9);
        }
        return list;
    }

    @Contract(value="null -> false")
    public static boolean isFirstElementOfDeclarationMember(@Nullable PsiElement element) {
        return RbsPsiUtil.isInsideContainerDeclaration(element) && RbsPsiUtil.isFirstNonWhiteSpaceElementOnLine(element);
    }

    @Contract(value="null -> false")
    public static boolean isInsideMethodMember(@Nullable PsiElement element) {
        return PsiTreeUtil.getParentOfType((PsiElement)element, RbsMethodMember.class) != null;
    }

    @Contract(value="null -> false")
    public static boolean isInsideAliasMember(@Nullable PsiElement element) {
        return PsiTreeUtil.getParentOfType((PsiElement)element, RbsAliasMember.class) != null;
    }

    @Contract(value="null -> false")
    public static boolean isInsideMethodOrAliasMember(@Nullable PsiElement element) {
        return RbsPsiUtil.isInsideMethodMember(element) || RbsPsiUtil.isInsideAliasMember(element);
    }

    @Contract(value="null -> false")
    public static boolean isInsideSimpleType(@Nullable PsiElement element) {
        return PsiTreeUtil.getParentOfType((PsiElement)element, RbsSimpleType.class) != null;
    }

    @Contract(value="null -> false")
    public static boolean isInsideModuleTypeParams(@Nullable PsiElement element) {
        if (element == null) {
            return false;
        }
        return PsiTreeUtil.getParentOfType((PsiElement)element, RbsModuleTypeParams.class) != null && PsiTreeUtil.getParentOfType((PsiElement)element, RbsGenericsBound.class) == null;
    }

    @Contract(value="null -> false")
    public static boolean isLastElementOfUseClause(@Nullable PsiElement element) {
        if (element == null) {
            return false;
        }
        PsiElement previous = PsiTreeUtil.prevVisibleLeaf((PsiElement)element);
        if (previous == null) {
            return false;
        }
        PsiElement parent = previous.getParent();
        return parent instanceof RbsUseNamespace && PsiUtilCore.getElementType((PsiElement)previous) != RbsElementTypesGenerated.RBS_TNAMESPACE;
    }

    @Contract(value="null -> false")
    public static boolean isLastElementOfUseClauseNamespace(@Nullable PsiElement element) {
        if (element == null || !(element.getParent() instanceof RbsUseNamespace)) {
            return false;
        }
        return PsiUtilCore.getElementType((PsiElement)PsiTreeUtil.prevVisibleLeaf((PsiElement)element)) == RbsElementTypesGenerated.RBS_TNAMESPACE && PsiUtilCore.getElementType((PsiElement)PsiTreeUtil.nextVisibleLeaf((PsiElement)element)) != RbsElementTypesGenerated.RBS_KAS;
    }

    @Contract(value="null -> false")
    public static boolean isMethodAliasTarget(@Nullable PsiElement element) {
        RbsAliasMember aliasMember = (RbsAliasMember)PsiTreeUtil.getParentOfType((PsiElement)element, RbsAliasMember.class);
        return aliasMember != null && element.equals(aliasMember.getTargetMethodNameIdentifier());
    }

    @Contract(value="null -> false")
    public static boolean isInsideQualifiedName(@Nullable PsiElement element) {
        PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{RbsClassNameElement.class, RbsQualifiedNameElement.class, RbsUseNamespaceElement.class});
        return parent != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5, 6, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ruby/rbs/psi/util/RbsPsiUtil";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ruby/rbs/psi/util/RbsPsiUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findChildrenOfTypeMatching";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclarationVisibility";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getUseClauseTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findChildrenOfTypeMatching";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDeclarationVisibility";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getUseClauseTypes";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5, 6, 8, 9 -> new IllegalStateException(string);
        };
    }
}

