/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.psi.util;

import com.intellij.lang.ruby.rbs.psi.RbsAliasDeclaration;
import com.intellij.lang.ruby.rbs.psi.RbsAttributeDeclaration;
import com.intellij.lang.ruby.rbs.psi.RbsClassDeclaration;
import com.intellij.lang.ruby.rbs.psi.RbsConstantDeclaration;
import com.intellij.lang.ruby.rbs.psi.RbsDeclarationType;
import com.intellij.lang.ruby.rbs.psi.RbsExtendCall;
import com.intellij.lang.ruby.rbs.psi.RbsGlobalDeclaration;
import com.intellij.lang.ruby.rbs.psi.RbsIncludeCall;
import com.intellij.lang.ruby.rbs.psi.RbsMethodDeclaration;
import com.intellij.lang.ruby.rbs.psi.RbsModuleDeclaration;
import com.intellij.lang.ruby.rbs.psi.RbsModuleInclusionCall;
import com.intellij.lang.ruby.rbs.psi.RbsPrependCall;
import com.intellij.lang.ruby.rbs.psi.RbsPrivateMember;
import com.intellij.lang.ruby.rbs.psi.RbsQualifiedNameDeclaration;
import com.intellij.lang.ruby.rbs.psi.RbsStatement;
import com.intellij.lang.ruby.rbs.psi.RbsTypeDeclaration;
import com.intellij.lang.ruby.rbs.psi.RbsUseClause;
import com.intellij.lang.ruby.rbs.psi.RbsUseClauseType;
import com.intellij.lang.ruby.rbs.psi.RbsUseCls;
import com.intellij.lang.ruby.rbs.psi.RbsUseDirective;
import com.intellij.lang.ruby.rbs.psi.RbsVariableDeclaration;
import com.intellij.lang.ruby.rbs.psi.RbsVariableType;
import com.intellij.lang.ruby.rbs.util.Fqn;
import com.intellij.ruby.rbs.frontback.psi.RbsVisibility;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Comparator;
import java.util.EnumSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class RbsPsiComparators {
    static final Comparator<RbsStatement> STATEMENT_COMPARATOR = Comparator.comparingInt(RbsPsiComparators::getStatementGroup).thenComparing(RbsPsiComparators::getStatementKey, Comparator.nullsLast(Comparator.naturalOrder()));

    private RbsPsiComparators() {
    }

    private static int getStatementGroup(@NotNull RbsStatement statement) {
        if (statement == null) {
            RbsPsiComparators.$$$reportNull$$$0(0);
        }
        if (statement instanceof RbsUseDirective) {
            RbsUseDirective useDirective = (RbsUseDirective)statement;
            RbsUseClauseType type = (RbsUseClauseType)ObjectUtils.doIfNotNull((Object)((RbsUseCls)ContainerUtil.getFirstItem(useDirective.getUseClsList())), RbsUseClause::getClauseType);
            return !(type instanceof RbsUseClauseType.Wildcard) ? -35 : -34;
        }
        if (statement instanceof RbsTypeDeclaration) {
            return -30;
        }
        if (statement instanceof RbsGlobalDeclaration) {
            return -25;
        }
        if (statement instanceof RbsConstantDeclaration) {
            return -20;
        }
        if (statement instanceof RbsClassDeclaration || statement instanceof RbsModuleDeclaration) {
            return -10;
        }
        if (statement instanceof RbsIncludeCall) {
            return 0;
        }
        if (statement instanceof RbsPrependCall) {
            return 2;
        }
        if (statement instanceof RbsExtendCall) {
            return 4;
        }
        if (statement instanceof RbsVariableDeclaration) {
            RbsVariableDeclaration declaration = (RbsVariableDeclaration)statement;
            return switch (declaration.getVariableType()) {
                default -> throw new IncompatibleClassChangeError();
                case RbsVariableType.CLASS_VARIABLE -> 10;
                case RbsVariableType.INSTANCE_VARIABLE -> {
                    switch (declaration.getDeclarationType()) {
                        default: {
                            throw new IncompatibleClassChangeError();
                        }
                        case SINGLETON_DECLARATION: {
                            yield 20;
                        }
                        case INSTANCE_DECLARATION: 
                    }
                    yield 30;
                }
            };
        }
        if (statement instanceof RbsAttributeDeclaration) {
            RbsAttributeDeclaration declaration = (RbsAttributeDeclaration)statement;
            return switch (declaration.getDeclarationType()) {
                default -> throw new IncompatibleClassChangeError();
                case RbsDeclarationType.SINGLETON_DECLARATION -> 50;
                case RbsDeclarationType.INSTANCE_DECLARATION -> 60;
            };
        }
        if (statement instanceof RbsMethodDeclaration) {
            RbsMethodDeclaration declaration = (RbsMethodDeclaration)statement;
            if (EnumSet.allOf(RbsDeclarationType.class).equals(declaration.getDeclarationTypes())) {
                return 40;
            }
            if (declaration.getDeclarationTypes().contains((Object)RbsDeclarationType.SINGLETON_DECLARATION)) {
                if ("new".equals(declaration.getName())) {
                    return 52;
                }
                if (declaration.getVisibility() == RbsVisibility.PUBLIC_VISIBILITY) {
                    return 54;
                }
                return 56;
            }
            if ("initialize".equals(declaration.getName())) {
                return 62;
            }
            if (declaration.getVisibility() == RbsVisibility.PUBLIC_VISIBILITY) {
                return 64;
            }
            return 66;
        }
        if (statement instanceof RbsAliasDeclaration) {
            RbsAliasDeclaration declaration = (RbsAliasDeclaration)statement;
            return switch (declaration.getDeclarationType()) {
                default -> throw new IncompatibleClassChangeError();
                case RbsDeclarationType.SINGLETON_DECLARATION -> 54;
                case RbsDeclarationType.INSTANCE_DECLARATION -> 64;
            };
        }
        if (statement instanceof RbsPrivateMember) {
            return 65;
        }
        return 0;
    }

    @Nullable
    private static String getStatementKey(@NotNull RbsStatement statement) {
        if (statement == null) {
            RbsPsiComparators.$$$reportNull$$$0(1);
        }
        if (statement instanceof RbsAliasDeclaration) {
            RbsAliasDeclaration declaration = (RbsAliasDeclaration)statement;
            return declaration.getAliasMethodName();
        }
        if (statement instanceof RbsAttributeDeclaration) {
            RbsAttributeDeclaration declaration = (RbsAttributeDeclaration)statement;
            return declaration.getName();
        }
        if (statement instanceof RbsGlobalDeclaration) {
            RbsGlobalDeclaration declaration = (RbsGlobalDeclaration)statement;
            return declaration.getName();
        }
        if (statement instanceof RbsMethodDeclaration) {
            RbsMethodDeclaration declaration = (RbsMethodDeclaration)statement;
            return declaration.getName();
        }
        if (statement instanceof RbsModuleInclusionCall) {
            RbsModuleInclusionCall inclusionCall = (RbsModuleInclusionCall)((Object)statement);
            return inclusionCall.getIncludedModuleText();
        }
        if (statement instanceof RbsQualifiedNameDeclaration) {
            RbsQualifiedNameDeclaration declaration = (RbsQualifiedNameDeclaration)((Object)statement);
            Fqn fqn = declaration.getFqn();
            return fqn != Fqn.INVALID ? fqn.getName() : null;
        }
        if (statement instanceof RbsUseDirective) {
            RbsUseDirective useDirective = (RbsUseDirective)statement;
            RbsUseClauseType type = ((RbsUseCls)ContainerUtil.getFirstItem(useDirective.getUseClsList())).getClauseType();
            if (type instanceof RbsUseClauseType.Alias) {
                RbsUseClauseType.Alias alias = (RbsUseClauseType.Alias)type;
                return alias.fqn().join();
            }
            if (type instanceof RbsUseClauseType.Import) {
                RbsUseClauseType.Import import_ = (RbsUseClauseType.Import)type;
                return import_.fqn().join();
            }
            if (type instanceof RbsUseClauseType.Wildcard) {
                RbsUseClauseType.Wildcard wildcard = (RbsUseClauseType.Wildcard)type;
                return wildcard.namespace().join();
            }
        } else if (statement instanceof RbsVariableDeclaration) {
            RbsVariableDeclaration declaration = (RbsVariableDeclaration)statement;
            return declaration.getName();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "statement";
        objectArray2[1] = "com/intellij/lang/ruby/rbs/psi/util/RbsPsiComparators";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getStatementGroup";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getStatementKey";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

