/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.psi.mixin;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ruby.rbs.completion.RbsQualifiedNameCompletionTarget;
import com.intellij.lang.ruby.rbs.model.psi.RbsQualifiedNameSymbolReference;
import com.intellij.lang.ruby.rbs.model.usages.RbsUsageTypes;
import com.intellij.lang.ruby.rbs.psi.RbsAttributeDeclarationElement;
import com.intellij.lang.ruby.rbs.psi.RbsClassName;
import com.intellij.lang.ruby.rbs.psi.RbsContainerDeclarationElement;
import com.intellij.lang.ruby.rbs.psi.RbsDeclarationType;
import com.intellij.lang.ruby.rbs.psi.RbsDefaultType;
import com.intellij.lang.ruby.rbs.psi.RbsExtendCall;
import com.intellij.lang.ruby.rbs.psi.RbsGenericsBound;
import com.intellij.lang.ruby.rbs.psi.RbsGenericsBoundElement;
import com.intellij.lang.ruby.rbs.psi.RbsMethodDeclarationElement;
import com.intellij.lang.ruby.rbs.psi.RbsModuleInclusionCallElement;
import com.intellij.lang.ruby.rbs.psi.RbsModuleSelfType;
import com.intellij.lang.ruby.rbs.psi.RbsSimpleType;
import com.intellij.lang.ruby.rbs.psi.RbsTypeDeclarationElement;
import com.intellij.lang.ruby.rbs.psi.RbsTypeElement;
import com.intellij.lang.ruby.rbs.psi.RbsVariableDeclarationElement;
import com.intellij.lang.ruby.rbs.psi.RbsVariableType;
import com.intellij.lang.ruby.rbs.psi.data.RbsBooleanLiteralSignature;
import com.intellij.lang.ruby.rbs.psi.data.RbsIntegerLiteralSignature;
import com.intellij.lang.ruby.rbs.psi.data.RbsKeywordTypeSignature;
import com.intellij.lang.ruby.rbs.psi.data.RbsNilLiteralSignature;
import com.intellij.lang.ruby.rbs.psi.data.RbsOptionalTypeSignature;
import com.intellij.lang.ruby.rbs.psi.data.RbsProcTypeSignature;
import com.intellij.lang.ruby.rbs.psi.data.RbsQualifiedNameReferenceSignature;
import com.intellij.lang.ruby.rbs.psi.data.RbsRecordTypeSignature;
import com.intellij.lang.ruby.rbs.psi.data.RbsSingletonTypeSignature;
import com.intellij.lang.ruby.rbs.psi.data.RbsStringLiteralSignature;
import com.intellij.lang.ruby.rbs.psi.data.RbsSymbolLiteralSignature;
import com.intellij.lang.ruby.rbs.psi.data.RbsTupleTypeSignature;
import com.intellij.lang.ruby.rbs.psi.data.RbsTypeSignature;
import com.intellij.lang.ruby.rbs.psi.data.RbsTypeVariableReferenceSignature;
import com.intellij.lang.ruby.rbs.psi.impl.RbsSuperClassImpl;
import com.intellij.lang.ruby.rbs.psi.impl.RbsTypeImpl;
import com.intellij.lang.ruby.rbs.psi.mixin.RbsMethodTypeMixin;
import com.intellij.model.psi.PsiSymbolReference;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ruby.rbs.frontback.psi.tree.RbsElementTypesGenerated;
import com.intellij.ruby.rbs.frontback.psi.tree.RbsTokenSets;
import com.intellij.usages.impl.rules.UsageType;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public abstract class RbsSimpleTypeMixin
extends RbsTypeImpl
implements RbsSimpleType {
    protected RbsSimpleTypeMixin(@NotNull ASTNode node) {
        if (node == null) {
            RbsSimpleTypeMixin.$$$reportNull$$$0(0);
        }
        super(node);
    }

    @Nullable
    public PsiElement getInteger() {
        return this.findChildByType(RbsElementTypesGenerated.RBS_TINTEGER);
    }

    @Override
    @Nullable
    public PsiElement getKeyword() {
        return this.findChildByType(RbsTokenSets.RBS_KEYWORDS);
    }

    @NotNull
    public @NotNull @Unmodifiable Collection<? extends @NotNull PsiSymbolReference> getOwnReferences() {
        PsiElement nameIdentifier = (PsiElement)ObjectUtils.coalesce((Object)this.getQualifiedName(), (Object)this.getClassName());
        if (nameIdentifier == null) {
            List list = Collections.emptyList();
            if (list == null) {
                RbsSimpleTypeMixin.$$$reportNull$$$0(1);
            }
            return list;
        }
        UsageType usageType = this.isTypeVariableDefaultType() ? RbsUsageTypes.USAGE_TYPE_TYPE_VARIABLE_DEFAULT : (this.isTypeVariableUpperBound() ? RbsUsageTypes.USAGE_TYPE_TYPE_VARIABLE_UPPER_BOUND : RbsUsageTypes.USAGE_TYPE_TYPE_SIGNATURE);
        EnumSet<RbsQualifiedNameCompletionTarget> completionTargets = this.isSingleton() ? EnumSet.of(RbsQualifiedNameCompletionTarget.CLASS, RbsQualifiedNameCompletionTarget.MODULE) : (this.isInstanceContext() ? EnumSet.allOf(RbsQualifiedNameCompletionTarget.class) : EnumSet.complementOf(EnumSet.of(RbsQualifiedNameCompletionTarget.CONTAINER_TYPE_VARIABLE)));
        List<RbsQualifiedNameSymbolReference> list = RbsQualifiedNameSymbolReference.createReferencesFor(this, nameIdentifier, usageType, completionTargets);
        if (list == null) {
            RbsSimpleTypeMixin.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Nullable
    public PsiElement getString() {
        return this.findChildByType(RbsElementTypesGenerated.RBS_KCOLON) == null ? this.findChildByType(RbsElementTypesGenerated.RBS_TSTRING) : null;
    }

    @Nullable
    public PsiElement getSymbol() {
        return this.findChildByType(RbsElementTypesGenerated.RBS_KCOLON) == null ? this.findChildByType(RbsElementTypesGenerated.RBS_TSYMBOL) : this.findChildByType(RbsElementTypesGenerated.RBS_TSTRING);
    }

    @Override
    @NotNull
    public RbsTypeSignature getTypeSignature() {
        RbsTypeSignature nonOptionalTypeSignature = this.getNonOptionalTypeSignature();
        RbsTypeSignature rbsTypeSignature = this.isOptional() ? new RbsOptionalTypeSignature(nonOptionalTypeSignature) : nonOptionalTypeSignature;
        if (rbsTypeSignature == null) {
            RbsSimpleTypeMixin.$$$reportNull$$$0(3);
        }
        return rbsTypeSignature;
    }

    @Override
    public boolean isOptional() {
        return PsiUtilCore.getElementType((PsiElement)this.getLastChild()) == RbsElementTypesGenerated.RBS_KQUESTION;
    }

    @Override
    public boolean isSingleton() {
        return this.findChildByType(RbsElementTypesGenerated.RBS_KSINGLETON) != null;
    }

    @Override
    public boolean isString() {
        return this.findChildByType(RbsElementTypesGenerated.RBS_KCOLON) == null && this.findChildByType(RbsTokenSets.RBS_OPEN_QUOTES) != null;
    }

    public boolean isSymbol() {
        return this.findChildByType(RbsElementTypesGenerated.RBS_KCOLON) != null || this.findChildByType(RbsElementTypesGenerated.RBS_TSYMBOL) != null;
    }

    @Override
    public boolean isTuple() {
        return this.getQualifiedName() == null && this.findChildByType(RbsElementTypesGenerated.RBS_KLBRACKET) != null;
    }

    @NotNull
    private RbsTypeSignature getNonOptionalTypeSignature() {
        PsiElement integer;
        if (this.isSingleton()) {
            RbsClassName className = this.getClassName();
            if (className == null) {
                RbsKeywordTypeSignature rbsKeywordTypeSignature = RbsKeywordTypeSignature.UNTYPED;
                if (rbsKeywordTypeSignature == null) {
                    RbsSimpleTypeMixin.$$$reportNull$$$0(4);
                }
                return rbsKeywordTypeSignature;
            }
            return new RbsSingletonTypeSignature(RbsQualifiedNameReferenceSignature.create(this, className.getStrippedText()));
        }
        if (this.getProcType() != null) {
            RbsProcTypeSignature rbsProcTypeSignature = this.getProcType().getTypeSignature();
            if (rbsProcTypeSignature == null) {
                RbsSimpleTypeMixin.$$$reportNull$$$0(5);
            }
            return rbsProcTypeSignature;
        }
        if (this.getQualifiedName() != null) {
            return this.getQualifiedNameTypeSignature(this.getQualifiedName().getStrippedText());
        }
        if (this.getRecordType() != null) {
            RbsRecordTypeSignature rbsRecordTypeSignature = this.getRecordType().getTypeSignature();
            if (rbsRecordTypeSignature == null) {
                RbsSimpleTypeMixin.$$$reportNull$$$0(6);
            }
            return rbsRecordTypeSignature;
        }
        if (this.isTuple()) {
            return new RbsTupleTypeSignature(ContainerUtil.map((Collection)this.getTypeListElements(), RbsTypeElement::getTypeSignature));
        }
        if (this.getType() != null) {
            RbsTypeSignature rbsTypeSignature = this.getType().getTypeSignature();
            if (rbsTypeSignature == null) {
                RbsSimpleTypeMixin.$$$reportNull$$$0(7);
            }
            return rbsTypeSignature;
        }
        PsiElement keyword = this.getKeyword();
        if (keyword != null) {
            RbsTypeSignature signature;
            RbsKeywordTypeSignature typeSignature = RbsKeywordTypeSignature.forName(keyword.getText());
            if (typeSignature != null) {
                RbsKeywordTypeSignature rbsKeywordTypeSignature = typeSignature;
                if (rbsKeywordTypeSignature == null) {
                    RbsSimpleTypeMixin.$$$reportNull$$$0(8);
                }
                return rbsKeywordTypeSignature;
            }
            switch (keyword.getText()) {
                case "true": {
                    RbsTypeSignature rbsTypeSignature = new RbsBooleanLiteralSignature(true);
                    break;
                }
                case "false": {
                    RbsTypeSignature rbsTypeSignature = new RbsBooleanLiteralSignature(false);
                    break;
                }
                case "nil": {
                    RbsTypeSignature rbsTypeSignature = RbsNilLiteralSignature.INSTANCE;
                    break;
                }
                case "self?": {
                    RbsTypeSignature rbsTypeSignature = new RbsOptionalTypeSignature(RbsKeywordTypeSignature.SELF);
                    break;
                }
                default: {
                    RbsTypeSignature rbsTypeSignature = signature = null;
                }
            }
            if (signature != null) {
                RbsTypeSignature rbsTypeSignature = signature;
                if (rbsTypeSignature == null) {
                    RbsSimpleTypeMixin.$$$reportNull$$$0(9);
                }
                return rbsTypeSignature;
            }
        }
        if ((integer = this.getInteger()) != null) {
            return new RbsIntegerLiteralSignature(new BigInteger(integer.getText().replaceAll("_", "")));
        }
        if (this.isString()) {
            PsiElement string = this.getString();
            return new RbsStringLiteralSignature(string != null ? string.getText() : "");
        }
        if (this.isSymbol()) {
            PsiElement symbol = this.getSymbol();
            if (symbol != null && PsiUtilCore.getElementType((PsiElement)symbol) == RbsElementTypesGenerated.RBS_TSYMBOL) {
                return new RbsSymbolLiteralSignature(StringUtil.trimStart((String)symbol.getText(), (String)":"));
            }
            return new RbsSymbolLiteralSignature(symbol != null ? symbol.getText() : "");
        }
        throw new UnsupportedOperationException(String.format("Unrecognised type: %s{text='%s'}", this.getClass(), this.getText()));
    }

    @NotNull
    private RbsTypeSignature getQualifiedNameTypeSignature(@NotNull String qualifiedName) {
        int index;
        int index2;
        int index3;
        RbsMethodTypeMixin methodType;
        if (qualifiedName == null) {
            RbsSimpleTypeMixin.$$$reportNull$$$0(10);
        }
        if ((methodType = (RbsMethodTypeMixin)PsiTreeUtil.getParentOfType((PsiElement)this, RbsMethodTypeMixin.class)) != null && (index3 = ContainerUtil.indexOf(methodType.getTypeParamIdentifiers(), identifier -> identifier != null && identifier.getText().equals(qualifiedName))) >= 0) {
            return new RbsTypeVariableReferenceSignature(RbsTypeVariableReferenceSignature.ReferenceType.METHOD_VARIABLE, qualifiedName, index3);
        }
        RbsTypeDeclarationElement typeAliasDeclaration = (RbsTypeDeclarationElement)PsiTreeUtil.getParentOfType((PsiElement)this, RbsTypeDeclarationElement.class);
        if (typeAliasDeclaration != null && (index2 = ContainerUtil.indexOf(typeAliasDeclaration.getModuleTypeParamIdentifiers(), identifier -> identifier != null && identifier.getText().equals(qualifiedName))) >= 0) {
            return new RbsTypeVariableReferenceSignature(RbsTypeVariableReferenceSignature.ReferenceType.TYPE_ALIAS_VARIABLE, qualifiedName, index2);
        }
        RbsContainerDeclarationElement containerDeclaration = (RbsContainerDeclarationElement)PsiTreeUtil.getParentOfType((PsiElement)this, RbsContainerDeclarationElement.class);
        if (containerDeclaration != null && this.isInstanceContext() && (index = ContainerUtil.indexOf(containerDeclaration.getModuleTypeParamIdentifiers(), parameter -> parameter != null && parameter.getText().equals(qualifiedName))) >= 0) {
            return new RbsTypeVariableReferenceSignature(RbsTypeVariableReferenceSignature.ReferenceType.CONTAINER_VARIABLE, qualifiedName, index);
        }
        RbsTypeSignature rbsTypeSignature = RbsQualifiedNameReferenceSignature.create(this, qualifiedName);
        if (rbsTypeSignature == null) {
            RbsSimpleTypeMixin.$$$reportNull$$$0(11);
        }
        return rbsTypeSignature;
    }

    private boolean isInstanceContext() {
        RbsAttributeDeclarationElement attributeDeclaration = (RbsAttributeDeclarationElement)PsiTreeUtil.getParentOfType((PsiElement)this, RbsAttributeDeclarationElement.class);
        if (attributeDeclaration != null) {
            return attributeDeclaration.getDeclarationType() == RbsDeclarationType.INSTANCE_DECLARATION;
        }
        RbsMethodDeclarationElement methodDeclaration = (RbsMethodDeclarationElement)PsiTreeUtil.getParentOfType((PsiElement)this, RbsMethodDeclarationElement.class);
        if (methodDeclaration != null) {
            return methodDeclaration.getDeclarationTypes().equals(Set.of(RbsDeclarationType.INSTANCE_DECLARATION));
        }
        RbsModuleInclusionCallElement moduleInclusionCall = (RbsModuleInclusionCallElement)PsiTreeUtil.getParentOfType((PsiElement)this, RbsModuleInclusionCallElement.class);
        if (moduleInclusionCall != null) {
            return !(moduleInclusionCall instanceof RbsExtendCall);
        }
        RbsModuleSelfType selfType = (RbsModuleSelfType)PsiTreeUtil.getParentOfType((PsiElement)this, RbsModuleSelfType.class);
        if (selfType != null) {
            return true;
        }
        RbsSuperClassImpl superclass = (RbsSuperClassImpl)PsiTreeUtil.getParentOfType((PsiElement)this, RbsSuperClassImpl.class);
        if (superclass != null) {
            return true;
        }
        RbsGenericsBound genericsBound = (RbsGenericsBound)PsiTreeUtil.getParentOfType((PsiElement)this, RbsGenericsBound.class);
        if (genericsBound != null) {
            return true;
        }
        RbsDefaultType defaultType = (RbsDefaultType)PsiTreeUtil.getParentOfType((PsiElement)this, RbsDefaultType.class);
        if (defaultType != null) {
            return true;
        }
        RbsVariableDeclarationElement variableDeclaration = (RbsVariableDeclarationElement)PsiTreeUtil.getParentOfType((PsiElement)this, RbsVariableDeclarationElement.class);
        if (variableDeclaration != null) {
            return variableDeclaration.getDeclarationType() == RbsDeclarationType.INSTANCE_DECLARATION && variableDeclaration.getVariableType() == RbsVariableType.INSTANCE_VARIABLE;
        }
        return false;
    }

    private boolean isTypeVariableDefaultType() {
        return PsiTreeUtil.getParentOfType((PsiElement)this, RbsDefaultType.class) != null;
    }

    private boolean isTypeVariableUpperBound() {
        return PsiTreeUtil.getParentOfType((PsiElement)this, RbsGenericsBoundElement.class) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ruby/rbs/psi/mixin/RbsSimpleTypeMixin";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ruby/rbs/psi/mixin/RbsSimpleTypeMixin";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOwnReferences";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSignature";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getNonOptionalTypeSignature";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedNameTypeSignature";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedNameTypeSignature";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 11 -> new IllegalStateException(string);
        };
    }
}

