/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.psi.mixin;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ruby.rbs.psi.RbsKeywordParam;
import com.intellij.lang.ruby.rbs.psi.RbsOptionalKeyword;
import com.intellij.lang.ruby.rbs.psi.RbsOptionalPositional;
import com.intellij.lang.ruby.rbs.psi.RbsParam;
import com.intellij.lang.ruby.rbs.psi.RbsProcType;
import com.intellij.lang.ruby.rbs.psi.RbsProcTypeElement;
import com.intellij.lang.ruby.rbs.psi.RbsRequiredKeyword;
import com.intellij.lang.ruby.rbs.psi.RbsRequiredPositional;
import com.intellij.lang.ruby.rbs.psi.RbsRestKeyword;
import com.intellij.lang.ruby.rbs.psi.RbsRestPositional;
import com.intellij.lang.ruby.rbs.psi.RbsSelfTypeBinding;
import com.intellij.lang.ruby.rbs.psi.RbsSimpleType;
import com.intellij.lang.ruby.rbs.psi.RbsTypeElement;
import com.intellij.lang.ruby.rbs.psi.data.RbsKeywordTypeSignature;
import com.intellij.lang.ruby.rbs.psi.data.RbsProcTypeSignature;
import com.intellij.lang.ruby.rbs.psi.data.RbsTypeSignature;
import com.intellij.lang.ruby.rbs.psi.mixin.RbsBlockMixin;
import com.intellij.lang.ruby.rbs.psi.mixin.RbsCompositeElement;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.ruby.rbs.frontback.psi.tree.RbsElementTypesGenerated;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public abstract class RbsProcTypeMixin
extends RbsCompositeElement
implements RbsProcType {
    protected RbsProcTypeMixin(@NotNull ASTNode node) {
        if (node == null) {
            RbsProcTypeMixin.$$$reportNull$$$0(0);
        }
        super(node);
    }

    @Override
    @NotNull
    public RbsProcTypeSignature getTypeSignature() {
        RbsSimpleType returnType;
        RbsTypeSignature returnTypeSignature;
        ArrayList<RbsProcTypeSignature.Parameter> parameters = new ArrayList<RbsProcTypeSignature.Parameter>();
        for (RbsParam parameter : this.getParamList()) {
            RbsTypeSignature typeSignature = parameter.getType().getTypeSignature();
            String variableName = (String)ObjectUtils.doIfNotNull((Object)parameter.getVarName(), PsiElement::getText);
            if (parameter instanceof RbsRequiredPositional) {
                parameters.add(new RbsProcTypeSignature.Parameter(RbsProcTypeSignature.ParameterType.POSITIONAL_REQUIRED, typeSignature, variableName));
                continue;
            }
            if (parameter instanceof RbsOptionalPositional) {
                parameters.add(new RbsProcTypeSignature.Parameter(RbsProcTypeSignature.ParameterType.POSITIONAL_OPTIONAL, typeSignature, variableName));
                continue;
            }
            if (parameter instanceof RbsRestPositional) {
                parameters.add(new RbsProcTypeSignature.Parameter(RbsProcTypeSignature.ParameterType.POSITIONAL_REST, typeSignature, variableName));
                continue;
            }
            if (parameter instanceof RbsKeywordParam) {
                String keywordName = StringUtil.trimEnd((String)((RbsKeywordParam)parameter).getKeywordName().getText(), (String)":");
                if (parameter instanceof RbsRequiredKeyword) {
                    parameters.add(new RbsProcTypeSignature.Parameter(RbsProcTypeSignature.ParameterType.KEYWORD_REQUIRED, keywordName, typeSignature, variableName));
                    continue;
                }
                if (parameter instanceof RbsOptionalKeyword) {
                    parameters.add(new RbsProcTypeSignature.Parameter(RbsProcTypeSignature.ParameterType.KEYWORD_OPTIONAL, keywordName, typeSignature, variableName));
                    continue;
                }
                throw new UnsupportedOperationException(String.format("Unrecognised parameter type: %s", parameter.getClass()));
            }
            if (parameter instanceof RbsRestKeyword) {
                parameters.add(new RbsProcTypeSignature.Parameter(RbsProcTypeSignature.ParameterType.KEYWORD_REST, typeSignature, variableName));
                continue;
            }
            throw new UnsupportedOperationException(String.format("Unrecognised parameter type: %s", parameter.getClass()));
        }
        RbsTypeSignature selfTypeSignature = Optional.ofNullable(this.getSelfTypeBinding()).map(RbsSelfTypeBinding::getType).map(RbsTypeElement::getTypeSignature).orElse(null);
        RbsBlockMixin block = (RbsBlockMixin)this.getBlock();
        RbsProcTypeSignature blockTypeSignature = null;
        boolean isBlockOptional = false;
        if (block != null) {
            blockTypeSignature = (RbsProcTypeSignature)ObjectUtils.doIfNotNull((Object)block.getSimpleFunctionType(), RbsProcTypeElement::getTypeSignature);
            isBlockOptional = block.isOptional();
        }
        RbsTypeSignature rbsTypeSignature = returnTypeSignature = (returnType = this.getSimpleType()) != null ? returnType.getTypeSignature() : RbsKeywordTypeSignature.UNTYPED;
        if (this.hasUntypedParameters()) {
            return new RbsProcTypeSignature(true, returnTypeSignature);
        }
        return new RbsProcTypeSignature(parameters, selfTypeSignature, blockTypeSignature, isBlockOptional, returnTypeSignature);
    }

    @Override
    public boolean hasUntypedParameters() {
        return this.getParamList().isEmpty() && this.findChildByType(RbsElementTypesGenerated.RBS_KQUESTION) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/ruby/rbs/psi/mixin/RbsProcTypeMixin", "<init>"));
    }
}

