/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.psi.data;

import com.intellij.lang.ruby.rbs.psi.data.RbsTypeSignature;
import com.intellij.lang.ruby.rbs.psi.data.RbsTypeSignatureVisitor;
import java.util.Objects;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RbsTypeVariableReferenceSignature
implements RbsTypeSignature {
    static final int TAG = 15;
    static final RbsTypeSignature.Serializer<RbsTypeVariableReferenceSignature> SERIALIZER = (signature, dataStream) -> {
        dataStream.writeName(signature.myReferenceType.name());
        dataStream.writeName(signature.myName);
        dataStream.writeVarInt(signature.myPosition);
    };
    static final RbsTypeSignature.Deserializer<RbsTypeVariableReferenceSignature> DESERIALIZER = dataStream -> {
        ReferenceType referenceType = ReferenceType.valueOf(dataStream.readNameString());
        String name = Objects.requireNonNull(dataStream.readNameString());
        int position = dataStream.readVarInt();
        return new RbsTypeVariableReferenceSignature(referenceType, name, position);
    };
    private final ReferenceType myReferenceType;
    private final String myName;
    private final int myPosition;

    public RbsTypeVariableReferenceSignature(@NotNull ReferenceType referenceType, @NotNull String name, int position) {
        if (referenceType == null) {
            RbsTypeVariableReferenceSignature.$$$reportNull$$$0(0);
        }
        if (name == null) {
            RbsTypeVariableReferenceSignature.$$$reportNull$$$0(1);
        }
        this.myReferenceType = referenceType;
        this.myName = name;
        this.myPosition = position;
    }

    @Override
    public void accept(@NotNull RbsTypeSignatureVisitor visitor) {
        if (visitor == null) {
            RbsTypeVariableReferenceSignature.$$$reportNull$$$0(2);
        }
        visitor.visitTypeVariableReferenceSignature(this);
    }

    @Override
    @NotNull
    public RbsTypeSignature apply(@NotNull Function<RbsTypeSignature, RbsTypeSignature> fun) {
        if (fun == null) {
            RbsTypeVariableReferenceSignature.$$$reportNull$$$0(3);
        }
        RbsTypeSignature rbsTypeSignature = fun.apply(this);
        if (rbsTypeSignature == null) {
            RbsTypeVariableReferenceSignature.$$$reportNull$$$0(4);
        }
        return rbsTypeSignature;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RbsTypeVariableReferenceSignature other = (RbsTypeVariableReferenceSignature)obj;
        return this.myReferenceType == other.myReferenceType && this.myName.equals(other.myName) && this.myPosition == other.myPosition;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            RbsTypeVariableReferenceSignature.$$$reportNull$$$0(5);
        }
        return string;
    }

    public int getPosition() {
        return this.myPosition;
    }

    @NotNull
    public ReferenceType getReferenceType() {
        ReferenceType referenceType = this.myReferenceType;
        if (referenceType == null) {
            RbsTypeVariableReferenceSignature.$$$reportNull$$$0(6);
        }
        return referenceType;
    }

    @Override
    public int getTag() {
        return 15;
    }

    public int hashCode() {
        int result = this.myReferenceType.hashCode();
        result = 31 * result + this.myName.hashCode();
        result = 31 * result + this.myPosition;
        return result;
    }

    @NotNull
    public String toString() {
        String string = this.myName;
        if (string == null) {
            RbsTypeVariableReferenceSignature.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fun";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ruby/rbs/psi/data/RbsTypeVariableReferenceSignature";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ruby/rbs/psi/data/RbsTypeVariableReferenceSignature";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "apply";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceType";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7 -> new IllegalStateException(string);
        };
    }

    public static enum ReferenceType {
        CONTAINER_VARIABLE,
        METHOD_VARIABLE,
        TYPE_ALIAS_VARIABLE;

    }
}

