/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.psi.data;

import com.intellij.lang.ruby.rbs.model.api.RbsContainerSymbol;
import com.intellij.lang.ruby.rbs.model.api.RbsQualifiedNameSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsContainerTypeVariableSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsTypeAliasSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsTypeAliasTypeVariableSymbol;
import com.intellij.lang.ruby.rbs.model.psi.RbsResolveUtil;
import com.intellij.lang.ruby.rbs.psi.RbsUseClauseType;
import com.intellij.lang.ruby.rbs.psi.data.RbsKeywordTypeSignature;
import com.intellij.lang.ruby.rbs.psi.data.RbsQualifiedNameReferenceSignature;
import com.intellij.lang.ruby.rbs.psi.data.RbsQualifiedNameTypeSignature;
import com.intellij.lang.ruby.rbs.psi.data.RbsTypeSignature;
import com.intellij.lang.ruby.rbs.psi.data.RbsTypeSignatureBinding;
import com.intellij.lang.ruby.rbs.psi.data.RbsTypeSignatureSubstitutor;
import com.intellij.lang.ruby.rbs.psi.data.RbsTypeVariableReferenceSignature;
import com.intellij.lang.ruby.rbs.psi.data.RbsUnionTypeSignature;
import com.intellij.lang.ruby.rbs.util.Fqn;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.util.StreamUtil;

public final class RbsTypeSignatureResolver
extends RbsTypeSignatureSubstitutor {
    private final Project myProject;
    private final SearchScope mySearchScope;

    public RbsTypeSignatureResolver(@NotNull Project project, @NotNull SearchScope searchScope) {
        if (project == null) {
            RbsTypeSignatureResolver.$$$reportNull$$$0(0);
        }
        if (searchScope == null) {
            RbsTypeSignatureResolver.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.mySearchScope = searchScope;
    }

    @Override
    public void visitQualifiedNameReferenceSignature(@NotNull RbsQualifiedNameReferenceSignature signature) {
        if (signature == null) {
            RbsTypeSignatureResolver.$$$reportNull$$$0(2);
        }
        String qualifiedName = signature.getQualifiedName();
        List<RbsTypeSignature> typeArgumentSignatures = signature.getTypeArgumentSignatures();
        if (signature.getUseClauses().isEmpty() && signature.getContainerFqn() == Fqn.INVALID || qualifiedName.startsWith("::")) {
            this.mySubstitute = RbsResolveUtil.resolveQualifiedNameInNesting(this.myProject, this.mySearchScope, Fqn.INVALID, qualifiedName).stream().map(it -> this.createQualifiedNameTypeSignature((RbsQualifiedNameSymbol)it, typeArgumentSignatures)).reduce(RbsUnionTypeSignature::of).orElse(RbsKeywordTypeSignature.UNTYPED);
            return;
        }
        Collection<Object> symbols = new ArrayList();
        String name = (String)ObjectUtils.coalesce((Object)StringUtil.substringBefore((String)qualifiedName, (String)"::"), (Object)qualifiedName);
        String suffix = StringUtil.substringAfter((String)qualifiedName, (String)"::");
        for (RbsUseClauseType.Wildcard wildcard : ContainerUtil.reverse(signature.getUseClauses())) {
            symbols = RbsResolveUtil.resolveUseClauseWildcard(this.myProject, this.mySearchScope, wildcard).stream().mapMulti(StreamUtil.select(RbsQualifiedNameSymbol.class, (Class[])new Class[0])).filter(it -> name.equals(it.getName())).toList();
            if (symbols.isEmpty()) continue;
            if (suffix == null) break;
            symbols = symbols.stream().flatMap(it -> RbsQualifiedNameSymbol.find(this.myProject, this.mySearchScope, Fqn.concat(it.getFqn(), suffix, new String[0]))).mapMulti(StreamUtil.select(RbsContainerSymbol.class, (Class[])new Class[]{RbsTypeAliasSymbol.class})).toList();
            break;
        }
        if (symbols.isEmpty()) {
            symbols = RbsResolveUtil.resolveQualifiedNameInNesting(this.myProject, this.mySearchScope, signature.getContainerFqn(), qualifiedName);
        }
        this.mySubstitute = symbols.stream().map(symbol -> this.createQualifiedNameTypeSignature((RbsQualifiedNameSymbol)symbol, typeArgumentSignatures)).reduce(RbsUnionTypeSignature::of).orElse(RbsKeywordTypeSignature.UNTYPED);
    }

    @NotNull
    private RbsQualifiedNameTypeSignature createQualifiedNameTypeSignature(@NotNull RbsQualifiedNameSymbol symbol, @NotNull List<RbsTypeSignature> typeArgumentSignatures) {
        ArrayList<RbsTypeSignature> newTypeArgumentSignatures;
        block5: {
            RbsTypeSignature defaultTypeSignature;
            block4: {
                RbsTypeSignature defaultTypeSignature2;
                if (symbol == null) {
                    RbsTypeSignatureResolver.$$$reportNull$$$0(3);
                }
                if (typeArgumentSignatures == null) {
                    RbsTypeSignatureResolver.$$$reportNull$$$0(4);
                }
                newTypeArgumentSignatures = new ArrayList<RbsTypeSignature>(typeArgumentSignatures);
                if (!(symbol instanceof RbsContainerSymbol)) break block4;
                RbsContainerSymbol containerSymbol = (RbsContainerSymbol)symbol;
                MultiMap<Integer, RbsContainerTypeVariableSymbol> typeVariables = containerSymbol.getTypeVariableSymbols(this.myProject, this.mySearchScope);
                int i = newTypeArgumentSignatures.size();
                while (typeVariables.containsKey((Object)i) && (defaultTypeSignature2 = (RbsTypeSignature)ObjectUtils.doIfNotNull((Object)((RbsContainerTypeVariableSymbol)ContainerUtil.getFirstItem((Collection)typeVariables.get((Object)i))), it -> it.getDefaultType())) != null) {
                    RbsTypeSignatureBinding binding = new RbsTypeSignatureBinding(RbsTypeVariableReferenceSignature.ReferenceType.CONTAINER_VARIABLE, newTypeArgumentSignatures);
                    newTypeArgumentSignatures.add(defaultTypeSignature2.apply(binding).apply(this));
                    ++i;
                }
                break block5;
            }
            if (!(symbol instanceof RbsTypeAliasSymbol)) break block5;
            RbsTypeAliasSymbol typeAliasSymbol = (RbsTypeAliasSymbol)symbol;
            Map<Integer, RbsTypeAliasTypeVariableSymbol> typeVariables = typeAliasSymbol.getTypeVariableSymbols(this.myProject, this.mySearchScope);
            int i = newTypeArgumentSignatures.size();
            while (typeVariables.containsKey(i) && (defaultTypeSignature = typeVariables.get(i).getDefaultType()) != null) {
                RbsTypeSignatureBinding binding = new RbsTypeSignatureBinding(RbsTypeVariableReferenceSignature.ReferenceType.CONTAINER_VARIABLE, newTypeArgumentSignatures);
                newTypeArgumentSignatures.add(defaultTypeSignature.apply(binding).apply(this));
                ++i;
            }
        }
        return new RbsQualifiedNameTypeSignature(symbol.getFqn(), newTypeArgumentSignatures);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeArgumentSignatures";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/ruby/rbs/psi/data/RbsTypeSignatureResolver";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visitQualifiedNameReferenceSignature";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createQualifiedNameTypeSignature";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

