/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.psi.data;

import com.intellij.lang.ruby.rbs.psi.RbsContainerDeclarationElement;
import com.intellij.lang.ruby.rbs.psi.RbsTypeElement;
import com.intellij.lang.ruby.rbs.psi.RbsTypeListOwner;
import com.intellij.lang.ruby.rbs.psi.RbsUseClauseType;
import com.intellij.lang.ruby.rbs.psi.data.RbsTypeSignature;
import com.intellij.lang.ruby.rbs.psi.data.RbsTypeSignatureSerializationUtil;
import com.intellij.lang.ruby.rbs.psi.data.RbsTypeSignatureVisitor;
import com.intellij.lang.ruby.rbs.psi.tree.RbsSerializationUtil;
import com.intellij.lang.ruby.rbs.psi.util.RbsPsiUtil;
import com.intellij.lang.ruby.rbs.util.Fqn;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RbsQualifiedNameReferenceSignature
implements RbsTypeSignature {
    static final int TAG = 8;
    static final RbsTypeSignature.Serializer<RbsQualifiedNameReferenceSignature> SERIALIZER = (signature, dataStream) -> {
        List<RbsUseClauseType.Wildcard> useClauses = signature.getUseClauses();
        dataStream.writeVarInt(useClauses.size());
        for (RbsUseClauseType rbsUseClauseType : useClauses) {
            RbsUseClauseType.serialize(rbsUseClauseType, dataStream);
        }
        Fqn.serialize(signature.myContainerFqn, dataStream);
        dataStream.writeName(signature.myQualifiedName);
        RbsSerializationUtil.serializeList(signature.myTypeArgumentSignatures, dataStream, RbsTypeSignatureSerializationUtil::serialize);
    };
    static final RbsTypeSignature.Deserializer<RbsQualifiedNameReferenceSignature> DESERIALIZER = dataStream -> {
        int size = dataStream.readVarInt();
        ArrayList<RbsUseClauseType.Wildcard> useClauses = new ArrayList<RbsUseClauseType.Wildcard>();
        for (int i = 0; i < size; ++i) {
            ContainerUtil.addIfNotNull(useClauses, (Object)((RbsUseClauseType.Wildcard)ObjectUtils.tryCast((Object)RbsUseClauseType.deserialize(dataStream), RbsUseClauseType.Wildcard.class)));
        }
        Fqn containerFqn = Fqn.deserialize(dataStream);
        String qualifiedName = Objects.requireNonNull(dataStream.readNameString());
        List<RbsTypeSignature> typeArguments = RbsSerializationUtil.deserializeList(dataStream, RbsTypeSignatureSerializationUtil::deserialize);
        return new RbsQualifiedNameReferenceSignature(useClauses, containerFqn, qualifiedName, typeArguments);
    };
    private final List<RbsUseClauseType.Wildcard> myUseClauses;
    private final Fqn myContainerFqn;
    private final String myQualifiedName;
    private final List<RbsTypeSignature> myTypeArgumentSignatures;

    public RbsQualifiedNameReferenceSignature(@NotNull Fqn fqn, @NotNull List<RbsTypeSignature> typeArgumentSignatures) {
        if (fqn == null) {
            RbsQualifiedNameReferenceSignature.$$$reportNull$$$0(0);
        }
        if (typeArgumentSignatures == null) {
            RbsQualifiedNameReferenceSignature.$$$reportNull$$$0(1);
        }
        this(Collections.emptyList(), Fqn.INVALID, fqn.join(), typeArgumentSignatures);
    }

    public RbsQualifiedNameReferenceSignature(@NotNull List<RbsUseClauseType.Wildcard> useClauses, @NotNull Fqn containerFqn, @NotNull String qualifiedName, @NotNull List<RbsTypeSignature> typeArgumentSignatures) {
        if (useClauses == null) {
            RbsQualifiedNameReferenceSignature.$$$reportNull$$$0(2);
        }
        if (containerFqn == null) {
            RbsQualifiedNameReferenceSignature.$$$reportNull$$$0(3);
        }
        if (qualifiedName == null) {
            RbsQualifiedNameReferenceSignature.$$$reportNull$$$0(4);
        }
        if (typeArgumentSignatures == null) {
            RbsQualifiedNameReferenceSignature.$$$reportNull$$$0(5);
        }
        this.myUseClauses = List.copyOf(useClauses);
        this.myContainerFqn = containerFqn;
        this.myQualifiedName = qualifiedName;
        this.myTypeArgumentSignatures = List.copyOf(typeArgumentSignatures);
    }

    @Override
    public void accept(@NotNull RbsTypeSignatureVisitor visitor) {
        if (visitor == null) {
            RbsQualifiedNameReferenceSignature.$$$reportNull$$$0(6);
        }
        visitor.visitQualifiedNameReferenceSignature(this);
    }

    @Override
    @NotNull
    public RbsTypeSignature apply(@NotNull Function<RbsTypeSignature, RbsTypeSignature> fun) {
        if (fun == null) {
            RbsQualifiedNameReferenceSignature.$$$reportNull$$$0(7);
        }
        RbsTypeSignature rbsTypeSignature = fun.apply(new RbsQualifiedNameReferenceSignature(this.myUseClauses, this.myContainerFqn, this.myQualifiedName, ContainerUtil.map(this.myTypeArgumentSignatures, it -> it.apply(fun))));
        if (rbsTypeSignature == null) {
            RbsQualifiedNameReferenceSignature.$$$reportNull$$$0(8);
        }
        return rbsTypeSignature;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RbsQualifiedNameReferenceSignature other = (RbsQualifiedNameReferenceSignature)obj;
        return this.myUseClauses.equals(other.myUseClauses) && this.myContainerFqn.equals(other.myContainerFqn) && this.myQualifiedName.equals(other.myQualifiedName) && this.myTypeArgumentSignatures.equals(other.myTypeArgumentSignatures);
    }

    @NotNull
    public Fqn getContainerFqn() {
        Fqn fqn = this.myContainerFqn;
        if (fqn == null) {
            RbsQualifiedNameReferenceSignature.$$$reportNull$$$0(9);
        }
        return fqn;
    }

    @NotNull
    public String getQualifiedName() {
        String string = this.myQualifiedName;
        if (string == null) {
            RbsQualifiedNameReferenceSignature.$$$reportNull$$$0(10);
        }
        return string;
    }

    @Override
    public int getTag() {
        return 8;
    }

    @NotNull
    public List<RbsTypeSignature> getTypeArgumentSignatures() {
        List<RbsTypeSignature> list = this.myTypeArgumentSignatures;
        if (list == null) {
            RbsQualifiedNameReferenceSignature.$$$reportNull$$$0(11);
        }
        return list;
    }

    @NotNull
    public List<RbsUseClauseType.Wildcard> getUseClauses() {
        List<RbsUseClauseType.Wildcard> list = this.myUseClauses;
        if (list == null) {
            RbsQualifiedNameReferenceSignature.$$$reportNull$$$0(12);
        }
        return list;
    }

    public int hashCode() {
        int result = this.myUseClauses.hashCode();
        result = 31 * result + this.myContainerFqn.hashCode();
        result = 31 * result + this.myQualifiedName.hashCode();
        result = 31 * result + this.myTypeArgumentSignatures.hashCode();
        return result;
    }

    @NotNull
    public String toString() {
        if (this.myTypeArgumentSignatures.isEmpty()) {
            String string = this.myQualifiedName;
            if (string == null) {
                RbsQualifiedNameReferenceSignature.$$$reportNull$$$0(13);
            }
            return string;
        }
        String string = String.format("%s[%s]", this.myQualifiedName, StringUtil.join(this.myTypeArgumentSignatures, (String)", "));
        if (string == null) {
            RbsQualifiedNameReferenceSignature.$$$reportNull$$$0(14);
        }
        return string;
    }

    @NotNull
    public static RbsTypeSignature create(@NotNull PsiElement element, @NotNull String qualifiedName) {
        Fqn containerFqn;
        if (element == null) {
            RbsQualifiedNameReferenceSignature.$$$reportNull$$$0(15);
        }
        if (qualifiedName == null) {
            RbsQualifiedNameReferenceSignature.$$$reportNull$$$0(16);
        }
        ArrayList<RbsUseClauseType.Wildcard> useClauses = new ArrayList<RbsUseClauseType.Wildcard>();
        List typeArgumentSignatures = Collections.emptyList();
        if (element instanceof RbsTypeListOwner) {
            RbsTypeListOwner typeListOwner = (RbsTypeListOwner)element;
            typeArgumentSignatures = ContainerUtil.map(typeListOwner.getTypeListElements(), RbsTypeElement::getTypeSignature);
        }
        String name = (String)ObjectUtils.coalesce((Object)StringUtil.substringBefore((String)qualifiedName, (String)"::"), (Object)qualifiedName);
        String suffix = StringUtil.substringAfter((String)qualifiedName, (String)"::");
        for (RbsUseClauseType type : RbsPsiUtil.getUseClauseTypes(element)) {
            RbsUseClauseType.Import import_;
            RbsUseClauseType.Alias alias;
            if (type instanceof RbsUseClauseType.Alias && name.equals((alias = (RbsUseClauseType.Alias)type).name())) {
                Fqn fqn = suffix != null ? Fqn.concat(alias.fqn(), suffix, new String[0]) : alias.fqn();
                return new RbsQualifiedNameReferenceSignature(fqn, typeArgumentSignatures);
            }
            if (type instanceof RbsUseClauseType.Import && name.equals((import_ = (RbsUseClauseType.Import)type).fqn().split().getName())) {
                Fqn fqn = suffix != null ? Fqn.concat(import_.fqn(), suffix, new String[0]) : import_.fqn();
                return new RbsQualifiedNameReferenceSignature(fqn, typeArgumentSignatures);
            }
            if (!(type instanceof RbsUseClauseType.Wildcard)) continue;
            RbsUseClauseType.Wildcard wildcard = (RbsUseClauseType.Wildcard)type;
            useClauses.add(wildcard);
        }
        RbsContainerDeclarationElement containerDeclaration = (RbsContainerDeclarationElement)PsiTreeUtil.getParentOfType((PsiElement)element, RbsContainerDeclarationElement.class);
        Fqn fqn = containerFqn = containerDeclaration != null ? containerDeclaration.getFqn() : Fqn.INVALID;
        if (useClauses.isEmpty() && containerFqn == Fqn.INVALID || qualifiedName.startsWith("::")) {
            return new RbsQualifiedNameReferenceSignature(Fqn.of(qualifiedName, new String[0]), typeArgumentSignatures);
        }
        return new RbsQualifiedNameReferenceSignature(useClauses, containerFqn, qualifiedName, typeArgumentSignatures);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9, 10, 11, 12, 13, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeArgumentSignatures";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "useClauses";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containerFqn";
                break;
            }
            case 4: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fun";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ruby/rbs/psi/data/RbsQualifiedNameReferenceSignature";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ruby/rbs/psi/data/RbsQualifiedNameReferenceSignature";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "apply";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainerFqn";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedName";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeArgumentSignatures";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getUseClauses";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 9, 10, 11, 12, 13, 14 -> new IllegalStateException(string);
        };
    }
}

