/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.psi;

import com.intellij.lang.ruby.rbs.util.Fqn;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface RbsUseClauseType {
    public int getTag();

    @NotNull
    public static RbsUseClauseType deserialize(@NotNull StubInputStream dataStream) throws IOException {
        if (dataStream == null) {
            RbsUseClauseType.$$$reportNull$$$0(0);
        }
        int tag = dataStream.readVarInt();
        Record record = switch (tag) {
            case 0 -> new Alias(Fqn.deserialize(dataStream), Objects.requireNonNull(dataStream.readNameString()));
            case 1 -> new Import(Fqn.deserialize(dataStream));
            case 2 -> new Wildcard(Fqn.deserialize(dataStream));
            default -> throw new UnsupportedOperationException("Unknown tag: " + tag);
        };
        if (record == null) {
            RbsUseClauseType.$$$reportNull$$$0(1);
        }
        return record;
    }

    public static void serialize(@NotNull RbsUseClauseType clauseType, @NotNull StubOutputStream dataStream) throws IOException {
        if (clauseType == null) {
            RbsUseClauseType.$$$reportNull$$$0(2);
        }
        if (dataStream == null) {
            RbsUseClauseType.$$$reportNull$$$0(3);
        }
        dataStream.writeVarInt(clauseType.getTag());
        if (clauseType instanceof Alias) {
            Alias alias = (Alias)clauseType;
            Fqn.serialize(alias.fqn, dataStream);
            dataStream.writeName(alias.name);
        } else if (clauseType instanceof Import) {
            Import import_ = (Import)clauseType;
            Fqn.serialize(import_.fqn, dataStream);
        } else if (clauseType instanceof Wildcard) {
            Wildcard wildcard = (Wildcard)clauseType;
            Fqn.serialize(wildcard.namespace, dataStream);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStream";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ruby/rbs/psi/RbsUseClauseType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clauseType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ruby/rbs/psi/RbsUseClauseType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "deserialize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    public record Alias(@NotNull Fqn fqn, @NotNull String name) implements RbsUseClauseType
    {
        @NotNull
        private final Fqn fqn;
        @NotNull
        private final String name;
        private static final int TAG = 0;

        public Alias(@NotNull Fqn fqn, @NotNull String name) {
            if (fqn == null) {
                Alias.$$$reportNull$$$0(0);
            }
            if (name == null) {
                Alias.$$$reportNull$$$0(1);
            }
        }

        @Override
        public int getTag() {
            return 0;
        }

        @NotNull
        public Fqn fqn() {
            Fqn fqn = this.fqn;
            if (fqn == null) {
                Alias.$$$reportNull$$$0(2);
            }
            return fqn;
        }

        @NotNull
        public String name() {
            String string = this.name;
            if (string == null) {
                Alias.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fqn";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/ruby/rbs/psi/RbsUseClauseType$Alias";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/ruby/rbs/psi/RbsUseClauseType$Alias";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fqn";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "name";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    public record Import(@NotNull Fqn fqn) implements RbsUseClauseType
    {
        @NotNull
        private final Fqn fqn;
        private static final int TAG = 1;

        public Import(@NotNull Fqn fqn) {
            if (fqn == null) {
                Import.$$$reportNull$$$0(0);
            }
        }

        @Override
        public int getTag() {
            return 1;
        }

        @NotNull
        public Fqn fqn() {
            Fqn fqn = this.fqn;
            if (fqn == null) {
                Import.$$$reportNull$$$0(1);
            }
            return fqn;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fqn";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/ruby/rbs/psi/RbsUseClauseType$Import";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/ruby/rbs/psi/RbsUseClauseType$Import";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fqn";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    public record Wildcard(@NotNull Fqn namespace) implements RbsUseClauseType
    {
        @NotNull
        private final Fqn namespace;
        private static final int TAG = 2;

        public Wildcard(@NotNull Fqn namespace) {
            if (namespace == null) {
                Wildcard.$$$reportNull$$$0(0);
            }
        }

        @Override
        public int getTag() {
            return 2;
        }

        @NotNull
        public Fqn namespace() {
            Fqn fqn = this.namespace;
            if (fqn == null) {
                Wildcard.$$$reportNull$$$0(1);
            }
            return fqn;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "namespace";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/ruby/rbs/psi/RbsUseClauseType$Wildcard";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/ruby/rbs/psi/RbsUseClauseType$Wildcard";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "namespace";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

