/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.psi;

import com.intellij.lang.ruby.rbs.psi.RbsVariance;
import com.intellij.lang.ruby.rbs.psi.data.RbsTypeSignature;
import com.intellij.lang.ruby.rbs.psi.data.RbsTypeSignatureSerializationUtil;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RbsTypeParameter {
    private final String myName;
    private final RbsVariance myVariance;
    private final boolean myIsUnchecked;
    @Nullable
    private final RbsTypeSignature myUpperBound;
    @Nullable
    private final RbsTypeSignature myDefaultType;

    public RbsTypeParameter(@NotNull String name, @NotNull RbsVariance variance, boolean isUnchecked, @Nullable RbsTypeSignature upperBound, @Nullable RbsTypeSignature defaultType) {
        if (name == null) {
            RbsTypeParameter.$$$reportNull$$$0(0);
        }
        if (variance == null) {
            RbsTypeParameter.$$$reportNull$$$0(1);
        }
        this.myName = name;
        this.myVariance = variance;
        this.myIsUnchecked = isUnchecked;
        this.myUpperBound = upperBound;
        this.myDefaultType = defaultType;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RbsTypeParameter other = (RbsTypeParameter)obj;
        return this.myName.equals(other.myName) && this.myVariance == other.myVariance && this.myIsUnchecked == other.myIsUnchecked && Objects.equals(this.myUpperBound, other.myUpperBound) && Objects.equals(this.myDefaultType, other.myDefaultType);
    }

    @Nullable
    public RbsTypeSignature getDefaultType() {
        return this.myDefaultType;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            RbsTypeParameter.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    public RbsTypeSignature getUpperBound() {
        return this.myUpperBound;
    }

    @NotNull
    public RbsVariance getVariance() {
        RbsVariance rbsVariance = this.myVariance;
        if (rbsVariance == null) {
            RbsTypeParameter.$$$reportNull$$$0(3);
        }
        return rbsVariance;
    }

    public boolean isUnchecked() {
        return this.myIsUnchecked;
    }

    public int hashCode() {
        int result = this.myName.hashCode();
        result = 31 * result + this.myVariance.hashCode();
        result = 31 * result + Boolean.hashCode(this.myIsUnchecked);
        result = 31 * result + Objects.hashCode(this.myUpperBound);
        result = 31 * result + Objects.hashCode(this.myDefaultType);
        return result;
    }

    @NotNull
    public String toString() {
        String string = String.format("RbsTypeParameter{myName='%s', myVariance=%s, myIsUnchecked=%s, myUpperBound=%s, myDefaultType=%s}", new Object[]{this.myName, this.myVariance, this.myIsUnchecked, this.myUpperBound, this.myDefaultType});
        if (string == null) {
            RbsTypeParameter.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public static RbsTypeParameter deserialize(@NotNull StubInputStream dataStream) throws IOException {
        if (dataStream == null) {
            RbsTypeParameter.$$$reportNull$$$0(5);
        }
        String name = Objects.requireNonNull(dataStream.readNameString());
        RbsVariance variance = RbsVariance.valueOf(dataStream.readNameString());
        boolean isUnchecked = dataStream.readBoolean();
        Object upperBound = RbsTypeSignatureSerializationUtil.deserializeNullable(dataStream);
        Object defaultType = RbsTypeSignatureSerializationUtil.deserializeNullable(dataStream);
        return new RbsTypeParameter(name, variance, isUnchecked, (RbsTypeSignature)upperBound, (RbsTypeSignature)defaultType);
    }

    public static void serialize(@NotNull RbsTypeParameter typeVariable, @NotNull StubOutputStream dataStream) throws IOException {
        if (typeVariable == null) {
            RbsTypeParameter.$$$reportNull$$$0(6);
        }
        if (dataStream == null) {
            RbsTypeParameter.$$$reportNull$$$0(7);
        }
        dataStream.writeName(typeVariable.myName);
        dataStream.writeName(typeVariable.myVariance.name());
        dataStream.writeBoolean(typeVariable.myIsUnchecked);
        RbsTypeSignatureSerializationUtil.serialize(typeVariable.myUpperBound, dataStream);
        RbsTypeSignatureSerializationUtil.serialize(typeVariable.myDefaultType, dataStream);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variance";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ruby/rbs/psi/RbsTypeParameter";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStream";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeVariable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ruby/rbs/psi/RbsTypeParameter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariance";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4 -> new IllegalStateException(string);
        };
    }
}

