/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.psi;

import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiParser;
import com.intellij.lang.ruby.rbs.psi.RbsElementFactory;
import com.intellij.lang.ruby.rbs.psi.RbsPsiFile;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ruby.rbs.frontback.psi.RbsBnfParser;
import com.intellij.ruby.rbs.frontback.psi.RbsLexerAdapter;
import com.intellij.ruby.rbs.frontback.psi.tree.RbsElementTypes;
import com.intellij.ruby.rbs.frontback.psi.tree.RbsElementTypesGenerated;
import com.intellij.ruby.rbs.frontback.psi.tree.RbsTokenSets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RbsParserDefinition
implements ParserDefinition {
    @NotNull
    public Lexer createLexer(Project project) {
        return new RbsLexerAdapter();
    }

    @NotNull
    public PsiParser createParser(Project project) {
        return new RbsBnfParser();
    }

    @NotNull
    public IFileElementType getFileNodeType() {
        IFileElementType iFileElementType = RbsElementTypes.RBS_FILE;
        if (iFileElementType == null) {
            RbsParserDefinition.$$$reportNull$$$0(0);
        }
        return iFileElementType;
    }

    @NotNull
    public TokenSet getCommentTokens() {
        TokenSet tokenSet = RbsTokenSets.RBS_COMMENTS;
        if (tokenSet == null) {
            RbsParserDefinition.$$$reportNull$$$0(1);
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getStringLiteralElements() {
        TokenSet tokenSet = RbsTokenSets.RBS_LITERALS;
        if (tokenSet == null) {
            RbsParserDefinition.$$$reportNull$$$0(2);
        }
        return tokenSet;
    }

    @NotNull
    public PsiElement createElement(ASTNode node) {
        PsiElement psiElement = RbsElementFactory.createElement(node);
        if (psiElement == null) {
            RbsParserDefinition.$$$reportNull$$$0(3);
        }
        return psiElement;
    }

    @NotNull
    public PsiFile createFile(@NotNull FileViewProvider viewProvider) {
        if (viewProvider == null) {
            RbsParserDefinition.$$$reportNull$$$0(4);
        }
        return new RbsPsiFile(viewProvider);
    }

    @Nullable
    public ASTNode reparseSpace(@NotNull ASTNode originalSpaceNode, @NotNull CharSequence newWhiteSpaceSequence) {
        if (originalSpaceNode == null) {
            RbsParserDefinition.$$$reportNull$$$0(5);
        }
        if (newWhiteSpaceSequence == null) {
            RbsParserDefinition.$$$reportNull$$$0(6);
        }
        return RbsParserDefinition.canReparseSpace(originalSpaceNode, newWhiteSpaceSequence) ? ASTFactory.leaf((IElementType)TokenType.WHITE_SPACE, (CharSequence)newWhiteSpaceSequence) : null;
    }

    private static boolean canReparseSpace(@NotNull ASTNode originalSpaceNode, @NotNull CharSequence newWhiteSpaceSequence) {
        boolean hasNewLines;
        if (originalSpaceNode == null) {
            RbsParserDefinition.$$$reportNull$$$0(7);
        }
        if (newWhiteSpaceSequence == null) {
            RbsParserDefinition.$$$reportNull$$$0(8);
        }
        if (newWhiteSpaceSequence.isEmpty()) {
            return false;
        }
        CharSequence originalText = originalSpaceNode.getChars();
        IElementType prevLeafType = PsiUtilCore.getElementType((ASTNode)TreeUtil.prevLeaf((ASTNode)originalSpaceNode));
        if (prevLeafType == RbsElementTypesGenerated.RBS_LINE_COMMENT) {
            int newNewLines;
            int oldNewLines = StringUtil.countNewLines((CharSequence)originalText);
            return oldNewLines == (newNewLines = StringUtil.countNewLines((CharSequence)newWhiteSpaceSequence)) || oldNewLines > 1 && newNewLines > 1;
        }
        boolean hadNewLines = StringUtil.containsLineBreak((CharSequence)originalText);
        return hadNewLines == (hasNewLines = StringUtil.containsLineBreak((CharSequence)newWhiteSpaceSequence));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 4, 5, 6, 7, 8 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ruby/rbs/psi/RbsParserDefinition";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewProvider";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalSpaceNode";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newWhiteSpaceSequence";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileNodeType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommentTokens";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringLiteralElements";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createElement";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ruby/rbs/psi/RbsParserDefinition";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "reparseSpace";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "canReparseSpace";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 4, 5, 6, 7, 8 -> new IllegalArgumentException(string);
        };
    }
}

