/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.model.rename;

import com.intellij.lang.ruby.rbs.model.api.RbsSymbol;
import com.intellij.lang.ruby.rbs.model.rename.RbsRenameTarget;
import com.intellij.lang.ruby.rbs.model.usages.RbsSearchTarget;
import com.intellij.model.Pointer;
import com.intellij.model.search.SearchRequest;
import com.intellij.openapi.project.Project;
import com.intellij.platform.backend.presentation.TargetPresentation;
import com.intellij.psi.search.SearchScope;
import com.intellij.refactoring.rename.api.ReplaceTextTarget;
import com.intellij.refactoring.rename.api.ReplaceTextTargetContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.model.rename.ReplaceReferenceTarget;

final class RbsDelegatingRenameTarget
implements RbsRenameTarget {
    private final Project myProject;
    private final RbsSearchTarget myDelegate;

    RbsDelegatingRenameTarget(@NotNull Project project, @NotNull RbsSearchTarget delegate) {
        if (project == null) {
            RbsDelegatingRenameTarget.$$$reportNull$$$0(0);
        }
        if (delegate == null) {
            RbsDelegatingRenameTarget.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myDelegate = delegate;
    }

    @NotNull
    public Pointer<RbsDelegatingRenameTarget> createPointer() {
        Project project = this.myProject;
        Pointer pointer = Pointer.delegatingPointer(this.myDelegate.createPointer(), it -> !project.isDisposed() ? new RbsDelegatingRenameTarget(project, (RbsSearchTarget)it) : null);
        if (pointer == null) {
            RbsDelegatingRenameTarget.$$$reportNull$$$0(2);
        }
        return pointer;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RbsDelegatingRenameTarget other = (RbsDelegatingRenameTarget)obj;
        return this.myProject.equals(other.myProject) && this.myDelegate.equals(other.myDelegate);
    }

    @Nullable
    public SearchScope getMaximalSearchScope() {
        return this.myDelegate.getMaximalSearchScope();
    }

    @Override
    @NotNull
    public Collection<? extends SearchRequest> getReferenceSearchRequests() {
        Collection<? extends SearchRequest> collection = this.myDelegate.getReferenceSearchRequests();
        if (collection == null) {
            RbsDelegatingRenameTarget.$$$reportNull$$$0(3);
        }
        return collection;
    }

    @Override
    @NotNull
    public List<ReplaceReferenceTarget> getReferenceTargets() {
        List list = ContainerUtil.map(this.myDelegate.getReferenceTargets(), ReplaceReferenceTarget::new);
        if (list == null) {
            RbsDelegatingRenameTarget.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Override
    @NotNull
    public RbsSymbol getTarget() {
        RbsSymbol rbsSymbol = this.myDelegate.getTarget();
        if (rbsSymbol == null) {
            RbsDelegatingRenameTarget.$$$reportNull$$$0(5);
        }
        return rbsSymbol;
    }

    @NotNull
    public String getTargetName() {
        String string = this.myDelegate.presentation().getPresentableText();
        if (string == null) {
            RbsDelegatingRenameTarget.$$$reportNull$$$0(6);
        }
        return string;
    }

    public int hashCode() {
        return 31 * this.myProject.hashCode() + this.myDelegate.hashCode();
    }

    @NotNull
    public TargetPresentation presentation() {
        TargetPresentation targetPresentation = this.myDelegate.presentation();
        if (targetPresentation == null) {
            RbsDelegatingRenameTarget.$$$reportNull$$$0(7);
        }
        return targetPresentation;
    }

    @NotNull
    public Collection<ReplaceTextTarget> textTargets(@NotNull ReplaceTextTargetContext context) {
        if (context == null) {
            RbsDelegatingRenameTarget.$$$reportNull$$$0(8);
        }
        ArrayList<ReplaceTextTarget> textTargets = new ArrayList<ReplaceTextTarget>();
        String targetName = this.getTargetName();
        for (SearchRequest request : this.myDelegate.getTextSearchRequests()) {
            String searchString = request.getSearchString();
            int index = searchString.lastIndexOf(targetName);
            textTargets.add(new ReplaceTextTarget(request, newName -> searchString.substring(0, index) + searchString.substring(index).replace(targetName, (CharSequence)newName)));
        }
        List<ReplaceTextTarget> list = Collections.unmodifiableList(textTargets);
        if (list == null) {
            RbsDelegatingRenameTarget.$$$reportNull$$$0(9);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 6, 7, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ruby/rbs/model/rename/RbsDelegatingRenameTarget";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ruby/rbs/model/rename/RbsDelegatingRenameTarget";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createPointer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceSearchRequests";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceTargets";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTarget";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "presentation";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "textTargets";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "textTargets";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 6, 7, 9 -> new IllegalStateException(string);
        };
    }
}

