/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.model.psi;

import com.intellij.lang.ruby.rbs.completion.RbsQualifiedNameCompletionTarget;
import com.intellij.lang.ruby.rbs.model.api.RbsContainerSymbol;
import com.intellij.lang.ruby.rbs.model.api.RbsQualifiedNameSymbol;
import com.intellij.lang.ruby.rbs.model.api.RbsTypeVariableSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsClassSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsContainerTypeVariableSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsInterfaceSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsMethodSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsMethodTypeVariableSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsModuleSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsTypeAliasSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsTypeAliasTypeVariableSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsUseClauseAliasSymbol;
import com.intellij.lang.ruby.rbs.psi.RbsContainerDeclarationElement;
import com.intellij.lang.ruby.rbs.psi.RbsMethodType;
import com.intellij.lang.ruby.rbs.psi.RbsPsiFile;
import com.intellij.lang.ruby.rbs.psi.RbsTypeDeclarationElement;
import com.intellij.lang.ruby.rbs.psi.RbsUseClauseElement;
import com.intellij.lang.ruby.rbs.psi.RbsUseClauseType;
import com.intellij.lang.ruby.rbs.psi.RbsUseCls;
import com.intellij.lang.ruby.rbs.psi.index.RbsDeclarationByParentFqnIndex;
import com.intellij.lang.ruby.rbs.util.Fqn;
import com.intellij.lang.ruby.rbs.util.RbsNamingConventionUtils;
import com.intellij.model.Symbol;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.util.StreamUtil;

public final class RbsResolveUtil {
    private RbsResolveUtil() {
    }

    @RequiresReadLock
    @RequiresBackgroundThread(generateAssertion=false)
    @Nullable
    public static RbsMethodSymbol resolveMethodName(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull RbsContainerSymbol containerSymbol, @NotNull String name) {
        if (project == null) {
            RbsResolveUtil.$$$reportNull$$$0(0);
        }
        if (searchScope == null) {
            RbsResolveUtil.$$$reportNull$$$0(1);
        }
        if (containerSymbol == null) {
            RbsResolveUtil.$$$reportNull$$$0(2);
        }
        if (name == null) {
            RbsResolveUtil.$$$reportNull$$$0(3);
        }
        ThreadingAssertions.softAssertReadAccess();
        return containerSymbol.allAncestors(project, searchScope).dropWhile(ancestor -> !ancestor.equals(containerSymbol)).flatMap(ancestor -> ancestor.children(project, searchScope)).mapMulti(StreamUtil.select(RbsMethodSymbol.class, (Class[])new Class[0])).filter(child -> child.getName().equals(name)).findFirst().orElse(null);
    }

    @RequiresReadLock
    @RequiresBackgroundThread(generateAssertion=false)
    @NotNull
    public static Collection<? extends Symbol> resolveQualifiedName(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull Fqn containerFqn, @NotNull String name, @NotNull Set<RbsQualifiedNameCompletionTarget> targets, @NotNull PsiElement invocationPoint) {
        Collection<RbsTypeVariableSymbol> result;
        if (project == null) {
            RbsResolveUtil.$$$reportNull$$$0(4);
        }
        if (searchScope == null) {
            RbsResolveUtil.$$$reportNull$$$0(5);
        }
        if (containerFqn == null) {
            RbsResolveUtil.$$$reportNull$$$0(6);
        }
        if (name == null) {
            RbsResolveUtil.$$$reportNull$$$0(7);
        }
        if (targets == null) {
            RbsResolveUtil.$$$reportNull$$$0(8);
        }
        if (invocationPoint == null) {
            RbsResolveUtil.$$$reportNull$$$0(9);
        }
        ThreadingAssertions.softAssertReadAccess();
        if (targets.contains((Object)RbsQualifiedNameCompletionTarget.TYPE_ALIAS_TYPE_VARIABLE) && RbsNamingConventionUtils.isValidTypeVariableName(name) && !(result = RbsResolveUtil.resolveSimpleNameToTypeAliasTypeVariables(name, invocationPoint)).isEmpty()) {
            Collection<RbsTypeAliasTypeVariableSymbol> collection = result;
            if (collection == null) {
                RbsResolveUtil.$$$reportNull$$$0(10);
            }
            return collection;
        }
        if (targets.contains((Object)RbsQualifiedNameCompletionTarget.METHOD_TYPE_VARIABLE) && RbsNamingConventionUtils.isValidTypeVariableName(name) && !(result = RbsResolveUtil.resolveSimpleNameToMethodTypeVariables(name, invocationPoint)).isEmpty()) {
            Collection<RbsTypeVariableSymbol> collection = result;
            if (collection == null) {
                RbsResolveUtil.$$$reportNull$$$0(11);
            }
            return collection;
        }
        if (targets.contains((Object)RbsQualifiedNameCompletionTarget.CONTAINER_TYPE_VARIABLE) && RbsNamingConventionUtils.isValidTypeVariableName(name) && !(result = RbsResolveUtil.resolveSimpleNameToContainerTypeVariables(name, invocationPoint)).isEmpty()) {
            Collection<RbsTypeVariableSymbol> collection = result;
            if (collection == null) {
                RbsResolveUtil.$$$reportNull$$$0(12);
            }
            return collection;
        }
        return RbsResolveUtil.resolveQualifiedNameInNesting(project, searchScope, containerFqn, name, invocationPoint);
    }

    @RequiresReadLock
    @RequiresBackgroundThread(generateAssertion=false)
    @NotNull
    public static Collection<? extends RbsQualifiedNameSymbol> resolveQualifiedNameInNesting(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull Fqn containerFqn, @NotNull String name) {
        if (project == null) {
            RbsResolveUtil.$$$reportNull$$$0(13);
        }
        if (searchScope == null) {
            RbsResolveUtil.$$$reportNull$$$0(14);
        }
        if (containerFqn == null) {
            RbsResolveUtil.$$$reportNull$$$0(15);
        }
        if (name == null) {
            RbsResolveUtil.$$$reportNull$$$0(16);
        }
        ThreadingAssertions.softAssertReadAccess();
        LinkedHashSet symbols = new LinkedHashSet();
        for (Fqn parent = containerFqn; parent != Fqn.INVALID && symbols.isEmpty(); parent = parent.getParent()) {
            ProgressManager.checkCanceled();
            RbsQualifiedNameSymbol.find(project, searchScope, Fqn.concat(parent, name, new String[0])).mapMulti(StreamUtil.select(RbsContainerSymbol.class, (Class[])new Class[]{RbsTypeAliasSymbol.class})).forEach(symbols::add);
        }
        if (symbols.isEmpty()) {
            RbsQualifiedNameSymbol.find(project, searchScope, Fqn.of(name, new String[0])).mapMulti(StreamUtil.select(RbsContainerSymbol.class, (Class[])new Class[]{RbsTypeAliasSymbol.class})).forEach(symbols::add);
        }
        Set set = Collections.unmodifiableSet(symbols);
        if (set == null) {
            RbsResolveUtil.$$$reportNull$$$0(17);
        }
        return set;
    }

    @RequiresReadLock
    @RequiresBackgroundThread(generateAssertion=false)
    @NotNull
    public static Collection<? extends RbsQualifiedNameSymbol> resolveQualifiedNameInNesting(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull Fqn containerFqn, @NotNull String name, @NotNull PsiElement invocationPoint) {
        Collection<? extends RbsQualifiedNameSymbol> result;
        RbsUseCls it;
        if (project == null) {
            RbsResolveUtil.$$$reportNull$$$0(18);
        }
        if (searchScope == null) {
            RbsResolveUtil.$$$reportNull$$$0(19);
        }
        if (containerFqn == null) {
            RbsResolveUtil.$$$reportNull$$$0(20);
        }
        if (name == null) {
            RbsResolveUtil.$$$reportNull$$$0(21);
        }
        if (invocationPoint == null) {
            RbsResolveUtil.$$$reportNull$$$0(22);
        }
        ThreadingAssertions.softAssertReadAccess();
        RbsUseCls useClause = invocationPoint instanceof RbsUseCls ? (it = (RbsUseCls)invocationPoint) : (RbsUseCls)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)invocationPoint, RbsUseCls.class);
        int index = name.indexOf("::");
        if (useClause == null && index != 0 && !(result = RbsResolveUtil.resolveSimpleNameToUseClause(project, searchScope, index > 0 ? name.substring(0, index) : name, invocationPoint)).isEmpty()) {
            Fqn fqn;
            if (index < 0) {
                Collection<? extends RbsQualifiedNameSymbol> collection = result;
                if (collection == null) {
                    RbsResolveUtil.$$$reportNull$$$0(23);
                }
                return collection;
            }
            RbsQualifiedNameSymbol intermediate = (RbsQualifiedNameSymbol)ContainerUtil.getFirstItem(result);
            if (intermediate instanceof RbsUseClauseAliasSymbol) {
                RbsUseClauseAliasSymbol symbol = (RbsUseClauseAliasSymbol)intermediate;
                fqn = symbol.getTargetFqn();
            } else {
                fqn = intermediate.getFqn();
            }
            Fqn fqn2 = fqn;
            return RbsResolveUtil.resolveQualifiedNameInNesting(project, searchScope, Fqn.INVALID, Fqn.concat(fqn2, name.substring(index + 2), new String[0]).absolute().join(), invocationPoint);
        }
        return RbsResolveUtil.resolveQualifiedNameInNesting(project, searchScope, containerFqn, name);
    }

    @RequiresReadLock
    @RequiresBackgroundThread(generateAssertion=false)
    @NotNull
    public static Collection<RbsContainerTypeVariableSymbol> resolveSimpleNameToContainerTypeVariables(@NotNull String name, @NotNull PsiElement invocationPoint) {
        if (name == null) {
            RbsResolveUtil.$$$reportNull$$$0(24);
        }
        if (invocationPoint == null) {
            RbsResolveUtil.$$$reportNull$$$0(25);
        }
        ThreadingAssertions.softAssertReadAccess();
        RbsContainerDeclarationElement containerDeclaration = (RbsContainerDeclarationElement)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)invocationPoint, RbsContainerDeclarationElement.class);
        if (containerDeclaration == null) {
            Set<RbsContainerTypeVariableSymbol> set = Collections.emptySet();
            if (set == null) {
                RbsResolveUtil.$$$reportNull$$$0(26);
            }
            return set;
        }
        List list = ContainerUtil.filter(containerDeclaration.getTypeVariableSymbols(), it -> it.getName().equals(name));
        if (list == null) {
            RbsResolveUtil.$$$reportNull$$$0(27);
        }
        return list;
    }

    @RequiresReadLock
    @RequiresBackgroundThread(generateAssertion=false)
    @NotNull
    public static Collection<RbsMethodTypeVariableSymbol> resolveSimpleNameToMethodTypeVariables(@NotNull String name, @NotNull PsiElement invocationPoint) {
        if (name == null) {
            RbsResolveUtil.$$$reportNull$$$0(28);
        }
        if (invocationPoint == null) {
            RbsResolveUtil.$$$reportNull$$$0(29);
        }
        ThreadingAssertions.softAssertReadAccess();
        RbsMethodType methodType = (RbsMethodType)PsiTreeUtil.getParentOfType((PsiElement)invocationPoint, RbsMethodType.class);
        if (methodType == null) {
            Set<RbsMethodTypeVariableSymbol> set = Collections.emptySet();
            if (set == null) {
                RbsResolveUtil.$$$reportNull$$$0(30);
            }
            return set;
        }
        List list = ContainerUtil.filter(methodType.getTypeVariableSymbols(), it -> it.getName().equals(name));
        if (list == null) {
            RbsResolveUtil.$$$reportNull$$$0(31);
        }
        return list;
    }

    @RequiresReadLock
    @RequiresBackgroundThread(generateAssertion=false)
    @NotNull
    public static Collection<RbsTypeAliasTypeVariableSymbol> resolveSimpleNameToTypeAliasTypeVariables(@NotNull String name, @NotNull PsiElement invocationPoint) {
        if (name == null) {
            RbsResolveUtil.$$$reportNull$$$0(32);
        }
        if (invocationPoint == null) {
            RbsResolveUtil.$$$reportNull$$$0(33);
        }
        ThreadingAssertions.softAssertReadAccess();
        RbsTypeDeclarationElement typeAliasDeclaration = (RbsTypeDeclarationElement)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)invocationPoint, RbsTypeDeclarationElement.class);
        if (typeAliasDeclaration == null) {
            Set<RbsTypeAliasTypeVariableSymbol> set = Collections.emptySet();
            if (set == null) {
                RbsResolveUtil.$$$reportNull$$$0(34);
            }
            return set;
        }
        List list = ContainerUtil.filter(typeAliasDeclaration.getTypeVariableSymbols(), it -> it.getName().equals(name));
        if (list == null) {
            RbsResolveUtil.$$$reportNull$$$0(35);
        }
        return list;
    }

    @RequiresReadLock
    @RequiresBackgroundThread(generateAssertion=false)
    @NotNull
    public static Collection<? extends RbsQualifiedNameSymbol> resolveSimpleNameToUseClause(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull String name, @NotNull PsiElement invocationPoint) {
        if (project == null) {
            RbsResolveUtil.$$$reportNull$$$0(36);
        }
        if (searchScope == null) {
            RbsResolveUtil.$$$reportNull$$$0(37);
        }
        if (name == null) {
            RbsResolveUtil.$$$reportNull$$$0(38);
        }
        if (invocationPoint == null) {
            RbsResolveUtil.$$$reportNull$$$0(39);
        }
        ThreadingAssertions.softAssertReadAccess();
        RbsPsiFile file = (RbsPsiFile)((Object)ObjectUtils.tryCast((Object)invocationPoint.getContainingFile(), RbsPsiFile.class));
        if (file == null) {
            Set set = Collections.emptySet();
            if (set == null) {
                RbsResolveUtil.$$$reportNull$$$0(40);
            }
            return set;
        }
        for (RbsUseClauseElement useClause : ContainerUtil.reverse(file.getUseClauses())) {
            RbsUseClauseType clauseType = useClause.getClauseType();
            if (clauseType instanceof RbsUseClauseType.Alias) {
                RbsUseClauseType.Alias alias = (RbsUseClauseType.Alias)clauseType;
                if (!alias.name().equals(name)) continue;
                List list = ContainerUtil.createMaybeSingletonList((Object)useClause.getSymbol());
                if (list == null) {
                    RbsResolveUtil.$$$reportNull$$$0(41);
                }
                return list;
            }
            if (clauseType instanceof RbsUseClauseType.Import) {
                RbsUseClauseType.Import import_ = (RbsUseClauseType.Import)clauseType;
                if (!import_.fqn().split().getName().equals(name)) continue;
                List list = RbsQualifiedNameSymbol.find(project, searchScope, import_.fqn()).mapMulti(StreamUtil.select(RbsContainerSymbol.class, (Class[])new Class[]{RbsTypeAliasSymbol.class})).toList();
                if (list == null) {
                    RbsResolveUtil.$$$reportNull$$$0(42);
                }
                return list;
            }
            if (!(clauseType instanceof RbsUseClauseType.Wildcard)) continue;
            RbsUseClauseType.Wildcard wildcard = (RbsUseClauseType.Wildcard)clauseType;
            LinkedHashSet symbols = new LinkedHashSet();
            Fqn namespace = wildcard.namespace();
            RbsDeclarationByParentFqnIndex.processAllValues(project, searchScope, namespace, (type, candidate) -> {
                if (!name.equals(candidate)) {
                    return;
                }
                switch (type) {
                    case CLASS: {
                        symbols.add(new RbsClassSymbol(Fqn.concat(namespace, name, new String[0])));
                        break;
                    }
                    case INTERFACE: {
                        symbols.add(new RbsInterfaceSymbol(Fqn.concat(namespace, name, new String[0])));
                        break;
                    }
                    case MODULE: {
                        symbols.add(new RbsModuleSymbol(Fqn.concat(namespace, name, new String[0])));
                        break;
                    }
                    case TYPE_ALIAS: {
                        symbols.add(new RbsTypeAliasSymbol(Fqn.concat(namespace, name, new String[0])));
                    }
                }
            });
            if (symbols.isEmpty()) continue;
            Set set = Collections.unmodifiableSet(symbols);
            if (set == null) {
                RbsResolveUtil.$$$reportNull$$$0(43);
            }
            return set;
        }
        Set set = Collections.emptySet();
        if (set == null) {
            RbsResolveUtil.$$$reportNull$$$0(44);
        }
        return set;
    }

    @NotNull
    public static Collection<? extends RbsQualifiedNameSymbol> resolveUseClauseWildcard(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull RbsUseClauseType.Wildcard wildcard) {
        if (project == null) {
            RbsResolveUtil.$$$reportNull$$$0(45);
        }
        if (searchScope == null) {
            RbsResolveUtil.$$$reportNull$$$0(46);
        }
        if (wildcard == null) {
            RbsResolveUtil.$$$reportNull$$$0(47);
        }
        LinkedHashSet targets = new LinkedHashSet();
        Fqn namespace = wildcard.namespace();
        if (namespace == Fqn.INVALID) {
            List list = Collections.emptyList();
            if (list == null) {
                RbsResolveUtil.$$$reportNull$$$0(48);
            }
            return list;
        }
        RbsDeclarationByParentFqnIndex.processAllValues(project, searchScope, namespace, (type, name) -> {
            switch (type) {
                case CLASS: {
                    targets.add(new RbsClassSymbol(Fqn.concat(namespace, name, new String[0])));
                    break;
                }
                case INTERFACE: {
                    targets.add(new RbsInterfaceSymbol(Fqn.concat(namespace, name, new String[0])));
                    break;
                }
                case MODULE: {
                    targets.add(new RbsModuleSymbol(Fqn.concat(namespace, name, new String[0])));
                    break;
                }
                case TYPE_ALIAS: {
                    targets.add(new RbsTypeAliasSymbol(Fqn.concat(namespace, name, new String[0])));
                }
            }
        });
        Set set = Collections.unmodifiableSet(targets);
        if (set == null) {
            RbsResolveUtil.$$$reportNull$$$0(49);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 11, 12, 17, 23, 26, 27, 30, 31, 34, 35, 40, 41, 42, 43, 44, 48, 49 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 14: 
            case 19: 
            case 37: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containerSymbol";
                break;
            }
            case 3: 
            case 7: 
            case 16: 
            case 21: 
            case 24: 
            case 28: 
            case 32: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: 
            case 15: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containerFqn";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targets";
                break;
            }
            case 9: 
            case 22: 
            case 25: 
            case 29: 
            case 33: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "invocationPoint";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 17: 
            case 23: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 34: 
            case 35: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 48: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ruby/rbs/model/psi/RbsResolveUtil";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wildcard";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ruby/rbs/model/psi/RbsResolveUtil";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveQualifiedName";
                break;
            }
            case 17: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveQualifiedNameInNesting";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveSimpleNameToContainerTypeVariables";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveSimpleNameToMethodTypeVariables";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveSimpleNameToTypeAliasTypeVariables";
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveSimpleNameToUseClause";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveUseClauseWildcard";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolveMethodName";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "resolveQualifiedName";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 17: 
            case 23: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 34: 
            case 35: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 48: 
            case 49: {
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "resolveQualifiedNameInNesting";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "resolveSimpleNameToContainerTypeVariables";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "resolveSimpleNameToMethodTypeVariables";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "resolveSimpleNameToTypeAliasTypeVariables";
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "resolveSimpleNameToUseClause";
                break;
            }
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "resolveUseClauseWildcard";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 11, 12, 17, 23, 26, 27, 30, 31, 34, 35, 40, 41, 42, 43, 44, 48, 49 -> new IllegalStateException(string);
        };
    }
}

