/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.model.psi;

import com.intellij.find.usages.api.PsiUsage;
import com.intellij.lang.ruby.rbs.completion.RbsQualifiedNameCompletionTarget;
import com.intellij.lang.ruby.rbs.model.api.RbsQualifiedNameSymbol;
import com.intellij.lang.ruby.rbs.model.api.RbsTypeVariableSymbol;
import com.intellij.lang.ruby.rbs.model.hierarchy.RbsContainerSymbolUtil;
import com.intellij.lang.ruby.rbs.model.psi.RbsPsiSymbolReferenceBase;
import com.intellij.lang.ruby.rbs.model.psi.RbsResolveUtil;
import com.intellij.lang.ruby.rbs.model.usages.RbsUsageTypes;
import com.intellij.lang.ruby.rbs.psi.RbsContainerDeclarationElement;
import com.intellij.lang.ruby.rbs.psi.RbsNamespace;
import com.intellij.lang.ruby.rbs.util.Fqn;
import com.intellij.model.Symbol;
import com.intellij.model.psi.PsiSymbolReference;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.CharFilter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.usages.impl.rules.UsageType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.model.usages.PsiUsageFactory;

public final class RbsQualifiedNameSymbolReference
extends RbsPsiSymbolReferenceBase<PsiElement> {
    private final PsiUsage myUsage;
    private final Fqn myContainerFqn;
    private final String myQualifiedName;
    private final EnumSet<RbsQualifiedNameCompletionTarget> myCompletionTargets;

    private RbsQualifiedNameSymbolReference(@NotNull PsiElement element, @NotNull TextRange rangeInElement, @NotNull UsageType usageType, @NotNull Fqn containerFqn, @NotNull String qualifiedName, @NotNull EnumSet<RbsQualifiedNameCompletionTarget> completionTargets) {
        if (element == null) {
            RbsQualifiedNameSymbolReference.$$$reportNull$$$0(0);
        }
        if (rangeInElement == null) {
            RbsQualifiedNameSymbolReference.$$$reportNull$$$0(1);
        }
        if (usageType == null) {
            RbsQualifiedNameSymbolReference.$$$reportNull$$$0(2);
        }
        if (containerFqn == null) {
            RbsQualifiedNameSymbolReference.$$$reportNull$$$0(3);
        }
        if (qualifiedName == null) {
            RbsQualifiedNameSymbolReference.$$$reportNull$$$0(4);
        }
        if (completionTargets == null) {
            RbsQualifiedNameSymbolReference.$$$reportNull$$$0(5);
        }
        super(element, rangeInElement);
        this.myUsage = PsiUsageFactory.classifiedUsage((PsiSymbolReference)this, (UsageType)usageType);
        this.myContainerFqn = containerFqn;
        this.myQualifiedName = qualifiedName;
        this.myCompletionTargets = completionTargets;
    }

    @NotNull
    public EnumSet<RbsQualifiedNameCompletionTarget> getCompletionTargets() {
        EnumSet<RbsQualifiedNameCompletionTarget> enumSet = this.myCompletionTargets;
        if (enumSet == null) {
            RbsQualifiedNameSymbolReference.$$$reportNull$$$0(6);
        }
        return enumSet;
    }

    @NotNull
    public Fqn getContainerFqn() {
        Fqn fqn = this.myContainerFqn;
        if (fqn == null) {
            RbsQualifiedNameSymbolReference.$$$reportNull$$$0(7);
        }
        return fqn;
    }

    @NotNull
    public String getQualifiedName() {
        String string = this.myQualifiedName;
        if (string == null) {
            RbsQualifiedNameSymbolReference.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public PsiUsage getUsage() {
        PsiUsage psiUsage = this.myUsage;
        if (psiUsage == null) {
            RbsQualifiedNameSymbolReference.$$$reportNull$$$0(9);
        }
        return psiUsage;
    }

    public boolean resolvesTo(@NotNull Symbol target) {
        if (target == null) {
            RbsQualifiedNameSymbolReference.$$$reportNull$$$0(10);
        }
        if (target instanceof RbsTypeVariableSymbol) {
            RbsTypeVariableSymbol typeVariableSymbol = (RbsTypeVariableSymbol)target;
            return typeVariableSymbol.getName().equals(this.myQualifiedName) && super.resolvesTo(target);
        }
        if (target instanceof RbsQualifiedNameSymbol) {
            RbsQualifiedNameSymbol qualifiedNameSymbol = (RbsQualifiedNameSymbol)target;
            return qualifiedNameSymbol.getFqn().join().endsWith(StringUtil.trimStart((String)this.myQualifiedName, (String)"::")) && super.resolvesTo(target);
        }
        return false;
    }

    @NotNull
    public Collection<? extends Symbol> resolveReference(boolean followAliases) {
        Collection result = this.resolveReference();
        if (!followAliases) {
            Collection collection = result;
            if (collection == null) {
                RbsQualifiedNameSymbolReference.$$$reportNull$$$0(11);
            }
            return collection;
        }
        List<? super Symbol> list = result.stream().mapMulti(RbsContainerSymbolUtil.followAliases(this.myProject, this.mySearchScope)).toList();
        if (list == null) {
            RbsQualifiedNameSymbolReference.$$$reportNull$$$0(12);
        }
        return list;
    }

    @NotNull
    protected Collection<? extends Symbol> resolveReferenceImpl() {
        Collection<? extends Symbol> collection = RbsResolveUtil.resolveQualifiedName(this.myProject, this.mySearchScope, this.myContainerFqn, this.myQualifiedName, this.myCompletionTargets, this.myElement);
        if (collection == null) {
            RbsQualifiedNameSymbolReference.$$$reportNull$$$0(13);
        }
        return collection;
    }

    @NotNull
    public static List<RbsQualifiedNameSymbolReference> createReferencesFor(@NotNull PsiElement declaringElement, @NotNull PsiElement nameElement, @NotNull UsageType usageType, @NotNull EnumSet<RbsQualifiedNameCompletionTarget> completionTargets) {
        RbsContainerDeclarationElement containerDeclaration;
        if (declaringElement == null) {
            RbsQualifiedNameSymbolReference.$$$reportNull$$$0(14);
        }
        if (nameElement == null) {
            RbsQualifiedNameSymbolReference.$$$reportNull$$$0(15);
        }
        if (usageType == null) {
            RbsQualifiedNameSymbolReference.$$$reportNull$$$0(16);
        }
        if (completionTargets == null) {
            RbsQualifiedNameSymbolReference.$$$reportNull$$$0(17);
        }
        Fqn containerFqn = (containerDeclaration = (RbsContainerDeclarationElement)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)declaringElement, RbsContainerDeclarationElement.class)) != null ? containerDeclaration.getFqn() : Fqn.INVALID;
        return RbsQualifiedNameSymbolReference.createReferencesFor(declaringElement, nameElement, usageType, containerFqn, completionTargets);
    }

    @NotNull
    public static List<RbsQualifiedNameSymbolReference> createReferencesFor(@NotNull PsiElement declaringElement, @NotNull PsiElement nameElement, @NotNull UsageType usageType, @NotNull Fqn containerFqn, @NotNull EnumSet<RbsQualifiedNameCompletionTarget> completionTargets) {
        String qualifiedName;
        TextRange textRange;
        String text;
        if (declaringElement == null) {
            RbsQualifiedNameSymbolReference.$$$reportNull$$$0(18);
        }
        if (nameElement == null) {
            RbsQualifiedNameSymbolReference.$$$reportNull$$$0(19);
        }
        if (usageType == null) {
            RbsQualifiedNameSymbolReference.$$$reportNull$$$0(20);
        }
        if (containerFqn == null) {
            RbsQualifiedNameSymbolReference.$$$reportNull$$$0(21);
        }
        if (completionTargets == null) {
            RbsQualifiedNameSymbolReference.$$$reportNull$$$0(22);
        }
        if ((text = StringUtil.trimEnd((String)nameElement.getText(), (String)"::")).isEmpty()) {
            List<RbsQualifiedNameSymbolReference> list = Collections.emptyList();
            if (list == null) {
                RbsQualifiedNameSymbolReference.$$$reportNull$$$0(23);
            }
            return list;
        }
        int offset = nameElement.getTextOffset() - declaringElement.getTextOffset();
        int startIndex = text.startsWith("::") ? 2 : 0;
        startIndex += StringUtil.findFirst((CharSequence)text.substring(startIndex), (CharFilter)CharFilter.NOT_WHITESPACE_FILTER);
        int endIndex = text.indexOf("::", startIndex += text.charAt(startIndex) == '_' ? 1 : 0);
        ArrayList<RbsQualifiedNameSymbolReference> references = new ArrayList<RbsQualifiedNameSymbolReference>();
        while (endIndex > startIndex) {
            textRange = TextRange.create((int)(offset + startIndex), (int)(offset + endIndex));
            qualifiedName = StringUtil.strip((String)(endIndex >= 0 ? text.substring(0, endIndex) : text), (CharFilter)CharFilter.NOT_WHITESPACE_FILTER);
            references.add(RbsQualifiedNameSymbolReference.createReference(declaringElement, nameElement, textRange, RbsUsageTypes.USAGE_TYPE_NESTED_CONSTANT_ACCESS, containerFqn, qualifiedName, EnumSet.noneOf(RbsQualifiedNameCompletionTarget.class)));
            startIndex = endIndex + 2;
            startIndex += StringUtil.findFirst((CharSequence)text.substring(startIndex), (CharFilter)CharFilter.NOT_WHITESPACE_FILTER);
            endIndex = text.indexOf("::", startIndex += text.charAt(startIndex) == '_' ? 1 : 0);
        }
        textRange = TextRange.create((int)(offset + startIndex), (int)(offset + text.length()));
        qualifiedName = StringUtil.strip((String)text, (CharFilter)CharFilter.NOT_WHITESPACE_FILTER);
        references.add(RbsQualifiedNameSymbolReference.createReference(declaringElement, nameElement, textRange, usageType, containerFqn, qualifiedName, completionTargets));
        ArrayList<RbsQualifiedNameSymbolReference> arrayList = references;
        if (arrayList == null) {
            RbsQualifiedNameSymbolReference.$$$reportNull$$$0(24);
        }
        return arrayList;
    }

    @NotNull
    private static RbsQualifiedNameSymbolReference createReference(@NotNull PsiElement declaringElement, @NotNull PsiElement nameElement, @NotNull TextRange textRange, @NotNull UsageType usageType, @NotNull Fqn containerFqn, @NotNull String qualifiedName, @NotNull EnumSet<RbsQualifiedNameCompletionTarget> completionTargets) {
        if (declaringElement == null) {
            RbsQualifiedNameSymbolReference.$$$reportNull$$$0(25);
        }
        if (nameElement == null) {
            RbsQualifiedNameSymbolReference.$$$reportNull$$$0(26);
        }
        if (textRange == null) {
            RbsQualifiedNameSymbolReference.$$$reportNull$$$0(27);
        }
        if (usageType == null) {
            RbsQualifiedNameSymbolReference.$$$reportNull$$$0(28);
        }
        if (containerFqn == null) {
            RbsQualifiedNameSymbolReference.$$$reportNull$$$0(29);
        }
        if (qualifiedName == null) {
            RbsQualifiedNameSymbolReference.$$$reportNull$$$0(30);
        }
        if (completionTargets == null) {
            RbsQualifiedNameSymbolReference.$$$reportNull$$$0(31);
        }
        if (nameElement instanceof RbsNamespace && containerFqn != Fqn.INVALID) {
            return new RbsQualifiedNameSymbolReference(declaringElement, textRange, usageType, Fqn.INVALID, Fqn.concat(containerFqn, qualifiedName, new String[0]).join(), completionTargets);
        }
        return new RbsQualifiedNameSymbolReference(declaringElement, textRange, usageType, containerFqn, qualifiedName, completionTargets);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 8, 9, 11, 12, 13, 23, 24 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeInElement";
                break;
            }
            case 2: 
            case 16: 
            case 20: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageType";
                break;
            }
            case 3: 
            case 21: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containerFqn";
                break;
            }
            case 4: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 5: 
            case 17: 
            case 22: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "completionTargets";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ruby/rbs/model/psi/RbsQualifiedNameSymbolReference";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 14: 
            case 18: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaringElement";
                break;
            }
            case 15: 
            case 19: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameElement";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ruby/rbs/model/psi/RbsQualifiedNameSymbolReference";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompletionTargets";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainerFqn";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getUsage";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveReference";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveReferenceImpl";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "createReferencesFor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 23: 
            case 24: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "resolvesTo";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createReferencesFor";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "createReference";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 8, 9, 11, 12, 13, 23, 24 -> new IllegalStateException(string);
        };
    }
}

