/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.model.impl;

import com.github.benmanes.caffeine.cache.Cache;
import com.intellij.lang.ruby.rbs.model.api.RbsQualifiedNameSymbol;
import com.intellij.lang.ruby.rbs.model.cache.RbsSymbolsCache;
import com.intellij.lang.ruby.rbs.model.impl.RbsTypeAliasTypeVariableSymbol;
import com.intellij.lang.ruby.rbs.model.psi.RbsPsiSymbolDeclarationSearcher;
import com.intellij.lang.ruby.rbs.psi.RbsTypeDeclaration;
import com.intellij.lang.ruby.rbs.psi.RbsTypeDeclarationElement;
import com.intellij.lang.ruby.rbs.psi.data.RbsKeywordTypeSignature;
import com.intellij.lang.ruby.rbs.psi.data.RbsTypeSignature;
import com.intellij.lang.ruby.rbs.psi.data.RbsUnionTypeSignature;
import com.intellij.lang.ruby.rbs.psi.index.RbsDeclarationFqnIndex;
import com.intellij.lang.ruby.rbs.psi.index.RbsTypeDeclarationFqnIndex;
import com.intellij.lang.ruby.rbs.util.Fqn;
import com.intellij.model.Pointer;
import com.intellij.model.Symbol;
import com.intellij.model.psi.PsiSymbolDeclaration;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.ruby.rbs.frontback.RbsBundle;
import com.intellij.ruby.rbs.frontback.RbsIcons;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.plugins.ruby.model.navigation.NavigatableSymbol;
import org.jetbrains.plugins.ruby.model.navigation.NavigationTarget;
import org.jetbrains.plugins.ruby.model.presentation.SymbolPresentation;
import org.jetbrains.plugins.ruby.model.psi.NavigatablePsiSymbolDeclaration;
import org.jetbrains.plugins.ruby.util.StreamUtil;

public final class RbsTypeAliasSymbol
implements RbsQualifiedNameSymbol,
NavigatableSymbol {
    private final Fqn myFqn;

    public RbsTypeAliasSymbol(@NotNull Fqn fqn) {
        if (fqn == null) {
            RbsTypeAliasSymbol.$$$reportNull$$$0(0);
        }
        this.myFqn = fqn.normalize();
    }

    @NotNull
    public Pointer<RbsTypeAliasSymbol> createPointer() {
        Pointer pointer = Pointer.hardPointer((Object)this);
        if (pointer == null) {
            RbsTypeAliasSymbol.$$$reportNull$$$0(1);
        }
        return pointer;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.myFqn.isEquivalentTo(((RbsTypeAliasSymbol)obj).myFqn);
    }

    @Override
    @NotNull
    public Fqn getFqn() {
        Fqn fqn = this.myFqn;
        if (fqn == null) {
            RbsTypeAliasSymbol.$$$reportNull$$$0(2);
        }
        return fqn;
    }

    @NotNull
    public Collection<? extends NavigationTarget> getNavigationTargets(@NotNull Project project) {
        if (project == null) {
            RbsTypeAliasSymbol.$$$reportNull$$$0(3);
        }
        GlobalSearchScope maximalSearchScope = GlobalSearchScope.allScope((Project)project);
        List<NavigationTarget> list = RbsPsiSymbolDeclarationSearcher.getDeclarations(project, (SearchScope)maximalSearchScope, this).stream().map(NavigatablePsiSymbolDeclaration::getNavigationTarget).sorted().toList();
        if (list == null) {
            RbsTypeAliasSymbol.$$$reportNull$$$0(4);
        }
        return list;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NotNull
    public SymbolPresentation getPresentation() {
        String name = this.getName();
        @Nls Supplier shortDescriptionSupplier = RbsBundle.messagePointer((String)"rbs.model.type.alias.shortDescription", (Object[])new Object[]{name});
        Fqn fqn = this.myFqn.split();
        if (fqn.getParent() == Fqn.INVALID) {
            return new SymbolPresentation(RbsIcons.RBS_TYPE_ALIAS_ICON, name, shortDescriptionSupplier);
        }
        @Nls Supplier longDescriptionSupplier = RbsBundle.messagePointer((String)"rbs.model.type.alias.longDescription", (Object[])new Object[]{name, fqn.getParent().join()});
        return new SymbolPresentation(RbsIcons.RBS_TYPE_ALIAS_ICON, name, shortDescriptionSupplier, longDescriptionSupplier);
    }

    @RequiresBackgroundThread(generateAssertion=false)
    @NotNull
    public RbsTypeSignature getTypeSignature(@NotNull Project project, @NotNull SearchScope searchScope) {
        if (project == null) {
            RbsTypeAliasSymbol.$$$reportNull$$$0(5);
        }
        if (searchScope == null) {
            RbsTypeAliasSymbol.$$$reportNull$$$0(6);
        }
        RbsTypeSignature rbsTypeSignature = (RbsTypeSignature)RbsSymbolsCache.getInstance(project, searchScope).getTypeSignatures().get((Object)this, __ -> this.getTypeSignatureImpl(project, searchScope));
        if (rbsTypeSignature == null) {
            RbsTypeAliasSymbol.$$$reportNull$$$0(7);
        }
        return rbsTypeSignature;
    }

    @RequiresBackgroundThread(generateAssertion=false)
    public @Unmodifiable @NotNull Map<Integer, RbsTypeAliasTypeVariableSymbol> getTypeVariableSymbols(@NotNull Project project, @NotNull SearchScope searchScope) {
        Cache<Symbol, Map<Integer, Pointer<RbsTypeAliasTypeVariableSymbol>>> cache;
        Map cachedTypeVariablePointers;
        if (project == null) {
            RbsTypeAliasSymbol.$$$reportNull$$$0(8);
        }
        if (searchScope == null) {
            RbsTypeAliasSymbol.$$$reportNull$$$0(9);
        }
        if ((cachedTypeVariablePointers = (Map)(cache = RbsSymbolsCache.getInstance(project, searchScope).getTypeAliasTypeVariablePointers()).getIfPresent((Object)this)) != null) {
            HashMap<Integer, RbsTypeAliasTypeVariableSymbol> cachedTypeVariableSymbols = new HashMap<Integer, RbsTypeAliasTypeVariableSymbol>();
            for (Map.Entry entry : cachedTypeVariablePointers.entrySet()) {
                RbsTypeAliasTypeVariableSymbol candidate = (RbsTypeAliasTypeVariableSymbol)((Pointer)entry.getValue()).dereference();
                if (candidate == null) continue;
                cachedTypeVariableSymbols.put((Integer)entry.getKey(), candidate);
            }
            if (cachedTypeVariableSymbols.size() == cachedTypeVariablePointers.size()) {
                Map<Integer, RbsTypeAliasTypeVariableSymbol> map = Collections.unmodifiableMap(cachedTypeVariableSymbols);
                if (map == null) {
                    RbsTypeAliasSymbol.$$$reportNull$$$0(10);
                }
                return map;
            }
            cache.invalidate((Object)this);
        }
        Map<Integer, RbsTypeAliasTypeVariableSymbol> typeVariableSymbols = this.getTypeVariableSymbolsImpl(project, searchScope);
        HashMap typeVariablePointers = new HashMap();
        typeVariableSymbols.forEach((key, value) -> typeVariablePointers.put(key, value.createPointer()));
        cache.put((Object)this, typeVariablePointers);
        Map<Integer, RbsTypeAliasTypeVariableSymbol> map = typeVariableSymbols;
        if (map == null) {
            RbsTypeAliasSymbol.$$$reportNull$$$0(11);
        }
        return map;
    }

    public int hashCode() {
        return this.myFqn.hashCode();
    }

    @NotNull
    public String toString() {
        String string = String.format("RbsTypeAliasSymbol{myFqn=%s}", this.myFqn);
        if (string == null) {
            RbsTypeAliasSymbol.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    private RbsTypeSignature getTypeSignatureImpl(@NotNull Project project, @NotNull SearchScope searchScope) {
        if (project == null) {
            RbsTypeAliasSymbol.$$$reportNull$$$0(13);
        }
        if (searchScope == null) {
            RbsTypeAliasSymbol.$$$reportNull$$$0(14);
        }
        Collection elements = RbsTypeDeclarationFqnIndex.getInstance().getElements(project, searchScope, this.myFqn);
        RbsTypeSignature rbsTypeSignature = RbsUnionTypeSignature.of(ContainerUtil.mapNotNull(elements, RbsTypeDeclaration::getTypeSignature)).orElse(RbsKeywordTypeSignature.UNTYPED);
        if (rbsTypeSignature == null) {
            RbsTypeAliasSymbol.$$$reportNull$$$0(15);
        }
        return rbsTypeSignature;
    }

    private @Unmodifiable @NotNull Map<Integer, RbsTypeAliasTypeVariableSymbol> getTypeVariableSymbolsImpl(@NotNull Project project, @NotNull SearchScope searchScope) {
        RbsTypeDeclarationElement declaration;
        if (project == null) {
            RbsTypeAliasSymbol.$$$reportNull$$$0(16);
        }
        if (searchScope == null) {
            RbsTypeAliasSymbol.$$$reportNull$$$0(17);
        }
        if ((declaration = RbsPsiSymbolDeclarationSearcher.getDeclarations(project, searchScope, this).stream().map(PsiSymbolDeclaration::getDeclaringElement).mapMulti(StreamUtil.select(RbsTypeDeclarationElement.class, (Class[])new Class[0])).collect(Collectors.collectingAndThen(Collectors.toList(), ContainerUtil::getOnlyItem))) == null) {
            Map<Integer, RbsTypeAliasTypeVariableSymbol> map = Collections.emptyMap();
            if (map == null) {
                RbsTypeAliasSymbol.$$$reportNull$$$0(18);
            }
            return map;
        }
        Map map = ContainerUtil.map2Map(declaration.getTypeVariableSymbols(), it -> new Pair((Object)it.getTypeVariableIndex(), it));
        if (map == null) {
            RbsTypeAliasSymbol.$$$reportNull$$$0(19);
        }
        return map;
    }

    @RequiresReadLock
    @RequiresBackgroundThread(generateAssertion=false)
    @NotNull
    public static Optional<RbsTypeAliasSymbol> find(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull Fqn fqn) {
        if (project == null) {
            RbsTypeAliasSymbol.$$$reportNull$$$0(20);
        }
        if (searchScope == null) {
            RbsTypeAliasSymbol.$$$reportNull$$$0(21);
        }
        if (fqn == null) {
            RbsTypeAliasSymbol.$$$reportNull$$$0(22);
        }
        ThreadingAssertions.softAssertReadAccess();
        if (fqn == Fqn.INVALID) {
            Optional<RbsTypeAliasSymbol> optional = Optional.empty();
            if (optional == null) {
                RbsTypeAliasSymbol.$$$reportNull$$$0(23);
            }
            return optional;
        }
        Cache<@NotNull RbsDeclarationFqnIndex.Type, @NotNull Set<Fqn>> cache = RbsSymbolsCache.getInstance(project, searchScope).getDeclarationFqns();
        boolean isTypeAliasFqn = ((Set)cache.get((Object)RbsDeclarationFqnIndex.Type.TYPE_ALIAS, type -> RbsDeclarationFqnIndex.getAllValues(project, searchScope, type))).contains(fqn.normalize());
        Optional<RbsTypeAliasSymbol> optional = isTypeAliasFqn ? Optional.of(new RbsTypeAliasSymbol(fqn)) : Optional.empty();
        if (optional == null) {
            RbsTypeAliasSymbol.$$$reportNull$$$0(24);
        }
        return optional;
    }

    @RequiresReadLock
    @RequiresBackgroundThread(generateAssertion=false)
    @NotNull
    public static Stream<RbsTypeAliasSymbol> stream(@NotNull Project project, @NotNull SearchScope searchScope) {
        if (project == null) {
            RbsTypeAliasSymbol.$$$reportNull$$$0(25);
        }
        if (searchScope == null) {
            RbsTypeAliasSymbol.$$$reportNull$$$0(26);
        }
        ThreadingAssertions.softAssertReadAccess();
        Stream<RbsTypeAliasSymbol> stream = ((Set)RbsSymbolsCache.getInstance(project, searchScope).getDeclarationFqns().get((Object)RbsDeclarationFqnIndex.Type.TYPE_ALIAS, type -> RbsDeclarationFqnIndex.getAllValues(project, searchScope, type))).stream().map(RbsTypeAliasSymbol::new);
        if (stream == null) {
            RbsTypeAliasSymbol.$$$reportNull$$$0(27);
        }
        return stream;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 4, 7, 10, 11, 12, 15, 18, 19, 23, 24, 27 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 18: 
            case 19: 
            case 23: 
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ruby/rbs/model/impl/RbsTypeAliasSymbol";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 13: 
            case 16: 
            case 20: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 9: 
            case 14: 
            case 17: 
            case 21: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ruby/rbs/model/impl/RbsTypeAliasSymbol";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createPointer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFqn";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigationTargets";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSignature";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeVariableSymbols";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSignatureImpl";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeVariableSymbolsImpl";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "find";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "stream";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 18: 
            case 19: 
            case 23: 
            case 24: 
            case 27: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getNavigationTargets";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getTypeSignature";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getTypeVariableSymbols";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getTypeSignatureImpl";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getTypeVariableSymbolsImpl";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "find";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "stream";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 4, 7, 10, 11, 12, 15, 18, 19, 23, 24, 27 -> new IllegalStateException(string);
        };
    }
}

