/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.model.impl;

import com.github.benmanes.caffeine.cache.Cache;
import com.intellij.lang.ruby.rbs.model.api.RbsContainerSymbol;
import com.intellij.lang.ruby.rbs.model.cache.RbsSymbolsCache;
import com.intellij.lang.ruby.rbs.model.impl.RbsClassSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsModuleSymbol;
import com.intellij.lang.ruby.rbs.util.Fqn;
import com.intellij.lang.ruby.rbs.util.RbsFqns;
import com.intellij.model.Pointer;
import com.intellij.model.Symbol;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.SearchScope;
import com.intellij.ruby.rbs.frontback.RbsBundle;
import com.intellij.ruby.rbs.frontback.RbsIcons;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.model.presentation.SymbolPresentation;

public final class RbsSingletonSymbol
implements RbsContainerSymbol {
    private final RbsContainerSymbol myOriginalSymbol;

    public RbsSingletonSymbol(@NotNull RbsContainerSymbol originalSymbol) {
        if (originalSymbol == null) {
            RbsSingletonSymbol.$$$reportNull$$$0(0);
        }
        this.myOriginalSymbol = originalSymbol;
    }

    @NotNull
    public Pointer<RbsSingletonSymbol> createPointer() {
        Pointer pointer = Pointer.delegatingPointer(this.myOriginalSymbol.createPointer(), RbsSingletonSymbol::new);
        if (pointer == null) {
            RbsSingletonSymbol.$$$reportNull$$$0(1);
        }
        return pointer;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.myOriginalSymbol.equals(((RbsSingletonSymbol)obj).myOriginalSymbol);
    }

    @Override
    @NotNull
    public Fqn getFqn() {
        Fqn fqn = this.myOriginalSymbol.getFqn();
        if (fqn == null) {
            RbsSingletonSymbol.$$$reportNull$$$0(2);
        }
        return fqn;
    }

    @Override
    @NotNull
    public String getFullName() {
        String string = RbsBundle.message((String)"rbs.model.singleton.fullName", (Object[])new Object[0]);
        if (string == null) {
            RbsSingletonSymbol.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    @NotNull
    public String getName() {
        String string = RbsBundle.message((String)"rbs.model.singleton.name", (Object[])new Object[0]);
        if (string == null) {
            RbsSingletonSymbol.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public RbsContainerSymbol getOriginalSymbol() {
        RbsContainerSymbol rbsContainerSymbol = this.myOriginalSymbol;
        if (rbsContainerSymbol == null) {
            RbsSingletonSymbol.$$$reportNull$$$0(5);
        }
        return rbsContainerSymbol;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NotNull
    public SymbolPresentation getPresentation() {
        String name = this.getName();
        @Nls Supplier shortDescriptionSupplier = RbsBundle.messagePointer((String)"rbs.model.singleton.shortDescription", (Object[])new Object[]{name});
        Fqn fqn = this.getFqn().split();
        if (fqn.getParent() == Fqn.INVALID) {
            return new SymbolPresentation(RbsIcons.RBS_CLASS_ICON, name, shortDescriptionSupplier);
        }
        Supplier longDescriptionSupplier = RbsBundle.messagePointer((String)"rbs.model.singleton.longDescription", (Object[])new Object[]{name, fqn.getParent().join()});
        return new SymbolPresentation(RbsIcons.RBS_CLASS_ICON, name, shortDescriptionSupplier, longDescriptionSupplier);
    }

    @RequiresBackgroundThread(generateAssertion=false)
    @Nullable
    public RbsContainerSymbol getSuperclassSymbol(@NotNull Project project, @NotNull SearchScope searchScope) {
        Cache<Symbol, List<RbsContainerSymbol>> cache;
        List cachedSuperclasses;
        if (project == null) {
            RbsSingletonSymbol.$$$reportNull$$$0(6);
        }
        if (searchScope == null) {
            RbsSingletonSymbol.$$$reportNull$$$0(7);
        }
        if ((cachedSuperclasses = (List)(cache = RbsSymbolsCache.getInstance(project, searchScope).getSuperclasses()).getIfPresent((Object)this)) != null) {
            return (RbsContainerSymbol)ContainerUtil.getOnlyItem((Collection)cachedSuperclasses);
        }
        List<RbsContainerSymbol> superclasses = this.getSuperclassSymbols(project, searchScope);
        cache.put((Object)this, superclasses);
        return (RbsContainerSymbol)ContainerUtil.getOnlyItem(superclasses);
    }

    public int hashCode() {
        return this.myOriginalSymbol.hashCode();
    }

    @NotNull
    public String toString() {
        String string = String.format("RbsSingletonSymbol{myOriginalSymbol=%s}", this.myOriginalSymbol);
        if (string == null) {
            RbsSingletonSymbol.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    private List<RbsContainerSymbol> getSuperclassSymbols(@NotNull Project project, @NotNull SearchScope searchScope) {
        if (project == null) {
            RbsSingletonSymbol.$$$reportNull$$$0(9);
        }
        if (searchScope == null) {
            RbsSingletonSymbol.$$$reportNull$$$0(10);
        }
        if (this.getFqn().isEquivalentTo(RbsFqns.BASIC_OBJECT_FQN)) {
            List<RbsContainerSymbol> list = List.of(new RbsClassSymbol(RbsFqns.CLASS_FQN));
            if (list == null) {
                RbsSingletonSymbol.$$$reportNull$$$0(11);
            }
            return list;
        }
        RbsContainerSymbol rbsContainerSymbol = this.myOriginalSymbol;
        if (rbsContainerSymbol instanceof RbsClassSymbol) {
            RbsClassSymbol clazz = (RbsClassSymbol)rbsContainerSymbol;
            RbsClassSymbol originalSuperclassSymbol = clazz.getSuperclassSymbol(project, searchScope);
            if (originalSuperclassSymbol != null) {
                List<RbsContainerSymbol> list = List.of(new RbsSingletonSymbol(originalSuperclassSymbol));
                if (list == null) {
                    RbsSingletonSymbol.$$$reportNull$$$0(12);
                }
                return list;
            }
        } else if (this.myOriginalSymbol instanceof RbsModuleSymbol) {
            List<RbsContainerSymbol> list = List.of(new RbsClassSymbol(RbsFqns.MODULE_FQN));
            if (list == null) {
                RbsSingletonSymbol.$$$reportNull$$$0(13);
            }
            return list;
        }
        List<RbsContainerSymbol> list = Collections.emptyList();
        if (list == null) {
            RbsSingletonSymbol.$$$reportNull$$$0(14);
        }
        return list;
    }

    @RequiresReadLock
    @RequiresBackgroundThread(generateAssertion=false)
    @NotNull
    public static Stream<RbsSingletonSymbol> find(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull Fqn fqn) {
        if (project == null) {
            RbsSingletonSymbol.$$$reportNull$$$0(15);
        }
        if (searchScope == null) {
            RbsSingletonSymbol.$$$reportNull$$$0(16);
        }
        if (fqn == null) {
            RbsSingletonSymbol.$$$reportNull$$$0(17);
        }
        ThreadingAssertions.softAssertReadAccess();
        Stream<RbsSingletonSymbol> stream = Stream.concat(RbsClassSymbol.find(project, searchScope, fqn).stream(), RbsModuleSymbol.find(project, searchScope, fqn).stream()).map(x$0 -> new RbsSingletonSymbol((RbsContainerSymbol)x$0));
        if (stream == null) {
            RbsSingletonSymbol.$$$reportNull$$$0(18);
        }
        return stream;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 8, 11, 12, 13, 14, 18 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalSymbol";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ruby/rbs/model/impl/RbsSingletonSymbol";
                break;
            }
            case 6: 
            case 9: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: 
            case 10: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ruby/rbs/model/impl/RbsSingletonSymbol";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createPointer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFqn";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getOriginalSymbol";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperclassSymbols";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "find";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 18: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getSuperclassSymbol";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getSuperclassSymbols";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "find";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 8, 11, 12, 13, 14, 18 -> new IllegalStateException(string);
        };
    }
}

