/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.model.impl;

import com.intellij.lang.ruby.rbs.model.api.RbsContainerSymbol;
import com.intellij.lang.ruby.rbs.model.api.RbsSyntacticSugarSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsMethodSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsSingletonSymbol;
import com.intellij.lang.ruby.rbs.model.psi.RbsPsiSymbolDeclarationSearcher;
import com.intellij.lang.ruby.rbs.model.psi.RbsResolveUtil;
import com.intellij.lang.ruby.rbs.psi.RbsDeclarationType;
import com.intellij.lang.ruby.rbs.util.Fqn;
import com.intellij.model.Pointer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.ruby.rbs.frontback.RbsBundle;
import com.intellij.ruby.rbs.frontback.RbsIcons;
import com.intellij.ruby.rbs.frontback.psi.RbsVisibility;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.model.navigation.NavigatableSymbol;
import org.jetbrains.plugins.ruby.model.navigation.NavigationTarget;
import org.jetbrains.plugins.ruby.model.presentation.PresentableSymbol;
import org.jetbrains.plugins.ruby.model.presentation.SymbolPresentation;
import org.jetbrains.plugins.ruby.model.psi.NavigatablePsiSymbolDeclaration;
import org.jetbrains.plugins.ruby.ruby.lang.TextUtil;

public final class RbsMethodAliasSymbol
implements RbsSyntacticSugarSymbol,
NavigatableSymbol,
PresentableSymbol {
    private final RbsDeclarationType myDeclarationType;
    private final RbsContainerSymbol myContainer;
    @NlsSafe
    private final String myName;
    @Nullable
    private final String myTargetName;

    public RbsMethodAliasSymbol(@NotNull RbsDeclarationType declarationType, @NotNull RbsContainerSymbol container, @NlsSafe @NotNull String name, @Nullable String targetName) {
        if (declarationType == null) {
            RbsMethodAliasSymbol.$$$reportNull$$$0(0);
        }
        if (container == null) {
            RbsMethodAliasSymbol.$$$reportNull$$$0(1);
        }
        if (name == null) {
            RbsMethodAliasSymbol.$$$reportNull$$$0(2);
        }
        this.myDeclarationType = declarationType;
        this.myContainer = container;
        this.myName = name;
        this.myTargetName = targetName;
    }

    @NotNull
    public Pointer<RbsMethodAliasSymbol> createPointer() {
        Pointer pointer = Pointer.hardPointer((Object)this);
        if (pointer == null) {
            RbsMethodAliasSymbol.$$$reportNull$$$0(3);
        }
        return pointer;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RbsMethodAliasSymbol other = (RbsMethodAliasSymbol)obj;
        return this.myDeclarationType.equals((Object)other.myDeclarationType) && this.myContainer.equals(other.myContainer) && this.myName.equals(other.myName) && Objects.equals(this.myTargetName, other.myTargetName);
    }

    @NotNull
    public Fqn getContainerFqn() {
        Fqn fqn = this.myContainer.getFqn();
        if (fqn == null) {
            RbsMethodAliasSymbol.$$$reportNull$$$0(4);
        }
        return fqn;
    }

    @NotNull
    public RbsContainerSymbol getContainerSymbol() {
        RbsContainerSymbol rbsContainerSymbol = this.myContainer;
        if (rbsContainerSymbol == null) {
            RbsMethodAliasSymbol.$$$reportNull$$$0(5);
        }
        return rbsContainerSymbol;
    }

    @NotNull
    public RbsDeclarationType getDeclarationType() {
        RbsDeclarationType rbsDeclarationType = this.myDeclarationType;
        if (rbsDeclarationType == null) {
            RbsMethodAliasSymbol.$$$reportNull$$$0(6);
        }
        return rbsDeclarationType;
    }

    @NotNull
    public List<RbsMethodSymbol> getDynamicSymbols(@NotNull Project project, @NotNull SearchScope searchScope) {
        if (project == null) {
            RbsMethodAliasSymbol.$$$reportNull$$$0(7);
        }
        if (searchScope == null) {
            RbsMethodAliasSymbol.$$$reportNull$$$0(8);
        }
        RbsMethodSymbol target = this.myDeclarationType == RbsDeclarationType.SINGLETON_DECLARATION && this.myTargetName != null ? RbsResolveUtil.resolveMethodName(project, searchScope, new RbsSingletonSymbol(this.myContainer), this.myTargetName) : (this.myTargetName != null ? RbsResolveUtil.resolveMethodName(project, searchScope, this.myContainer, this.myTargetName) : null);
        RbsVisibility visibility = target != null ? target.getVisibility() : RbsVisibility.PUBLIC_VISIBILITY;
        List<RbsMethodSymbol> list = List.of(new RbsMethodSymbol(visibility, this.myDeclarationType, this.myContainer, this.myName, this));
        if (list == null) {
            RbsMethodAliasSymbol.$$$reportNull$$$0(9);
        }
        return list;
    }

    @NlsSafe
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            RbsMethodAliasSymbol.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    public Collection<? extends NavigationTarget> getNavigationTargets(@NotNull Project project) {
        if (project == null) {
            RbsMethodAliasSymbol.$$$reportNull$$$0(11);
        }
        GlobalSearchScope maximalSearchScope = GlobalSearchScope.allScope((Project)project);
        List<NavigationTarget> list = RbsPsiSymbolDeclarationSearcher.getDeclarations(project, (SearchScope)maximalSearchScope, this).stream().map(NavigatablePsiSymbolDeclaration::getNavigationTarget).sorted().toList();
        if (list == null) {
            RbsMethodAliasSymbol.$$$reportNull$$$0(12);
        }
        return list;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NotNull
    public SymbolPresentation getPresentation() {
        @Nls Supplier shortDescriptionSupplier = RbsBundle.messagePointer((String)"rbs.model.method.alias.shortDescription", (Object[])new Object[]{this.myName});
        Supplier<@Nls String> longDescriptionSupplier = () -> {
            @Nls String containerDescription = TextUtil.decapitalize((String)this.myContainer.getPresentation().longDescription());
            return RbsBundle.message((String)"rbs.model.method.alias.longDescription", (Object[])new Object[]{this.myName, containerDescription});
        };
        return new SymbolPresentation(RbsIcons.RBS_METHOD_ALIAS_ICON, this.myName, shortDescriptionSupplier, longDescriptionSupplier);
    }

    @Nullable
    public String getTargetName() {
        return this.myTargetName;
    }

    public int hashCode() {
        int result = this.myDeclarationType.hashCode();
        result = 31 * result + this.myContainer.hashCode();
        result = 31 * result + this.myName.hashCode();
        result = 31 * result + Objects.hashCode(this.myTargetName);
        return result;
    }

    @NotNull
    public String toString() {
        String string = String.format("RbsMethodAliasSymbol{myContainer=%s, myDeclarationType=%s, myName='%s', myTargetName='%s'}", new Object[]{this.myContainer, this.myDeclarationType, this.myName, this.myTargetName});
        if (string == null) {
            RbsMethodAliasSymbol.$$$reportNull$$$0(13);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6, 9, 10, 12, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarationType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ruby/rbs/model/impl/RbsMethodAliasSymbol";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ruby/rbs/model/impl/RbsMethodAliasSymbol";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createPointer";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainerFqn";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainerSymbol";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclarationType";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDynamicSymbols";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigationTargets";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getDynamicSymbols";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getNavigationTargets";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6, 9, 10, 12, 13 -> new IllegalStateException(string);
        };
    }
}

