/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.model.impl;

import com.intellij.lang.ruby.rbs.model.api.RbsContainerSymbol;
import com.intellij.lang.ruby.rbs.model.api.RbsContainerVariableSymbol;
import com.intellij.lang.ruby.rbs.model.api.RbsSyntacticSugarSymbol;
import com.intellij.lang.ruby.rbs.model.cache.RbsSymbolsCache;
import com.intellij.lang.ruby.rbs.model.psi.RbsPsiSymbolDeclarationSearcher;
import com.intellij.lang.ruby.rbs.psi.RbsAttributeDeclarationElement;
import com.intellij.lang.ruby.rbs.psi.RbsDeclarationType;
import com.intellij.lang.ruby.rbs.psi.RbsVariableDeclarationElement;
import com.intellij.lang.ruby.rbs.psi.data.RbsKeywordTypeSignature;
import com.intellij.lang.ruby.rbs.psi.data.RbsTypeSignature;
import com.intellij.lang.ruby.rbs.psi.data.RbsUnionTypeSignature;
import com.intellij.lang.ruby.rbs.psi.index.RbsInstanceVariableDeclarationNameIndex;
import com.intellij.lang.ruby.rbs.psi.stub.RbsStubBasedPsiElement;
import com.intellij.model.Pointer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.ruby.rbs.frontback.RbsBundle;
import com.intellij.ruby.rbs.frontback.RbsIcons;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.model.navigation.NavigatableSymbol;
import org.jetbrains.plugins.ruby.model.navigation.NavigationTarget;
import org.jetbrains.plugins.ruby.model.presentation.PresentableSymbol;
import org.jetbrains.plugins.ruby.model.presentation.SymbolPresentation;
import org.jetbrains.plugins.ruby.model.psi.NavigatablePsiSymbolDeclaration;
import org.jetbrains.plugins.ruby.ruby.lang.TextUtil;

public final class RbsInstanceVariableSymbol
implements RbsContainerVariableSymbol,
NavigatableSymbol,
PresentableSymbol {
    private final RbsDeclarationType myDeclarationType;
    private final RbsContainerSymbol myContainer;
    @NlsSafe
    private final String myName;
    @Nullable
    private final RbsSyntacticSugarSymbol myOriginalDeclaration;

    public RbsInstanceVariableSymbol(@NotNull RbsDeclarationType declarationType, @NotNull RbsContainerSymbol container, @NlsSafe @NotNull String name) {
        if (declarationType == null) {
            RbsInstanceVariableSymbol.$$$reportNull$$$0(0);
        }
        if (container == null) {
            RbsInstanceVariableSymbol.$$$reportNull$$$0(1);
        }
        if (name == null) {
            RbsInstanceVariableSymbol.$$$reportNull$$$0(2);
        }
        this(declarationType, container, name, null);
    }

    public RbsInstanceVariableSymbol(@NotNull RbsDeclarationType declarationType, @NotNull RbsContainerSymbol container, @NlsSafe @NotNull String name, @Nullable RbsSyntacticSugarSymbol originalDeclaration) {
        if (declarationType == null) {
            RbsInstanceVariableSymbol.$$$reportNull$$$0(3);
        }
        if (container == null) {
            RbsInstanceVariableSymbol.$$$reportNull$$$0(4);
        }
        if (name == null) {
            RbsInstanceVariableSymbol.$$$reportNull$$$0(5);
        }
        this.myDeclarationType = declarationType;
        this.myContainer = container;
        this.myName = name;
        this.myOriginalDeclaration = originalDeclaration;
    }

    @NotNull
    public Pointer<RbsInstanceVariableSymbol> createPointer() {
        Pointer pointer = Pointer.hardPointer((Object)this);
        if (pointer == null) {
            RbsInstanceVariableSymbol.$$$reportNull$$$0(6);
        }
        return pointer;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RbsInstanceVariableSymbol other = (RbsInstanceVariableSymbol)obj;
        return this.myDeclarationType == other.myDeclarationType && this.myContainer.equals(other.myContainer) && this.myName.equals(other.myName);
    }

    @Override
    @NotNull
    public RbsContainerSymbol getContainerSymbol() {
        RbsContainerSymbol rbsContainerSymbol = this.myContainer;
        if (rbsContainerSymbol == null) {
            RbsInstanceVariableSymbol.$$$reportNull$$$0(7);
        }
        return rbsContainerSymbol;
    }

    @NotNull
    public RbsDeclarationType getDeclarationType() {
        RbsDeclarationType rbsDeclarationType = this.myDeclarationType;
        if (rbsDeclarationType == null) {
            RbsInstanceVariableSymbol.$$$reportNull$$$0(8);
        }
        return rbsDeclarationType;
    }

    @Override
    @NlsSafe
    @NotNull
    public String getFullName() {
        String string = "@" + this.myName;
        if (string == null) {
            RbsInstanceVariableSymbol.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Override
    @NlsSafe
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            RbsInstanceVariableSymbol.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    public Collection<? extends NavigationTarget> getNavigationTargets(@NotNull Project project) {
        if (project == null) {
            RbsInstanceVariableSymbol.$$$reportNull$$$0(11);
        }
        GlobalSearchScope maximalSearchScope = GlobalSearchScope.allScope((Project)project);
        List<NavigationTarget> list = RbsPsiSymbolDeclarationSearcher.getDeclarations(project, (SearchScope)maximalSearchScope, this).stream().map(NavigatablePsiSymbolDeclaration::getNavigationTarget).sorted().toList();
        if (list == null) {
            RbsInstanceVariableSymbol.$$$reportNull$$$0(12);
        }
        return list;
    }

    @Nullable
    public RbsSyntacticSugarSymbol getOriginalDeclaration() {
        return this.myOriginalDeclaration;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NotNull
    public SymbolPresentation getPresentation() {
        @Nls Supplier shortDescriptionSupplier = RbsBundle.messagePointer((String)"rbs.model.instance.variable.shortDescription", (Object[])new Object[]{this.myName});
        Supplier<@Nls String> longDescriptionSupplier = () -> {
            @Nls String containerDescription = TextUtil.decapitalize((String)this.myContainer.getPresentation().longDescription());
            return RbsBundle.message((String)"rbs.model.instance.variable.longDescription", (Object[])new Object[]{this.myName, containerDescription});
        };
        return new SymbolPresentation(RbsIcons.RBS_INSTANCE_VARIABLE_ICON, this.myName, shortDescriptionSupplier, longDescriptionSupplier);
    }

    @Override
    @NotNull
    public RbsTypeSignature getTypeSignature(@NotNull Project project, @NotNull SearchScope searchScope) {
        if (project == null) {
            RbsInstanceVariableSymbol.$$$reportNull$$$0(13);
        }
        if (searchScope == null) {
            RbsInstanceVariableSymbol.$$$reportNull$$$0(14);
        }
        RbsTypeSignature rbsTypeSignature = (RbsTypeSignature)RbsSymbolsCache.getInstance(project, searchScope).getTypeSignatures().get((Object)this, __ -> this.getTypeSignatureImpl(project, searchScope));
        if (rbsTypeSignature == null) {
            RbsInstanceVariableSymbol.$$$reportNull$$$0(15);
        }
        return rbsTypeSignature;
    }

    public int hashCode() {
        int result = this.myDeclarationType.hashCode();
        result = 31 * result + this.myContainer.hashCode();
        result = 31 * result + this.myName.hashCode();
        return result;
    }

    @NotNull
    public String toString() {
        String string = String.format("RbsInstanceVariableSymbol{myDeclarationType=%s, myContainer=%s, myName='%s', myOriginalDeclaration=%s}", new Object[]{this.myDeclarationType, this.myContainer, this.myName, this.myOriginalDeclaration});
        if (string == null) {
            RbsInstanceVariableSymbol.$$$reportNull$$$0(16);
        }
        return string;
    }

    @NotNull
    private RbsTypeSignature getTypeSignatureImpl(@NotNull Project project, @NotNull SearchScope searchScope) {
        if (project == null) {
            RbsInstanceVariableSymbol.$$$reportNull$$$0(17);
        }
        if (searchScope == null) {
            RbsInstanceVariableSymbol.$$$reportNull$$$0(18);
        }
        Collection<RbsStubBasedPsiElement> elements = RbsInstanceVariableDeclarationNameIndex.getInstance().getElements(project, searchScope, this.myDeclarationType, this.getContainerFqn(), this.myName);
        RbsTypeSignature rbsTypeSignature = elements.stream().mapMulti((element, consumer) -> {
            if (element instanceof RbsVariableDeclarationElement) {
                RbsVariableDeclarationElement variableDeclaration = (RbsVariableDeclarationElement)((Object)element);
                consumer.accept(variableDeclaration.getTypeSignature());
            } else if (element instanceof RbsAttributeDeclarationElement) {
                RbsAttributeDeclarationElement attributeDeclaration = (RbsAttributeDeclarationElement)((Object)element);
                consumer.accept(attributeDeclaration.getTypeSignature());
            }
        }).reduce(RbsUnionTypeSignature::of).orElse(RbsKeywordTypeSignature.UNTYPED);
        if (rbsTypeSignature == null) {
            RbsInstanceVariableSymbol.$$$reportNull$$$0(19);
        }
        return rbsTypeSignature;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 8, 9, 10, 12, 15, 16, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarationType";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 15: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ruby/rbs/model/impl/RbsInstanceVariableSymbol";
                break;
            }
            case 11: 
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ruby/rbs/model/impl/RbsInstanceVariableSymbol";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createPointer";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainerSymbol";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclarationType";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigationTargets";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSignature";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSignatureImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 15: 
            case 16: 
            case 19: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getNavigationTargets";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getTypeSignature";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getTypeSignatureImpl";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 8, 9, 10, 12, 15, 16, 19 -> new IllegalStateException(string);
        };
    }
}

