/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.model.impl;

import com.intellij.lang.ruby.rbs.model.api.RbsSymbol;
import com.intellij.lang.ruby.rbs.model.cache.RbsSymbolsCache;
import com.intellij.lang.ruby.rbs.model.psi.RbsPsiSymbolDeclarationSearcher;
import com.intellij.lang.ruby.rbs.psi.RbsGlobalDeclaration;
import com.intellij.lang.ruby.rbs.psi.data.RbsKeywordTypeSignature;
import com.intellij.lang.ruby.rbs.psi.data.RbsTypeSignature;
import com.intellij.lang.ruby.rbs.psi.data.RbsUnionTypeSignature;
import com.intellij.lang.ruby.rbs.psi.index.RbsGlobalVariableDeclarationNameIndex;
import com.intellij.lang.ruby.rbs.psi.index.RbsGlobalVariableNameIndex;
import com.intellij.model.Pointer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.ruby.rbs.frontback.RbsBundle;
import com.intellij.ruby.rbs.frontback.RbsIcons;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.model.navigation.NavigatableSymbol;
import org.jetbrains.plugins.ruby.model.navigation.NavigationTarget;
import org.jetbrains.plugins.ruby.model.presentation.PresentableSymbol;
import org.jetbrains.plugins.ruby.model.presentation.SymbolPresentation;
import org.jetbrains.plugins.ruby.model.psi.NavigatablePsiSymbolDeclaration;

public final class RbsGlobalVariableSymbol
implements RbsSymbol,
NavigatableSymbol,
PresentableSymbol {
    @NlsSafe
    private final String myName;

    public RbsGlobalVariableSymbol(@NlsSafe @NotNull String name) {
        if (name == null) {
            RbsGlobalVariableSymbol.$$$reportNull$$$0(0);
        }
        this.myName = name;
    }

    @NotNull
    public Pointer<RbsGlobalVariableSymbol> createPointer() {
        Pointer pointer = Pointer.hardPointer((Object)this);
        if (pointer == null) {
            RbsGlobalVariableSymbol.$$$reportNull$$$0(1);
        }
        return pointer;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.myName.equals(((RbsGlobalVariableSymbol)obj).myName);
    }

    @NlsSafe
    @NotNull
    public String getFullName() {
        String string = "$" + this.myName;
        if (string == null) {
            RbsGlobalVariableSymbol.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NlsSafe
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            RbsGlobalVariableSymbol.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public Collection<? extends NavigationTarget> getNavigationTargets(@NotNull Project project) {
        if (project == null) {
            RbsGlobalVariableSymbol.$$$reportNull$$$0(4);
        }
        GlobalSearchScope maximalSearchScope = GlobalSearchScope.allScope((Project)project);
        List<NavigationTarget> list = RbsPsiSymbolDeclarationSearcher.getDeclarations(project, (SearchScope)maximalSearchScope, this).stream().map(NavigatablePsiSymbolDeclaration::getNavigationTarget).sorted().toList();
        if (list == null) {
            RbsGlobalVariableSymbol.$$$reportNull$$$0(5);
        }
        return list;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NotNull
    public SymbolPresentation getPresentation() {
        @Nls Supplier shortDescriptionSupplier = RbsBundle.messagePointer((String)"rbs.model.global.variable.shortDescription", (Object[])new Object[]{this.myName});
        return new SymbolPresentation(RbsIcons.RBS_GLOBAL_VARIABLE_ICON, this.myName, shortDescriptionSupplier);
    }

    @RequiresBackgroundThread(generateAssertion=false)
    @NotNull
    public RbsTypeSignature getTypeSignature(@NotNull Project project, @NotNull SearchScope searchScope) {
        if (project == null) {
            RbsGlobalVariableSymbol.$$$reportNull$$$0(6);
        }
        if (searchScope == null) {
            RbsGlobalVariableSymbol.$$$reportNull$$$0(7);
        }
        RbsTypeSignature rbsTypeSignature = (RbsTypeSignature)RbsSymbolsCache.getInstance(project, searchScope).getTypeSignatures().get((Object)this, __ -> this.getTypeSignatureImpl(project, searchScope));
        if (rbsTypeSignature == null) {
            RbsGlobalVariableSymbol.$$$reportNull$$$0(8);
        }
        return rbsTypeSignature;
    }

    public int hashCode() {
        return this.myName.hashCode();
    }

    @NotNull
    public String toString() {
        String string = String.format("RbsGlobalVariableSymbol{myName='%s'}", this.myName);
        if (string == null) {
            RbsGlobalVariableSymbol.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    private RbsTypeSignature getTypeSignatureImpl(@NotNull Project project, @NotNull SearchScope searchScope) {
        if (project == null) {
            RbsGlobalVariableSymbol.$$$reportNull$$$0(10);
        }
        if (searchScope == null) {
            RbsGlobalVariableSymbol.$$$reportNull$$$0(11);
        }
        Collection elements = RbsGlobalVariableDeclarationNameIndex.getInstance().getElements(project, searchScope, this.myName);
        RbsTypeSignature rbsTypeSignature = RbsUnionTypeSignature.of(ContainerUtil.mapNotNull(elements, RbsGlobalDeclaration::getTypeSignature)).orElse(RbsKeywordTypeSignature.UNTYPED);
        if (rbsTypeSignature == null) {
            RbsGlobalVariableSymbol.$$$reportNull$$$0(12);
        }
        return rbsTypeSignature;
    }

    @RequiresReadLock
    @RequiresBackgroundThread(generateAssertion=false)
    @NotNull
    public static Optional<RbsGlobalVariableSymbol> find(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull String name) {
        if (project == null) {
            RbsGlobalVariableSymbol.$$$reportNull$$$0(13);
        }
        if (searchScope == null) {
            RbsGlobalVariableSymbol.$$$reportNull$$$0(14);
        }
        if (name == null) {
            RbsGlobalVariableSymbol.$$$reportNull$$$0(15);
        }
        ThreadingAssertions.softAssertReadAccess();
        if (name.isBlank()) {
            Optional<RbsGlobalVariableSymbol> optional = Optional.empty();
            if (optional == null) {
                RbsGlobalVariableSymbol.$$$reportNull$$$0(16);
            }
            return optional;
        }
        boolean isGlobalVariableName = (Boolean)RbsSymbolsCache.getInstance(project, searchScope).getGlobalVariableNames().get((Object)name, __ -> RbsGlobalVariableDeclarationNameIndex.getInstance().containsElements(project, searchScope, name));
        Optional<RbsGlobalVariableSymbol> optional = isGlobalVariableName ? Optional.of(new RbsGlobalVariableSymbol(name)) : Optional.empty();
        if (optional == null) {
            RbsGlobalVariableSymbol.$$$reportNull$$$0(17);
        }
        return optional;
    }

    @RequiresReadLock
    @RequiresBackgroundThread(generateAssertion=false)
    @NotNull
    public static Stream<RbsGlobalVariableSymbol> stream(@NotNull Project project, @NotNull SearchScope searchScope) {
        if (project == null) {
            RbsGlobalVariableSymbol.$$$reportNull$$$0(18);
        }
        if (searchScope == null) {
            RbsGlobalVariableSymbol.$$$reportNull$$$0(19);
        }
        ThreadingAssertions.softAssertReadAccess();
        Stream<RbsGlobalVariableSymbol> stream = RbsGlobalVariableNameIndex.getAllKeys(project, searchScope).stream().map(RbsGlobalVariableSymbol::new);
        if (stream == null) {
            RbsGlobalVariableSymbol.$$$reportNull$$$0(20);
        }
        return stream;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 5, 8, 9, 12, 16, 17, 20 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 12: 
            case 16: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ruby/rbs/model/impl/RbsGlobalVariableSymbol";
                break;
            }
            case 4: 
            case 6: 
            case 10: 
            case 13: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: 
            case 11: 
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ruby/rbs/model/impl/RbsGlobalVariableSymbol";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createPointer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigationTargets";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSignature";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSignatureImpl";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "find";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "stream";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 12: 
            case 16: 
            case 17: 
            case 20: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getNavigationTargets";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getTypeSignature";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getTypeSignatureImpl";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "find";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "stream";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 5, 8, 9, 12, 16, 17, 20 -> new IllegalStateException(string);
        };
    }
}

