/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.model.impl;

import com.intellij.lang.ruby.rbs.model.api.RbsContainerSymbol;
import com.intellij.lang.ruby.rbs.model.api.RbsSymbol;
import com.intellij.lang.ruby.rbs.model.api.RbsSyntacticSugarSymbol;
import com.intellij.lang.ruby.rbs.model.cache.RbsSymbolsCache;
import com.intellij.lang.ruby.rbs.model.impl.RbsInstanceVariableSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsMethodSymbol;
import com.intellij.lang.ruby.rbs.model.psi.RbsPsiSymbolDeclarationSearcher;
import com.intellij.lang.ruby.rbs.psi.RbsDeclarationType;
import com.intellij.lang.ruby.rbs.psi.data.RbsKeywordTypeSignature;
import com.intellij.lang.ruby.rbs.psi.data.RbsTypeSignature;
import com.intellij.lang.ruby.rbs.psi.data.RbsUnionTypeSignature;
import com.intellij.lang.ruby.rbs.psi.index.RbsAttributeDeclarationNameIndex;
import com.intellij.lang.ruby.rbs.psi.mixin.RbsAttributeDeclarationMixin;
import com.intellij.lang.ruby.rbs.util.Fqn;
import com.intellij.model.Pointer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.ruby.rbs.frontback.RbsBundle;
import com.intellij.ruby.rbs.frontback.RbsIcons;
import com.intellij.ruby.rbs.frontback.psi.RbsAttributeType;
import com.intellij.ruby.rbs.frontback.psi.RbsVisibility;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.model.navigation.NavigatableSymbol;
import org.jetbrains.plugins.ruby.model.navigation.NavigationTarget;
import org.jetbrains.plugins.ruby.model.presentation.PresentableSymbol;
import org.jetbrains.plugins.ruby.model.presentation.SymbolPresentation;
import org.jetbrains.plugins.ruby.model.psi.NavigatablePsiSymbolDeclaration;
import org.jetbrains.plugins.ruby.ruby.lang.TextUtil;

public final class RbsAttributeSymbol
implements RbsSyntacticSugarSymbol,
NavigatableSymbol,
PresentableSymbol {
    private final RbsVisibility myVisibility;
    private final RbsAttributeType myAttributeType;
    private final RbsDeclarationType myDeclarationType;
    private final RbsContainerSymbol myContainer;
    @NlsSafe
    private final String myName;
    private final boolean myOverridesAttributeVariable;
    @NlsSafe
    @Nullable
    private final String myAttributeVariableName;

    public RbsAttributeSymbol(@NotNull RbsVisibility visibility, @NotNull RbsAttributeType attributeType, @NotNull RbsDeclarationType declarationType, @NotNull RbsContainerSymbol container, @NlsSafe @NotNull String name, boolean overridesAttributeVariable, @NlsSafe @Nullable String attributeVariableName) {
        if (visibility == null) {
            RbsAttributeSymbol.$$$reportNull$$$0(0);
        }
        if (attributeType == null) {
            RbsAttributeSymbol.$$$reportNull$$$0(1);
        }
        if (declarationType == null) {
            RbsAttributeSymbol.$$$reportNull$$$0(2);
        }
        if (container == null) {
            RbsAttributeSymbol.$$$reportNull$$$0(3);
        }
        if (name == null) {
            RbsAttributeSymbol.$$$reportNull$$$0(4);
        }
        this.myVisibility = visibility;
        this.myAttributeType = attributeType;
        this.myDeclarationType = declarationType;
        this.myContainer = container;
        this.myName = name;
        this.myOverridesAttributeVariable = overridesAttributeVariable;
        this.myAttributeVariableName = attributeVariableName;
    }

    @NotNull
    public Pointer<RbsAttributeSymbol> createPointer() {
        Pointer pointer = Pointer.hardPointer((Object)this);
        if (pointer == null) {
            RbsAttributeSymbol.$$$reportNull$$$0(5);
        }
        return pointer;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RbsAttributeSymbol other = (RbsAttributeSymbol)obj;
        return this.myAttributeType.equals((Object)other.myAttributeType) && this.myDeclarationType == other.myDeclarationType && this.myContainer.equals(other.myContainer) && this.myName.equals(other.myName);
    }

    @NotNull
    public RbsAttributeType getAttributeType() {
        RbsAttributeType rbsAttributeType = this.myAttributeType;
        if (rbsAttributeType == null) {
            RbsAttributeSymbol.$$$reportNull$$$0(6);
        }
        return rbsAttributeType;
    }

    @NlsSafe
    @Nullable
    public String getAttributeVariableName() {
        return this.myAttributeVariableName;
    }

    @NotNull
    public Fqn getContainerFqn() {
        Fqn fqn = this.myContainer.getFqn();
        if (fqn == null) {
            RbsAttributeSymbol.$$$reportNull$$$0(7);
        }
        return fqn;
    }

    @NotNull
    public RbsContainerSymbol getContainerSymbol() {
        RbsContainerSymbol rbsContainerSymbol = this.myContainer;
        if (rbsContainerSymbol == null) {
            RbsAttributeSymbol.$$$reportNull$$$0(8);
        }
        return rbsContainerSymbol;
    }

    @NotNull
    public RbsDeclarationType getDeclarationType() {
        RbsDeclarationType rbsDeclarationType = this.myDeclarationType;
        if (rbsDeclarationType == null) {
            RbsAttributeSymbol.$$$reportNull$$$0(9);
        }
        return rbsDeclarationType;
    }

    @Override
    @NotNull
    public List<? extends RbsSymbol> getDynamicSymbols(@NotNull Project project, @NotNull SearchScope searchScope) {
        if (project == null) {
            RbsAttributeSymbol.$$$reportNull$$$0(10);
        }
        if (searchScope == null) {
            RbsAttributeSymbol.$$$reportNull$$$0(11);
        }
        ArrayList<RbsSymbol> symbols = new ArrayList<RbsSymbol>();
        RbsAttributeType attributeType = this.myAttributeType;
        if (attributeType != RbsAttributeType.ATTRIBUTE_WRITER) {
            symbols.add(new RbsMethodSymbol(this.myVisibility, this.myDeclarationType, this.myContainer, this.myName, this));
        }
        if (attributeType != RbsAttributeType.ATTRIBUTE_READER) {
            symbols.add(new RbsMethodSymbol(this.myVisibility, this.myDeclarationType, this.myContainer, this.myName + "=", this));
        }
        if (!this.isOverridesAttributeVariable()) {
            symbols.add(new RbsInstanceVariableSymbol(this.myDeclarationType, this.myContainer, this.myName, this));
        }
        List list = Collections.unmodifiableList(symbols);
        if (list == null) {
            RbsAttributeSymbol.$$$reportNull$$$0(12);
        }
        return list;
    }

    @NlsSafe
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            RbsAttributeSymbol.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    public Collection<? extends NavigationTarget> getNavigationTargets(@NotNull Project project) {
        if (project == null) {
            RbsAttributeSymbol.$$$reportNull$$$0(14);
        }
        GlobalSearchScope maximalSearchScope = GlobalSearchScope.allScope((Project)project);
        List<NavigationTarget> list = RbsPsiSymbolDeclarationSearcher.getDeclarations(project, (SearchScope)maximalSearchScope, this).stream().map(NavigatablePsiSymbolDeclaration::getNavigationTarget).sorted().toList();
        if (list == null) {
            RbsAttributeSymbol.$$$reportNull$$$0(15);
        }
        return list;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NotNull
    public SymbolPresentation getPresentation() {
        Supplier shortDescriptionSupplier;
        Icon icon;
        String containerDescription = TextUtil.decapitalize((String)this.myContainer.getPresentation().longDescription());
        @Nls Supplier longDescriptionSupplier = switch (this.myAttributeType) {
            case RbsAttributeType.ATTRIBUTE_ACCESSOR -> {
                icon = this.myVisibility == RbsVisibility.PUBLIC_VISIBILITY ? RbsIcons.RBS_PUBLIC_ATTRIBUTE_ACCESSOR_ICON : RbsIcons.RBS_PRIVATE_ATTRIBUTE_ACCESSOR_ICON;
                shortDescriptionSupplier = RbsBundle.messagePointer((String)"rbs.model.attribute.accessor.shortDescription", (Object[])new Object[]{this.myName});
                yield RbsBundle.messagePointer((String)"rbs.model.attribute.accessor.longDescription", (Object[])new Object[]{this.myName, containerDescription});
            }
            case RbsAttributeType.ATTRIBUTE_READER -> {
                icon = this.myVisibility == RbsVisibility.PUBLIC_VISIBILITY ? RbsIcons.RBS_PUBLIC_ATTRIBUTE_READER_ICON : RbsIcons.RBS_PRIVATE_ATTRIBUTE_READER_ICON;
                shortDescriptionSupplier = RbsBundle.messagePointer((String)"rbs.model.attribute.reader.shortDescription", (Object[])new Object[]{this.myName});
                yield RbsBundle.messagePointer((String)"rbs.model.attribute.reader.longDescription", (Object[])new Object[]{this.myName, containerDescription});
            }
            case RbsAttributeType.ATTRIBUTE_WRITER -> {
                icon = this.myVisibility == RbsVisibility.PUBLIC_VISIBILITY ? RbsIcons.RBS_PUBLIC_ATTRIBUTE_WRITER_ICON : RbsIcons.RBS_PRIVATE_ATTRIBUTE_WRITER_ICON;
                shortDescriptionSupplier = RbsBundle.messagePointer((String)"rbs.model.attribute.writer.shortDescription", (Object[])new Object[]{this.myName});
                yield RbsBundle.messagePointer((String)"rbs.model.attribute.writer.longDescription", (Object[])new Object[]{this.myName, containerDescription});
            }
            default -> throw new UnsupportedOperationException("Unknown type: " + String.valueOf(this.myAttributeType));
        };
        if (this.myVisibility == RbsVisibility.PUBLIC_VISIBILITY) {
            return new SymbolPresentation(icon, this.myName, shortDescriptionSupplier, longDescriptionSupplier);
        }
        String prefix = RbsBundle.message((String)"rbs.model.descriptions.private.prefix", (Object[])new Object[0]) + " ";
        return new SymbolPresentation(icon, this.myName, () -> RbsAttributeSymbol.lambda$getPresentation$0(prefix, (Supplier)shortDescriptionSupplier), () -> RbsAttributeSymbol.lambda$getPresentation$1(prefix, (Supplier)longDescriptionSupplier));
    }

    @RequiresBackgroundThread(generateAssertion=false)
    @NotNull
    public RbsTypeSignature getTypeSignature(@NotNull Project project, @NotNull SearchScope searchScope) {
        if (project == null) {
            RbsAttributeSymbol.$$$reportNull$$$0(16);
        }
        if (searchScope == null) {
            RbsAttributeSymbol.$$$reportNull$$$0(17);
        }
        RbsTypeSignature rbsTypeSignature = (RbsTypeSignature)RbsSymbolsCache.getInstance(project, searchScope).getTypeSignatures().get((Object)this, __ -> this.getTypeSignatureImpl(project, searchScope));
        if (rbsTypeSignature == null) {
            RbsAttributeSymbol.$$$reportNull$$$0(18);
        }
        return rbsTypeSignature;
    }

    @NotNull
    public RbsVisibility getVisibility() {
        RbsVisibility rbsVisibility = this.myVisibility;
        if (rbsVisibility == null) {
            RbsAttributeSymbol.$$$reportNull$$$0(19);
        }
        return rbsVisibility;
    }

    public int hashCode() {
        int result = this.myAttributeType.hashCode();
        result = 31 * result + this.myDeclarationType.hashCode();
        result = 31 * result + this.myContainer.hashCode();
        result = 31 * result + this.myName.hashCode();
        return result;
    }

    public boolean isOverridesAttributeVariable() {
        return this.myOverridesAttributeVariable;
    }

    @NotNull
    public String toString() {
        String string = "RbsAttributeSymbol{myVisibility=%s, myAttributeType=%s, myDeclarationType=%s, myContainer=%s, myName='%s', myOverridesAttributeVariable=%s, myAttributeVariableName='%s'}".formatted(new Object[]{this.myVisibility, this.myAttributeType, this.myDeclarationType, this.myContainer, this.myName, this.myOverridesAttributeVariable, this.myAttributeVariableName});
        if (string == null) {
            RbsAttributeSymbol.$$$reportNull$$$0(20);
        }
        return string;
    }

    @NotNull
    private RbsTypeSignature getTypeSignatureImpl(@NotNull Project project, @NotNull SearchScope searchScope) {
        if (project == null) {
            RbsAttributeSymbol.$$$reportNull$$$0(21);
        }
        if (searchScope == null) {
            RbsAttributeSymbol.$$$reportNull$$$0(22);
        }
        Collection<RbsAttributeDeclarationMixin> elements = RbsAttributeDeclarationNameIndex.getInstance().getElements(project, searchScope, this.myDeclarationType, this.getContainerFqn(), this.myName);
        RbsTypeSignature rbsTypeSignature = RbsUnionTypeSignature.of(ContainerUtil.mapNotNull(elements, RbsAttributeDeclarationMixin::getTypeSignature)).orElse(RbsKeywordTypeSignature.UNTYPED);
        if (rbsTypeSignature == null) {
            RbsAttributeSymbol.$$$reportNull$$$0(23);
        }
        return rbsTypeSignature;
    }

    private static /* synthetic */ String lambda$getPresentation$1(String prefix, Supplier longDescriptionSupplier) {
        return prefix + TextUtil.decapitalize((String)((String)longDescriptionSupplier.get()));
    }

    private static /* synthetic */ String lambda$getPresentation$0(String prefix, Supplier shortDescriptionSupplier) {
        return prefix + TextUtil.decapitalize((String)((String)shortDescriptionSupplier.get()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 7, 8, 9, 12, 13, 15, 18, 19, 20, 23 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visibility";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarationType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ruby/rbs/model/impl/RbsAttributeSymbol";
                break;
            }
            case 10: 
            case 14: 
            case 16: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 11: 
            case 17: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ruby/rbs/model/impl/RbsAttributeSymbol";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createPointer";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributeType";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainerFqn";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainerSymbol";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclarationType";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDynamicSymbols";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigationTargets";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSignature";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisibility";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSignatureImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 23: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getDynamicSymbols";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getNavigationTargets";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getTypeSignature";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getTypeSignatureImpl";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 7, 8, 9, 12, 13, 15, 18, 19, 20, 23 -> new IllegalStateException(string);
        };
    }
}

