/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.model.hierarchy;

import com.intellij.lang.ruby.rbs.model.api.RbsContainerSymbol;
import com.intellij.lang.ruby.rbs.model.api.RbsQualifiedNameSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsClassSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsMethodSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsModuleSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsSingletonSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsTypeAliasSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsUseClauseAliasSymbol;
import com.intellij.lang.ruby.rbs.util.RbsFqns;
import com.intellij.model.Symbol;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.ObjectUtils;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.util.StreamUtil;

public final class RbsContainerSymbolUtil {
    private RbsContainerSymbolUtil() {
    }

    @NotNull
    public static BiConsumer<Symbol, Consumer<? super Symbol>> followAliases(@NotNull Project project, @NotNull SearchScope searchScope) {
        if (project == null) {
            RbsContainerSymbolUtil.$$$reportNull$$$0(0);
        }
        if (searchScope == null) {
            RbsContainerSymbolUtil.$$$reportNull$$$0(1);
        }
        BiConsumer<Symbol, Consumer<? super Symbol>> biConsumer = (symbol, consumer) -> {
            if (symbol instanceof RbsUseClauseAliasSymbol) {
                RbsUseClauseAliasSymbol alias = (RbsUseClauseAliasSymbol)symbol;
                RbsQualifiedNameSymbol.find(project, searchScope, alias.getTargetFqn()).mapMulti(StreamUtil.select(RbsContainerSymbol.class, (Class[])new Class[]{RbsTypeAliasSymbol.class})).forEach(consumer);
            } else if (symbol instanceof RbsClassSymbol) {
                RbsClassSymbol classSymbol = (RbsClassSymbol)symbol;
                consumer.accept(ObjectUtils.coalesce((Object)classSymbol.getTargetClassSymbol(project, searchScope), (Object)classSymbol));
            } else if (symbol instanceof RbsModuleSymbol) {
                RbsModuleSymbol moduleSymbol = (RbsModuleSymbol)symbol;
                consumer.accept(ObjectUtils.coalesce((Object)moduleSymbol.getTargetModuleSymbol(project, searchScope), (Object)moduleSymbol));
            } else {
                consumer.accept(symbol);
            }
        };
        if (biConsumer == null) {
            RbsContainerSymbolUtil.$$$reportNull$$$0(2);
        }
        return biConsumer;
    }

    @NotNull
    public static BiConsumer<? super RbsMethodSymbol, Consumer<? super RbsMethodSymbol>> inlineInitialize(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull RbsContainerSymbol container) {
        if (project == null) {
            RbsContainerSymbolUtil.$$$reportNull$$$0(3);
        }
        if (searchScope == null) {
            RbsContainerSymbolUtil.$$$reportNull$$$0(4);
        }
        if (container == null) {
            RbsContainerSymbolUtil.$$$reportNull$$$0(5);
        }
        BiConsumer<RbsMethodSymbol, Consumer<? super RbsMethodSymbol>> biConsumer = (method, consumer) -> {
            if (container instanceof RbsSingletonSymbol) {
                RbsSingletonSymbol singleton = (RbsSingletonSymbol)container;
                if (method.getContainerFqn().equals(RbsFqns.CLASS_FQN) && method.getName().equals("new")) {
                    singleton.getOriginalSymbol().allChildren(project, searchScope).mapMulti(StreamUtil.select(RbsMethodSymbol.class, (Class[])new Class[0])).filter(child -> child.getName().equals("initialize")).limit(1L).forEach((Consumer<RbsMethodSymbol>)consumer);
                    return;
                }
            }
            consumer.accept(method);
        };
        if (biConsumer == null) {
            RbsContainerSymbolUtil.$$$reportNull$$$0(6);
        }
        return biConsumer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ruby/rbs/model/hierarchy/RbsContainerSymbolUtil";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ruby/rbs/model/hierarchy/RbsContainerSymbolUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "followAliases";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "inlineInitialize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "followAliases";
                break;
            }
            case 2: 
            case 6: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "inlineInitialize";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 6 -> new IllegalStateException(string);
        };
    }
}

