/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.model.documentation;

import com.intellij.lang.ruby.rbs.model.documentation.RbsDocumentationChunk;
import com.intellij.lang.ruby.rbs.model.documentation.RbsDocumentationTargetBase;
import com.intellij.lang.ruby.rbs.model.impl.RbsParameterSymbol;
import com.intellij.lang.ruby.rbs.psi.RbsParameterType;
import com.intellij.lang.ruby.rbs.psi.data.RbsProcTypeSignature;
import com.intellij.lang.ruby.rbs.psi.data.RbsTypeSignatureResolver;
import com.intellij.model.Pointer;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.platform.backend.presentation.TargetPresentation;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

final class RbsParameterDocumentationTarget
extends RbsDocumentationTargetBase<RbsParameterSymbol> {
    RbsParameterDocumentationTarget(@NotNull Project project, @NotNull RbsParameterSymbol symbol) {
        if (project == null) {
            RbsParameterDocumentationTarget.$$$reportNull$$$0(0);
        }
        if (symbol == null) {
            RbsParameterDocumentationTarget.$$$reportNull$$$0(1);
        }
        super(project, symbol);
    }

    @NlsContexts.HintText
    @NotNull
    public String computeDocumentationHint() {
        Set<RbsProcTypeSignature.ParameterType> parameterTypes = ((RbsParameterSymbol)this.mySymbol).getParameterType() == RbsParameterType.POSITIONAL_PARAMETER ? RbsProcTypeSignature.ParameterType.POSITIONAL_TYPES : RbsProcTypeSignature.ParameterType.KEYWORD_TYPES;
        RbsProcTypeSignature.Parameter parameter = ((RbsParameterSymbol)this.mySymbol).getElement().getTypeSignature().findParameter(parameterTypes, ((RbsParameterSymbol)this.mySymbol).getName());
        if (parameter != null) {
            String string = RbsDocumentationChunk.parameter(parameter.apply(new RbsTypeSignatureResolver(this.myProject, this.mySearchScope)));
            if (string == null) {
                RbsParameterDocumentationTarget.$$$reportNull$$$0(2);
            }
            return string;
        }
        String name = RbsDocumentationChunk.identifier(((RbsParameterSymbol)this.mySymbol).getName());
        String type = RbsDocumentationChunk.highlighted(HighlighterColors.BAD_CHARACTER, "?");
        String string = switch (((RbsParameterSymbol)this.mySymbol).getParameterType()) {
            default -> throw new IncompatibleClassChangeError();
            case RbsParameterType.POSITIONAL_PARAMETER -> "%s %s".formatted(type, name);
            case RbsParameterType.KEYWORD_PARAMETER -> "%s: %s".formatted(name, type);
        };
        if (string == null) {
            RbsParameterDocumentationTarget.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public TargetPresentation computePresentation() {
        TargetPresentation targetPresentation = TargetPresentation.builder((String)((RbsParameterSymbol)this.mySymbol).getName()).icon(((RbsParameterSymbol)this.mySymbol).getPresentation().icon()).presentation();
        if (targetPresentation == null) {
            RbsParameterDocumentationTarget.$$$reportNull$$$0(4);
        }
        return targetPresentation;
    }

    @Override
    @NotNull
    public Pointer<RbsParameterDocumentationTarget> createPointer() {
        Project project = this.myProject;
        Pointer pointer = Pointer.delegatingPointer(((RbsParameterSymbol)this.mySymbol).createPointer(), it -> !project.isDisposed() ? new RbsParameterDocumentationTarget(project, (RbsParameterSymbol)it) : null);
        if (pointer == null) {
            RbsParameterDocumentationTarget.$$$reportNull$$$0(5);
        }
        return pointer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ruby/rbs/model/documentation/RbsParameterDocumentationTarget";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ruby/rbs/model/documentation/RbsParameterDocumentationTarget";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "computeDocumentationHint";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "computePresentation";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createPointer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5 -> new IllegalStateException(string);
        };
    }
}

