/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.model.documentation;

import com.intellij.lang.ruby.rbs.model.api.RbsContainerSymbol;
import com.intellij.lang.ruby.rbs.model.documentation.RbsDocumentationChunk;
import com.intellij.lang.ruby.rbs.model.documentation.RbsDocumentationTargetBase;
import com.intellij.lang.ruby.rbs.model.impl.RbsModuleSymbol;
import com.intellij.lang.ruby.rbs.psi.data.RbsTypeSignature;
import com.intellij.lang.ruby.rbs.psi.data.RbsTypeSignatureBinding;
import com.intellij.lang.ruby.rbs.util.RbsFqns;
import com.intellij.model.Pointer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.platform.backend.presentation.TargetPresentation;
import com.intellij.util.containers.ContainerUtil;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

final class RbsModuleDocumentationTarget
extends RbsDocumentationTargetBase<RbsModuleSymbol> {
    RbsModuleDocumentationTarget(@NotNull Project project, @NotNull RbsModuleSymbol symbol) {
        if (project == null) {
            RbsModuleDocumentationTarget.$$$reportNull$$$0(0);
        }
        if (symbol == null) {
            RbsModuleDocumentationTarget.$$$reportNull$$$0(1);
        }
        super(project, symbol);
    }

    @NlsContexts.HintText
    @NotNull
    public String computeDocumentationHint() {
        @Nls StringBuilder sb = new StringBuilder();
        sb.append(RbsDocumentationChunk.keyword("module")).append(" ").append(RbsDocumentationChunk.fqn(((RbsModuleSymbol)this.mySymbol).getFqn()));
        RbsModuleSymbol targetModule = ((RbsModuleSymbol)this.mySymbol).getTargetModuleSymbol(this.myProject, this.mySearchScope);
        if (targetModule != null) {
            sb.append(" ").append(RbsDocumentationChunk.operation("=")).append(" ").append(RbsDocumentationChunk.fqn(targetModule.getFqn()));
            String string = sb.toString();
            if (string == null) {
                RbsModuleDocumentationTarget.$$$reportNull$$$0(2);
            }
            return string;
        }
        sb.append(RbsDocumentationChunk.typeVariables(this.myProject, ((RbsModuleSymbol)this.mySymbol).getTypeVariableSymbols(this.myProject, this.mySearchScope)));
        List selfTypeSymbols = ContainerUtil.filter(((RbsModuleSymbol)this.mySymbol).getSelfTypeSymbols(this.myProject, this.mySearchScope), it -> !it.getFqn().isEquivalentTo(RbsFqns.OBJECT_FQN));
        if (!selfTypeSymbols.isEmpty()) {
            sb.append(" ").append(RbsDocumentationChunk.operation(":")).append(" ");
            Iterator it2 = selfTypeSymbols.iterator();
            while (it2.hasNext()) {
                RbsContainerSymbol next = (RbsContainerSymbol)it2.next();
                Function<RbsTypeSignature, RbsTypeSignature> binding = ((RbsModuleSymbol)this.mySymbol).getTypeVariableBinding(this.myProject, this.mySearchScope).getOrDefault(next, RbsTypeSignatureBinding.UNTYPED);
                sb.append(RbsDocumentationChunk.ancestor(this.myProject, next, binding));
                if (!it2.hasNext()) continue;
                sb.append(RbsDocumentationChunk.operation(",")).append(" ");
            }
        }
        String string = sb.toString();
        if (string == null) {
            RbsModuleDocumentationTarget.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public TargetPresentation computePresentation() {
        TargetPresentation targetPresentation = TargetPresentation.builder((String)((RbsModuleSymbol)this.mySymbol).getName()).icon(((RbsModuleSymbol)this.mySymbol).getPresentation().icon()).presentation();
        if (targetPresentation == null) {
            RbsModuleDocumentationTarget.$$$reportNull$$$0(4);
        }
        return targetPresentation;
    }

    @Override
    @NotNull
    public Pointer<RbsModuleDocumentationTarget> createPointer() {
        Project project = this.myProject;
        Pointer pointer = Pointer.delegatingPointer(((RbsModuleSymbol)this.mySymbol).createPointer(), it -> !project.isDisposed() ? new RbsModuleDocumentationTarget(project, (RbsModuleSymbol)it) : null);
        if (pointer == null) {
            RbsModuleDocumentationTarget.$$$reportNull$$$0(5);
        }
        return pointer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ruby/rbs/model/documentation/RbsModuleDocumentationTarget";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ruby/rbs/model/documentation/RbsModuleDocumentationTarget";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "computeDocumentationHint";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "computePresentation";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createPointer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5 -> new IllegalStateException(string);
        };
    }
}

