/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.model.documentation;

import com.intellij.lang.ruby.rbs.model.documentation.RbsDocumentationChunk;
import com.intellij.lang.ruby.rbs.model.documentation.RbsDocumentationTargetBase;
import com.intellij.lang.ruby.rbs.model.impl.RbsMethodSymbol;
import com.intellij.lang.ruby.rbs.psi.RbsDeclarationType;
import com.intellij.lang.ruby.rbs.psi.data.RbsMethodTypeSignature;
import com.intellij.lang.ruby.rbs.psi.data.RbsTypeSignatureResolver;
import com.intellij.model.Pointer;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.platform.backend.presentation.TargetPresentation;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.ruby.rbs.frontback.RbsFileType;
import com.intellij.ruby.rbs.frontback.psi.RbsVisibility;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.lang.highlighter.RubyHighlighter;

final class RbsMethodDocumentationTarget
extends RbsDocumentationTargetBase<RbsMethodSymbol> {
    RbsMethodDocumentationTarget(@NotNull Project project, @NotNull RbsMethodSymbol symbol) {
        if (project == null) {
            RbsMethodDocumentationTarget.$$$reportNull$$$0(0);
        }
        if (symbol == null) {
            RbsMethodDocumentationTarget.$$$reportNull$$$0(1);
        }
        super(project, symbol);
    }

    @NlsContexts.HintText
    @NotNull
    public String computeDocumentationHint() {
        @Nls StringBuilder sb = new StringBuilder();
        sb.append(RbsDocumentationChunk.fqn(((RbsMethodSymbol)this.mySymbol).getContainerFqn()));
        sb.append(RbsDocumentationChunk.typeVariables(this.myProject, ((RbsMethodSymbol)this.mySymbol).getContainerSymbol().getTypeVariableSymbols(this.myProject, this.mySearchScope), true));
        sb.append(HtmlChunk.br());
        if (((RbsMethodSymbol)this.mySymbol).getVisibility() == RbsVisibility.PRIVATE_VISIBILITY) {
            sb.append(RbsDocumentationChunk.keyword("private")).append(" ");
        }
        sb.append(RbsDocumentationChunk.keyword("def")).append(" ");
        if (((RbsMethodSymbol)this.mySymbol).getDeclarationType() == RbsDeclarationType.SINGLETON_DECLARATION) {
            sb.append(RbsDocumentationChunk.keyword("self")).append(RbsDocumentationChunk.operation("."));
        }
        sb.append(RbsDocumentationChunk.highlighted(RubyHighlighter.METHOD_NAME, ((RbsMethodSymbol)this.mySymbol).getName()));
        sb.append(RbsDocumentationChunk.operation(":")).append(" ");
        List<RbsMethodTypeSignature> signatures = ((RbsMethodSymbol)this.mySymbol).getMethodTypeSignatures(this.myProject, this.mySearchScope);
        if (signatures.isEmpty()) {
            sb.append(RbsDocumentationChunk.highlighted(HighlighterColors.BAD_CHARACTER, "?"));
        }
        String indent = HtmlChunk.nbsp().toString().repeat(CodeStyleSettings.getDefaults().getIndentSize((FileType)RbsFileType.INSTANCE));
        Iterator<RbsMethodTypeSignature> it = signatures.iterator();
        while (it.hasNext()) {
            sb.append(RbsDocumentationChunk.typeSignature(it.next().apply((Function)new RbsTypeSignatureResolver(this.myProject, this.mySearchScope))));
            if (!it.hasNext()) continue;
            sb.append(HtmlChunk.br()).append(indent).append(RbsDocumentationChunk.operation("|")).append(" ");
        }
        String string = sb.toString();
        if (string == null) {
            RbsMethodDocumentationTarget.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public TargetPresentation computePresentation() {
        TargetPresentation targetPresentation = TargetPresentation.builder((String)((RbsMethodSymbol)this.mySymbol).getName()).icon(((RbsMethodSymbol)this.mySymbol).getPresentation().icon()).presentation();
        if (targetPresentation == null) {
            RbsMethodDocumentationTarget.$$$reportNull$$$0(3);
        }
        return targetPresentation;
    }

    @Override
    @NotNull
    public Pointer<RbsMethodDocumentationTarget> createPointer() {
        Project project = this.myProject;
        Pointer pointer = Pointer.delegatingPointer(((RbsMethodSymbol)this.mySymbol).createPointer(), it -> !project.isDisposed() ? new RbsMethodDocumentationTarget(project, (RbsMethodSymbol)it) : null);
        if (pointer == null) {
            RbsMethodDocumentationTarget.$$$reportNull$$$0(4);
        }
        return pointer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ruby/rbs/model/documentation/RbsMethodDocumentationTarget";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ruby/rbs/model/documentation/RbsMethodDocumentationTarget";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "computeDocumentationHint";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "computePresentation";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createPointer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4 -> new IllegalStateException(string);
        };
    }
}

