/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.model.documentation;

import com.intellij.lang.ruby.rbs.model.documentation.RbsDocumentationChunk;
import com.intellij.lang.ruby.rbs.psi.data.RbsBooleanLiteralSignature;
import com.intellij.lang.ruby.rbs.psi.data.RbsIntegerLiteralSignature;
import com.intellij.lang.ruby.rbs.psi.data.RbsIntersectionTypeSignature;
import com.intellij.lang.ruby.rbs.psi.data.RbsKeywordTypeSignature;
import com.intellij.lang.ruby.rbs.psi.data.RbsLiteralSignature;
import com.intellij.lang.ruby.rbs.psi.data.RbsMethodTypeSignature;
import com.intellij.lang.ruby.rbs.psi.data.RbsNilLiteralSignature;
import com.intellij.lang.ruby.rbs.psi.data.RbsOptionalTypeSignature;
import com.intellij.lang.ruby.rbs.psi.data.RbsProcTypeSignature;
import com.intellij.lang.ruby.rbs.psi.data.RbsQualifiedNameReferenceSignature;
import com.intellij.lang.ruby.rbs.psi.data.RbsQualifiedNameTypeSignature;
import com.intellij.lang.ruby.rbs.psi.data.RbsRecordTypeSignature;
import com.intellij.lang.ruby.rbs.psi.data.RbsSingletonTypeSignature;
import com.intellij.lang.ruby.rbs.psi.data.RbsStringLiteralSignature;
import com.intellij.lang.ruby.rbs.psi.data.RbsSymbolLiteralSignature;
import com.intellij.lang.ruby.rbs.psi.data.RbsTupleTypeSignature;
import com.intellij.lang.ruby.rbs.psi.data.RbsTypeSignature;
import com.intellij.lang.ruby.rbs.psi.data.RbsTypeSignatureVisitor;
import com.intellij.lang.ruby.rbs.psi.data.RbsTypeVariableReferenceSignature;
import com.intellij.lang.ruby.rbs.psi.data.RbsUnionTypeSignature;
import com.intellij.lang.ruby.rbs.util.RbsNamingConventionUtils;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.Strings;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

final class RbsDocumentationTypeSignaturePresentationVisitor
implements RbsTypeSignatureVisitor {
    @NlsSafe
    private String myText = "";

    RbsDocumentationTypeSignaturePresentationVisitor() {
    }

    @NotNull
    @NlsSafe
    public String getText() {
        String string = this.myText;
        if (string == null) {
            RbsDocumentationTypeSignaturePresentationVisitor.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public void visitBooleanLiteralSignature(@NotNull RbsBooleanLiteralSignature signature) {
        if (signature == null) {
            RbsDocumentationTypeSignaturePresentationVisitor.$$$reportNull$$$0(1);
        }
        this.myText = RbsDocumentationChunk.keyword(signature.getLiteral() ? "true" : "false");
    }

    @Override
    public void visitIntegerLiteralSignature(@NotNull RbsIntegerLiteralSignature signature) {
        if (signature == null) {
            RbsDocumentationTypeSignaturePresentationVisitor.$$$reportNull$$$0(2);
        }
        this.myText = RbsDocumentationChunk.number(signature.getLiteral().toString());
    }

    @Override
    public void visitIntersectionTypeSignature(@NotNull RbsIntersectionTypeSignature signature) {
        List<RbsTypeSignature> signatures;
        if (signature == null) {
            RbsDocumentationTypeSignaturePresentationVisitor.$$$reportNull$$$0(3);
        }
        this.myText = (signatures = signature.getTypeSignatures()).size() <= 3 ? signature.getTypeSignatures().stream().map(it -> RbsDocumentationTypeSignaturePresentationVisitor.isParenthesesRequired(it) ? RbsDocumentationChunk.parentheses("(") + RbsDocumentationChunk.typeSignature(it) + RbsDocumentationChunk.parentheses(")") : RbsDocumentationChunk.typeSignature(it)).collect(Collectors.joining(" " + RbsDocumentationChunk.operation("&") + " ")) : signature.getTypeSignatures().stream().limit(2L).map(it -> RbsDocumentationTypeSignaturePresentationVisitor.isParenthesesRequired(it) ? RbsDocumentationChunk.parentheses("(") + RbsDocumentationChunk.typeSignature(it) + RbsDocumentationChunk.parentheses(")") : RbsDocumentationChunk.typeSignature(it)).collect(Collectors.joining(" " + RbsDocumentationChunk.operation("&") + " ")) + " " + RbsDocumentationChunk.operation("&") + " " + RbsDocumentationChunk.operation("\u2026");
    }

    @Override
    public void visitKeywordTypeSignature(@NotNull RbsKeywordTypeSignature signature) {
        if (signature == null) {
            RbsDocumentationTypeSignaturePresentationVisitor.$$$reportNull$$$0(4);
        }
        this.myText = RbsDocumentationChunk.keyword(signature.name().toLowerCase(Locale.ROOT));
    }

    @Override
    public void visitLiteralSignature(@NotNull RbsLiteralSignature signature) {
        if (signature == null) {
            RbsDocumentationTypeSignaturePresentationVisitor.$$$reportNull$$$0(5);
        }
        throw new IllegalStateException();
    }

    @Override
    public void visitMethodTypeSignature(@NotNull RbsMethodTypeSignature signature) {
        RbsProcTypeSignature blockTypeSignature;
        RbsTypeSignature selfTypeSignature;
        String parametersText;
        String typeParametersText;
        if (signature == null) {
            RbsDocumentationTypeSignaturePresentationVisitor.$$$reportNull$$$0(6);
        }
        String string = typeParametersText = signature.hasUntypedParameters() ? RbsDocumentationChunk.operation("?") : Strings.join(signature.getTypeParameters(), it -> {
            String name = it.getName();
            RbsTypeSignature upperBound = it.getUpperBound();
            return upperBound != null ? RbsDocumentationChunk.fqn(name) + " " + RbsDocumentationChunk.operation("<") + " " + RbsDocumentationChunk.typeSignature(upperBound) : RbsDocumentationChunk.fqn(name);
        }, (String)(RbsDocumentationChunk.operation(",") + " "));
        if (!typeParametersText.isBlank()) {
            this.myText = RbsDocumentationChunk.brackets("[") + typeParametersText + RbsDocumentationChunk.brackets("]") + " ";
        }
        if (!(parametersText = Strings.join(signature.getParameters(), RbsDocumentationChunk::parameter, (String)(RbsDocumentationChunk.operation(",") + " "))).isBlank()) {
            this.myText = this.myText + RbsDocumentationChunk.parentheses("(") + parametersText + RbsDocumentationChunk.parentheses(")") + " ";
        }
        if ((selfTypeSignature = signature.getSelfTypeSignature()) != null) {
            String selfText = RbsDocumentationChunk.typeSignature(selfTypeSignature);
            this.myText = this.myText + RbsDocumentationChunk.brackets("[") + RbsDocumentationChunk.keyword("self") + RbsDocumentationChunk.operation(":") + " " + selfText + RbsDocumentationChunk.brackets("]");
        }
        if ((blockTypeSignature = signature.getBlockTypeSignature()) != null) {
            String blockOptionalMarker = signature.isBlockOptional() ? RbsDocumentationChunk.operation("?") : "";
            String blockText = RbsDocumentationChunk.typeSignature(blockTypeSignature);
            this.myText = this.myText + blockOptionalMarker + RbsDocumentationChunk.braces("{") + " " + blockText + " " + RbsDocumentationChunk.braces("}") + " " + RbsDocumentationChunk.operation("->") + " ";
        } else {
            this.myText = this.myText + RbsDocumentationChunk.operation("->") + " ";
        }
        RbsTypeSignature returnTypeSignature = signature.getReturnTypeSignature();
        this.myText = RbsDocumentationTypeSignaturePresentationVisitor.isParenthesesRequired(returnTypeSignature) ? this.myText + RbsDocumentationChunk.parentheses("(") + RbsDocumentationChunk.typeSignature(returnTypeSignature) + RbsDocumentationChunk.parentheses(")") : this.myText + RbsDocumentationChunk.typeSignature(returnTypeSignature);
    }

    @Override
    public void visitNilLiteralSignature(@NotNull RbsNilLiteralSignature signature) {
        if (signature == null) {
            RbsDocumentationTypeSignaturePresentationVisitor.$$$reportNull$$$0(7);
        }
        this.myText = RbsDocumentationChunk.keyword("nil");
    }

    @Override
    public void visitOptionalTypeSignature(@NotNull RbsOptionalTypeSignature signature) {
        if (signature == null) {
            RbsDocumentationTypeSignaturePresentationVisitor.$$$reportNull$$$0(8);
        }
        this.myText = RbsDocumentationTypeSignaturePresentationVisitor.isParenthesesRequired(signature.getTypeSignature()) ? RbsDocumentationChunk.parentheses("(") + RbsDocumentationChunk.typeSignature(signature.getTypeSignature()) + RbsDocumentationChunk.parentheses(")") + RbsDocumentationChunk.operation("?") : RbsDocumentationChunk.typeSignature(signature.getTypeSignature()) + RbsDocumentationChunk.operation("?");
    }

    @Override
    public void visitProcTypeSignature(@NotNull RbsProcTypeSignature signature) {
        RbsProcTypeSignature blockTypeSignature;
        if (signature == null) {
            RbsDocumentationTypeSignaturePresentationVisitor.$$$reportNull$$$0(9);
        }
        String parametersText = signature.hasUntypedParameters() ? RbsDocumentationChunk.operation("?") : Strings.join(signature.getParameters(), RbsDocumentationChunk::parameter, (String)(RbsDocumentationChunk.operation(",") + " "));
        this.myText = RbsDocumentationChunk.parentheses("(") + parametersText + RbsDocumentationChunk.parentheses(")") + " ";
        RbsTypeSignature selfTypeSignature = signature.getSelfTypeSignature();
        if (selfTypeSignature != null) {
            String selfText = RbsDocumentationChunk.typeSignature(selfTypeSignature);
            this.myText = this.myText + RbsDocumentationChunk.brackets("[") + RbsDocumentationChunk.keyword("self") + RbsDocumentationChunk.operation(":") + " " + selfText + RbsDocumentationChunk.brackets("]") + " ";
        }
        if ((blockTypeSignature = signature.getBlockTypeSignature()) != null) {
            String blockOptionalMarker = signature.isBlockOptional() ? RbsDocumentationChunk.operation("?") : "";
            String blockText = RbsDocumentationChunk.typeSignature(blockTypeSignature);
            this.myText = this.myText + blockOptionalMarker + RbsDocumentationChunk.braces("{") + " " + blockText + " " + RbsDocumentationChunk.braces("}") + " ";
        }
        this.myText = this.myText + RbsDocumentationChunk.operation("->") + " ";
        RbsTypeSignature returnTypeSignature = signature.getReturnTypeSignature();
        this.myText = RbsDocumentationTypeSignaturePresentationVisitor.isParenthesesRequired(returnTypeSignature) ? this.myText + RbsDocumentationChunk.parentheses("(") + RbsDocumentationChunk.typeSignature(returnTypeSignature) + RbsDocumentationChunk.parentheses(")") : this.myText + RbsDocumentationChunk.typeSignature(returnTypeSignature);
    }

    @Override
    public void visitQualifiedNameReferenceSignature(@NotNull RbsQualifiedNameReferenceSignature signature) {
        if (signature == null) {
            RbsDocumentationTypeSignaturePresentationVisitor.$$$reportNull$$$0(10);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void visitQualifiedNameTypeSignature(@NotNull RbsQualifiedNameTypeSignature signature) {
        if (signature == null) {
            RbsDocumentationTypeSignaturePresentationVisitor.$$$reportNull$$$0(11);
        }
        if (!signature.getTypeArgumentSignatures().isEmpty()) {
            String typeArgumentsText = Strings.join(signature.getTypeArgumentSignatures(), RbsDocumentationChunk::typeSignature, (String)(RbsDocumentationChunk.operation(",") + " "));
            this.myText = RbsDocumentationChunk.fqn(signature.getFqn()) + RbsDocumentationChunk.brackets("[") + typeArgumentsText + RbsDocumentationChunk.brackets("]");
        } else {
            this.myText = RbsDocumentationChunk.fqn(signature.getFqn());
        }
    }

    @Override
    public void visitRecordTypeSignature(@NotNull RbsRecordTypeSignature signature) {
        List<RbsRecordTypeSignature.Field> fields;
        if (signature == null) {
            RbsDocumentationTypeSignaturePresentationVisitor.$$$reportNull$$$0(12);
        }
        this.myText = (fields = signature.getFields()).isEmpty() ? RbsDocumentationChunk.braces("{}") : (fields.size() <= 3 ? RbsDocumentationChunk.braces("{") + Strings.join(fields, it -> RbsDocumentationTypeSignaturePresentationVisitor.getPresentableText(it), (String)(RbsDocumentationChunk.operation(",") + " ")) + RbsDocumentationChunk.braces("}") : RbsDocumentationChunk.braces("{") + Strings.join(fields.subList(0, 2), it -> RbsDocumentationTypeSignaturePresentationVisitor.getPresentableText(it), (String)(RbsDocumentationChunk.operation(",") + " ")) + RbsDocumentationChunk.operation(",") + " " + RbsDocumentationChunk.operation("\u2026") + RbsDocumentationChunk.braces("}"));
    }

    @Override
    public void visitSingletonTypeSignature(@NotNull RbsSingletonTypeSignature signature) {
        if (signature == null) {
            RbsDocumentationTypeSignaturePresentationVisitor.$$$reportNull$$$0(13);
        }
        this.myText = RbsDocumentationChunk.keyword("singleton") + RbsDocumentationChunk.parentheses("(") + RbsDocumentationChunk.typeSignature(signature.getTypeSignature()) + RbsDocumentationChunk.parentheses(")");
    }

    @Override
    public void visitStringLiteralSignature(@NotNull RbsStringLiteralSignature signature) {
        if (signature == null) {
            RbsDocumentationTypeSignaturePresentationVisitor.$$$reportNull$$$0(14);
        }
        this.myText = RbsDocumentationChunk.string("'" + signature.getLiteral() + "'");
    }

    @Override
    public void visitSymbolLiteralSignature(@NotNull RbsSymbolLiteralSignature signature) {
        if (signature == null) {
            RbsDocumentationTypeSignaturePresentationVisitor.$$$reportNull$$$0(15);
        }
        this.myText = RbsDocumentationChunk.symbol(":" + signature.getLiteral());
    }

    @Override
    public void visitTupleTypeSignature(@NotNull RbsTupleTypeSignature signature) {
        List<RbsTypeSignature> signatures;
        if (signature == null) {
            RbsDocumentationTypeSignaturePresentationVisitor.$$$reportNull$$$0(16);
        }
        this.myText = (signatures = signature.getTypeSignatures()).isEmpty() ? RbsDocumentationChunk.brackets("[") + " " + RbsDocumentationChunk.brackets("]") : (signatures.size() <= 3 ? RbsDocumentationChunk.brackets("[") + Strings.join(signatures, RbsDocumentationChunk::typeSignature, (String)(RbsDocumentationChunk.operation(",") + " ")) + RbsDocumentationChunk.brackets("]") : RbsDocumentationChunk.brackets("[") + Strings.join(signatures.subList(0, 2), RbsDocumentationChunk::typeSignature, (String)(RbsDocumentationChunk.operation(",") + " ")) + RbsDocumentationChunk.operation(",") + " " + RbsDocumentationChunk.operation("\u2026") + RbsDocumentationChunk.brackets("]"));
    }

    @Override
    public void visitTypeSignature(@NotNull RbsTypeSignature signature) {
        if (signature == null) {
            RbsDocumentationTypeSignaturePresentationVisitor.$$$reportNull$$$0(17);
        }
        throw new IllegalStateException();
    }

    @Override
    public void visitTypeVariableReferenceSignature(@NotNull RbsTypeVariableReferenceSignature signature) {
        if (signature == null) {
            RbsDocumentationTypeSignaturePresentationVisitor.$$$reportNull$$$0(18);
        }
        this.myText = RbsDocumentationChunk.fqn(signature.getName());
    }

    @Override
    public void visitUnionTypeSignature(@NotNull RbsUnionTypeSignature signature) {
        List<RbsTypeSignature> signatures;
        if (signature == null) {
            RbsDocumentationTypeSignaturePresentationVisitor.$$$reportNull$$$0(19);
        }
        this.myText = (signatures = signature.getTypeSignatures()).size() <= 3 ? signature.getTypeSignatures().stream().map(it -> RbsDocumentationTypeSignaturePresentationVisitor.isParenthesesRequired(it) ? RbsDocumentationChunk.parentheses("(") + RbsDocumentationChunk.typeSignature(it) + RbsDocumentationChunk.parentheses(")") : RbsDocumentationChunk.typeSignature(it)).collect(Collectors.joining(" " + RbsDocumentationChunk.operation("|") + " ")) : signature.getTypeSignatures().stream().limit(2L).map(it -> RbsDocumentationTypeSignaturePresentationVisitor.isParenthesesRequired(it) ? RbsDocumentationChunk.parentheses("(") + RbsDocumentationChunk.typeSignature(it) + RbsDocumentationChunk.parentheses(")") : RbsDocumentationChunk.typeSignature(it)).collect(Collectors.joining(" " + RbsDocumentationChunk.operation("|") + " ")) + " " + RbsDocumentationChunk.operation("|") + " " + RbsDocumentationChunk.operation("\u2026");
    }

    @NlsSafe
    @NotNull
    private static String getPresentableText(@NotNull RbsRecordTypeSignature.Field field) {
        RbsSymbolLiteralSignature literal;
        String text;
        if (field == null) {
            RbsDocumentationTypeSignaturePresentationVisitor.$$$reportNull$$$0(20);
        }
        RbsLiteralSignature keySignature = field.getKeyTypeSignature();
        RbsTypeSignature valueSignature = field.getValueTypeSignature();
        String key = keySignature instanceof RbsSymbolLiteralSignature ? (RbsNamingConventionUtils.isValidSymbolName(":" + (text = (literal = (RbsSymbolLiteralSignature)keySignature).getLiteral())) ? text + RbsDocumentationChunk.operation(":") : (!text.contains("`") ? "`%s`".formatted(text) + RbsDocumentationChunk.operation(":") : RbsDocumentationChunk.typeSignature(keySignature) + " " + RbsDocumentationChunk.operation("=>"))) : RbsDocumentationChunk.typeSignature(keySignature) + " " + RbsDocumentationChunk.operation("=>");
        String value = RbsDocumentationChunk.typeSignature(valueSignature);
        String string = switch (field.getFieldType()) {
            default -> throw new IncompatibleClassChangeError();
            case RbsRecordTypeSignature.FieldType.OPTIONAL -> "%s%s %s".formatted(RbsDocumentationChunk.operation("?"), key, value);
            case RbsRecordTypeSignature.FieldType.REQUIRED -> "%s %s".formatted(key, value);
        };
        if (string == null) {
            RbsDocumentationTypeSignaturePresentationVisitor.$$$reportNull$$$0(21);
        }
        return string;
    }

    private static boolean isParenthesesRequired(@NotNull RbsTypeSignature signature) {
        if (signature == null) {
            RbsDocumentationTypeSignaturePresentationVisitor.$$$reportNull$$$0(22);
        }
        return signature instanceof RbsIntersectionTypeSignature || signature instanceof RbsProcTypeSignature || signature instanceof RbsUnionTypeSignature;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 22 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ruby/rbs/model/documentation/RbsDocumentationTypeSignaturePresentationVisitor";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ruby/rbs/model/documentation/RbsDocumentationTypeSignaturePresentationVisitor";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableText";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "visitBooleanLiteralSignature";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "visitIntegerLiteralSignature";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "visitIntersectionTypeSignature";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "visitKeywordTypeSignature";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "visitLiteralSignature";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "visitMethodTypeSignature";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "visitNilLiteralSignature";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "visitOptionalTypeSignature";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "visitProcTypeSignature";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "visitQualifiedNameReferenceSignature";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "visitQualifiedNameTypeSignature";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "visitRecordTypeSignature";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "visitSingletonTypeSignature";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "visitStringLiteralSignature";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "visitSymbolLiteralSignature";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "visitTupleTypeSignature";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "visitTypeSignature";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "visitTypeVariableReferenceSignature";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "visitUnionTypeSignature";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableText";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isParenthesesRequired";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 22 -> new IllegalArgumentException(string);
        };
    }
}

